/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.perf.AchieveDataHelper;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowCollection;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluGroupCollection;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionException;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionRuleFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvalWFObjects;
import com.kingdee.eas.hr.perf.IEvalWorkFlow;
import com.kingdee.eas.hr.perf.IEvalWorkFlowFacade;
import com.kingdee.eas.hr.perf.IEvaluGroup;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IEvaluGroupTargetType;
import com.kingdee.eas.hr.perf.IEvaluNode;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.IEvaluSolution;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.IPrecisionMaintain;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.ITargetDeploy;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.NodeVisibleCollection;
import com.kingdee.eas.hr.perf.NodeVisibleInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.TargetDeployCollection;
import com.kingdee.eas.hr.perf.TargetDeployEntryCollection;
import com.kingdee.eas.hr.perf.TargetDeployEntryFactory;
import com.kingdee.eas.hr.perf.TargetDeployEntryInfo;
import com.kingdee.eas.hr.perf.TargetDeployFactory;
import com.kingdee.eas.hr.perf.TargetDeployInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetScoreComputeFacadeFactory;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractEvaluSolutionFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluSolutionFacadeControllerBean
extends AbstractEvaluSolutionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluSolutionFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.hr.perf.PerfResource";

    @Override
    protected IObjectCollection _getPersonCollection(Context ctx, String personId, boolean isPrimaryPosition, String hierarchyId, boolean isFindByParent) throws BOSException, EASBizException {
        PersonCollection personColl = null;
        IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection posiMemberColl = this.getPersonPosiMember(ctx, personId);
        PositionHierarchyCollection positionHierColl = null;
        PositionInfo positionInfo = null;
        PositionMemberInfo posiMemInfo = null;
        for (int i = 0; i < posiMemberColl.size(); ++i) {
            posiMemInfo = posiMemberColl.get(i);
            if (!posiMemInfo.isIsPrimary()) continue;
            positionInfo = posiMemInfo.getPosition();
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarInfo.getId().toString(), positionInfo.getId().toString(), isFindByParent));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarchyId, positionInfo.getId().toString(), isFindByParent));
            }
            personColl = this.getPersonCOllByPM(ctx, positionHierColl, isFindByParent);
            break;
        }
        return personColl;
    }

    private PositionMemberCollection getPersonPosiMember(Context ctx, String personId) throws EASBizException, BOSException {
        PositionMemberCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        posiMemberColl = iPosiMember.getPositionMemberCollection(this.getPMEntityViewInfo(ctx, personId));
        return posiMemberColl;
    }

    private EntityViewInfo getPMEntityViewInfo(Context ctx, String personId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemPosi = new FilterItemInfo("person.id", (Object)personId);
        filter.getFilterItems().add(filterItemPosi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPrimary"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        return viewInfo;
    }

    private EntityViewInfo getPHEntityViewInfo(String hierarchyId, String positionId, boolean isParent) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (!isParent) {
            filterItem = new FilterItemInfo("child.id", (Object)positionId, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("parent.id", (Object)positionId, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemHier = new FilterItemInfo("hierarchy.id", (Object)hierarchyId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemHier);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        return viewInfo;
    }

    private PersonCollection getPersonCOllByPM(Context ctx, PositionHierarchyCollection positionHierColl, boolean isFindByParent) throws BOSException {
        PersonCollection personColl = new PersonCollection();
        PositionInfo positionInfo = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        for (int k = 0; k < positionHierColl.size(); ++k) {
            positionInfo = !isFindByParent ? positionHierColl.get(k).getParent() : positionHierColl.get(k).getChild();
            PositionMemberCollection superPMColl = iPosiMember.getPositionMemberCollection(this.getOtherPMEntityViewInfo(positionInfo));
            int size = superPMColl.size();
            for (int j = 0; j < size; ++j) {
                personColl.add(superPMColl.get(j).getPerson());
            }
        }
        return personColl;
    }

    private EntityViewInfo getOtherPMEntityViewInfo(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionInfo.getId().toString().trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        return viewInfo;
    }

    @Override
    protected void _deliverTarget(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setTargetDelivererAndStatus(ctx, solutionPeriodId, null, 1);
        AchieveDataHelper.createAchieveDataonDeliverTarget(ctx, solutionPeriodId, null);
    }

    @Override
    protected void _unDeliverTarget(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setTargetDelivererAndStatus(ctx, solutionPeriodId, null, 0);
        AchieveDataHelper.delAchieveDataOnUnDeliverTarget(ctx, solutionPeriodId);
        this.unDeliverEvaluGroup(ctx, solutionPeriodId);
    }

    private void setTargetDelivererAndStatus(Context ctx, String solutionPeriodId, Set evaluGroupIdSet, int isDelivered) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        String sql = "UPDATE T_PF_TargetEvaluStore SET FIsDelivered = ? WHERE FSolutionPeriodID = ?";
        if (evaluGroupIdSet != null && evaluGroupIdSet.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_PF_TargetEvaluStore set fisDelivered = ? where fsolutionPeriodID = ? and fevaluTargetId in (");
            sb.append("select fevaluTargetId from t_pf_evaluGroupTarget fevaluGroupId in (");
            sb.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sb.append(")");
            sql = sb.toString();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, isDelivered);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _isTargetDelivered(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        return this.isDelivered(ctx, solutionPeriodId, false);
    }

    private boolean isDelivered(Context ctx, String solutionPeriodId, boolean isAll) throws SQLDataException, BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return false;
        }
        boolean isTargetDelivered = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 FID FROM T_PF_TargetEvaluStore WHERE FIsDelivered = 0 AND FSolutionPeriodID = '");
        sql.append(solutionPeriodId);
        sql.append("'");
        if (!isAll) {
            sql.append(" and FUniteTarget = 1");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                isTargetDelivered = false;
            } else if (this.getTargetCount(ctx, solutionPeriodId) != 0) {
                isTargetDelivered = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isTargetDelivered;
    }

    private int getTargetCount(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            int n;
            if (solutionPeriodId == null) {
                return 0;
            }
            String sql = "SELECT COUNT(FID) AS TargetCount FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? ";
            conn = null;
            pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                n = rs.getInt("TargetCount");
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return 0;
    }

    @Override
    protected boolean _checkIfAllObjectHaveFlow(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return false;
        }
        List flowIDList = this.getFlowIDList(ctx, solutionPeriodId);
        List storeIDList = this.getStoreIDList(ctx, solutionPeriodId);
        for (int i = 0; i < storeIDList.size(); ++i) {
            if (flowIDList.contains(storeIDList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _resetSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("status"));
        SolutionPeriodInfo solutionPeriodInfo = solutionPeriod.getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        int status = solutionPeriodInfo.getStatus().getValue();
        if (status == 100) {
            return;
        }
        IEvalWorkFlowFacade flowFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        flowFacade.stopSolutionPeriod(BOSUuid.read((String)solutionPeriodId));
        AchieveDataHelper.clearValueOnCopySolutionPeriod(ctx, solutionPeriodId);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluSolutionFacadeFactory.getLocalInstance(ctx).getType(), null, (String)solutionPeriodInfo.getName(), (String)"perf_EvalSolutionPeriod_reset");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void unDeliverEvaluGroup(Context ctx, String solutionPeriodId) throws SQLDataException, BOSException {
        String sql = "update T_PF_EvaluGroup set FDelivered = 0 where FSolutionPeriodID = ?";
        Connection conn = this.getConnection(ctx);
        PreparedStatement prst = null;
        try {
            prst = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)prst, (int)1, (String)solutionPeriodId);
            prst.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)prst, (Connection)conn);
        }
    }

    @Override
    protected void _submitEvaluTargetStore(Context ctx, String evaluGroupId, Map weightMap) throws BOSException, EASBizException {
    }

    private BOSUuid getTargetEvaluStoreId(Context ctx, BOSUuid objectId, BOSUuid targetId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectId));
        fi.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)targetId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        TargetEvaluStoreCollection storeColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        if (storeColl != null && storeColl.size() != 0) {
            return storeColl.get(0).getId();
        }
        return null;
    }

    @Override
    protected void _submitEvaluTargetStore(Context ctx, BOSUuid evaluGroupId, BOSUuid evaluTargetId, BOSUuid evaluObjectId, BigDecimal weight) throws BOSException, EASBizException {
    }

    @Override
    protected int _getTargetCount(Context ctx, String solutionPeriodId, String evaluObjectId, Boolean isDelivered) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            int n;
            if (solutionPeriodId == null || evaluObjectId == null) {
                return -1;
            }
            String sql = null;
            sql = isDelivered == null ? "SELECT COUNT(FID) AS TargetCount FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID = ?" : "SELECT COUNT(FID) AS TargetCount FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID = ? AND FIsDelivered = ?";
            conn = null;
            pstmt = null;
            try {
                ResultSet rs;
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluObjectId);
                if (isDelivered != null) {
                    if (isDelivered.equals(Boolean.TRUE)) {
                        pstmt.setInt(3, 1);
                    } else if (isDelivered.equals(Boolean.FALSE)) {
                        pstmt.setInt(3, 0);
                    }
                }
                if (!(rs = pstmt.executeQuery()).next()) break block9;
                n = rs.getInt("TargetCount");
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return 0;
    }

    @Override
    protected void _restartEvaluFlow(Context ctx, String solutionPeriodId, String evaluObjectId) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluObjectId == null) {
            return;
        }
        IEvalWorkFlowFacade workFlowFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        workFlowFacade.restartProcess(solutionPeriodId, evaluObjectId);
        TargetScoreComputeFacadeFactory.getLocalInstance(ctx).updateAchieveDataState(solutionPeriodId, evaluObjectId, false);
    }

    @Override
    protected boolean _checkIfAllObjectHaveTarget(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return false;
        }
        List flowIDList = this.getFlowIDList(ctx, solutionPeriodId);
        List storeIDList = this.getStoreIDList(ctx, solutionPeriodId);
        for (int i = 0; i < flowIDList.size(); ++i) {
            if (storeIDList.contains(flowIDList.get(i))) continue;
            return false;
        }
        return true;
    }

    private List getStoreIDList(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        ITargetEvaluStore store = TargetEvaluStoreFactory.getLocalInstance(ctx);
        TargetEvaluStoreCollection storeColl = store.getTargetEvaluStoreCollection(evi);
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        int size = storeColl.size();
        for (int i = 0; i < size; ++i) {
            EvaluObjectInfo evaluObjectInfo = storeColl.get(i).getEvaluObject();
            if (evaluObjectInfo == null) continue;
            list.add(evaluObjectInfo.getId());
        }
        return list;
    }

    private List getFlowIDList(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        IEvalWFObjects evalWFObjects = EvalWFObjectsFactory.getLocalInstance(ctx);
        EvalWFObjectsCollection wfObjectsColl = evalWFObjects.getEvalWFObjectsCollection(evi);
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        for (int i = 0; i < wfObjectsColl.size(); ++i) {
            EvaluObjectInfo evaluObjectInfo = wfObjectsColl.get(i).getEvaluObject();
            if (evaluObjectInfo == null) continue;
            list.add(evaluObjectInfo.getId());
        }
        return list;
    }

    @Override
    protected boolean _isEvaluObjectRefered(Context ctx, String evaluObjectId) throws BOSException, EASBizException {
        if (evaluObjectId == null) {
            return false;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("solutionPeriod.id"));
        evi.getSelector().add(new SelectorItemInfo("solutionPeriod.status"));
        TargetEvaluStoreCollection storeColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        for (int i = 0; i < storeColl.size(); ++i) {
            if (!storeColl.get(i).getSolutionPeriod().getStatus().equals((Object)SolutionPeriodStatusEnum.ON_EVALU) && !storeColl.get(i).getSolutionPeriod().getStatus().equals((Object)SolutionPeriodStatusEnum.END_EVALU)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BigDecimal _getTargetWeight(Context ctx, String solutionPeriodId, String evaluObjectId, Boolean isDelivered) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block10: {
            BigDecimal bigDecimal;
            block11: {
                ResultSet rs;
                if (solutionPeriodId == null || evaluObjectId == null) {
                    return new BigDecimal("0");
                }
                String sql = null;
                sql = isDelivered == null ? "SELECT SUM(FWeight) AS TargetWeight FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID = ?" : "SELECT SUM(FWeight) AS TargetWeight FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID = ? AND FIsDelivered = ?";
                conn = null;
                pstmt = null;
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluObjectId);
                if (isDelivered != null) {
                    if (isDelivered.equals(Boolean.TRUE)) {
                        pstmt.setInt(3, 1);
                    } else if (isDelivered.equals(Boolean.FALSE)) {
                        pstmt.setInt(3, 0);
                    }
                }
                if (!(rs = pstmt.executeQuery()).next()) break block10;
                if (rs.getBigDecimal("TargetWeight") == null) break block11;
                BigDecimal bigDecimal2 = rs.getBigDecimal("TargetWeight");
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                return bigDecimal2;
            }
            try {
                bigDecimal = new BigDecimal("0");
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return bigDecimal;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return new BigDecimal("0");
    }

    @Override
    protected Map _getTargetCountWeight(Context ctx, String solutionPeriodId, String evaluObjectId, Boolean isDelivered) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluObjectId == null) {
            return null;
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        int targetCount = this._getTargetCount(ctx, solutionPeriodId, evaluObjectId, isDelivered);
        BigDecimal targetWeight = this._getTargetWeight(ctx, solutionPeriodId, evaluObjectId, isDelivered);
        map.put("TargetCount", new Integer(targetCount));
        map.put("TargetWeight", targetWeight);
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkTargetweight(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        boolean bl;
        PreparedStatement pstmt;
        Connection conn;
        block11: {
            block12: {
                boolean bl2;
                if (solutionPeriodId == null) {
                    return false;
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("evaluSolution.allocateTarget"));
                sic.add(new SelectorItemInfo("evaluSolution.deliverMode"));
                SolutionPeriodInfo info = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
                if (info != null && info.getEvaluSolution().getAllocateTarget() == 1) {
                    if (!DeliverModeEnum.PART_UNITY_DELIVER.equals((Object)info.getEvaluSolution().getDeliverMode())) return true;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod", (Object)solutionPeriodId));
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(filter);
                    SelectorItemCollection selector = view.getSelector();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("evaluObject"));
                    selector.add(new SelectorItemInfo("evaluGroup.weight"));
                    EvaluGroupObjectCollection groupObjectColl = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectCollection(view);
                    StringBuffer sb = new StringBuffer();
                    sb.append("SELECT SUM(FWeight) AS TargetWeight, FEvaluObjectID AS evaluObjectId FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = '");
                    sb.append(solutionPeriodId);
                    sb.append("' and FUniteTarget = 0 GROUP BY FEvaluObjectID");
                    IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    try {
                        String evaluObjectId;
                        BigDecimal weight;
                        BigDecimal sum;
                        set.beforeFirst();
                        do {
                            if (!set.next()) return true;
                            sum = new BigDecimal("0.00");
                        } while ((sum = (weight = set.getBigDecimal("TargetWeight")).add(this.getEvaluGroupObjectWeightByID(groupObjectColl, evaluObjectId = set.getString("evaluObjectId")))).compareTo(new BigDecimal("100")) == 0);
                        return false;
                    }
                    catch (SQLException ex) {
                        throw new BOSException((Throwable)ex);
                    }
                }
                String sql = "SELECT SUM(FWeight) AS TargetWeight FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? GROUP BY FEvaluObjectID";
                conn = null;
                pstmt = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                    ResultSet rs = pstmt.executeQuery();
                    boolean hasOne = false;
                    while (rs.next()) {
                        hasOne = true;
                        BigDecimal weight = rs.getBigDecimal("TargetWeight");
                        if (weight.compareTo(new BigDecimal("100")) == 0) continue;
                        bl = false;
                        break block11;
                    }
                    if (hasOne) break block12;
                    bl2 = false;
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                return bl2;
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return true;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return bl;
    }

    private BigDecimal getEvaluGroupObjectWeightByID(EvaluGroupObjectCollection groupObject, String evaluObjectId) {
        EvaluGroupObjectInfo info = null;
        int j = groupObject.size();
        for (int i = 0; i < j; ++i) {
            info = groupObject.get(i);
            if (evaluObjectId == null || !evaluObjectId.equals(info.getEvaluObject().getId().toString())) continue;
            return info.getEvaluGroup().getWeight();
        }
        return new BigDecimal("0.00");
    }

    @Override
    protected void _finishSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("status"));
        SolutionPeriodInfo solutionPeriodInfo = solutionPeriod.getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        int status = solutionPeriodInfo.getStatus().getValue();
        if (status == 102) {
            return;
        }
        IEvalWorkFlowFacade flowFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        flowFacade.closeSolutionPeriod(BOSUuid.read((String)solutionPeriodId));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluSolutionFacadeFactory.getLocalInstance(ctx).getType(), null, (String)solutionPeriodInfo.getName(), (String)"perf_EvalSolutionPeriod_end");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _startSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        Set evaluObjectIdSet = EvaluSolutionRuleFacadeFactory.getLocalInstance(ctx).getEvaluableObject(solutionPeriodId);
        if (evaluObjectIdSet == null || evaluObjectIdSet.isEmpty()) {
            throw new EvaluSolutionException(EvaluSolutionException.NO_EVALUOBJECT);
        }
        this.startSolutionPeriod(ctx, solutionPeriodId, evaluObjectIdSet);
    }

    @Override
    protected boolean _checkIfExistObjectInTargetStore(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        List storeIDList = this.getStoreIDList(ctx, solutionPeriodId);
        return storeIDList.size() != 0;
    }

    @Override
    protected IObjectCollection _getEvaluObjectCollection(Context ctx, List idList) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getLongName(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String longName = EvaluSolutionFacadeControllerBean.getLongName(ctx, sb, EvaluSolutionFacadeControllerBean.getAdminOrgUnitInfo(ctx, BOSUuid.read((String)orgUnitId)));
        return longName;
    }

    private static String getLongName(Context ctx, StringBuffer sb, AdminOrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (orgUnitInfo.getParent() == null) {
            orgUnitInfo = EvaluSolutionFacadeControllerBean.getAdminOrgUnitInfo(ctx, orgUnitInfo.getId());
        }
        if (orgUnitInfo.getParent() != null) {
            sb.append(orgUnitInfo.getName());
            sb.append("/");
            EvaluSolutionFacadeControllerBean.getLongName(ctx, sb, orgUnitInfo.getParent());
        } else {
            sb.append(orgUnitInfo.getName());
        }
        return sb.toString();
    }

    private static AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        return AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    @Override
    protected Map _getLongNames(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> longNameMap = new HashMap<String, String>();
        for (String orgUnitId : idSet) {
            longNameMap.put(orgUnitId, this._getLongName(ctx, orgUnitId));
        }
        return longNameMap;
    }

    @Override
    protected Set _getReferedEvaluObjectIDSet(Context ctx, Set idSet, SolutionPeriodStatusEnum status) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.status", (Object)new Integer(status.getValue())));
        filter.setMaskString("#0 AND #1");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        TargetEvaluStoreCollection storeColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        HashSet<String> canDelIDSet = new HashSet<String>();
        for (int i = 0; i < storeColl.size(); ++i) {
            canDelIDSet.add(storeColl.get(i).getEvaluObject().getId().toString());
        }
        return canDelIDSet;
    }

    @Override
    protected String _getLongNameByLongNumber(Context ctx, BOSObjectType bosType, String longNumber) throws BOSException, EASBizException {
        HashSet<String> numberSet = new HashSet<String>();
        while (longNumber.indexOf("!") != -1) {
            numberSet.add(longNumber);
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        numberSet.add(longNumber);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", numberSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("longNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        evi.getSelector().add(new SelectorItemInfo("name"));
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, evi);
        StringBuffer sb = new StringBuffer();
        DataBaseInfo baseInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            baseInfo = (DataBaseInfo)coll.getObject(i);
            sb.append(baseInfo.getName());
            if (i == size - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    protected Map _getLongNames(Context ctx, Map numberMap) throws BOSException, EASBizException {
        HashMap<String, String> longNameMap = new HashMap<String, String>();
        BOSObjectType bosType = new AdminOrgUnitInfo().getBOSType();
        Iterator it = numberMap.keySet().iterator();
        while (it.hasNext()) {
            String orgUnitId = it.next().toString();
            longNameMap.put(orgUnitId, this._getLongNameByLongNumber(ctx, bosType, (String)numberMap.get(orgUnitId)));
        }
        return longNameMap;
    }

    @Override
    protected IObjectCollection _getPersonCollectionByOrgUnitId(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitId));
        fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        IRowSet rowSet = this.getRowSet(ctx, fi, "OrgUnitSuperiorQuery");
        PersonCollection personCollection = new PersonCollection();
        PersonInfo personInfo = null;
        try {
            while (rowSet.next()) {
                personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)rowSet.getString("deliverer.id")));
                personInfo.setNumber(rowSet.getString("deliverer.number"));
                personInfo.setName(rowSet.getString("deliverer.name"));
                personCollection.add(personInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return personCollection;
    }

    private IRowSet getRowSet(Context ctx, FilterInfo fi, String queryName) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    @Override
    protected void _copySolution(Context ctx, IObjectValue solution, IObjectValue assessPeriod, IObjectValue solutionPeriod, boolean isCopyEvaluObject) throws BOSException, EASBizException {
        EvaluSolutionInfo info = (EvaluSolutionInfo)solution;
        AssessPeriodInfo assessPeriodInfo = (AssessPeriodInfo)assessPeriod;
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)solutionPeriod;
        IEvaluSolution ies = EvaluSolutionFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("targetRankGroup.id"));
        sic.add(new SelectorItemInfo("targetGradeModeLink.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("evaluRule.id"));
        EvaluSolutionInfo oldSolution = ies.getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
        oldSolution.setNumber(info.getNumber());
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L1")), LocaleUtils.getLocale((String)"L1"));
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L2")), LocaleUtils.getLocale((String)"L2"));
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L3")), LocaleUtils.getLocale((String)"L3"));
        oldSolution.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        oldSolution.setId(null);
        oldSolution.setSolutionStatus(SolutionStatusEnum.UNUSED);
        IObjectPK pk = ies.submit((CoreBaseInfo)oldSolution);
        oldSolution.setId(BOSUuid.read((String)pk.toString()));
        if (oldSolution.isCustomPrecision()) {
            FilterInfo precisionFi = new FilterInfo();
            precisionFi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)info.getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(precisionFi);
            IPrecisionMaintain ipm = PrecisionMaintainFactory.getLocalInstance(ctx);
            PrecisionMaintainInfo oldPMinfo = ipm.getPrecisionMaintainCollection(evi).get(0);
            oldPMinfo.setId(null);
            oldPMinfo.setEvaluSolution(oldSolution);
            ipm.save(oldPMinfo);
        }
        EntityViewInfo viewInfo = null;
        FilterInfo filter = null;
        String oldID = null;
        String newID = null;
        ISolutionPeriod isp = SolutionPeriodFactory.getLocalInstance(ctx);
        SolutionPeriodInfo spInfo = new SolutionPeriodInfo();
        spInfo.setId(null);
        spInfo.setStatus(SolutionPeriodStatusEnum.UN_EVALU);
        spInfo.setEvaluSolution(oldSolution);
        spInfo.setAssessPeriod(assessPeriodInfo);
        StringBuffer sb = new StringBuffer();
        sb.append(oldSolution.getName());
        sb.append(" ");
        sb.append(assessPeriodInfo.getStartDate());
        sb.append("----");
        sb.append(assessPeriodInfo.getEndDate());
        Locale locale = ctx.getLocale();
        if (locale.equals(new Locale("L2"))) {
            spInfo.setName(sb.toString(), locale);
            spInfo.setName(STConverter.sc2tc((String)sb.toString()), new Locale("L3"));
        } else if (locale.equals(new Locale("L3"))) {
            spInfo.setName(sb.toString(), locale);
            spInfo.setName(STConverter.tc2sc((String)sb.toString()), new Locale("L2"));
        } else {
            spInfo.setName(sb.toString());
        }
        spInfo.setEvaluStartDate(solutionPeriodInfo.getEvaluStartDate());
        spInfo.setEvaluEndDate(solutionPeriodInfo.getEvaluEndDate());
        spInfo.setAchievePeriod(solutionPeriodInfo.getAchievePeriod());
        spInfo.setKeyEventPeriod(solutionPeriodInfo.getKeyEventPeriod());
        spInfo.setFormSolution(solutionPeriodInfo.getFormSolution());
        spInfo.setEvaluFormDesc(solutionPeriodInfo.getEvaluFormDesc());
        spInfo.setTargetManageDesc(solutionPeriodInfo.getTargetManageDesc());
        spInfo.setDescription(solutionPeriodInfo.getDescription());
        spInfo.setEvaluFormDescAttachId(solutionPeriodInfo.getEvaluFormDescAttachId());
        spInfo.setTargetManageDesAttachId(solutionPeriodInfo.getTargetManageDesAttachId());
        spInfo.setFormTitle(ResourceBase.getString((String)RES, (String)"formTitle", (Locale)ctx.getLocale()));
        spInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        String newSolutionPeriodID = isp.submit((CoreBaseInfo)spInfo).toString();
        SolutionPeriodInfo newSolutionPeriod = isp.getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(newSolutionPeriodID));
        String oldSolutionPeriodID = solutionPeriodInfo.getId().toString();
        Map evalObjMap = null;
        if (isCopyEvaluObject) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.getSelector().add(new SelectorItemInfo("targetDeliverers.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("appointPerson"));
            viewInfo.getSelector().add(new SelectorItemInfo("achDataPermissions.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("achDataPermissions.entry.*"));
            IEvaluObject iEvalObj = EvaluObjectFactory.getLocalInstance(ctx);
            EvaluObjectCollection evlObjColl = iEvalObj.getEvaluObjectCollection(viewInfo);
            EvaluObjectInfo evlObjInfo = null;
            int n = evlObjColl.size();
            for (int i = 0; i < n; ++i) {
                evlObjInfo = evlObjColl.get(i);
                evlObjInfo.setId(null);
                evlObjInfo.setEvaluSolution(oldSolution);
            }
            evalObjMap = iEvalObj.submitBatchEvaluObject(evlObjColl);
        }
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)oldSolutionPeriodID));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic2 = viewInfo.getSelector();
        sic2.add(new SelectorItemInfo("*"));
        sic2.add(new SelectorItemInfo("concurArgs.*"));
        sic2.add(new SelectorItemInfo("evaluNodes.*"));
        sic2.add(new SelectorItemInfo("evaluNodes.nodes.*"));
        sic2.add(new SelectorItemInfo("wfObjects.*"));
        sic2.add(new SelectorItemInfo("wfObjects.evaluObject.objectID"));
        IEvalWorkFlow iewf = EvalWorkFlowFactory.getLocalInstance(ctx);
        IEvalWorkFlowFacade iewffacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        EvalWorkFlowCollection flowColl = iewf.getEvalWorkFlowCollection(viewInfo);
        EvalWorkFlowInfo flowInfo = null;
        EvalWFObjectsCollection wfObjColls = null;
        EvalWFObjectsInfo wfObjectInfo = null;
        EvaluObjectInfo evalObjectInfo = null;
        String objectId = null;
        String evalObjectId = null;
        int n = flowColl.size();
        for (int i = 0; i < n; ++i) {
            int l;
            flowInfo = flowColl.get(i);
            oldID = flowInfo.getId().toString();
            flowInfo.setId(null);
            flowInfo.setSolutionPeriod(newSolutionPeriod);
            if (oldSolution.getAllocateTarget() != 1 && isCopyEvaluObject) {
                wfObjColls = flowInfo.getWfObjects();
                for (int l2 = wfObjColls.size() - 1; l2 >= 0; --l2) {
                    wfObjectInfo = wfObjColls.get(l2);
                    evalObjectInfo = wfObjectInfo.getEvaluObject();
                    objectId = evalObjectInfo.getObjectID();
                    evalObjectId = (String)evalObjMap.get(objectId);
                    if (StringUtils.isEmpty((String)evalObjectId)) {
                        wfObjColls.remove(wfObjectInfo);
                        continue;
                    }
                    evalObjectInfo.setId(BOSUuid.read((String)evalObjectId));
                    wfObjectInfo.setStatus(WFStatuEnum.UNUSED);
                    wfObjectInfo.setProcInstID(null);
                    wfObjectInfo.setId(null);
                }
            } else {
                flowInfo.put("wfObjects", null);
            }
            EvaluNodeInfo evaluNodeInfo = null;
            int k = flowInfo.getEvaluNodes().size();
            for (l = 0; l < k; ++l) {
                evaluNodeInfo = flowInfo.getEvaluNodes().get(l);
                evaluNodeInfo.setId(null);
                evaluNodeInfo.setEvalWorkFlow(flowInfo);
                this.setNodeVisibleIdNull(evaluNodeInfo);
            }
            k = flowInfo.getConcurArgs().size();
            for (l = 0; l < k; ++l) {
                flowInfo.getConcurArgs().get(l).setId(null);
                flowInfo.getConcurArgs().get(l).setEvalWorkFlow(flowInfo);
            }
            newID = iewffacade.addNewWorkFlow(flowInfo).toString();
        }
        if (101 != oldSolution.getDeliverMode().getValue()) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)oldSolutionPeriodID));
            viewInfo.setFilter(filter);
            IEvaluGroup ieg = EvaluGroupFactory.getLocalInstance(ctx);
            EvaluGroupCollection egColl = ieg.getEvaluGroupCollection(viewInfo);
            EvaluGroupInfo egInfo = null;
            IORMappingDAO evaluGroupORMDao = ORMappingDAO.getInstance((BOSObjectType)new BOSObjectType("84EF04F9"), (Context)ctx, (Connection)this.getConnection(ctx));
            HashMap<String, String> groupMap = new HashMap<String, String>();
            int n2 = egColl.size();
            for (int i = 0; i < n2; ++i) {
                egInfo = egColl.get(i);
                oldID = egInfo.getId().toString();
                newID = BOSUuid.create((String)"84EF04F9").toString();
                egInfo.setId(BOSUuid.read((String)newID));
                egInfo.setSolutionPeriod(newSolutionPeriod);
                egInfo.setDelivered(false);
                evaluGroupORMDao.addNewBatch((IObjectValue)egInfo);
                groupMap.put(oldID, newID);
            }
            evaluGroupORMDao.executeBatch();
            HashMap<String, String> targetMap = new HashMap<String, String>();
            IEvaluTarget iet = EvaluTargetFactory.getLocalInstance(ctx);
            EvaluTargetInfo etInfo = null;
            if (groupMap.size() > 0) {
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evaluGroup", groupMap.keySet(), CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("evaluTarget.*"));
                EvaluGroupTargetCollection etColl = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(viewInfo);
                IORMappingDAO evaluTargetORMDao = ORMappingDAO.getInstance((BOSObjectType)new BOSObjectType("2E323257"), (Context)ctx, (Connection)this.getConnection(ctx));
                int n3 = etColl.size();
                for (int i = 0; i < n3; ++i) {
                    etInfo = etColl.get(i).getEvaluTarget();
                    oldID = etInfo.getId().toString();
                    newID = BOSUuid.create((String)"2E323257").toString();
                    etInfo.setId(BOSUuid.read((String)newID));
                    etInfo.setSolutionPeriod(newSolutionPeriod);
                    evaluTargetORMDao.addNewBatch((IObjectValue)etInfo);
                    targetMap.put(oldID, newID);
                }
                evaluTargetORMDao.executeBatch();
            }
            if (groupMap.size() > 0) {
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evaluGroup.id", groupMap.keySet(), CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                IEvaluGroupTarget iegt = EvaluGroupTargetFactory.getLocalInstance(ctx);
                EvaluGroupTargetInfo egtInfo = null;
                EvaluGroupTargetCollection egtColl = iegt.getEvaluGroupTargetCollection(viewInfo);
                IORMappingDAO evaluGroupTargetORMDao = ORMappingDAO.getInstance((BOSObjectType)new BOSObjectType("776F03EA"), (Context)ctx, (Connection)this.getConnection(ctx));
                int n4 = egtColl.size();
                for (int i = 0; i < n4; ++i) {
                    egtInfo = egtColl.get(i);
                    oldID = egtInfo.getEvaluGroup().getId().toString();
                    egInfo = ieg.getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(groupMap.get(oldID).toString()));
                    egtInfo.setEvaluGroup(egInfo);
                    oldID = egtInfo.getEvaluTarget().getId().toString();
                    etInfo = iet.getEvaluTargetInfo((IObjectPK)new ObjectUuidPK(targetMap.get(oldID).toString()));
                    egtInfo.setEvaluTarget(etInfo);
                    egtInfo.setId(BOSUuid.create((String)"776F03EA"));
                    evaluGroupTargetORMDao.addNewBatch((IObjectValue)egtInfo);
                }
                evaluGroupTargetORMDao.executeBatch();
            }
            if (isCopyEvaluObject && groupMap.size() > 0) {
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evaluGroup.id", groupMap.keySet(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("evaluObject.objectID"));
                IEvaluGroupObject iEvaluGroupObject = EvaluGroupObjectFactory.getLocalInstance(ctx);
                EvaluGroupObjectCollection egoColl = iEvaluGroupObject.getEvaluGroupObjectCollection(viewInfo);
                EvaluGroupObjectInfo egoInfo = null;
                EvaluGroupObjectCollection evaluGroupObjectCollection = new EvaluGroupObjectCollection();
                int n5 = egoColl.size();
                for (int i = 0; i < n5; ++i) {
                    egoInfo = egoColl.get(i);
                    oldID = egoInfo.getEvaluGroup().getId().toString();
                    egInfo = ieg.getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(groupMap.get(oldID).toString()));
                    egoInfo.setEvaluGroup(egInfo);
                    oldID = egoInfo.getEvaluObject().getObjectID().toString();
                    evalObjectId = (String)evalObjMap.get(oldID);
                    evalObjectInfo = egoInfo.getEvaluObject();
                    evalObjectInfo.setId(BOSUuid.read((String)evalObjectId));
                    egoInfo.setEvaluObject(evalObjectInfo);
                    egoInfo.setId(null);
                    evaluGroupObjectCollection.add(egoInfo);
                }
                iEvaluGroupObject.submitBatchGroupObject(evaluGroupObjectCollection);
            }
        }
        this.dealLogInfo(ctx, info, "perf_EvalSolution_copy");
    }

    private void setNodeVisibleIdNull(EvaluNodeInfo evaluNodeInfo) {
        NodeVisibleCollection nodes = evaluNodeInfo.getNodes();
        int size = nodes.size();
        for (int j = 0; j < size; ++j) {
            NodeVisibleInfo nodeVisibleInfo = nodes.get(j);
            nodeVisibleInfo.setId(null);
        }
    }

    @Override
    protected void _submitTargetDeploy(Context ctx, String id, String evaluGroupID, String evalWorkFlowID, String[][] entryList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupID));
        ITargetDeploy itd = TargetDeployFactory.getLocalInstance(ctx);
        if (itd.exists(filter)) {
            this.updateFlowObject(ctx, evaluGroupID, evalWorkFlowID);
            itd.delete(filter);
        } else {
            this.createFlowObject(ctx, evaluGroupID, evalWorkFlowID);
        }
        TargetDeployInfo tdInfo = new TargetDeployInfo();
        if (id != null) {
            tdInfo.setId(BOSUuid.read((String)id));
        }
        EvaluGroupInfo evaluGroup = new EvaluGroupInfo();
        evaluGroup.setId(BOSUuid.read((String)evaluGroupID));
        tdInfo.setEvaluGroup(evaluGroup);
        EvalWorkFlowInfo evalWorkFlow = new EvalWorkFlowInfo();
        evalWorkFlow.setId(BOSUuid.read((String)evalWorkFlowID));
        tdInfo.setEvalWorkFlow(evalWorkFlow);
        TargetDeployEntryCollection coll = new TargetDeployEntryCollection();
        TargetDeployEntryInfo info = null;
        String[] entry2 = null;
        EvaluTargetInfo evaluTarget = null;
        EvaluNodeInfo evaluNode = null;
        BigDecimal weight = null;
        for (String[] entry2 : entryList) {
            if (entry2[3] == null) continue;
            info = new TargetDeployEntryInfo();
            if (entry2[0] != null) {
                info.setId(BOSUuid.read((String)entry2[0]));
            }
            info.setParent(tdInfo);
            evaluTarget = new EvaluTargetInfo();
            evaluTarget.setId(BOSUuid.read((String)entry2[1]));
            info.setEvaluTarget(evaluTarget);
            evaluNode = new EvaluNodeInfo();
            evaluNode.setId(BOSUuid.read((String)entry2[2]));
            info.setEvaluNode(evaluNode);
            weight = new BigDecimal(entry2[3]);
            info.setWeight(weight);
            coll.add(info);
        }
        tdInfo.put("entry", (Object)coll);
        IObjectPK pk = TargetDeployFactory.getLocalInstance(ctx).submit(tdInfo);
        this.setNodeWeightForDeploy2(ctx, pk.toString());
    }

    private void setNodeWeightForDeploy2(Context ctx, String targetDeployParentId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluGroup.id"));
        sic.add(new SelectorItemInfo("evaluGroup.solutionPeriod.evaluSolution.allocateTarget"));
        sic.add(new SelectorItemInfo("evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("id"));
        TargetDeployInfo info = TargetDeployFactory.getLocalInstance(ctx).getTargetDeployInfo((IObjectPK)new ObjectUuidPK(targetDeployParentId), sic);
        if (info.getEvaluGroup().getSolutionPeriod().getEvaluSolution().getAllocateTarget() == 2) {
            FilterInfo filter2 = new FilterInfo();
            EntityViewInfo viewInfo2 = new EntityViewInfo();
            viewInfo2.setFilter(filter2);
            SelectorItemCollection sic2 = viewInfo2.getSelector();
            filter2.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)info.getEvaluGroup().getId().toString()));
            sic2.add(new SelectorItemInfo("weight"));
            sic2.add(new SelectorItemInfo("evaluTarget.id"));
            EvaluGroupTargetCollection groupTargetColl = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(viewInfo2);
            HashMap<String, BigDecimal> targetWeight = new HashMap<String, BigDecimal>();
            for (int i = 0; i < groupTargetColl.size(); ++i) {
                EvaluGroupTargetInfo egti = groupTargetColl.get(i);
                targetWeight.put(egti.getEvaluTarget().getId().toString(), egti.getWeight());
            }
            FilterInfo filter1 = new FilterInfo();
            EntityViewInfo viewInfo1 = new EntityViewInfo();
            viewInfo1.setFilter(filter1);
            SelectorItemCollection sic1 = viewInfo1.getSelector();
            filter1.getFilterItems().add(new FilterItemInfo("parent.id", (Object)targetDeployParentId));
            sic1.add(new SelectorItemInfo("evaluTarget.id"));
            sic1.add(new SelectorItemInfo("evaluNode.id"));
            sic1.add(new SelectorItemInfo("weight"));
            TargetDeployEntryCollection collEntry = TargetDeployEntryFactory.getLocalInstance(ctx).getTargetDeployEntryCollection(viewInfo1);
            FilterInfo filter3 = new FilterInfo();
            EntityViewInfo viewInfo3 = new EntityViewInfo();
            viewInfo3.setFilter(filter3);
            SelectorItemCollection sic3 = viewInfo3.getSelector();
            filter3.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)info.getEvalWorkFlow().getId().toString()));
            sic3.add(new SelectorItemInfo("id"));
            sic3.add(new SelectorItemInfo("weight"));
            CoreBaseCollection updateEvaluNodeColl = new CoreBaseCollection();
            EvaluNodeCollection evaluNodeColl = EvaluNodeFactory.getLocalInstance(ctx).getEvaluNodeCollection(viewInfo3);
            for (int l = 0; l < evaluNodeColl.size(); ++l) {
                EvaluNodeInfo evaluNodeInfo = evaluNodeColl.get(l);
                evaluNodeInfo.setWeight(BigDecimal.ZERO);
                for (int m = 0; m < collEntry.size(); ++m) {
                    TargetDeployEntryInfo entryInfo = collEntry.get(m);
                    if (entryInfo.getEvaluNode().getId() == null || evaluNodeInfo.getId() == null || !entryInfo.getEvaluNode().getId().toString().equals(evaluNodeInfo.getId().toString())) continue;
                    evaluNodeInfo.setWeight(evaluNodeInfo.getWeight().add(entryInfo.getWeight().multiply((BigDecimal)targetWeight.get(entryInfo.getEvaluTarget().getId().toString()))));
                }
                evaluNodeInfo.setWeight(evaluNodeInfo.getWeight().divide(new BigDecimal("100")));
                updateEvaluNodeColl.add((CoreBaseInfo)evaluNodeInfo);
            }
            EvaluNodeFactory.getLocalInstance(ctx).update(updateEvaluNodeColl);
        }
    }

    private void updateFlowObject(Context ctx, String evaluGroupID, String flowID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PF_EvalWFObjects SET FEvalWorkFlowID = ?  where fid in (");
        sql.append("select wfobj.fid from T_PF_EvalWFObjects wfobj ");
        sql.append("inner join t_pf_evalWorkflow flow on flow.fid = wfobj.fevalworkflowid ");
        sql.append("inner join T_PF_EvaluGroup evaluGroup on evaluGroup.fsolutionperiodId = flow.fsolutionperiodId ");
        sql.append("inner join T_PF_EvaluGroupObject groupObj on groupObj.FEvaluGroupID = evaluGroup.fid ");
        sql.append("and wfobj.FEvaluObjectID = groupObj.FEvaluObjectID ");
        sql.append("where  groupObj.FEvaluGroupID = ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)flowID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluGroupID);
            pstmt.execute();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _createFlowObject(Context ctx, String evaluGroupID, String flowID) throws BOSException, EASBizException {
        String groupObjectSql = " SELECT GroupObject.FEvaluObjectID evaluObjectID  FROM T_PF_EvaluGroupObject GroupObject  INNER JOIN T_PF_EvaluGroup EvaluGroup ON GroupObject.FEvaluGroupID = EvaluGroup.FID  WHERE EvaluGroup.FID = ?";
        String insertSql = " INSERT INTO T_PF_EvalWFObjects (FID,FStatus,FEvaluObjectID,FEvalWorkFlowID) VALUES (?,?,?,?) ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement insertPstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(groupObjectSql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)evaluGroupID);
            ResultSet resultSet = pstmt.executeQuery();
            insertPstmt = conn.prepareStatement(insertSql);
            EvalWFObjectsInfo info = new EvalWFObjectsInfo();
            int count = 0;
            while (resultSet.next()) {
                ++count;
                DbUtil.prepareVarcharParam((PreparedStatement)insertPstmt, (int)1, (String)BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                insertPstmt.setInt(2, 10);
                DbUtil.prepareVarcharParam((PreparedStatement)insertPstmt, (int)3, (String)resultSet.getString("evaluObjectID"));
                DbUtil.prepareVarcharParam((PreparedStatement)insertPstmt, (int)4, (String)flowID);
                insertPstmt.addBatch();
            }
            if (count > 0) {
                insertPstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(insertPstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)insertPstmt, (Connection)conn);
    }

    @Override
    protected Map _getAssessPeriodNames(Context ctx, Set idSet) throws BOSException, EASBizException {
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        sb.append("select solution.FID as ID,assessPeriod.FName");
        sb.append(locale);
        sb.append(" as NAME");
        sb.append(" from T_PF_SolutionPeriod solutionPeriod");
        sb.append(" inner join T_PF_EvaluSolution solution on solutionPeriod.FEvaluSolutionID = solution.FID");
        sb.append(" left outer join T_PF_AssessPeriod assessPeriod on solutionPeriod.FAssessPeriodID = assessPeriod.FID");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String id = null;
            String name = null;
            if (idSet == null) {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            } else {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    if (!idSet.contains(id)) continue;
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return map;
    }

    @Override
    protected void _addEvaluObject(Context ctx, Set idSet, String evaluSolutionId) throws BOSException, EASBizException {
        String CUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        EvaluObjectInfo evaluObject = new EvaluObjectInfo();
        String bosType = evaluObject.getBOSType().toString();
        sb.append("INSERT INTO T_PF_EvaluObject(FID, FControlUnitID, FName_L1, FName_L2, FName_L3, ").append("FNumber, ").append("FEvaluObjectType, FObjectID, FEvaluSolutionID, FPositionID, FDeleted, FDescription_L1,FDescription_L2,FDescription_L3)");
        sb.append("SELECT newbosid('");
        sb.append(bosType);
        sb.append("'),");
        sb.append("'");
        sb.append(CUID);
        sb.append("',");
        sb.append("person.FName_L1,");
        sb.append("person.FName_L2,");
        sb.append("person.FName_L3,");
        sb.append("person.FNumber,");
        sb.append(100);
        sb.append(",");
        sb.append("person.FID,");
        sb.append("'");
        sb.append(evaluSolutionId);
        sb.append("',");
        sb.append("personPosition.FPrimaryPositionID,");
        sb.append("-1,'','',''");
        sb.append("FROM T_BD_Person person INNER JOIN T_HR_PersonPosition personPosition ON person.FID = personPosition.FPersonID ");
        sb.append("WHERE person.FID IN (");
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            sb.append("'");
            sb.append((String)iter.next());
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") AND ");
        sb.append(" person.FID NOT IN(");
        sb.append("SELECT FObjectID FROM T_PF_EvaluObject WHERE FEvaluSolutionID = ");
        sb.append("'");
        sb.append(evaluSolutionId);
        sb.append("'");
        sb.append(" AND FDeleted = 0 )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        sb.append("UPDATE T_PF_EvaluObject SET FDeleted = 0 WHERE FEvaluSolutionID = '");
        sb.append(evaluSolutionId);
        sb.append("' AND FDeleted = -1");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected String[] _checkSameTargetWeight(Context ctx, String id) throws BOSException, EASBizException {
        String[] ret = this.checkSamTargetWeight(ctx, id, null);
        return ret;
    }

    private String[] checkSamTargetWeight(Context ctx, String id, Set evaluGroupIdSet) throws BOSException {
        String[] ret = new String[]{};
        StringBuffer sb = this.getCheckSameTargetWeightSQL(id, evaluGroupIdSet);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int size = rowSet.size();
            if (size > 0) {
                ret = new String[size];
                int i = 0;
                while (rowSet.next()) {
                    ret[i] = rowSet.getString("groupNumber");
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return ret;
    }

    private StringBuffer getCheckSameTargetWeightSQL(String solutionPeriodId, Set evaluGroupIdSet) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT evaluGroup.FNumber groupNumber FROM ");
        sb.append("T_PF_EvaluGroupTarget groupTarget ");
        sb.append("INNER JOIN T_PF_EvaluGroup evaluGroup ON groupTarget.FEvaluGroupID = evaluGroup.FID ");
        sb.append("INNER JOIN T_PF_EvaluTarget evaluTarget ON groupTarget.FEvaluTargetID = evaluTarget.FID ");
        sb.append("INNER JOIN T_PF_EvaluGroupTargetType targetType ON (groupTarget.FEvaluGroupID=targetType.FEvaluGroupID and evaluTarget.FTypeID=targetType.FPerformTargetTypeID) ");
        sb.append("WHERE evaluGroup.FSolutionPeriodID='");
        sb.append(solutionPeriodId);
        sb.append("'");
        if (evaluGroupIdSet != null && evaluGroupIdSet.size() > 0) {
            sb.append(" and evaluGroup.fid in (");
            sb.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sb.append(")");
        }
        sb.append("GROUP BY evaluGroup.FID,targetType.FID,targetType.FWeight,evaluGroup.FNumber ");
        sb.append("HAVING targetType.FWeight-sum(groupTarget.FWeight)!=0 ");
        sb.append("ORDER BY evaluGroup.FNumber");
        return sb;
    }

    @Override
    protected void _copySolutionPeriod(Context ctx, IObjectPK sourceSolutionPeriodId, AssessPeriodInfo destAssessPeriod) throws BOSException, EASBizException {
        if (sourceSolutionPeriodId == null || destAssessPeriod == null) {
            return;
        }
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.name"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("formSolution.id"));
        sic.add(new SelectorItemInfo("achievePeriod.id"));
        SolutionPeriodInfo solutionPeriodInfo = iSolutionPeriod.getSolutionPeriodInfo(sourceSolutionPeriodId, sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionPeriodInfo.getEvaluSolution().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)destAssessPeriod.getId().toString()));
        if (iSolutionPeriod.exists(filterInfo)) {
            throw new EvaluSolutionException(EvaluSolutionException.ASSESSPERIOD_EXIST, new Object[]{destAssessPeriod.getName()});
        }
        solutionPeriodInfo = this.copyPeriod(ctx, solutionPeriodInfo, destAssessPeriod);
        HashMap oldNewIdMap = new HashMap();
        this.copyEvaluGroup(ctx, sourceSolutionPeriodId, solutionPeriodInfo, oldNewIdMap);
        this.copyEvaluWorkFlow(ctx, sourceSolutionPeriodId, solutionPeriodInfo, oldNewIdMap);
        this.copyTargetDeploy(ctx, solutionPeriodInfo, oldNewIdMap);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluSolutionFacadeFactory.getLocalInstance(ctx).getType(), null, (String)solutionPeriodInfo.getName(), (String)"perf_EvalSolutionPeriod_copy");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private SolutionPeriodInfo copyPeriod(Context ctx, SolutionPeriodInfo solutionPeriodInfo, AssessPeriodInfo destAssessPeriod) throws BOSException, EASBizException {
        this.setObjectValueEmpty(ctx, (ObjectBaseInfo)solutionPeriodInfo);
        StringBuffer sb = new StringBuffer();
        sb.append(solutionPeriodInfo.getEvaluSolution().getName());
        sb.append(" ");
        sb.append(destAssessPeriod.getStartDate());
        sb.append("----");
        sb.append(destAssessPeriod.getEndDate());
        Locale locale = ctx.getLocale();
        if (locale.equals(new Locale("L2"))) {
            solutionPeriodInfo.setName(sb.toString(), locale);
            solutionPeriodInfo.setName(STConverter.sc2tc((String)sb.toString()), new Locale("L3"));
        } else if (locale.equals(new Locale("L3"))) {
            solutionPeriodInfo.setName(sb.toString(), locale);
            solutionPeriodInfo.setName(STConverter.tc2sc((String)sb.toString()), new Locale("L2"));
        } else {
            solutionPeriodInfo.setName(sb.toString());
        }
        solutionPeriodInfo.setAssessPeriod(destAssessPeriod);
        solutionPeriodInfo.setStatus(SolutionPeriodStatusEnum.UN_EVALU);
        solutionPeriodInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        solutionPeriodInfo = (SolutionPeriodInfo)this.submitInfo((ICoreBase)iSolutionPeriod, (CoreBaseInfo)solutionPeriodInfo);
        return solutionPeriodInfo;
    }

    private void copyEvaluGroup(Context ctx, IObjectPK sourceSolutionPeriodId, SolutionPeriodInfo solutionPeriodInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)sourceSolutionPeriodId));
        viewInfo.setFilter(filterInfo);
        IEvaluGroup bizInterface = EvaluGroupFactory.getLocalInstance(ctx);
        EvaluGroupCollection collection = bizInterface.getEvaluGroupCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            EvaluGroupInfo info = null;
            String sourceId = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                sourceId = this.setObjectValueEmpty(ctx, (ObjectBaseInfo)info);
                info.setSolutionPeriod(solutionPeriodInfo);
                info.setDelivered(false);
                info = (EvaluGroupInfo)this.submitInfo((ICoreBase)bizInterface, (CoreBaseInfo)info);
                info.setSavedTemplateTarget(true);
                info = (EvaluGroupInfo)this.submitInfo((ICoreBase)bizInterface, (CoreBaseInfo)info);
                this.copyEvaluGroupTargetType(ctx, sourceId, info);
                this.copyEvaluGroupTarget(ctx, sourceId, info, solutionPeriodInfo, oldNewIdMap);
                this.copyEvaluGroupObject(ctx, sourceId, info);
            }
        }
    }

    private void copyEvaluGroupTargetType(Context ctx, String sourceEvaluGroupId, EvaluGroupInfo evaluGroupInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)sourceEvaluGroupId));
        viewInfo.setFilter(filterInfo);
        IEvaluGroupTargetType bizInterface = EvaluGroupTargetTypeFactory.getLocalInstance(ctx);
        EvaluGroupTargetTypeCollection collection = bizInterface.getEvaluGroupTargetTypeCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            EvaluGroupTargetTypeInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                this.setObjectValueEmpty(ctx, (ObjectBaseInfo)info);
                info.setEvaluGroup(evaluGroupInfo);
                this.submitInfo((ICoreBase)bizInterface, (CoreBaseInfo)info);
            }
        }
    }

    private void copyEvaluGroupObject(Context ctx, String sourceEvaluGroupId, EvaluGroupInfo evaluGroupInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)sourceEvaluGroupId));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
        viewInfo.setFilter(filterInfo);
        IEvaluGroupObject bizInterface = EvaluGroupObjectFactory.getLocalInstance(ctx);
        EvaluGroupObjectCollection collection = bizInterface.getEvaluGroupObjectCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            EvaluGroupObjectInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                this.setObjectValueEmpty(ctx, (ObjectBaseInfo)info);
                info.setEvaluGroup(evaluGroupInfo);
                this.submitInfo((ICoreBase)bizInterface, (CoreBaseInfo)info);
            }
        }
    }

    private void copyEvaluGroupTarget(Context ctx, String sourceEvaluGroupId, EvaluGroupInfo evaluGroupInfo, SolutionPeriodInfo solutionPeriodInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)sourceEvaluGroupId));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("multiTable.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("values"));
        viewInfo.getSelector().add(new SelectorItemInfo("weight"));
        IEvaluGroupTarget bizInterface = EvaluGroupTargetFactory.getLocalInstance(ctx);
        EvaluGroupTargetCollection collection = bizInterface.getEvaluGroupTargetCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            EvaluGroupTargetInfo info = null;
            EvaluTargetInfo evaluTargetInfo = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                this.setObjectValueEmpty(ctx, (ObjectBaseInfo)info);
                if (info.getEvaluTarget() != null && info.getEvaluTarget().getId() != null) {
                    evaluTargetInfo = this.copyEvaluTarget(ctx, info.getEvaluTarget().getId().toString(), solutionPeriodInfo, oldNewIdMap);
                    info.setEvaluTarget(evaluTargetInfo);
                }
                info.setEvaluGroup(evaluGroupInfo);
                this.submitInfo((ICoreBase)bizInterface, (CoreBaseInfo)info);
            }
        }
    }

    private EvaluTargetInfo copyEvaluTarget(Context ctx, String sourceEvaluTargetId, SolutionPeriodInfo solutionPeriodInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        EvaluTargetInfo evaluTargetInfo = iEvaluTarget.getEvaluTargetInfo((IObjectPK)new ObjectUuidPK(sourceEvaluTargetId));
        this.setObjectValueEmpty(ctx, evaluTargetInfo);
        evaluTargetInfo.setSolutionPeriod(solutionPeriodInfo);
        evaluTargetInfo = (EvaluTargetInfo)this.submitInfo((ICoreBase)iEvaluTarget, (CoreBaseInfo)evaluTargetInfo);
        return evaluTargetInfo;
    }

    private void copyTargetEvaluStore(Context ctx, String sourceEvaluTargetId, EvaluTargetInfo newEvaluTargetInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)sourceEvaluTargetId));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
        viewInfo.setFilter(filterInfo);
        ITargetEvaluStore iTargetEvaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        TargetEvaluStoreCollection collection = iTargetEvaluStore.getTargetEvaluStoreCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            TargetEvaluStoreInfo info = null;
            Object storeParentInfo = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                this.setObjectValueEmpty(ctx, (ObjectBaseInfo)info);
                info.setIsDelivered(false);
                info.setEvaluTarget(newEvaluTargetInfo);
                info.setSolutionPeriod(newEvaluTargetInfo.getSolutionPeriod());
                info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                info.setSeqNumber(newEvaluTargetInfo.getSeqNumber());
                this.submitInfo((ICoreBase)iTargetEvaluStore, (CoreBaseInfo)info);
            }
        }
    }

    private void copyEvaluWorkFlow(Context ctx, IObjectPK sourceSolutionPeriodId, SolutionPeriodInfo solutionPeriodInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)sourceSolutionPeriodId));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluNodes.*"));
        sic.add(new SelectorItemInfo("evaluNodes.nodes.*"));
        sic.add(new SelectorItemInfo("concurArgs.*"));
        sic.add(new SelectorItemInfo("wfObjects.*"));
        sic.add(new SelectorItemInfo("wfObjects.evaluObject.deleted"));
        viewInfo.setSelector(sic);
        IEvalWorkFlow bizInterface = EvalWorkFlowFactory.getLocalInstance(ctx);
        EvalWorkFlowCollection collection = bizInterface.getEvalWorkFlowCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            EvalWorkFlowInfo info = null;
            EvaluNodeCollection oldEvaluNodes = null;
            String oldId = null;
            IEvalWorkFlowFacade iEvalWorkFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                oldId = info.getId().toString();
                info.setId(null);
                info.setWorkFlowID(null);
                oldEvaluNodes = (EvaluNodeCollection)((Object)info.getEvaluNodes().clone());
                info.getEvaluNodes().clear();
                this.setCollectionIdEmpty((IObjectCollection)info.getConcurArgs());
                this.setCollectionIdEmpty((IObjectCollection)info.getWfObjects());
                this.handleWFEvaluObject(info);
                info.setSolutionPeriod(solutionPeriodInfo);
                info = (EvalWorkFlowInfo)this.submitInfo(bizInterface, info);
                this.storeOldNewId(oldNewIdMap, oldId, info);
                this.copyEvaluNode(ctx, oldEvaluNodes, info, oldNewIdMap);
                iEvalWorkFacade.createWf(solutionPeriodInfo.getId(), info.getId());
            }
        }
    }

    private void copyEvaluNode(Context ctx, EvaluNodeCollection oldEvaluNodes, EvalWorkFlowInfo evaluWorkFlowInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        IEvaluNode iEvaluNode = EvaluNodeFactory.getLocalInstance(ctx);
        EvaluNodeInfo evaluNodeInfo = null;
        String oldId = null;
        int size = oldEvaluNodes.size();
        for (int i = 0; i < size; ++i) {
            evaluNodeInfo = oldEvaluNodes.get(i);
            oldId = evaluNodeInfo.getId().toString();
            evaluNodeInfo.setId(null);
            evaluNodeInfo.setEvalWorkFlow(evaluWorkFlowInfo);
            this.setNodeVisibleIdNull(evaluNodeInfo);
            evaluNodeInfo = (EvaluNodeInfo)this.submitInfo((ICoreBase)iEvaluNode, (CoreBaseInfo)evaluNodeInfo);
            this.storeOldNewId(oldNewIdMap, oldId, (CoreBaseInfo)evaluNodeInfo);
        }
    }

    private void copyTargetDeploy(Context ctx, SolutionPeriodInfo solutionPeriodInfo, Map oldNewIdMap) throws BOSException, EASBizException {
        if (oldNewIdMap != null && !oldNewIdMap.isEmpty()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", oldNewIdMap.keySet(), CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            ITargetDeploy iTargetDeploy = TargetDeployFactory.getLocalInstance(ctx);
            TargetDeployCollection targetDeploys = iTargetDeploy.getTargetDeployCollection(viewInfo);
            if (targetDeploys != null && !targetDeploys.isEmpty()) {
                TargetDeployInfo targetDeployInfo = null;
                TargetDeployEntryCollection entrys = null;
                TargetDeployEntryInfo entryInfo = null;
                int size = targetDeploys.size();
                for (int i = 0; i < size; ++i) {
                    targetDeployInfo = targetDeploys.get(i);
                    targetDeployInfo.setId(null);
                    this.setInfoNewValue(targetDeployInfo, "evaluGroup", oldNewIdMap);
                    this.setInfoNewValue(targetDeployInfo, "evalWorkFlow", oldNewIdMap);
                    entrys = targetDeployInfo.getEntry();
                    int size2 = entrys.size();
                    for (int j = 0; j < size2; ++j) {
                        entryInfo = entrys.get(j);
                        entryInfo.setId(null);
                        this.setInfoNewValue((CoreBaseInfo)entryInfo, "evaluTarget", oldNewIdMap);
                        this.setInfoNewValue((CoreBaseInfo)entryInfo, "evaluNode", oldNewIdMap);
                    }
                    this.submitInfo(iTargetDeploy, targetDeployInfo);
                }
            }
        }
    }

    private void setInfoNewValue(CoreBaseInfo info, String property, Map oldNewIdMap) throws BOSException {
        CoreBaseInfo propertyInfo;
        String newId;
        if (info.get(property) != null && !StringUtils.isEmpty((String)(newId = (String)oldNewIdMap.get((propertyInfo = (CoreBaseInfo)info.get(property)).getId().toString())))) {
            try {
                StringBuffer methodName = new StringBuffer("get");
                methodName.append(property.substring(0, 1).toUpperCase());
                methodName.append(property.substring(1));
                Method method = info.getClass().getMethod(methodName.toString(), null);
                Class<?> returnType = method.getReturnType();
                if (CoreBaseInfo.class.isAssignableFrom(returnType)) {
                    propertyInfo = (CoreBaseInfo)returnType.newInstance();
                    propertyInfo.setId(BOSUuid.read((String)newId));
                    info.put(property, (Object)propertyInfo);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String setObjectValueEmpty(Context ctx, ObjectBaseInfo info) {
        info.setCreateTime(null);
        info.setCreator(null);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        String oldId = null;
        if (info.getId() != null) {
            oldId = info.getId().toString();
        }
        info.setId(null);
        return oldId;
    }

    private void setCollectionIdEmpty(IObjectCollection collection) {
        if (collection != null && !collection.isEmpty()) {
            CoreBaseInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = (CoreBaseInfo)collection.getObject(i);
                info.setId(null);
            }
        }
    }

    private CoreBaseInfo submitInfo(ICoreBase iCoreBase, CoreBaseInfo info) throws BOSException, EASBizException {
        IObjectPK pk = iCoreBase.submit(info);
        info.setId(BOSUuid.read((String)pk.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copy solutionPeriod: " + info.toString()));
        }
        return info;
    }

    private void storeOldNewId(Map oldNewIdMap, String oldId, CoreBaseInfo newInfo) {
        if (oldId != null && newInfo != null) {
            oldNewIdMap.put(oldId, newInfo.getId().toString());
        }
    }

    private void handleWFEvaluObject(EvalWorkFlowInfo info) {
        EvalWFObjectsCollection wfObjectsCollection = info.getWfObjects();
        EvalWFObjectsInfo wfObjectsInfo = null;
        for (int j = wfObjectsCollection.size() - 1; j >= 0; --j) {
            wfObjectsInfo = info.getWfObjects().get(j);
            if (wfObjectsInfo.getEvaluObject().isDeleted()) {
                wfObjectsCollection.remove(wfObjectsInfo);
            }
            wfObjectsInfo.setStatus(WFStatuEnum.UNUSED);
            wfObjectsInfo.setProcInstID(null);
        }
    }

    @Override
    protected HashSet _getAdminRangeWithAllHR(Context ctx) throws BOSException, EASBizException {
        String sql = PerfUtils.getAdminRangeSql(ctx);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> set = new HashSet<String>();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("FFromUnitID") == null) continue;
                set.add(rowSet.getString("FFromUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        return set;
    }

    @Override
    protected void _deliverTargetForPartUniteMode(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setTargetStatusForUniteTarget(ctx, solutionPeriodId, null, 1);
        List tesIds = this.getUniteTargetEvaluStoreIds(ctx, solutionPeriodId);
        if (tesIds != null && tesIds.size() > 0) {
            AchieveDataHelper.createAchieveDataonDeliverTarget2(ctx, solutionPeriodId, tesIds);
        }
    }

    private List getUniteTargetEvaluStoreIds(Context ctx, String solutionPeriodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_pf_targetEvaluStore where fsolutionPeriodId = '");
        sql.append(solutionPeriodId);
        sql.append("' and funiteTarget =  1");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> tesIds = new ArrayList<String>();
        try {
            set.beforeFirst();
            while (set.next()) {
                tesIds.add(set.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getCause(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return tesIds;
    }

    private void setTargetStatusForUniteTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet, int isDelivered) throws BOSException {
        if (solutionPeriodId == null) {
            return;
        }
        String sql = "UPDATE T_PF_TargetEvaluStore SET FIsDelivered = ?,FAuditStatus = ? WHERE FSolutionPeriodID = ? ";
        if (evaluGroupIdSet != null && evaluGroupIdSet.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_PF_TargetEvaluStore set fisDelivered = ?,FAuditStatus = ? where fsolutionPeriodID = ?  and FEvaluObjectID in (");
            sb.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
            sb.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sb.append("))");
            sql = sb.toString();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, isDelivered);
            pstmt.setInt(2, 20);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)solutionPeriodId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _unDeliverTargetForPartUniteMode(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setTargetStatusForUniteTarget(ctx, solutionPeriodId, null, 0);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.evaluSolution.allocateTarget", (Object)Boolean.TRUE));
        EvalWFObjectsFactory.getLocalInstance(ctx).delete(filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.id", (Object)solutionPeriodId));
        TargetDeployFactory.getLocalInstance(ctx).delete(filter);
        List tesIds = this.getUniteTargetEvaluStoreIds(ctx, solutionPeriodId);
        AchieveDataHelper.delAchieveDataOnUnDeliverTarget2(ctx, solutionPeriodId, tesIds);
    }

    @Override
    protected boolean _isAllTargetDelivered(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        return this.isDelivered(ctx, solutionPeriodId, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkTargetWeight(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        boolean bl;
        PreparedStatement pstmt;
        Connection conn;
        block8: {
            boolean bl2;
            block9: {
                if (solutionPeriodId == null || evaluGroupIdSet == null) {
                    return false;
                }
                conn = null;
                pstmt = null;
                StringBuffer sql = new StringBuffer();
                sql.append("select sum(fweight) as TargetWeight from t_pf_targetEvaluStore where fsolutionPeriodID = ? and fevaluTargetid in (");
                sql.append("select fevalutargetid from t_pf_evalugrouptarget where fevalugroupid in (");
                sql.append(PerfUtils.convertSetToString(evaluGroupIdSet));
                sql.append(")) Group by fevaluObjectID");
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                ResultSet rs = pstmt.executeQuery();
                boolean hasOne = false;
                while (rs.next()) {
                    hasOne = true;
                    BigDecimal weight = rs.getBigDecimal("TargetWeight");
                    if (weight.compareTo(new BigDecimal("100")) == 0) continue;
                    bl = false;
                    break block8;
                }
                if (hasOne) break block9;
                boolean bl3 = false;
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                return bl3;
            }
            try {
                bl2 = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return bl2;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return bl;
    }

    @Override
    protected boolean _checkIfExistObjectInTargetStore(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException {
        if (solutionPeriodId == null || evaluGroupIdSet == null) {
            return false;
        }
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.GetEvaluGroupIdByTargetEvaluStoreQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)evaluGroupIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("targetEvaluStore.uniteTarget", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(filter);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            evaluGroupIdSet.removeAll(idSet);
            if (evaluGroupIdSet.size() == 0) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected String[] _checkSameTargetWeight(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        String[] ret = this.checkSamTargetWeight(ctx, solutionPeriodId, evaluGroupIdSet);
        return ret;
    }

    @Override
    protected void _deliverTargetForPartUniteMode(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        this.deliverForEvaluGroupTarget(ctx, solutionPeriodId, evaluGroupIdSet);
    }

    @Override
    protected void _unDeliverTargetForPartUniteMode(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        this.undeliverEvaluGroupTarget(ctx, solutionPeriodId, evaluGroupIdSet);
    }

    @Override
    protected void _deliverTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        this.deliverForEvaluGroupTarget(ctx, solutionPeriodId, evaluGroupIdSet);
    }

    private void deliverForEvaluGroupTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        this.setTargetStatusForUniteTarget(ctx, solutionPeriodId, evaluGroupIdSet, 1);
        this.deliverEvaluTargetTypeStore(ctx, solutionPeriodId, evaluGroupIdSet, 1);
        List tesIds = this.getTargetEvaluStoreIds(ctx, solutionPeriodId, evaluGroupIdSet);
        if (evaluGroupIdSet != null) {
            if (tesIds != null && tesIds.size() > 0) {
                AchieveDataHelper.createAchieveDataonDeliverTarget2(ctx, solutionPeriodId, tesIds);
            }
        } else {
            AchieveDataHelper.createAchieveDataonDeliverTarget(ctx, solutionPeriodId, null);
        }
    }

    private void deliverEvaluTargetTypeStore(Context ctx, String solutionPeriodId, Set evaluGroupIdSet, int isDelivered) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.deliverMode"));
        SolutionPeriodCollection spc = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodCollection(evi);
        if (spc != null && spc.size() == 1 && DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)spc.get(0).getEvaluSolution().getDeliverMode())) {
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_PF_EvaluTargetTypeStore SET FDelivered = ").append(isDelivered);
            sql.append(" WHERE FEvaluGroupTargetTypeID IN( ");
            sql.append(" SELECT egtt.FID FROM T_PF_EvaluGroupTargetType egtt");
            sql.append(" INNER JOIN T_PF_EvaluGroup eg ON egtt.FEvaluGroupID = eg.FID ");
            sql.append(" WHERE eg.FID IN(");
            Iterator iterator = evaluGroupIdSet.iterator();
            while (iterator.hasNext()) {
                sql.append("'").append(iterator.next().toString()).append("',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private List getTargetEvaluStoreIds(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException {
        ArrayList<String> tesIds = null;
        if (solutionPeriodId == null || evaluGroupIdSet == null) {
            return null;
        }
        if (evaluGroupIdSet != null && evaluGroupIdSet.size() > 0) {
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.GetEvaluGroupIdByTargetEvaluStoreQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)evaluGroupIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("targetEvaluStore.uniteTarget", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
            evi.setFilter(filter);
            evi.getSelector().add("targetEvaluStore.id");
            exec.setObjectView(evi);
            IRowSet rowSet = exec.executeQuery();
            tesIds = new ArrayList<String>(rowSet.size());
            try {
                while (rowSet.next()) {
                    tesIds.add(rowSet.getString("targetEvaluStore.id"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return tesIds;
    }

    @Override
    protected void _unDeliverTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        this.undeliverEvaluGroupTarget(ctx, solutionPeriodId, evaluGroupIdSet);
    }

    private void undeliverEvaluGroupTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        this.setTargetStatusForUniteTarget(ctx, solutionPeriodId, evaluGroupIdSet, 0);
        List tesIds = this.getTargetEvaluStoreIds(ctx, solutionPeriodId, evaluGroupIdSet);
        this.deliverEvaluTargetTypeStore(ctx, solutionPeriodId, evaluGroupIdSet, 0);
        if (evaluGroupIdSet != null) {
            if (tesIds != null && tesIds.size() > 0) {
                AchieveDataHelper.delAchieveDataOnUnDeliverTarget2(ctx, solutionPeriodId, tesIds);
            }
        } else {
            AchieveDataHelper.delAchieveDataOnUnDeliverTarget(ctx, solutionPeriodId);
        }
    }

    @Override
    protected void _startSolutionPeriod(Context ctx, String solutionPeriodId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluObjectIdSet == null || evaluObjectIdSet.size() == 0) {
            throw new EvaluSolutionException(EvaluSolutionException.NO_EVALUOBJECT);
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("status"));
        SolutionPeriodInfo solutionPeriodInfo = solutionPeriod.getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        int status = solutionPeriodInfo.getStatus().getValue();
        if (status == 101) {
            return;
        }
        IEvalWorkFlowFacade flowFacade = EvalWorkFlowFacadeFactory.getLocalInstance(ctx);
        flowFacade.startSolutionPeriod(solutionPeriodId, evaluObjectIdSet);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluSolutionFacadeFactory.getLocalInstance(ctx).getType(), null, (String)solutionPeriodInfo.getName(), (String)"perf_EvalSolutionPeriod_start");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected Set _getEvaluableObject(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return Collections.EMPTY_SET;
        }
        return this.getEvaluableObject(ctx, solutionPeriodId, null, null);
    }

    @Override
    protected Set _getEvaluableObject(Context ctx, String solutionPeriodId, Set includeIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null || includeIdSet == null || includeIdSet.size() == 0) {
            return Collections.EMPTY_SET;
        }
        Set allEvaluableObjectOfSolutionPeriod = EvaluSolutionRuleFacadeFactory.getLocalInstance(ctx).getEvaluableObject(solutionPeriodId);
        allEvaluableObjectOfSolutionPeriod.retainAll(includeIdSet);
        if (allEvaluableObjectOfSolutionPeriod == null || allEvaluableObjectOfSolutionPeriod.size() <= 0) {
            return Collections.EMPTY_SET;
        }
        return allEvaluableObjectOfSolutionPeriod;
    }

    private Set getEvalWFObjects(Context ctx, String solutionPeriodId, Set includeIdSet) throws BOSException {
        HashSet<String> evaluObjectIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
        if (includeIdSet != null && includeIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)includeIdSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        view.getSelector().add("evaluObject.id");
        IEvalWFObjects ievalWFObjects = EvalWFObjectsFactory.getLocalInstance(ctx);
        EvalWFObjectsCollection coll = ievalWFObjects.getEvalWFObjectsCollection(view);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                evaluObjectIdSet.add(coll.get(i).getEvaluObject().getId().toString());
            }
        }
        return evaluObjectIdSet;
    }

    private Set getEvaluableObject(Context ctx, String solutionPeriodId, Set includeIdSet, Set evaluObjectIdSet) throws BOSException, EASBizException {
        return EvaluSolutionRuleFacadeFactory.getLocalInstance(ctx).getEvaluableObject(solutionPeriodId);
    }

    private Set checkIfAllDeployEntryHasTarget(String solutionPeriodId, Context ctx, boolean isTargetTemplate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append("select wf.fnumber as flowNumber, evaluNode.fseqNumber ");
        sql.append("from t_pf_evaluNode evaluNode ");
        sql.append("inner join t_pf_evalWorkFlow wf ");
        sql.append("on wf.fid = evaluNode.fevalWorkflowid ");
        sql.append("inner join t_pf_targetDeploy deploy ");
        sql.append("on wf.fid = deploy.fevalWorkflowID ");
        sql.append("left join ");
        sql.append("(select entry.fevaluNodeID as fid, entry.@@ as evaluTarget, wf.fid as workflow ");
        sql.append("from t_pf_targetDeploy parent inner join ");
        sql.append("t_pf_targetDeployEntry entry on parent.fid = entry.fparentid ");
        sql.append("inner join t_pf_evalworkflow wf on parent.fevalworkflowid = wf.fid ");
        sql.append("where  wf.fsolutionPeriodid = '").append(solutionPeriodId).append("') t2 ");
        sql.append("on evaluNode.fid = t2.fid and wf.fid = t2.workflow ");
        sql.append("where wf.fsolutionPeriodid = '").append(solutionPeriodId).append("' ");
        sql.append("and t2.evaluTarget is null ");
        String sqlStr = sql.toString();
        sqlStr = isTargetTemplate ? sqlStr.replaceFirst("@@", "FEvaluTargetTypeID") : sqlStr.replaceFirst("@@", "FEvaluTargetID");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        HashSet<String> flowNumberSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                flowNumberSet.add(rowSet.getString("flowNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowNumberSet;
    }

    private StringBuffer getInvalidGroup(Context ctx, String solutionPeriodId, Set groupIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodId));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        EvaluGroupCollection groupColl = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupCollection(view);
        StringBuffer sb = new StringBuffer();
        EvaluGroupInfo evaluGroupInfo = null;
        if (groupColl != null && groupColl.size() > 0) {
            int size = groupColl.size();
            for (int i = 0; i < size; ++i) {
                evaluGroupInfo = groupColl.get(i);
                if (groupIdSet.contains(evaluGroupInfo.getId().toString())) continue;
                sb.append(evaluGroupInfo.getNumber());
                sb.append(",");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private Set getDeployEvaluGroupInPartMode(Context ctx, String solutionPeriodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select parent.fevaluGroupId as groupId, sum(entry.fweight) as weight, evaluGroup.fweight as groupWeight from t_pf_targetDeployEntry entry inner join t_pf_targetDeploy parent on ");
        sql.append("entry.fparentid = parent.fid inner join t_pf_evalWorkFlow wf on parent.fevalWorkFlowID = wf.fid ");
        sql.append("inner join t_pf_evaluGroup evaluGroup on evaluGroup.fid = parent.fevaluGroupId ");
        sql.append("where wf.fsolutionPeriodid = ");
        sql.append("'");
        sql.append(solutionPeriodId);
        sql.append("'");
        sql.append(" group by parent.fevaluGroupId, evaluGroup.fweight, entry.fevaluNodeId");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> groupIdSet = new HashSet<String>();
        HashSet<String> removeIdSet = new HashSet<String>();
        BigDecimal groupWeight = null;
        BigDecimal weight = null;
        try {
            while (rowSet.next()) {
                groupWeight = rowSet.getBigDecimal("groupWeight");
                weight = rowSet.getBigDecimal("weight");
                if (groupWeight != null && weight != null && groupWeight.compareTo(weight) == 0) {
                    groupIdSet.add(rowSet.getString("groupId"));
                    continue;
                }
                removeIdSet.add(rowSet.getString("groupId"));
            }
            groupIdSet.removeAll(removeIdSet);
        }
        catch (SQLException e) {
            logger.error((Object)("sql is " + sql.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return groupIdSet;
    }

    private Set getDeployEvaluGroup(Context ctx, String solutionPeriodId, BigDecimal compareValue, DeliverModeEnum deliverMode) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select parent.fevaluGroupId as groupId, sum(entry.fweight) as weight from t_pf_targetDeployEntry entry inner join t_pf_targetDeploy parent on ");
        sql.append("entry.fparentid = parent.fid inner join t_pf_evalWorkFlow wf on parent.fevalWorkFlowID = wf.fid ");
        sql.append("where wf.fsolutionPeriodid = ");
        sql.append("'");
        sql.append(solutionPeriodId);
        sql.append("'");
        sql.append(" group by parent.fevaluGroupId, entry.fevaluNodeId");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> groupIdSet = new HashSet<String>();
        HashSet<String> removeIdSet = new HashSet<String>();
        boolean isTemplate = DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode);
        try {
            while (rowSet.next()) {
                if (!isTemplate) {
                    if (rowSet.getBigDecimal("weight").compareTo(compareValue) == 0) {
                        groupIdSet.add(rowSet.getString("groupId"));
                        continue;
                    }
                    removeIdSet.add(rowSet.getString("groupId"));
                    continue;
                }
                groupIdSet.add(rowSet.getString("groupId"));
            }
            groupIdSet.removeAll(removeIdSet);
        }
        catch (SQLException e) {
            logger.error((Object)("sql is " + sql.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return groupIdSet;
    }

    @Override
    protected String[] _checkTargetWeightLessThanType(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT evaluGroup.FNumber groupNumber FROM ");
        sb.append("T_PF_EvaluGroupTarget groupTarget ");
        sb.append("INNER JOIN T_PF_EvaluGroup evaluGroup ON groupTarget.FEvaluGroupID = evaluGroup.FID ");
        sb.append("INNER JOIN T_PF_EvaluTarget evaluTarget ON groupTarget.FEvaluTargetID = evaluTarget.FID ");
        sb.append("INNER JOIN T_PF_EvaluGroupTargetType targetType ON (groupTarget.FEvaluGroupID=targetType.FEvaluGroupID and evaluTarget.FTypeID=targetType.FPerformTargetTypeID) ");
        sb.append("WHERE evaluGroup.FSolutionPeriodID='");
        sb.append(solutionPeriodId);
        sb.append("'");
        if (evaluGroupIdSet != null && evaluGroupIdSet.size() > 0) {
            sb.append(" and evaluGroup.fid in (");
            sb.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sb.append(")");
        }
        sb.append(" GROUP BY evaluGroup.FID,targetType.FID,targetType.FWeight,evaluGroup.FNumber ");
        sb.append(" HAVING targetType.FWeight-sum(groupTarget.FWeight) < 0 ");
        sb.append(" ORDER BY evaluGroup.FNumber");
        String[] ret = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int size = rowSet.size();
            if (size > 0) {
                ret = new String[size];
                int i = 0;
                while (rowSet.next()) {
                    ret[i] = rowSet.getString("groupNumber");
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return ret;
    }

    protected Set getTargetWeightLessThanType(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashSet<String> objectIds = new HashSet<String>();
        sb.append("SELECT TES.FEVALUOBJECTID OBJECTID ");
        sb.append(" FROM T_PF_TARGETEVALUSTORE TES ");
        sb.append(" INNER JOIN T_PF_EVALUTARGETTYPESTORE ETTS ON TES.FEvaluTargetStoreTypeID = ETTS.FID ");
        sb.append(" INNER JOIN T_PF_EVALUGROUPTARGETTYPE EGTT ON EGTT.FID = ETTS.FEVALUGROUPTARGETTYPEID ");
        sb.append(" WHERE TES.FSOLUTIONPERIODID = '");
        sb.append(solutionPeriodId).append("' ");
        sb.append(" GROUP BY TES.FEVALUOBJECTID,ETTS.FID,EGTT.FWEIGHT ");
        sb.append(" HAVING SUM(TES.FWEIGHT) <> EGTT.FWEIGHT ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                objectIds.add(rowSet.getString("OBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return objectIds;
    }

    @Override
    protected void _submitTargetTemplateDeploy(Context ctx, String id, String evaluWorkFlowId, String evaluGroupID, IObjectCollection entryColl) throws BOSException, EASBizException {
        this.saveTargetDeployInfo(ctx, id, evaluWorkFlowId, evaluGroupID, entryColl);
    }

    private void saveTargetDeployInfo(Context ctx, String id, String evaluWorkFlowId, String evaluGroupID, IObjectCollection entryColl) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupID));
        ITargetDeploy itd = TargetDeployFactory.getLocalInstance(ctx);
        if (itd.exists(filter)) {
            this.updateFlowObject(ctx, evaluGroupID, evaluWorkFlowId);
            itd.delete(filter);
        } else {
            this.createFlowObject(ctx, evaluGroupID, evaluWorkFlowId);
        }
        TargetDeployInfo tdInfo = new TargetDeployInfo();
        if (id != null) {
            tdInfo.setId(BOSUuid.read((String)id));
        }
        EvaluGroupInfo evaluGroup = new EvaluGroupInfo();
        evaluGroup.setId(BOSUuid.read((String)evaluGroupID));
        tdInfo.setEvaluGroup(evaluGroup);
        EvalWorkFlowInfo evalWorkFlow = new EvalWorkFlowInfo();
        evalWorkFlow.setId(BOSUuid.read((String)evaluWorkFlowId));
        tdInfo.setEvalWorkFlow(evalWorkFlow);
        tdInfo.put("entry", entryColl);
        TargetDeployFactory.getLocalInstance(ctx).submit(tdInfo);
    }

    @Override
    protected boolean _checkEvaluGroupIfExistTargetType(Context ctx, String solutionPeriodID, Set evaluGroupIDSet) throws BOSException, EASBizException {
        IRowSet rs;
        boolean flag = true;
        StringBuffer sql = new StringBuffer();
        sql.append(" select evauGroupTargetType.FID  from  T_PF_EvaluGroupTargetType evauGroupTargetType  ").append(" inner join T_PF_EvaluGroup evaluGroup on evauGroupTargetType.FEvaluGroupID = evaluGroup.FID ").append(" inner join T_PF_SolutionPeriod solutionPeriod  on evaluGroup.FSolutionPeriodID = solutionPeriod.FID").append(" where solutionPeriod.Fid = '").append(solutionPeriodID).append("' ");
        if (evaluGroupIDSet != null && evaluGroupIDSet.size() > 0) {
            sql.append(" and evaluGroup.fid in (");
            sql.append(PerfUtils.convertSetToString(evaluGroupIDSet));
            sql.append(")");
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).size() <= 0) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected boolean _checkEvaluGroupIfExistEvaluGroupObject(Context ctx, String solutionPeriodID, Set evaluGroupIDSet) throws BOSException, EASBizException {
        boolean flag = true;
        StringBuffer sql = new StringBuffer();
        sql.append(" select evaluGroupObject.FID, evaluGroupObject.FEvaluObjectID from  T_PF_EvaluGroupTargetType evauGroupTargetType  ").append(" inner join T_PF_EvaluGroup evaluGroup on evauGroupTargetType.FEvaluGroupID = evaluGroup.FID ").append(" inner join T_PF_SolutionPeriod solutionPeriod  on evaluGroup.FSolutionPeriodID = solutionPeriod.FID").append(" inner join T_PF_EvaluGroupObject evaluGroupObject on evaluGroup.FID =evaluGroupObject.FEvaluGroupID").append(" where solutionPeriod.Fid = '").append(solutionPeriodID).append("' ");
        if (evaluGroupIDSet != null && evaluGroupIDSet.size() > 0) {
            sql.append(" and evaluGroup.fid in (");
            sql.append(PerfUtils.convertSetToString(evaluGroupIDSet));
            sql.append(")");
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" select distinct FEvaluGroupID from T_PF_EvaluGroupObject ");
        sqlStr.append(" where FEvaluGroupID in (");
        sqlStr.append(PerfUtils.convertSetToString(evaluGroupIDSet));
        sqlStr.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        if (rs.size() != evaluGroupIDSet.size()) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected void _deliverGroupTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluGroupIdSet.size() <= 0) {
            return;
        }
        TargetEvaluStoreParentFactory.getLocalInstance(ctx).addnew(solutionPeriodId, evaluGroupIdSet);
        TargetEvaluStoreFactory.getLocalInstance(ctx).addnew(evaluGroupIdSet);
        this.setTargetEvaluStoreAuditStatus(ctx, solutionPeriodId, evaluGroupIdSet);
        this.setGroupState(ctx, solutionPeriodId, evaluGroupIdSet);
        List TargetEvaluStoreIdList = this.getGroupObjectTargetStoreIDForCreateAchieveData(ctx, solutionPeriodId, evaluGroupIdSet);
        if (TargetEvaluStoreIdList != null && TargetEvaluStoreIdList.size() > 0) {
            AchieveDataHelper.createAchieveDataonDeliverTarget(ctx, solutionPeriodId, TargetEvaluStoreIdList);
        }
    }

    @Override
    protected void _deliverGroupTarget(Context ctx, String solutionPeriodId, String evaluGroupId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        if (solutionPeriodId == null || evaluGroupId == null) {
            return;
        }
        HashSet<String> evaluGroupIdSet = new HashSet<String>();
        evaluGroupIdSet.add(evaluGroupId);
        TargetEvaluStoreParentFactory.getLocalInstance(ctx).addnew(solutionPeriodId, evaluObjectIdSet, null);
        TargetEvaluStoreFactory.getLocalInstance(ctx).addnew(evaluGroupId, evaluObjectIdSet);
        Connection conn = null;
        PreparedStatement pstmtStore = null;
        PreparedStatement pstmtGroup = null;
        PreparedStatement pstmtGetStoreId = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sqlStore = new StringBuffer();
            sqlStore.append("update T_PF_TargetEvaluStore set fisDelivered = ?,FAuditStatus = ? where fsolutionPeriodID = ? and FUniteTarget = 1 and FEvaluObjectID in (");
            sqlStore.append(PerfUtils.convertSetToString(evaluObjectIdSet));
            sqlStore.append(")");
            pstmtStore = conn.prepareStatement(sqlStore.toString());
            pstmtStore.setInt(1, 1);
            pstmtStore.setInt(2, 20);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtStore, (int)3, (String)solutionPeriodId);
            pstmtStore.executeUpdate();
            StringBuffer sqlGroup = new StringBuffer();
            sqlGroup.append("update T_PF_EvaluGroup set FDelivered = ? where fsolutionPeriodID = ? and fid in (");
            sqlGroup.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sqlGroup.append(")");
            pstmtGroup = conn.prepareStatement(sqlGroup.toString());
            pstmtGroup.setInt(1, 1);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtGroup, (int)2, (String)solutionPeriodId);
            pstmtGroup.executeUpdate();
            StringBuffer sqlGetStoreId = new StringBuffer();
            sqlGetStoreId.append("SELECT FID FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID in(");
            sqlGetStoreId.append(PerfUtils.convertSetToString(this.getObjectIdstoreParentStateIsDelivered(ctx, solutionPeriodId, evaluObjectIdSet)));
            sqlGetStoreId.append(")");
            pstmtGetStoreId = conn.prepareStatement(sqlGetStoreId.toString());
            pstmtGetStoreId.setString(1, solutionPeriodId);
            ResultSet rowSet = pstmtGetStoreId.executeQuery();
            ArrayList<String> tesIds = new ArrayList<String>(rowSet.getRow());
            while (rowSet.next()) {
                tesIds.add(rowSet.getString("FID"));
            }
            if (tesIds != null && tesIds.size() > 0) {
                AchieveDataHelper.createAchieveDataonDeliverTarget2(ctx, solutionPeriodId, tesIds);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtStore);
                SQLUtils.cleanup(pstmtGroup);
                SQLUtils.cleanup(pstmtGetStoreId, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtStore);
        SQLUtils.cleanup((Statement)pstmtGroup);
        SQLUtils.cleanup((Statement)pstmtGetStoreId, (Connection)conn);
    }

    private void setTargetEvaluStoreAuditStatus(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        StringBuffer sqlStore = new StringBuffer();
        sqlStore.append("update T_PF_TargetEvaluStore set fisDelivered = ?,FAuditStatus = ? where fsolutionPeriodID = ? and FUniteTarget = 1 and FEvaluObjectID in (");
        sqlStore.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
        sqlStore.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sqlStore.append("))");
        Connection conn = null;
        PreparedStatement pstmtStore = null;
        try {
            conn = this.getConnection(ctx);
            pstmtStore = conn.prepareStatement(sqlStore.toString());
            pstmtStore.setInt(1, 1);
            pstmtStore.setInt(2, 20);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtStore, (int)3, (String)solutionPeriodId);
            pstmtStore.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtStore);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtStore);
        SQLUtils.cleanup((Connection)conn);
    }

    private void setGroupState(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        StringBuffer sqlGroup = new StringBuffer();
        sqlGroup.append("update T_PF_EvaluGroup set FDelivered = ? where fsolutionPeriodID = ? and fid in (");
        sqlGroup.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sqlGroup.append(")");
        Connection conn = null;
        PreparedStatement pstmtGroup = null;
        try {
            conn = this.getConnection(ctx);
            pstmtGroup = conn.prepareStatement(sqlGroup.toString());
            pstmtGroup.setInt(1, 1);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtGroup, (int)2, (String)solutionPeriodId);
            pstmtGroup.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtGroup);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtGroup);
        SQLUtils.cleanup((Connection)conn);
    }

    private Set getEvaluGroupIdSetForCreateAchieveData(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        HashSet<String> newEvaluGroupIdSet = new HashSet<String>();
        for (int k = 0; k < evaluGroupIdSet.size(); ++k) {
            String evaluGroupID = (String)evaluGroupIdSet.iterator().next();
            Set evaluObjectIDSet = this.searchEvaluGroupObject(ctx, evaluGroupID);
            boolean isDelivered = this.targetEvaluStoreParentStateIsDelivered(ctx, solutionPeriodId, evaluObjectIDSet);
            if (!isDelivered) continue;
            newEvaluGroupIdSet.add(evaluGroupID);
        }
        return newEvaluGroupIdSet;
    }

    private List getGroupObjectTargetStoreIDForCreateAchieveData(Context ctx, String solutionPeriodId, Set newEvaluGroupIdSet) throws BOSException, EASBizException {
        StringBuffer sqlGetStoreId = new StringBuffer();
        sqlGetStoreId.append("SELECT FID FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FSTATE = 2 AND FEvaluObjectID in(");
        sqlGetStoreId.append("select FEvaluObjectID from t_pf_evaluGroupObject WHERE FEvaluGroupID IN (");
        sqlGetStoreId.append(PerfUtils.convertSetToString(newEvaluGroupIdSet));
        sqlGetStoreId.append(")");
        sqlGetStoreId.append(")");
        Connection conn = null;
        PreparedStatement pstmtGetStoreId = null;
        ArrayList<String> tesIds = null;
        try {
            conn = this.getConnection(ctx);
            pstmtGetStoreId = conn.prepareStatement(sqlGetStoreId.toString());
            pstmtGetStoreId.setString(1, solutionPeriodId);
            ResultSet rowSet = pstmtGetStoreId.executeQuery();
            tesIds = new ArrayList<String>(rowSet.getRow());
            while (rowSet.next()) {
                tesIds.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtGetStoreId);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtGetStoreId);
        SQLUtils.cleanup((Connection)conn);
        return tesIds;
    }

    private Set searchEvaluGroupObject(Context ctx, String evaluGroupId) throws BOSException, EASBizException {
        StringBuffer evaluGroupObjectSql = new StringBuffer();
        evaluGroupObjectSql.append("select FEvaluObjectID from t_pf_evaluGroupObject WHERE FEvaluGroupID IN ('");
        evaluGroupObjectSql.append(evaluGroupId);
        evaluGroupObjectSql.append("')");
        Connection conn = null;
        PreparedStatement pstmtEvaluGroupObject = null;
        ResultSet rowSet = null;
        HashSet<String> evaluObjectIds = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            pstmtEvaluGroupObject = conn.prepareStatement(evaluGroupObjectSql.toString());
            rowSet = pstmtEvaluGroupObject.executeQuery();
            while (rowSet.next()) {
                evaluObjectIds.add(rowSet.getString("FEvaluObjectID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet);
                SQLUtils.cleanup(pstmtEvaluGroupObject);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        SQLUtils.cleanup((Statement)pstmtEvaluGroupObject);
        SQLUtils.cleanup((Connection)conn);
        return evaluObjectIds;
    }

    private boolean targetEvaluStoreParentStateIsDelivered(Context ctx, String solutionPeriod, Set evaluObjectIDSet) throws BOSException, EASBizException {
        Set objectIDSet = this.getObjectIdstoreParentStateIsDelivered(ctx, solutionPeriod, evaluObjectIDSet);
        return objectIDSet != null && objectIDSet.size() > 0;
    }

    private Set getObjectIdstoreParentStateIsDelivered(Context ctx, String solutionPeriod, Set evaluObjectIDSet) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriod));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectIDSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        TargetEvaluStoreParentCollection parentColl = TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentCollection(evi);
        HashSet<String> returnSet = new HashSet<String>();
        int size = parentColl.size();
        for (int i = 0; i < size; ++i) {
            returnSet.add(parentColl.get(i).getEvaluObject().getId().toString());
        }
        return returnSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _undeliverGroupTarget(Context ctx, String solutionPeriodId, Set evaluGroupIdSet, boolean isDelPlatformTarget) throws BOSException, EASBizException {
        if (solutionPeriodId == null) return;
        if (evaluGroupIdSet == null) return;
        if (evaluGroupIdSet.size() <= 0) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluSolution.modifyContent"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        boolean isModifyFormSolutionContent = solutionPeriodInfo.getEvaluSolution().isModifyContent();
        StringBuffer sqlGetStoreId = new StringBuffer();
        sqlGetStoreId.append("SELECT FID FROM T_PF_TargetEvaluStore WHERE FSolutionPeriodID = ? AND FEvaluObjectID in(");
        sqlGetStoreId.append("select FEvaluObjectID from t_pf_evaluGroupObject WHERE FEvaluGroupID IN (");
        sqlGetStoreId.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sqlGetStoreId.append(")");
        sqlGetStoreId.append(")");
        StringBuffer sqlGetDelUnUniteEvaluTargetID = new StringBuffer();
        sqlGetDelUnUniteEvaluTargetID.append("select FEvaluTargetID from T_PF_TargetEvaluStore where fsolutionPeriodID = ? ");
        if (!isDelPlatformTarget) {
            sqlGetDelUnUniteEvaluTargetID.append(" and fdeleteableByUndeliver = 1 ");
        }
        sqlGetDelUnUniteEvaluTargetID.append("and FUniteTarget =0  and FEvaluObjectID in (");
        sqlGetDelUnUniteEvaluTargetID.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
        sqlGetDelUnUniteEvaluTargetID.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sqlGetDelUnUniteEvaluTargetID.append("))");
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_PF_TargetEvaluStore where fsolutionPeriodID = ? ");
        if (!isDelPlatformTarget) {
            sql.append(" and fdeleteableByUndeliver = 1 ");
        }
        sql.append(" and FEvaluObjectID in (");
        sql.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
        sql.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sql.append("))");
        StringBuffer sql1 = new StringBuffer();
        sql1.append("update T_PF_TargetEvaluStore set fisDelivered = ?,FAuditStatus = ? ,FState = ? where fsolutionPeriodID = ? and FEvaluObjectID in (");
        sql1.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
        sql1.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sql1.append("))");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update T_PF_EvaluGroup set FDelivered = ? where fsolutionPeriodID = ? and fid in (");
        sql2.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sql2.append(")");
        StringBuffer sql3 = new StringBuffer();
        sql3.append("update t_pf_TargetEvaluStoreparent set FState = ?,FSolutionDeliverd = ? ");
        sql3.append(" where  fsolutionperiodid='");
        sql3.append(solutionPeriodId);
        sql3.append("' and FEvaluObjectID in (");
        sql3.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
        sql3.append(PerfUtils.convertSetToString(evaluGroupIdSet));
        sql3.append("))");
        Connection conn = null;
        PreparedStatement pstmtGetStoreId = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        PreparedStatement pstmt5 = null;
        PreparedStatement pstmt6 = null;
        PreparedStatement pstmtGetDelUnUniteEvaluTargetID = null;
        PreparedStatement pstmtDelUnUniteEvaluTargetID = null;
        try {
            String procInstID;
            ProcessInstInfo procInst;
            int i;
            conn = this.getConnection(ctx);
            StringBuffer sql4 = new StringBuffer();
            sql4.append(" select FParentID from T_PF_TargetEvaluStore  where fsolutionPeriodID = ? and FEvaluObjectID in (");
            sql4.append("select FevaluObjectID from t_pf_evaluGroupObject where fevalugroupid in (");
            sql4.append(PerfUtils.convertSetToString(evaluGroupIdSet));
            sql4.append("))");
            HashSet<String> ParentIDSet = new HashSet<String>();
            pstmt4 = conn.prepareStatement(sql4.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt4, (int)1, (String)solutionPeriodId);
            ResultSet ParentIDRowSet = pstmt4.executeQuery();
            while (ParentIDRowSet.next()) {
                ParentIDSet.add(ParentIDRowSet.getString("FParentID"));
            }
            StringBuffer sql5 = new StringBuffer();
            sql5.append("select FPROCINSTID from T_WFR_Assign assign where assign.FBIZOBJID in(");
            sql5.append(PerfUtils.convertSetToString(ParentIDSet));
            sql5.append(")");
            ArrayList<String> currencyProcinstidList = new ArrayList<String>();
            pstmt5 = conn.prepareStatement(sql5.toString());
            ResultSet currencyProcinstidRowSet = pstmt5.executeQuery();
            while (currencyProcinstidRowSet.next()) {
                currencyProcinstidList.add(currencyProcinstidRowSet.getString("FPROCINSTID"));
            }
            StringBuffer sql6 = new StringBuffer();
            sql6.append("select FPROCINSTID from T_WFR_AssignDetail assignDetail where assignDetail.FBIZOBJID in(");
            sql6.append(PerfUtils.convertSetToString(ParentIDSet));
            sql6.append(")");
            ArrayList<String> historyProcinstidList = new ArrayList<String>();
            pstmt6 = conn.prepareStatement(sql6.toString());
            ResultSet historyProcinstidRowSet = pstmt6.executeQuery();
            while (historyProcinstidRowSet.next()) {
                historyProcinstidList.add(historyProcinstidRowSet.getString("FPROCINSTID"));
            }
            EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
            if (currencyProcinstidList != null && currencyProcinstidList.size() > 0) {
                for (i = 0; i < currencyProcinstidList.size(); ++i) {
                    procInst = null;
                    procInstID = null;
                    procInstID = currencyProcinstidList.get(i).toString();
                    if (!StringUtils.isEmpty((String)procInstID)) {
                        try {
                            procInst = enactmentService.getProcessInstInfo(procInstID);
                        }
                        catch (Exception e) {
                            logger.error((Object)("procInstID: " + procInstID));
                            logger.error((Object)e);
                        }
                    }
                    if (procInst == null || procInst.getState().startsWith(WfState.CLOSED.getValue())) continue;
                    enactmentService.terminateProcessInst(procInst.getProcInstId());
                }
            }
            if (historyProcinstidList != null && historyProcinstidList.size() > 0) {
                for (i = 0; i < historyProcinstidList.size(); ++i) {
                    procInst = null;
                    procInstID = null;
                    procInstID = historyProcinstidList.get(i).toString();
                    if (!StringUtils.isEmpty((String)procInstID)) {
                        try {
                            procInst = enactmentService.getProcessInstInfo(procInstID);
                        }
                        catch (Exception e) {
                            logger.error((Object)("procInstID: " + procInstID));
                            logger.error((Object)e);
                        }
                    }
                    if (procInst == null || procInst.getState().startsWith(WfState.CLOSED.getValue())) continue;
                    enactmentService.terminateProcessInst(procInst.getProcInstId());
                }
            }
            pstmtGetStoreId = conn.prepareStatement(sqlGetStoreId.toString());
            pstmtGetStoreId.setString(1, solutionPeriodId);
            ResultSet rowSet = pstmtGetStoreId.executeQuery();
            ArrayList<String> tesIds = new ArrayList<String>(rowSet.getRow());
            while (rowSet.next()) {
                tesIds.add(rowSet.getString("FID"));
            }
            if (evaluGroupIdSet != null) {
                if (tesIds != null && tesIds.size() >= 0) {
                    AchieveDataHelper.delAchieveDataOnUnDeliverTarget2(ctx, solutionPeriodId, tesIds);
                }
            } else {
                AchieveDataHelper.delAchieveDataOnUnDeliverTarget(ctx, solutionPeriodId);
            }
            HashSet<String> evaluTargetIdDel = new HashSet<String>();
            pstmtGetDelUnUniteEvaluTargetID = conn.prepareStatement(sqlGetDelUnUniteEvaluTargetID.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtGetDelUnUniteEvaluTargetID, (int)1, (String)solutionPeriodId);
            ResultSet resultIdSet = pstmtGetDelUnUniteEvaluTargetID.executeQuery();
            while (resultIdSet.next()) {
                evaluTargetIdDel.add(resultIdSet.getString("FEvaluTargetID"));
            }
            pstmt = conn.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
            pstmt.executeUpdate();
            pstmtDelUnUniteEvaluTargetID = conn.prepareStatement("delete from t_pf_evalutarget where fid in (" + PerfUtils.convertSetToString(evaluTargetIdDel) + ")");
            pstmtDelUnUniteEvaluTargetID.executeUpdate();
            pstmt1 = conn.prepareStatement(sql1.toString());
            pstmt1.setInt(1, 0);
            pstmt1.setInt(2, 10);
            pstmt1.setInt(3, 3);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)4, (String)solutionPeriodId);
            pstmt1.executeUpdate();
            pstmt2 = conn.prepareStatement(sql2.toString());
            pstmt2.setInt(1, 0);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt2, (int)2, (String)solutionPeriodId);
            pstmt2.executeUpdate();
            pstmt3 = conn.prepareStatement(sql3.toString());
            pstmt3.setInt(1, 3);
            pstmt3.setInt(2, 0);
            pstmt3.executeUpdate();
        }
        catch (EvaluSolutionException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt1);
                SQLUtils.cleanup(pstmt2);
                SQLUtils.cleanup(pstmt3);
                SQLUtils.cleanup(pstmt4);
                SQLUtils.cleanup(pstmt5);
                SQLUtils.cleanup(pstmt6);
                SQLUtils.cleanup(pstmtGetDelUnUniteEvaluTargetID);
                SQLUtils.cleanup(pstmtDelUnUniteEvaluTargetID);
                SQLUtils.cleanup(pstmtGetStoreId, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt1);
        SQLUtils.cleanup((Statement)pstmt2);
        SQLUtils.cleanup((Statement)pstmt3);
        SQLUtils.cleanup((Statement)pstmt4);
        SQLUtils.cleanup((Statement)pstmt5);
        SQLUtils.cleanup((Statement)pstmt6);
        SQLUtils.cleanup((Statement)pstmtGetDelUnUniteEvaluTargetID);
        SQLUtils.cleanup((Statement)pstmtDelUnUniteEvaluTargetID);
        SQLUtils.cleanup((Statement)pstmtGetStoreId, (Connection)conn);
    }

    private PrecisionMaintainInfo getPrecisionMaintainInfo(Context ctx, String evaluSolutionID) throws BOSException, EASBizException {
        PrecisionMaintainInfo pMaintainInfo = new PrecisionMaintainInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution", (Object)evaluSolutionID));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        PrecisionMaintainCollection pMaintainColl = PrecisionMaintainFactory.getLocalInstance(ctx).getPrecisionMaintainCollection(evi);
        if (pMaintainColl != null && pMaintainColl.size() > 0) {
            pMaintainInfo = pMaintainColl.get(0);
        }
        return pMaintainInfo;
    }

    private void dealLogInfo(Context ctx, EvaluSolutionInfo info, String logItem) throws BOSException, EASBizException {
        String retValue = null;
        if (!StringUtils.isEmpty((String)info.getName())) {
            retValue = info.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluSolutionFactory.getLocalInstance(ctx).getType(), null, (String)retValue.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

