/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluSolutionCollection;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetCollection;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IEvaluSolutionFacade;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;

public class EvaluSolutionServerHelper {
    public static EvaluObjectCollection getEvaluObjectCollection(Context ctx, String evaluGroupId) throws BOSException, EASBizException {
        if (evaluGroupId == null) {
            return null;
        }
        EvaluObjectCollection objectColl = new EvaluObjectCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        IEvaluGroupObject object = EvaluGroupObjectFactory.getLocalInstance(ctx);
        EvaluGroupObjectCollection groupObjectColl = object.getEvaluGroupObjectCollection(evi);
        EvaluGroupObjectInfo groupObjectInfo = null;
        for (int i = 0; i < groupObjectColl.size(); ++i) {
            groupObjectInfo = groupObjectColl.get(i);
            objectColl.add(groupObjectInfo.getEvaluObject());
        }
        return objectColl;
    }

    public static EvaluTargetCollection getEvaluTargetCollection(Context ctx, String evaluGroupId) throws BOSException, EASBizException {
        if (evaluGroupId == null) {
            return null;
        }
        EvaluTargetCollection targetColl = new EvaluTargetCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        IEvaluGroupTarget target = EvaluGroupTargetFactory.getLocalInstance(ctx);
        EvaluGroupTargetCollection groupTargetColl = target.getEvaluGroupTargetCollection(evi);
        EvaluGroupTargetInfo groupTargetInfo = null;
        for (int i = 0; i < groupTargetColl.size(); ++i) {
            groupTargetInfo = groupTargetColl.get(i);
            targetColl.add(groupTargetInfo.getEvaluTarget());
        }
        return targetColl;
    }

    public static EvaluSolutionInfo getEvaluSolutionInfo(Context context, String evaluSolutionId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("targetGradeModeLink.id"));
        sic.add(new SelectorItemInfo("targetGradeModeLink.name"));
        sic.add(new SelectorItemInfo("targetRankGroup.id"));
        sic.add(new SelectorItemInfo("targetRankGroup.name"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("rankGroup.name"));
        sic.add(new SelectorItemInfo("targetGradeMode"));
        sic.add(new SelectorItemInfo("weightCreateMode"));
        sic.add(new SelectorItemInfo("targetCreateMode"));
        sic.add(new SelectorItemInfo("deliverMode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("canViewEvaluForm"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("solutionType"));
        sic.add(new SelectorItemInfo("canComment"));
        sic.add(new SelectorItemInfo("allocateTarget"));
        sic.add(new SelectorItemInfo("viewSelfForm"));
        sic.add(new SelectorItemInfo("viewOtherResult"));
        sic.add(new SelectorItemInfo("outGradeMode"));
        sic.add(new SelectorItemInfo("viewWeight"));
        sic.add(new SelectorItemInfo("isControlWeight"));
        return EvaluSolutionFactory.getLocalInstance(context).getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionId), sic);
    }

    public static IRowSet getRowSet(Context context, String queryName, FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static boolean isExistSolutionPeriodStarted(Context context, String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(context);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        return solutionPeriod.exists(fi);
    }

    public static DeliverModeEnum getDeliverMode(Context context, String evaluSolutionId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("deliverMode"));
        EvaluSolutionInfo info = EvaluSolutionFactory.getLocalInstance(context).getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionId), sic);
        return info.getDeliverMode();
    }

    public static boolean isExistSolutionPeriodStartedOrEnded(Context context, String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(context);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(102)));
        fi.setMaskString("#0 AND (#1 OR #2)");
        return solutionPeriod.exists(fi);
    }

    public static SolutionStatusEnum getEvaluSolutionStatus(Context context, String evaluSolutionId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionStatus"));
        return EvaluSolutionFactory.getLocalInstance(context).getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionId), sic).getSolutionStatus();
    }

    public static SolutionPeriodCollection initSolutionPeriod(Context context, String evaluSolutionId, boolean isUsingHROrgUnitAndOrgRangeFilter) throws Exception {
        if (evaluSolutionId == null) {
            return null;
        }
        return EvaluSolutionServerHelper.initSolutionPeriod(context, evaluSolutionId, null, null, isUsingHROrgUnitAndOrgRangeFilter);
    }

    private static SolutionPeriodCollection initSolutionPeriod(Context context, String evaluSolutionId, SolutionPeriodStatusEnum status, EvaluSolutionTypeEnum type, boolean isUsingHROrgUnitAndOrgRangeFilter) throws Exception {
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(context);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (evaluSolutionId != null) {
            fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionId));
        }
        if (status != null) {
            fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(status.getValue())));
        }
        if (type != null) {
            fi.getFilterItems().add(new FilterItemInfo("evaluSolution.solutionType", (Object)new Integer(type.getValue())));
        }
        if (isUsingHROrgUnitAndOrgRangeFilter) {
            fi.mergeFilter(PfServerUtils.getHRAndAdminRangeFilterInfo(context, "evaluSolution.hrOrgUnit.id", "evaluSolution.orgUnit.id"), "AND");
        }
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("status"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.number"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        SolutionPeriodCollection solutionPeriodCollction = solutionPeriod.getSolutionPeriodCollection(evi);
        return solutionPeriodCollction;
    }

    public static boolean isTargetDelivered(Context context, String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return false;
        }
        IEvaluSolutionFacade solutionFacade = EvaluSolutionFacadeFactory.getLocalInstance(context);
        return solutionFacade.isTargetDelivered(solutionPeriodId);
    }

    public static boolean isSolutionAllocateTarget(Context context, String solutionId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionId));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("allocateTarget"));
        EvaluSolutionCollection coll = EvaluSolutionFactory.getLocalInstance(context).getEvaluSolutionCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getAllocateTarget() == 1;
        }
        return false;
    }

    public static SolutionPeriodStatusEnum getSolutionPeriodStatus(Context context, String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return SolutionPeriodStatusEnum.UN_EVALU;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("status"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getLocalInstance(context).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        return solutionPeriodInfo.getStatus();
    }

    public static FilterInfo getHROrgUnitAndOrgRangeFilter(Context context, String hrOrgUnit, String adminOrgUnit) throws Exception {
        String userID = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)context).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(adminOrgUnit, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrOrgUnit, (Object)hrOrgUnitID);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static void showWorkFlowDef(Context context, String procDefId) throws Exception {
        EnactmentService ormServer = new EnactmentService();
        ProcessDefInfo procDefInfo = ormServer.getProcessDefInfo(procDefId);
        Locale currentLocale = context.getLocale();
        if (procDefInfo == null) {
            return;
        }
        ProcessDef processDef = EnactmentServiceFactory.createEnactService((Context)context).getProcessDefByDefineHashValue(procDefInfo.getMd5HashValue());
    }

    public static void showWfDiagramOnNoFlowInstance(Context context, String solutionPeriodID, String evaluObjectID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("evaluObject.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 AND #1");
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalWorkFlowQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        String workflowId = null;
        if (rowSet.size() != 0) {
            rowSet.next();
            workflowId = rowSet.getString("workFlowID");
            EvaluSolutionServerHelper.showWorkFlowDef(context, workflowId);
        }
        rowSet.beforeFirst();
    }

    public static void showWfDiagram(Context context, String solutionPeriodId, String evaluObjectId) throws Exception {
        if (solutionPeriodId == null || evaluObjectId == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
        filterInfo.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("procInstID"));
        EvalWFObjectsCollection collection = EvalWFObjectsFactory.getLocalInstance(context).getEvalWFObjectsCollection(viewInfo);
        String procInstID = null;
        if (collection == null || collection.size() == 0) {
            return;
        }
        procInstID = collection.get(0).getProcInstID();
    }

    public static boolean isExistFlowInstance(Context context, String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        EvaluSolutionInfo solutionInfo = EvaluSolutionServerHelper.getEvaluSolutionInfo(context, evaluSolutionId);
        DeliverModeEnum deliverModeEnum = solutionInfo.getDeliverMode();
        return deliverModeEnum == null || !deliverModeEnum.equals((Object)DeliverModeEnum.DIRECT_ENTER);
    }
}

