/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.app.AbstractEvaluTargetControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class EvaluTargetControllerBean
extends AbstractEvaluTargetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.EvaluTargetControllerBean");

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return " ";
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        EvaluTargetInfo info = (EvaluTargetInfo)super._getValue(ctx, pk, sic);
        if (info != null) {
            return info.getNumber();
        }
        return " ";
    }

    @Override
    protected void _batchUpdate(Context ctx, List infos) throws BOSException, EASBizException {
        if (infos == null || infos.size() == 0) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("standard"));
        sic.add(new SelectorItemInfo("kind"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("thresholdValue"));
        sic.add(new SelectorItemInfo("standardValue"));
        sic.add(new SelectorItemInfo("challengeValue"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("reportFrequency"));
        sic.add(new SelectorItemInfo("scoringMethod"));
        sic.add(new SelectorItemInfo("evaluationSide"));
        sic.add(new SelectorItemInfo("reservedField1"));
        sic.add(new SelectorItemInfo("reservedField2"));
        sic.add(new SelectorItemInfo("formula"));
        sic.add(new SelectorItemInfo("seqNumber"));
        EvaluTargetInfo info = null;
        String sql = "update T_PF_TargetEvaluStore set FThresholdValue = ?, FStandardValue = ?, FChallengeValue = ? where FEvaluTargetId = ?";
        Connection conn = this.getConnection(ctx);
        PreparedStatement prst = null;
        try {
            prst = conn.prepareStatement(sql);
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            info = (EvaluTargetInfo)infos.get(i);
            super.updatePartial(ctx, (CoreBaseInfo)info, sic);
            try {
                prst.setBigDecimal(1, info.getThresholdValue());
                prst.setBigDecimal(2, info.getStandardValue());
                prst.setBigDecimal(3, info.getChallengeValue());
                DbUtil.prepareVarcharParam((PreparedStatement)prst, (int)4, (String)info.getId().toString());
                prst.addBatch();
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        try {
            prst.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)prst, (Connection)conn);
        }
    }
}

