/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.app.AbstractEvaluTargetDetailListUIHandler;
import com.kingdee.eas.hr.perf.app.EvaluSolutionServerHelper;
import com.kingdee.eas.util.app.ContextUtil;

public class EvaluTargetDetailListUIHandler
extends AbstractEvaluTargetDetailListUIHandler {
    private String firstSolutionPeriodId;

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (ContextUtil.getCurrentHRUnit((Context)context) == null) {
            return;
        }
        ISolutionPeriod solutionPeriod = SolutionPeriodFactory.getLocalInstance(context);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.solutionType", (Object)new Integer(100)));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)context).getId().toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("status"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.number"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        SolutionPeriodCollection coll = solutionPeriod.getSolutionPeriodCollection(evi);
        if (coll.size() > 0) {
            FilterInfo initFilter = this.getInitFilterForQuery(context, coll.get(0));
            request.setInitFilterInfo(initFilter);
        }
        if (coll != null && coll.size() > 0) {
            this.firstSolutionPeriodId = coll.get(0).getId().toString();
        }
        super._handleInit(request, response, context);
    }

    @Override
    protected void _handleActionEvaluForm(RequestContext request, ResponseContext response, Context context) throws Exception {
        String solutionPeriodId = (String)request.get("solutionPeriodId");
        String evaluObjectId = (String)request.get("evaluObjectId");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectId));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodId));
        NodeProcesserFactory.getLocalInstance(context).exists(filter);
    }

    @Override
    protected void _handleActionRestartFlow(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSummary(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewFlow(RequestContext request, ResponseContext response, Context context) throws Exception {
        String evaluSolutionId = (String)request.get("evaluSolutionId");
        String solutionPeriodId = (String)request.get("solutionPeriodId");
        String evaluObjectId = (String)request.get("evaluObjectId");
        BizEnumValueInfo status = (BizEnumValueInfo)request.get("status");
        if (solutionPeriodId == null || evaluObjectId == null) {
            return;
        }
        if (status.getInt() == 10) {
            EvaluSolutionServerHelper.showWfDiagramOnNoFlowInstance(context, solutionPeriodId, evaluObjectId);
        } else if (!EvaluSolutionServerHelper.isExistFlowInstance(context, evaluSolutionId)) {
            EvaluSolutionServerHelper.showWfDiagramOnNoFlowInstance(context, solutionPeriodId, evaluObjectId);
        } else {
            EvaluSolutionServerHelper.showWfDiagram(context, solutionPeriodId, evaluObjectId);
        }
    }

    @Override
    protected void _handleActionFlowHasten(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected FilterInfo getInitFilterForQuery(Context context, SolutionPeriodInfo solutionPeriodInfo) throws Exception {
        String solutionPeriodId = null;
        solutionPeriodId = solutionPeriodInfo != null ? solutionPeriodInfo.getId().toString() : "%noeas%";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("rsSolutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(context, "orgUnit.id"));
        return filter;
    }

    public ResponseContext tableRequestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVirtualModel(false);
        return super.tableRequestData(request, response, context);
    }

    protected IQueryExecutor getQueryExecutor(RequestContext request, ResponseContext response, Context context) throws Exception {
        IQueryExecutor exec = super.getQueryExecutor(request, response, context);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected FilterInfo getDefaultFilterForQuery(RequestContext request, Context context) throws Exception {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)request.get("solutionPeriod");
        String solutionPeriodId = null;
        solutionPeriodId = solutionPeriodInfo != null ? solutionPeriodInfo.getId().toString() : this.firstSolutionPeriodId;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("rsSolutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(context, "orgUnit.id"));
        return filter;
    }
}

