/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.PerfModeEnum;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormulaComputeHelper {
    public static final String pt_sp_condit = "1";
    public static final String pt_obj_condit = "2";
    public static final String ot_sp_condit = "3";
    public static final String ot_obj_condit = "4";
    public static final String pm_sp_condit = "5";
    public static final String pm_obj_condit = "6";
    public static final String om_sp_condit = "7";
    public static final String om_obj_condit = "8";
    public static final String syn_sp_condit = "9";
    public static final String syn_obj_condit = "10";
    public static final String sum_sp_condit = "11";
    public static final String sum_obj_condit = "12";
    public static final String error_id = "error_id";

    public static Map buildConditionMap(Map map, String key, String value) {
        StringBuffer pt_sp_condit = map.containsKey(key) ? (StringBuffer)map.get(key) : new StringBuffer();
        if (pt_sp_condit.length() > 0) {
            pt_sp_condit.append(",");
        }
        pt_sp_condit.append("'").append(value).append("'");
        map.put(key, pt_sp_condit);
        return map;
    }

    public static String buildInSql(Set set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList list = new ArrayList(set);
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            if (list.get(i) == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(list.get(i).toString()).append("'");
        }
        return sb.toString();
    }

    public static String getOrgOrPersonId(Context ctx, String objId, PerfModeEnum pm) throws BOSException, EASBizException {
        if (PerfModeEnum.personTarget.equals((Object)pm) || PerfModeEnum.orgTarget.equals((Object)pm)) {
            EvaluObjectInfo objInfo = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objId));
            return objInfo.getObjectID();
        }
        if (PerfModeEnum.personMulti.equals((Object)pm) || PerfModeEnum.orgMulti.equals((Object)pm)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("evaluOrg.id"));
            MultiDimentionObjectInfo objInfo = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(objId), sic);
            if (PerfModeEnum.personMulti.equals((Object)pm)) {
                return objInfo.getPerson().getId().toString();
            }
            return objInfo.getEvaluOrg().getId().toString();
        }
        if (PerfModeEnum.sum.equals((Object)pm)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            SumPersonInfo objInfo = SumPersonFactory.getLocalInstance(ctx).getSumPersonInfo((IObjectPK)new ObjectUuidPK(objId), sic);
            return objInfo.getPerson().getId().toString();
        }
        if (PerfModeEnum.complex.equals((Object)pm)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            SynEvaluObjectInfo objInfo = SynEvaluObjectFactory.getLocalInstance(ctx).getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objId), sic);
            return objInfo.getPerson().getId().toString();
        }
        return null;
    }

    public static String createTempTable(Connection conn, TempTablePool pool, List numCols, List txtCols) throws Exception {
        int i;
        if (!(numCols != null && numCols.size() > 0 || txtCols != null && txtCols.size() > 0)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTab ");
        sql.append(" ( ");
        sql.append(" FID varchar(44) ");
        int j = numCols.size();
        for (i = 0; i < j; ++i) {
            sql.append(",");
            sql.append(numCols.get(i).toString()).append("  NUMERIC(21,8)");
        }
        j = txtCols.size();
        for (i = 0; i < j; ++i) {
            sql.append(",");
            sql.append(txtCols.get(i).toString()).append("  nvarchar(300)");
        }
        sql.append(" ) ");
        return pool.createTempTable(sql.toString());
    }

    public static String getOwnerOrg(Context ctx, String personId) throws Exception {
        if (personId == null) {
            return error_id;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ps.FAdminOrgUnitID orgId from T_ORG_PositionMember pm ");
        sql.append(" inner join T_ORG_Position ps on ps.FId = pm.FPositionID ");
        sql.append(" where pm.FPersonID = '").append(personId).append("'");
        sql.append(" and pm.FIsPrimary = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getString("orgId");
        }
        return error_id;
    }
}

