/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.GradeModeEnum;
import com.kingdee.eas.hr.perf.GradeModeException;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.app.AbstractGradeModeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class GradeModeControllerBean
extends AbstractGradeModeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.GradeModeControllerBean");
    private static final String TABLE = " T_PF_GradeMode ";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GradeModeInfo info = (GradeModeInfo)model;
        super._checkNumberBlank(ctx, model);
        super._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        BigDecimal minGrade = info.getMinGrade();
        if (minGrade == null) {
            throw new GradeModeException(GradeModeException.MIN_GRADE_NULL);
        }
        if (minGrade.doubleValue() < 0.0) {
            throw new GradeModeException(GradeModeException.MIN_GRADE_NG);
        }
        BigDecimal maxGrade = info.getMaxGrade();
        if (maxGrade == null) {
            throw new GradeModeException(GradeModeException.MAX_GARDE_NULL);
        }
        if (maxGrade.compareTo(minGrade) < 1) {
            throw new GradeModeException(GradeModeException.MAX_MIN_GRATE);
        }
        if (!this.existDefaultGradeModeInfo(ctx)) {
            info.setIsDefault(GradeModeEnum.YES);
        } else if (info.getIsDefault().equals((Object)GradeModeEnum.YES)) {
            this.disableOldDefaultGradeMode(ctx);
        }
    }

    private boolean existDefaultGradeModeInfo(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return super._exists(ctx, filter);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        super._update(ctx, pk, model);
    }

    private void disableOldDefaultGradeMode(Context ctx) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_GradeMode SET FIsDefault = ? WHERE ( FIsDefault = ? ) AND (FHROrgUnitID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 10);
            pstmt.setInt(2, 0);
            String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)hrOrgUnitID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new GradeModeException(GradeModeException.ERROR_DATABASE);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GradeModeInfo dataBaseInfo = (GradeModeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)dataBaseInfo.getName()));
        if (this._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GradeModeInfo dataBaseInfo = (GradeModeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

