/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.InterviewEntryCollection;
import com.kingdee.eas.hr.perf.InterviewEntryInfo;
import com.kingdee.eas.hr.perf.InterviewEvalResultEntityCollection;
import com.kingdee.eas.hr.perf.InterviewEvalResultEntityFactory;
import com.kingdee.eas.hr.perf.InterviewEvalResultEntityInfo;
import com.kingdee.eas.hr.perf.InterviewFactory;
import com.kingdee.eas.hr.perf.InterviewInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.app.AbstractInterviewControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterviewControllerBean
extends AbstractInterviewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.InterviewControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    private boolean checkDataExists(InterviewInfo info, Context ctx) throws BOSException, EASBizException {
        String empID = info.getEmployee().getId().toString();
        String assID = info.getAssesspersiod().getId().toString();
        String interviewDate = info.getInterviewDate().toString();
        String evaluSolutionID = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)empID));
        filter.getFilterItems().add(new FilterItemInfo("assesspersiod", (Object)assID));
        filter.getFilterItems().add(new FilterItemInfo("interviewDate", (Object)interviewDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        if (info.getEvaluSolution() != null && info.getEvaluSolution().getId() != null) {
            evaluSolutionID = info.getEvaluSolution().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution", evaluSolutionID));
        return InterviewFactory.getLocalInstance(ctx).exists(filter);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InterviewInfo interviewInfo = (InterviewInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_PF_Interview SET FInterviewer = ? ,FEmployeeID = ? ,FInterviewDate = ?  WHERE  FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (!StringUtils.isEmpty((String)interviewInfo.getInterviewer())) {
                pstmt.setString(1, interviewInfo.getInterviewer());
            } else {
                pstmt.setString(1, null);
            }
            if (interviewInfo.getEmployee() != null && interviewInfo.getEmployee().getId() != null) {
                pstmt.setString(2, interviewInfo.getEmployee().getId().toString());
            } else {
                pstmt.setString(2, null);
            }
            if (interviewInfo.getInterviewDate() != null && interviewInfo.getInterviewDate() instanceof Date) {
                pstmt.setDate(3, (Date)interviewInfo.getInterviewDate());
            } else {
                pstmt.setDate(3, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)interviewInfo.getId().toString());
            pstmt.addBatch();
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        FilterItemInfo filterItem = null;
        FilterInfo fi = new FilterInfo();
        filterItem = new FilterItemInfo("interview.id", (Object)interviewInfo.getId().toString());
        fi.getFilterItems().add(filterItem);
        InterviewEvalResultEntityFactory.getLocalInstance(ctx).delete(fi);
        this.insertInEvalRes(ctx, interviewInfo);
        this.updateInterviewEntry(ctx, interviewInfo);
    }

    private void insertInEvalRes(Context ctx, InterviewInfo interviewInfo) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "insert INTO T_PF_InEvalRes (FID,FRemark_l2,FAssessperiodID,FEvaluSolutionId,FInterviewID) values (?,?,?,?,?)";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            InterviewEvalResultEntityCollection resultCol = interviewInfo.getInterviewEvalResult();
            int n = resultCol.size();
            for (int i = 0; i < n; ++i) {
                InterviewEvalResultEntityInfo resultInfo = resultCol.get(i);
                String id = BOSUuid.create((BOSObjectType)new InterviewEvalResultEntityInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                if (!StringUtils.isEmpty((String)resultInfo.getRemark())) {
                    pstmt.setString(2, resultInfo.getRemark());
                } else {
                    pstmt.setString(2, null);
                }
                if (resultInfo.getAssesspersiod() != null && resultInfo.getAssesspersiod().getId() != null) {
                    pstmt.setString(3, resultInfo.getAssesspersiod().getId().toString());
                } else {
                    pstmt.setString(3, null);
                }
                if (!StringUtils.isEmpty((String)resultInfo.getEvaluSolutionId())) {
                    pstmt.setString(4, resultInfo.getEvaluSolutionId());
                } else {
                    pstmt.setString(4, null);
                }
                if (resultInfo.getInterview() != null && resultInfo.getInterview().getId() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)resultInfo.getInterview().getId().toString());
                } else {
                    pstmt.setString(5, null);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateInterviewEntry(Context ctx, InterviewInfo interviewInfo) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_PF_InterviewEntry SET FContent = ? WHERE  FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            InterviewEntryCollection interviewEntryCollection = interviewInfo.getInteviewEntry();
            int n = interviewEntryCollection.size();
            for (int i = 0; i < n; ++i) {
                InterviewEntryInfo interviewEntryInfo = interviewEntryCollection.get(i);
                if (!StringUtils.isEmpty((String)interviewEntryInfo.getContent())) {
                    pstmt.setString(1, interviewEntryInfo.getContent());
                } else {
                    pstmt.setString(1, null);
                }
                if (interviewEntryInfo.getId() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)interviewEntryInfo.getId().toString());
                } else {
                    pstmt.setString(2, null);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _employeeChanged(Context ctx, String employeeID) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)employeeID, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        String[] selects = new String[]{"id", "name", "personDep.id", "personDep.name", "primaryPosition.id", "primaryPosition.name", "enterDate"};
        SelectorItemCollection sic = PerfUtils.getSic(selects);
        ev.setSelector(sic);
        ev.setFilter(filter);
        PersonPositionCollection personPositionColl = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(ev);
        if (personPositionColl != null && personPositionColl.size() > 0) {
            PersonPositionInfo info = personPositionColl.get(0);
            if (info.getPrimaryPosition() != null && info.getPrimaryPosition().getName() != null) {
                map.put("position", info.getPrimaryPosition().getName());
            }
            String superior = null;
            if (info.getPrimaryPosition() != null) {
                superior = this.getSuperior(info.getPrimaryPosition().getId().toString(), "00000000-0000-0000-0000-000000000001396FCAD0", ctx);
                map.put("superior", superior);
            }
            if (info.getEnterDate() != null) {
                map.put("enterDate", DateTimeUtils.truncateDate((java.util.Date)info.getEnterDate()));
            }
            if (info.getPersonDep() != null) {
                map.put("personDep", info.getPersonDep().getName());
            }
        }
        return map;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    private String getSuperior(String positionId, String hierarchyId, Context ctx) throws BOSException {
        String superior = "";
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperiorQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = iqryEx.executeQuery();
        try {
            while (rows.next()) {
                if (superior.length() == 0) {
                    superior = superior + rows.getString("name");
                    continue;
                }
                superior = superior + "," + rows.getString("name");
            }
            rows.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return superior;
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return "";
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("interviewer"));
        InterviewInfo info = (InterviewInfo)super.getValue(ctx, pk, sic);
        return info.getLogInfo();
    }
}

