/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.app.AbstractMDEvaluAverageScoreFacadeControllerBean;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MDEvaluAverageScoreFacadeControllerBean
extends AbstractMDEvaluAverageScoreFacadeControllerBean {
    private Map quesIdNumberMap = new LinkedHashMap();
    private Map paramNumMap = new HashMap();
    private boolean isRank = false;
    private static boolean isQuest = false;
    private String testPaperBeforId;
    private static String testPaperQuest;
    private static String testPaperName;
    private static String testPaperType;
    private static Map paperQuestMap;
    private static Set evalRelationID;
    private static Set multiDimentionObjcetID;
    private static Set evalPersonsID;
    private static String solutionPeriodID;
    private static Map faMap;
    private IRowSet rowQuestSet;
    private static String testPaperID;

    @Override
    protected Map _getAvgSumResult(Context ctx, String mdSolutionId, String assessPeriodId, String testPaperId, Set adminiIds, Set personIds) throws BOSException {
        HashMap map = new HashMap();
        if (mdSolutionId == null || assessPeriodId == null || testPaperId == null) {
            return null;
        }
        if (adminiIds == null || adminiIds.size() == 0) {
            try {
                adminiIds = PerfUtils.getAdminRangeSet(ctx);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (adminiIds == null || adminiIds.size() == 0) {
                return null;
            }
        }
        Set quesIds = this.getQuestionIds(ctx, testPaperId);
        Set resultIds = this.getEvaluResultIds(ctx, mdSolutionId, assessPeriodId, testPaperId, adminiIds, personIds);
        IRowSet testPageRowSet = this.getQueryTestPageFormTotalScoreSet(ctx, quesIds, resultIds, testPaperId);
        IRowSet questionRowSet = this.getQueryQuestionAvgTotalScoreSet(ctx, quesIds, resultIds, testPaperId);
        try {
            while (testPageRowSet.next()) {
                ArrayList<BigDecimal> sumScoreSet = new ArrayList<BigDecimal>();
                String key = testPageRowSet.getString("resultId") + "_" + testPageRowSet.getString("personId");
                sumScoreSet.add(testPageRowSet.getBigDecimal("avgScore"));
                IRowSet questionRowSetCopy = questionRowSet.createCopy();
                while (questionRowSetCopy.next()) {
                    String keyName = questionRowSetCopy.getString("rID") + "_" + testPageRowSet.getString("personId");
                    if (!key.equals(keyName)) continue;
                    sumScoreSet.add(questionRowSetCopy.getBigDecimal("avgScore"));
                }
                map.put(key, sumScoreSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected IRowSet _getResult(Context ctx, String mdSolutionId, String assessPeriodId, String testPaperId, Set adminiIds, Set personIds) throws BOSException, EASBizException {
        if (mdSolutionId == null || assessPeriodId == null || testPaperId == null) {
            return null;
        }
        this.testPaperBeforId = testPaperId;
        if (!(adminiIds != null && adminiIds.size() != 0 || (adminiIds = PerfUtils.getAdminRangeSet(ctx)) != null && adminiIds.size() != 0)) {
            return null;
        }
        this.getPageQuest(ctx, mdSolutionId, assessPeriodId, testPaperId, "");
        Set quesIds = this.getQuestionIds(ctx, testPaperId);
        Set resultIds = this.getEvaluResultIds(ctx, mdSolutionId, assessPeriodId, testPaperId, adminiIds, personIds);
        this.isRank = this.initIsRank(ctx, mdSolutionId);
        if (quesIds == null || resultIds == null || quesIds.size() == 0 || resultIds.size() == 0 || this.quesIdNumberMap.size() == 0) {
            return null;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tName = null;
        try {
            tName = this.createTempTable(ctx, pool);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        faMap = this.getPaperQuestID(ctx, mdSolutionId, assessPeriodId, testPaperId, adminiIds, personIds, resultIds);
        this.rowQuestSet = this.getTempTableQuery(ctx, solutionPeriodID, testPaperId);
        isQuest = false;
        testPaperQuest = null;
        if (this.rowQuestSet.size() > 0) {
            this.getEvaluandQuest(testPaperId);
            if (testPaperQuest != null) {
                testPaperId = testPaperID;
                this.getPaperName(ctx, testPaperQuest);
            }
        }
        this.initTempTable(ctx, tName, mdSolutionId, assessPeriodId, testPaperId, adminiIds, personIds, resultIds);
        if (isQuest && paperQuestMap != null && paperQuestMap.size() > 0) {
            for (Map.Entry entry : paperQuestMap.entrySet()) {
                Object key = entry.getKey();
                String value = entry.getValue().toString();
                String evaluValue = value.substring(0, value.indexOf(","));
                String mdObjctValue = value.substring(value.indexOf(",") + 1, value.indexOf(":"));
                String testPaperValue = value.substring(value.indexOf(":") + 1, value.length());
                StringBuffer updateSql = new StringBuffer(" update ");
                updateSql.append(tName);
                updateSql.append(" set paperQuestID = ?,").append(" paperName ").append(" = ? ,");
                updateSql.append(" paperType ").append(" = ? ");
                updateSql.append(" where evaluRelationID = ? ").append("and multiDimentionObjcetID =?");
                Connection conn = null;
                PreparedStatement ps = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    ps = conn.prepareStatement(updateSql.toString());
                    ps.setString(1, "1");
                    ps.setString(2, testPaperName);
                    ps.setString(3, testPaperType);
                    ps.setString(4, evaluValue);
                    ps.setString(5, mdObjctValue);
                    ps.execute();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException(e.getMessage(), e.getCause());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps);
                        SQLUtils.cleanup((Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup((Connection)conn);
            }
        }
        if (isQuest && testPaperQuest != null && !testPaperId.equals(testPaperQuest)) {
            testPaperId = testPaperQuest;
        }
        this.fillTestPageFormScore(ctx, tName, resultIds, testPaperId);
        IRowSet rowSet = this.getQueryQuestionAvgScoreSet(ctx, quesIds, resultIds, testPaperId);
        this.fillQScoreIntoTable(ctx, quesIds, tName, rowSet);
        this.fillAvgScoreIntoTable(ctx, tName);
        StringBuffer sqlbuf = new StringBuffer();
        sqlbuf.append("select * from " + tName);
        if (isQuest && paperQuestMap != null && paperQuestMap.size() > 0) {
            sqlbuf.append(" where paperQuestID = '1'");
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlbuf.toString());
        pool.releaseTable(tName);
        return row;
    }

    private void getPageQuest(Context ctx, String mdSolutionId, String assessPeriodId, String testPaperId, String tName) throws BOSException {
        EntityViewInfo entityInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MDSolution", (Object)mdSolutionId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("AssessPeriod", (Object)assessPeriodId, CompareType.EQUALS));
        entityInfo.setFilter(filter);
        MultiDimentionSolutionPeriodCollection collSolution = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodCollection(entityInfo);
        if (collSolution != null && collSolution.size() > 0) {
            solutionPeriodID = collSolution.get(0).getId().toString();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodID, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("paperQuest", (Object)testPaperId, CompareType.INCLUDE));
            viewInfo.setFilter(fi);
        }
    }

    private String getEvaluandQuest(String testPaper) throws BOSException {
        int index = 0;
        Iterator iter = faMap.entrySet().iterator();
        boolean isContinue = false;
        evalRelationID = new HashSet();
        multiDimentionObjcetID = new HashSet();
        evalPersonsID = new HashSet();
        isQuest = false;
        paperQuestMap = new HashMap();
        testPaperQuest = testPaper;
        testPaperID = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            String value = entry.getValue().toString();
            String evaluValue = value.substring(0, value.indexOf(","));
            String mdObjctValue = value.substring(value.indexOf(",") + 1, value.indexOf(":"));
            String testPaperValue = value.substring(value.indexOf(":") + 1, value.length());
            try {
                IRowSet rowQuest = this.rowQuestSet.createCopy();
                while (rowQuest.next()) {
                    String rowsetValue = rowQuest.getString("FEvalRelationID").toString();
                    String mdobjct = rowQuest.getString("FMultiDimentionObject").toString();
                    String evalPersonValue = rowQuest.getString("FMultiDimentionObject").toString();
                    if (!evaluValue.equals(rowsetValue) && evaluValue != rowsetValue || !mdobjct.equals(mdObjctValue) && mdobjct != mdObjctValue) continue;
                    ++index;
                    testPaperQuest = testPaper;
                    testPaperID = testPaperValue;
                    isContinue = true;
                    isQuest = true;
                    evalRelationID.add(rowsetValue);
                    multiDimentionObjcetID.add(mdObjctValue);
                    evalPersonsID.add(evalPersonValue);
                    paperQuestMap.put("paperQuestMap" + index, rowsetValue + "," + mdObjctValue + ":" + evalPersonValue);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        return testPaperQuest;
    }

    private IRowSet getTempTableQuery(Context ctx, String solutionperiod, String testPaperId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FEvalRelationID,FMultiDimentionObject from T_PF_EvalurelationQuest ");
        sql.append("where FPaperQuestID ='");
        sql.append(testPaperId);
        sql.append("' and FSolutionPeriodID = '");
        sql.append(solutionperiod);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private void getPaperName(Context ctx, String testPaperId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 PAPERSTORETYPE.FDisplayName_l2  as paperType,TESTPAPER.fname_l2 as paperName from  T_PF_TestPaper AS TESTPAPER ");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQuestions  AS PAPERQUESTIONS ON PAPERQUESTIONS.FTestPaperID = TESTPAPER.FID ");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQueDetail AS QSCORE  ON  QSCORE.FPaperQueID = PAPERQUESTIONS.FID ");
        sql.append(" LEFT OUTER JOIN T_PF_PaperType AS PAPERSTORETYPE   ON TESTPAPER.FTypeID = PAPERSTORETYPE.FID ");
        sql.append(" where TESTPAPER.fid='");
        sql.append(testPaperId);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    testPaperName = rowSet.getString("paperName").toString();
                    testPaperType = rowSet.getString("paperType").toString();
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected int _getCount(Context ctx, String testpaperfid, String mdevaluresultfID) throws BOSException, EASBizException {
        int count = 0;
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct MDEVALURESULT.FID as FID, \n");
        sql.append(" TESTPAPER.FName_");
        sql.append(locale);
        sql.append("  AS paperName , \n");
        sql.append(" EVALURELATION.FWeight as weight,EVALURELATION.fid as relationId ,\n MDOBJECT.FID as mdObjctID ");
        sql.append(" FROM T_PF_MDEVALURESULT AS MDEVALURESULT \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDSolutionPeriod AS SOLUTIONPERIOD \n");
        sql.append(" ON MDEVALURESULT.FSolutionPeriodID = SOLUTIONPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionObject AS MDOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDOBJECT.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Position AS POSITION \n");
        sql.append(" ON MDEVALURESULT.FPositionID = POSITION.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Job AS JOB \n");
        sql.append(" ON POSITION.FJobID = JOB.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT \n");
        sql.append(" ON MDEVALURESULT.FAdminOrgUnitID = ADMINORGUNIT.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionSolution AS MDSOLUTION \n");
        sql.append(" ON SOLUTIONPERIOD.FMDSolutionID = MDSOLUTION.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_AssessPeriod AS ASSESSPERIOD \n");
        sql.append(" ON SOLUTIONPERIOD.FAssessPeriodID = ASSESSPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS PERSON \n");
        sql.append(" ON MDOBJECT.FPersonID = PERSON.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDGroupObject AS MDGROUPOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDGROUPOBJECT.FMDObjectID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDEvaluGroup AS MDEVALUGROUP \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = MDEVALUGROUP.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvaluRelation AS EVALURELATION \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = EVALURELATION.FMdEvaluGroupID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvalReDetail as  EvalReDetail \n");
        sql.append(" ON EvalReDetail.FEvalRelationID = EvaluRelation.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON EVALURELATION.FPaperID = TESTPAPER.FID \n");
        sql.append(" where ");
        if (!isQuest) {
            sql.append(" TESTPAPER.FID = '").append(testpaperfid).append("'\n and ");
        }
        sql.append(" MDEVALURESULT.FID = '");
        sql.append(mdevaluresultfID);
        sql.append("' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        count = rs.size();
        if (isQuest) {
            int index = 0;
            if (paperQuestMap != null && paperQuestMap.size() > 0) {
                for (Map.Entry entry : paperQuestMap.entrySet()) {
                    Object key = entry.getKey();
                    String value = entry.getValue().toString();
                    String evaluValue = value.substring(0, value.indexOf(","));
                    String mdObjctValue = value.substring(value.indexOf(",") + 1, value.indexOf(":"));
                    String testPaperValue = value.substring(value.indexOf(":") + 1, value.length());
                    try {
                        IRowSet rows = rs.createCopy();
                        while (rows.next()) {
                            String rowsetValue = rows.getString("relationId").toString();
                            String mdobjct = rows.getString("mdObjctID").toString();
                            if (!evaluValue.equals(rowsetValue) && evaluValue != rowsetValue || !mdobjct.equals(mdObjctValue) && mdobjct != mdObjctValue) continue;
                            ++index;
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException(e.getMessage(), e.getCause());
                    }
                }
                count = index;
            }
        }
        return count;
    }

    public IRowSet getQueryTestPageFormTotalScoreSet(Context ctx, Set quesIds, Set resultIds, String testPaperId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(t.avgScore*t.weight)*0.01 as avgScore, t.resultId as resultId,t.personid \n");
        sql.append(" from ( select ROUND(AVG(TestPageForm.FScore),2) as avgScore ,  EvalReDetail.FID as EvalReDetailFID,EvaluRelation.FWeight as weight,  \n");
        sql.append(" MDEVALURESULT.FID as resultId ,person.fid as personId  \n");
        sql.append(" from T_PF_TestPageForm as TestPageForm  \n");
        sql.append(" inner join T_PF_MDEVALURESULT as MDEVALURESULT  \n");
        sql.append(" on TestPageForm.FMDEvaluResultID = MDEVALURESULT.FID  \n");
        sql.append(" inner join T_PF_EvalPerson  as  EvalPerson  \n");
        sql.append(" on TestPageForm.FEvalPersonID = EvalPerson.FID  \n");
        sql.append(" inner join T_PF_EvalReDetail as EvalReDetail   \n");
        sql.append(" on EvalPerson.FEvalReDetailID = EvalReDetail.FID  \n");
        sql.append(" left join T_PF_MDEvaluator mdEvaluator on EvalReDetail.FMDEvaluatorID = mdEvaluator.fid \n");
        sql.append(" left join  t_pf_MultiDimentionObject mdobject on mdEvaluator.FMDObjectID = mdobject.fid \n");
        sql.append(" left join t_bd_person person on mdobject.fpersonId = person.fid \n");
        sql.append(" inner join T_PF_EvaluRelation as  EvaluRelation  \n");
        sql.append(" on  EvalReDetail.FEvalRelationID = EvaluRelation.FID  \n");
        sql.append(" RIGHT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON TestPageForm.FTestPaperID = TESTPAPER.FID \n");
        sql.append(" where");
        sql.append(" TESTPAPER.FID='");
        sql.append(testPaperId);
        sql.append("' \n and ");
        sql.append(" MDEVALURESULT.FID in (  \n");
        int i = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")");
        sql.append(" group by MDEVALURESULT.FID,EvalReDetail.FID,  \n");
        sql.append(" EvaluRelation.FWeight,EvaluRelation.FID,person.fid  \n");
        sql.append(" having AVG(TestPageForm.FScore)  is not null \n");
        sql.append(" ) as t group by t.resultId,t.personid \n");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    public IRowSet getQueryQuestionAvgTotalScoreSet(Context ctx, Set quesIds, Set resultIds, String testPaperId) throws BOSException {
        int k = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(t.avgScore*t.weight)*0.01 avgScore, t.rID rID, t.qid qID,t.personid,t.FSerial from \n");
        sql.append("( ");
        if (this.isRank) {
            sql.append("select AVG(rank.FGrade) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid,person.fid personId,pQuestions.FSerial FSerial \n");
            sql.append("from T_PF_PaperQueDetail qScore \n");
            sql.append("left join T_PF_Rank rank on qScore.FRankID = rank.FID \n");
        } else {
            sql.append("select ROUND(AVG(qScore.FScore),2) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid,person.fid personId,pQuestions.FSerial FSerial \n");
            sql.append("from T_PF_PaperQueDetail qScore \n");
        }
        sql.append("left join T_PF_PaperQuestions   pQuestions on qScore.FPaperQueID = pQuestions.FID \n");
        sql.append("left join T_PF_TestPageForm   pForm on qScore.FTestPageFormID = pForm.FID \n");
        sql.append(" RIGHT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON pForm.FTestPaperID = TESTPAPER.FID \n");
        sql.append(" left join T_PF_MDEVALURESULT     mResult on pForm.FMDEvaluResultID = mResult.FID  \n");
        sql.append(" left join T_PF_EvalPerson        ePerson on pForm.FEvalPersonID = ePerson.FID \n");
        sql.append(" left join T_PF_EvalReDetail      eRelation on ePerson.FEvalReDetailID = eRelation.FID \n");
        sql.append(" left join T_PF_MDEvaluator mdEvaluator on eRelation.FMDEvaluatorID = mdEvaluator.fid \n");
        sql.append(" left join  t_pf_MultiDimentionObject mdobject on mdEvaluator.FMDObjectID = mdobject.fid \n");
        sql.append(" left join t_bd_person person on mdobject.fpersonId = person.fid \n");
        sql.append("left join T_PF_EvaluRelation     eR        on  eRelation.FEvalRelationID = eR.FID \n");
        sql.append("where ");
        sql.append(" TESTPAPER.FID='");
        sql.append(testPaperId);
        sql.append("' and");
        sql.append(" mResult.FID in \n");
        sql.append("( ");
        k = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("and qScore.FPaperQueID in ");
        sql.append("( ");
        k = 0;
        it = quesIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("group by mResult.FID,eRelation.FID,qScore.FPaperQueID,eR.FWeight,eR.FID,person.fid,pQuestions.FSerial \n");
        sql.append(") ");
        sql.append("t ");
        sql.append(" group by t.rID,t.qid,t.personid,t.FSerial ");
        sql.append(" order by FSerial ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private void fillTestPageFormScore(Context ctx, String tName, Set resultIds, String testPaperId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ROUND(AVG(TestPageForm.FScore),2) as avgScore ,  EvalReDetail.FID as EvalReDetailFID,EvaluRelation.FWeight as weight,  \n");
        sql.append(" MDEVALURESULT.FID as resultId ,EvaluRelation.fid as relationId, EvalReDetail.FName_l2 as EvalReDetailName \n");
        sql.append(" from T_PF_TestPageForm as TestPageForm  \n");
        sql.append(" inner join T_PF_MDEVALURESULT as MDEVALURESULT  \n");
        sql.append(" on TestPageForm.FMDEvaluResultID = MDEVALURESULT.FID  \n");
        sql.append(" inner join T_PF_EvalPerson  as  EvalPerson  \n");
        sql.append(" on TestPageForm.FEvalPersonID = EvalPerson.FID  \n");
        sql.append(" inner join T_PF_EvalReDetail as EvalReDetail   \n");
        sql.append(" on EvalPerson.FEvalReDetailID = EvalReDetail.FID  \n");
        sql.append(" inner join T_PF_MDEvaluator mdEvaluator on EvalReDetail.FMDEvaluatorID = mdEvaluator.fid \n");
        sql.append(" inner join  t_pf_MultiDimentionObject mdobject on mdEvaluator.FMDObjectID = mdobject.fid \n");
        sql.append(" inner join t_bd_person person on mdobject.fpersonId = person.fid \n");
        sql.append(" inner join T_PF_EvaluRelation as  EvaluRelation  \n");
        sql.append(" on  EvalReDetail.FEvalRelationID = EvaluRelation.FID  \n");
        sql.append(" RIGHT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON TestPageForm.FTestPaperID = TESTPAPER.FID \n");
        sql.append(" where ");
        sql.append(" TESTPAPER.FID='");
        sql.append(testPaperId);
        sql.append("' \n and ");
        sql.append("  MDEVALURESULT.FID in (  \n");
        int i = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")");
        sql.append(" group by MDEVALURESULT.FID,EvalReDetail.FID,  \n");
        sql.append(" EvaluRelation.FWeight,EvaluRelation.FID,EvalReDetail.FName_l2  \n");
        sql.append(" having AVG(TestPageForm.FScore)  is not null   \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                String resultId = rowSet.getString("resultId");
                String relationId = rowSet.getString("relationId");
                String key = resultId + ":" + relationId;
                BigDecimal avgScore = rowSet.getBigDecimal("avgScore");
                String evalReDetailName = rowSet.getString("EvalReDetailName");
                String value = avgScore.toString() + ":" + evalReDetailName;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        StringBuffer updateSql = new StringBuffer(" update ");
        updateSql.append(tName);
        updateSql.append(" set ").append(" paperAverScore ").append(" = ? ,");
        updateSql.append(" evaluGroup ").append(" = ? ");
        updateSql.append(" where FID = ? ").append("and relationId=?");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                String[] keys = StringUtil.split((String)key, (String)":");
                String value = entry.getValue().toString();
                String[] values = StringUtil.split((String)value, (String)":");
                ps = conn.prepareStatement(updateSql.toString());
                ps.setObject(1, values[0]);
                ps.setString(2, values[1]);
                ps.setString(3, keys[0]);
                ps.setString(4, keys[1]);
                ps.execute();
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup(ps);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String createTempTable(Context ctx, TempTablePool pool) throws Exception {
        int i = 0;
        Collection coll = this.quesIdNumberMap.values();
        if (coll == null || coll.size() == 0 || pool == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(" create table ");
        sql.append("t_TP_AverageScore");
        sql.append(" (  FID Varchar(44),");
        sql.append(" personNum nvarchar(80),");
        sql.append(" personName nvarchar(80),");
        sql.append(" adminDisplayName nvarchar(400),");
        sql.append(" position nvarchar(255),");
        sql.append(" job nvarchar(255),");
        sql.append(" solutionPeriodName  nvarchar(400),");
        sql.append(" paperType nvarchar(255),");
        sql.append(" paperName nvarchar(255),");
        sql.append(" paperAverScore NUMERIC(28,10), ");
        sql.append(" evaluGroup nvarchar(80),");
        sql.append(" weight NUMERIC(28,10),");
        sql.append(" relationId nvarchar(80),");
        sql.append(" personId nvarchar(80),");
        sql.append(" name nvarchar(80),");
        sql.append(" evaluRelationID nvarchar(80),");
        sql.append(" paperID nvarchar(80),");
        sql.append(" multiDimentionObjcetID nvarchar(80),");
        sql.append("paperQuestID nvarchar(80),");
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            String column = it.next().toString();
            if (i != 0) {
                sql.append(" , ");
            }
            sql.append(column).append("  ").append("NUMERIC(28,10)");
            ++i;
        }
        sql.append(")");
        pool = TempTablePool.getInstance((Context)ctx);
        String tName = pool.createTempTable(sql.toString());
        pool.createIndex(tName, "FID", false, false);
        return tName;
    }

    private boolean initIsRank(Context ctx, String mdSolutionId) throws BOSException, EASBizException {
        if (mdSolutionId == null) {
            return false;
        }
        MultiDimentionSolutionInfo multiDimentionSolutionInfo = MultiDimentionSolutionFactory.getLocalInstance(ctx).getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(mdSolutionId));
        if (multiDimentionSolutionInfo != null) {
            return EvaluModeEnum.RANK_GROUP.equals((Object)multiDimentionSolutionInfo.getEvaluModeEnum());
        }
        return false;
    }

    private Set getEvaluResultIds(Context ctx, String mdSolutionId, String assessPeriodId, String testPaperId, Set adminIds, Set personIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Distinct MDEVALURESULT.FID AS MDEVALURESULTFID\n");
        sql.append(" FROM T_PF_MDEVALURESULT AS MDEVALURESULT  \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDSolutionPeriod AS SOLUTIONPERIOD \n");
        sql.append(" ON MDEVALURESULT.FSolutionPeriodID = SOLUTIONPERIOD.FID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionObject AS MDOBJECT  \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDOBJECT.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT \n");
        sql.append(" ON MDEVALURESULT.FAdminOrgUnitID = ADMINORGUNIT.FID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionSolution AS MDSOLUTION \n");
        sql.append(" ON SOLUTIONPERIOD.FMDSolutionID = MDSOLUTION.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_AssessPeriod AS ASSESSPERIOD \n");
        sql.append(" ON SOLUTIONPERIOD.FAssessPeriodID = ASSESSPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS PERSON  \n");
        sql.append(" ON MDOBJECT.FPersonID = PERSON.FID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDGroupObject AS MDGROUPOBJECT  \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDGROUPOBJECT.FMDObjectID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDEvaluGroup AS MDEVALUGROUP  \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = MDEVALUGROUP.FID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvaluRelation AS EVALURELATION  \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = EVALURELATION.FMdEvaluGroupID  \n");
        sql.append(" LEFT OUTER JOIN T_PF_TestPaper AS TESTPAPER  \n");
        sql.append(" ON EVALURELATION.FPaperID = TESTPAPER.FID  \n");
        sql.append(" where MDSOLUTION.FID='");
        sql.append(mdSolutionId);
        sql.append("' and  ASSESSPERIOD.FID='");
        sql.append(assessPeriodId);
        sql.append("'");
        if (personIds != null && personIds.size() > 0) {
            sql.append(" and  PERSON.FID in (");
            int j = 0;
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                if (j != 0) {
                    sql.append(",");
                }
                sql.append("'").append(it.next().toString()).append("'");
                ++j;
            }
            sql.append(" ) \n");
        }
        HashSet<String> set = new HashSet<String>();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                set.add(row.getString("MDEVALURESULTFID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return set;
    }

    private Set getQuestionIds(Context ctx, String testPaperId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)testPaperId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.name"));
        sic.add(new SelectorItemInfo("testQuestion.number"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        SorterItemCollection sort = evi.getSorter();
        sort.add(new SorterItemInfo("serial"));
        PaperQuestionsCollection paperQuesColl = PaperQuestionsFactory.getLocalInstance(ctx).getPaperQuestionsCollection(evi);
        HashSet<String> questionIds = new HashSet<String>();
        int j = paperQuesColl.size();
        for (int i = 0; i < j; ++i) {
            questionIds.add(paperQuesColl.get(i).getId().toString());
            this.quesIdNumberMap.put(paperQuesColl.get(i).getId().toString(), "F" + i);
        }
        return questionIds;
    }

    private Set getPersonIds(Context ctx, Set adminIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.fid as fpersonId from t_bd_person as person \n");
        sql.append(" left outer join t_org_positionmember as positionmember \n");
        sql.append(" on positionmember.fpersonid=person.fid \n");
        sql.append(" left outer join t_org_position as position \n");
        sql.append(" on position.fid=positionmember.fpositionid \n");
        sql.append(" left outer join t_org_admin as admin \n");
        sql.append(" on admin.fid=position.FAdminOrgUnitID \n");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> personIds = new HashSet<String>();
        try {
            while (row.next()) {
                personIds.add(row.getString("fpersonId"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return personIds;
    }

    private Set getHRAndAdminRangeOrgUnitIds(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> orgIds = new HashSet<String>();
        try {
            while (row.next()) {
                orgIds.add(row.getString("FFromUnitID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return orgIds;
    }

    private void initTempTable(Context ctx, String tName, String mdSolutionId, String assessPeriodId, String testPaperId, Set adminiIds, Set personIds, Set resultIds) throws BOSException, EASBizException {
        if (tName == null || assessPeriodId == null || testPaperId == null || adminiIds == null || adminiIds.size() == 0 || resultIds == null || resultIds.size() == 0) {
            return;
        }
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(tName).append(" (FID,personNum,personName,adminDisplayName,position,job,solutionPeriodName,paperType,paperName,evaluGroup, weight,relationId,personId,name, \n");
        sql.append(" evaluRelationID,paperID,multiDimentionObjcetID)");
        sql.append(" (SELECT distinct MDEVALURESULT.FID as FID,PERSON.fnumber as personNum,PERSON.fname_");
        sql.append(locale);
        sql.append("  as personName,ADMINORGUNIT.fdisplayName_");
        sql.append(locale);
        sql.append("  as adminDisplayName, \n");
        sql.append(" POSITION.fname_");
        sql.append(locale);
        sql.append("  as position,job.fname_");
        sql.append(locale);
        sql.append("  as job,SOLUTIONPERIOD.fName_");
        sql.append(locale);
        sql.append("  as solutionPeriodName, \n");
        sql.append(" PAPERSTORETYPE.FDisplayName_");
        sql.append(locale);
        sql.append("  as paperType,TESTPAPER.FName_");
        sql.append(locale);
        sql.append("  AS paperName , \n");
        sql.append("(case when (EVALURELATION.FMDEvaluTypeEnum = 10) then '" + (Object)((Object)MDEvaluTypeEnum.SELF) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 20) then '" + (Object)((Object)MDEvaluTypeEnum.DIRECT_SUPERIOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 30) then '" + (Object)((Object)MDEvaluTypeEnum.INDIRECT_SUPERIOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 40) then '" + (Object)((Object)MDEvaluTypeEnum.ORGRESPONSER) + "' \n ");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 50) then '" + (Object)((Object)MDEvaluTypeEnum.FELLOW) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 60) then '" + (Object)((Object)MDEvaluTypeEnum.DIRECT_SUBORDINATOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 70) then '" + (Object)((Object)MDEvaluTypeEnum.INDIRECT_SUBORDINATOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 80) then '" + (Object)((Object)MDEvaluTypeEnum.APPOINT) + "'\n");
        sql.append(" end) as evaluGroup,");
        sql.append(" EVALURELATION.FWeight as weight,EVALURELATION.fid as relationId,PERSON.fid as personid ,\n ");
        sql.append("EVALURELATION.FName_");
        sql.append(locale);
        sql.append(" as name, \n");
        sql.append(" EVALURELATION.fid as EVALURELATIONFId,TESTPAPER.fid as TESTPAPERFID,MDOBJECT.fid as MDOBJECTFID \n ");
        sql.append(" FROM T_PF_MDEVALURESULT AS MDEVALURESULT \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDSolutionPeriod AS SOLUTIONPERIOD \n");
        sql.append(" ON MDEVALURESULT.FSolutionPeriodID = SOLUTIONPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionObject AS MDOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDOBJECT.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Position AS POSITION \n");
        sql.append(" ON MDEVALURESULT.FPositionID = POSITION.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Job AS JOB \n");
        sql.append(" ON POSITION.FJobID = JOB.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT \n");
        sql.append(" ON MDEVALURESULT.FAdminOrgUnitID = ADMINORGUNIT.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionSolution AS MDSOLUTION \n");
        sql.append(" ON SOLUTIONPERIOD.FMDSolutionID = MDSOLUTION.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_AssessPeriod AS ASSESSPERIOD \n");
        sql.append(" ON SOLUTIONPERIOD.FAssessPeriodID = ASSESSPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS PERSON \n");
        sql.append(" ON MDOBJECT.FPersonID = PERSON.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDGroupObject AS MDGROUPOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDGROUPOBJECT.FMDObjectID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDEvaluGroup AS MDEVALUGROUP \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = MDEVALUGROUP.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvaluRelation AS EVALURELATION \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = EVALURELATION.FMdEvaluGroupID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvalReDetail as  EvalReDetail \n");
        sql.append(" ON EvalReDetail.FEvalRelationID = EvaluRelation.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON EVALURELATION.FPaperID = TESTPAPER.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQuestions  AS PAPERQUESTIONS  \n");
        sql.append(" ON  PAPERQUESTIONS.FTestPaperID = TESTPAPER.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQueDetail AS QSCORE  \n");
        sql.append(" ON  QSCORE.FPaperQueID = PAPERQUESTIONS.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperType AS PAPERSTORETYPE  \n");
        sql.append(" ON TESTPAPER.FTypeID = PAPERSTORETYPE.FID \n");
        sql.append(" where MDSOLUTION.fsolutionType=100 \n");
        sql.append(" and MDSOLUTION.FID = '").append(mdSolutionId).append("'\n");
        sql.append(" and ASSESSPERIOD.FID = '").append(assessPeriodId).append("'\n");
        sql.append(" and TESTPAPER.fid = '").append(testPaperId).append("'\n");
        sql.append(" and MDEVALURESULT.FID in (");
        int i = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")");
        if (personIds != null && personIds.size() > 0) {
            sql.append(" and PERSON.FID in ( ");
            int k = 0;
            Iterator it2 = personIds.iterator();
            while (it2.hasNext()) {
                if (k != 0) {
                    sql.append(",");
                }
                sql.append("'").append(it2.next().toString()).append("'");
                ++k;
            }
            sql.append(")");
        }
        sql.append("  order by fid ").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String avgSql = "insert into " + tName + " (FID,personNum,personName,adminDisplayName,position,job,solutionPeriodName,paperType,paperName,evaluGroup) " + " values('avgData','avgData','avgData','avgData','avgData','avgData','avgData','avgData','avgData','avgData') ";
        DbUtil.execute((Context)ctx, (String)avgSql);
    }

    private Map getPaperQuestID(Context ctx, String mdSolutionId, String assessPeriodId, String testPaperId, Set adminiIds, Set personIds, Set resultIds) throws BOSException {
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" (SELECT distinct MDEVALURESULT.FID as FID,PERSON.fnumber as personNum,PERSON.fname_");
        sql.append(locale);
        sql.append("  as personName,ADMINORGUNIT.fdisplayName_");
        sql.append(locale);
        sql.append("  as adminDisplayName, \n");
        sql.append(" POSITION.fname_");
        sql.append(locale);
        sql.append("  as position,job.fname_");
        sql.append(locale);
        sql.append("  as job,SOLUTIONPERIOD.fName_");
        sql.append(locale);
        sql.append("  as solutionPeriodName, \n");
        sql.append(" PAPERSTORETYPE.FDisplayName_");
        sql.append(locale);
        sql.append("  as paperType,TESTPAPER.FName_");
        sql.append(locale);
        sql.append("  AS paperName , \n");
        sql.append("(case when (EVALURELATION.FMDEvaluTypeEnum = 10) then '" + (Object)((Object)MDEvaluTypeEnum.SELF) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 20) then '" + (Object)((Object)MDEvaluTypeEnum.DIRECT_SUPERIOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 30) then '" + (Object)((Object)MDEvaluTypeEnum.INDIRECT_SUPERIOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 40) then '" + (Object)((Object)MDEvaluTypeEnum.ORGRESPONSER) + "' \n ");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 50) then '" + (Object)((Object)MDEvaluTypeEnum.FELLOW) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 60) then '" + (Object)((Object)MDEvaluTypeEnum.DIRECT_SUBORDINATOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 70) then '" + (Object)((Object)MDEvaluTypeEnum.INDIRECT_SUBORDINATOR) + "' \n");
        sql.append("  when (EVALURELATION.FMDEvaluTypeEnum = 80) then '" + (Object)((Object)MDEvaluTypeEnum.APPOINT) + "'\n");
        sql.append(" end) as evaluGroup,");
        sql.append(" EVALURELATION.FWeight as weight,EVALURELATION.fid as relationId,PERSON.fid as personid ,\n ");
        sql.append("EVALURELATION.FName_");
        sql.append(locale);
        sql.append(" as name, \n");
        sql.append(" EVALURELATION.fid as EVALURELATIONFId,TESTPAPER.fid as TESTPAPERFID,MDOBJECT.fid as MDOBJECTFID \n ");
        sql.append(" FROM T_PF_MDEVALURESULT AS MDEVALURESULT \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDSolutionPeriod AS SOLUTIONPERIOD \n");
        sql.append(" ON MDEVALURESULT.FSolutionPeriodID = SOLUTIONPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionObject AS MDOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDOBJECT.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Position AS POSITION \n");
        sql.append(" ON MDEVALURESULT.FPositionID = POSITION.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Job AS JOB \n");
        sql.append(" ON POSITION.FJobID = JOB.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT \n");
        sql.append(" ON MDEVALURESULT.FAdminOrgUnitID = ADMINORGUNIT.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MultiDimentionSolution AS MDSOLUTION \n");
        sql.append(" ON SOLUTIONPERIOD.FMDSolutionID = MDSOLUTION.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_AssessPeriod AS ASSESSPERIOD \n");
        sql.append(" ON SOLUTIONPERIOD.FAssessPeriodID = ASSESSPERIOD.FID \n");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS PERSON \n");
        sql.append(" ON MDOBJECT.FPersonID = PERSON.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDGroupObject AS MDGROUPOBJECT \n");
        sql.append(" ON MDEVALURESULT.FMdObjectID = MDGROUPOBJECT.FMDObjectID \n");
        sql.append(" LEFT OUTER JOIN T_PF_MDEvaluGroup AS MDEVALUGROUP \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = MDEVALUGROUP.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvaluRelation AS EVALURELATION \n");
        sql.append(" ON MDGROUPOBJECT.FMDEvaluGroupID = EVALURELATION.FMdEvaluGroupID \n");
        sql.append(" LEFT OUTER JOIN T_PF_EvalReDetail as  EvalReDetail \n");
        sql.append(" ON EvalReDetail.FEvalRelationID = EvaluRelation.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON EVALURELATION.FPaperID = TESTPAPER.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQuestions  AS PAPERQUESTIONS  \n");
        sql.append(" ON  PAPERQUESTIONS.FTestPaperID = TESTPAPER.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperQueDetail AS QSCORE  \n");
        sql.append(" ON  QSCORE.FPaperQueID = PAPERQUESTIONS.FID \n");
        sql.append(" LEFT OUTER JOIN T_PF_PaperType AS PAPERSTORETYPE  \n");
        sql.append(" ON TESTPAPER.FTypeID = PAPERSTORETYPE.FID \n");
        sql.append(" where MDSOLUTION.fsolutionType=100 \n");
        sql.append(" and MDSOLUTION.FID = '").append(mdSolutionId).append("'\n");
        sql.append(" and ASSESSPERIOD.FID = '").append(assessPeriodId).append("'\n");
        sql.append(" and MDEVALURESULT.FID in (");
        int i = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")");
        if (personIds != null && personIds.size() > 0) {
            sql.append(" and PERSON.FID in ( ");
            int k = 0;
            Iterator it2 = personIds.iterator();
            while (it2.hasNext()) {
                if (k != 0) {
                    sql.append(",");
                }
                sql.append("'").append(it2.next().toString()).append("'");
                ++k;
            }
            sql.append(")");
        }
        sql.append(" order by fid ").append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> mapObjcts = new HashMap<String, String>();
        try {
            int index = 0;
            while (row.next()) {
                mapObjcts.put("evaluRelaionIds" + ++index, row.getString("EVALURELATIONFId") + "," + row.getString("MDOBJECTFID") + ":" + row.getString("TESTPAPERFID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return mapObjcts;
    }

    private IRowSet getQueryQuestionAvgScoreSet(Context ctx, Set quesIds, Set resultIds, String testPaperId) throws BOSException {
        int k = 0;
        StringBuffer sql = new StringBuffer();
        if (this.isRank) {
            sql.append("select AVG(rank.FGrade) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid ,eR.FID erId,pQuestions.FSerial FSerial \n");
            sql.append("from T_PF_PaperQueDetail qScore \n");
            sql.append("left join T_PF_Rank rank on qScore.FRankID = rank.FID \n");
        } else {
            sql.append("select ROUND(AVG(qScore.FScore),2) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid,eR.FID erId, pQuestions.FSerial FSerial \n");
            sql.append("from T_PF_PaperQueDetail qScore \n");
        }
        sql.append("left join T_PF_PaperQuestions     pQuestions  on qScore.FPaperQueID = pQuestions.FID \n");
        sql.append("left join T_PF_TestPageForm      pForm on qScore.FTestPageFormID = pForm.FID \n");
        sql.append(" RIGHT OUTER JOIN T_PF_TestPaper AS TESTPAPER \n");
        sql.append(" ON pForm.FTestPaperID = TESTPAPER.FID \n");
        sql.append("left join T_PF_MDEVALURESULT     mResult on pForm.FMDEvaluResultID = mResult.FID \n");
        sql.append("left join T_PF_EvalPerson        ePerson on pForm.FEvalPersonID = ePerson.FID \n");
        sql.append("left join T_PF_EvalReDetail      eRelation on ePerson.FEvalReDetailID = eRelation.FID \n");
        sql.append(" left join T_PF_MDEvaluator mdEvaluator on eRelation.FMDEvaluatorID = mdEvaluator.fid \n");
        sql.append(" left join  t_pf_MultiDimentionObject mdobject on mdEvaluator.FMDObjectID = mdobject.fid \n");
        sql.append(" left join t_bd_person person on mdobject.fpersonId = person.fid \n");
        sql.append("left join T_PF_EvaluRelation     eR        on  eRelation.FEvalRelationID = eR.FID \n");
        sql.append(" where ");
        if (!isQuest) {
            sql.append(" TESTPAPER.FID='");
            sql.append(testPaperId);
            sql.append("' and");
        }
        sql.append(" mResult.FID in ");
        sql.append("( ");
        k = 0;
        Iterator it = resultIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("and qScore.FPaperQueID in ");
        sql.append("( ");
        k = 0;
        it = quesIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("group by mResult.FID,eRelation.FID,qScore.FPaperQueID,eR.FWeight,eR.FID,pQuestions.FSerial \n");
        if (this.isRank) {
            sql.append("having AVG(rank.FGrade) is not null ");
        } else {
            sql.append("having AVG(qScore.FScore) is not null ");
        }
        sql.append("order by  FSerial");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private void fillQScoreIntoTable(Context ctx, Set qIds, String tName, IRowSet rowSet) throws SQLDataException, BOSException {
        String questionID;
        if (qIds == null || qIds.size() == 0 || tName == null || rowSet == null) {
            return;
        }
        HashMap map = new HashMap();
        try {
            while (rowSet.next()) {
                Map<String, Double> qIdScore;
                String relationID = rowSet.getString("erId");
                String resultID = rowSet.getString("rID");
                double avgScore = rowSet.getDouble("avgScore");
                questionID = rowSet.getString("qID");
                String key = resultID + ":" + relationID + ":" + questionID;
                if (map.containsKey(key)) {
                    qIdScore = (Map)map.get(resultID);
                    qIdScore.put(questionID, new Double(avgScore));
                    continue;
                }
                qIdScore = new HashMap();
                qIdScore.put(questionID, new Double(avgScore));
                map.put(key, qIdScore);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.setQuesIds(ctx, tName, qIds);
        Connection conn = null;
        PreparedStatement ps = null;
        String[] keyResultIds = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (Map.Entry entry : map.entrySet()) {
                String rID = entry.getKey().toString();
                keyResultIds = StringUtil.split((String)rID, (String)":");
                Map qIdScore = (Map)entry.getValue();
                for (Map.Entry entry2 : this.paramNumMap.entrySet()) {
                    questionID = entry2.getKey().toString();
                    if (!qIdScore.containsKey(questionID)) continue;
                    String updateSql = this.getUpdateSql(ctx, tName, questionID);
                    ps = conn.prepareStatement(updateSql);
                    ps.setObject(1, qIdScore.get(questionID));
                    ps.setString(2, keyResultIds[0]);
                    ps.setString(3, keyResultIds[1]);
                    ps.execute();
                    SQLUtils.cleanup((Statement)ps);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void setQuesIds(Context ctx, String tName, Set qIds) {
        if (tName == null || qIds == null || qIds.size() == 0) {
            return;
        }
        int k = 0;
        Iterator it = qIds.iterator();
        while (it.hasNext()) {
            String qId = it.next().toString();
            if (k == 0) {
                if (this.quesIdNumberMap.containsKey(qId)) {
                    this.paramNumMap.put(qId, new Integer(1));
                }
            } else if (this.quesIdNumberMap.containsKey(qId)) {
                this.paramNumMap.put(qId, new Integer(k + 1));
            }
            ++k;
        }
    }

    private String getUpdateSql(Context ctx, String tName, String qId) {
        if (tName == null || qId == null) {
            return null;
        }
        StringBuffer updateSql = new StringBuffer("update ");
        updateSql.append(tName);
        String fieldName = this.quesIdNumberMap.get(qId).toString();
        updateSql.append(" set ").append(fieldName).append(" = ? ");
        updateSql.append(" where FID = ? and relationId=?");
        return updateSql.toString();
    }

    private void fillAvgScoreIntoTable(Context ctx, String tName) throws BOSException, EASBizException {
        String column;
        if (tName == null) {
            return;
        }
        StringBuffer sql = new StringBuffer("select avg(paperAverScore) paperAverScore,");
        Collection coll = this.quesIdNumberMap.values();
        int i = 0;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(" , ");
            }
            column = it.next().toString();
            sql.append(" avg(").append(column).append(") ").append(column);
            ++i;
        }
        sql.append(" from ").append(tName);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer updateSql = new StringBuffer("update ");
        updateSql.append(tName);
        updateSql.append(" set ");
        try {
            if (row.next()) {
                updateSql.append(" paperAverScore = ").append(row.getDouble("paperAverScore")).append(",");
                i = 0;
                Iterator it2 = coll.iterator();
                while (it2.hasNext()) {
                    if (i != 0) {
                        updateSql.append(",");
                    }
                    column = it2.next().toString();
                    updateSql.append(column).append(" = ").append(row.getDouble(column));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        updateSql.append(" where FID = 'avgData'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected String _getAdd(Context ctx) throws BOSException {
        return null;
    }
}

