/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.MDEvaluResultCollection;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;

public class MDEvaluResultDataTransmission
extends AbstractDataTransmission {
    GradeModeInfo gradeMode = null;
    boolean isRank = false;
    private DecimalFormat df = new DecimalFormat("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MDEvaluResultFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        MDEvaluResultInfo ret;
        block14: {
            Object obj = null;
            ret = new MDEvaluResultInfo();
            try {
                String personId = null;
                FilterInfo filterInfo = new FilterInfo();
                EntityViewInfo viewInfo = new EntityViewInfo();
                obj = hsData.get("personNumber");
                if (obj == null || "".equals(obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString()));
                obj = hsData.get("personName");
                if (obj == null || "".equals(obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
                viewInfo.setFilter(filterInfo);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
                if (personColl == null || personColl.size() <= 0) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
                }
                personId = personColl.get(0).getId().toString();
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                String solutionID = (String)this.getContextParameter("solutionID");
                filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)solutionID));
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
                viewInfo.setFilter(filterInfo);
                selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                MultiDimentionObjectCollection coll = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
                MultiDimentionObjectInfo objectInfo = null;
                if (coll == null || coll.size() != 1) {
                    throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
                }
                objectInfo = coll.get(0);
                ret.setMdObject(objectInfo);
                if (this.gradeMode == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("gradeMode.id"));
                    sic.add(new SelectorItemInfo("gradeMode.minGrade"));
                    sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
                    sic.add(new SelectorItemInfo("inputMode"));
                    MultiDimentionSolutionInfo s = MultiDimentionSolutionFactory.getLocalInstance(ctx).getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID), sic);
                    this.gradeMode = s.getGradeMode();
                }
                String spID = (String)this.getContextParameter("spID");
                MultiDimentionSolutionPeriodInfo spInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spID));
                ret.setSolutionPeriod(spInfo);
                obj = hsData.get("evaluScore");
                if (obj != null && !"".equals(obj.toString().trim())) {
                    BigDecimal score = null;
                    try {
                        score = new BigDecimal(obj.toString());
                    }
                    catch (Exception ex) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    if (this.gradeMode.getMaxGrade().compareTo(score) == -1 || this.gradeMode.getMinGrade().compareTo(score) == 1) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    ret.setEvaluScore(new BigDecimal(obj.toString()));
                }
                if ((obj = hsData.get("rank")) == null || "".equals(obj.toString().trim())) break block14;
                String rankGroupID = (String)this.getContextParameter("rankGroupID");
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                if (rankGroupID != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)rankGroupID));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)"%noRankGroupID%"));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
                viewInfo.setFilter(filterInfo);
                RankInfo rank = null;
                RankCollection rankColl = RankFactory.getLocalInstance(ctx).getRankCollection(viewInfo);
                if (rankColl != null && rankColl.size() > 0) {
                    rank = rankColl.get(0);
                    ret.setRank(rank);
                    break block14;
                }
                throw new EvaluResultException(EvaluResultException.RANK_ERROR);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        return ret;
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (this.isSltImportUpdate()) {
            MDEvaluResultInfo info = (MDEvaluResultInfo)coreBaseInfo;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String spID = (String)this.getContextParameter("spID");
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
            filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)info.getMdObject().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            MDEvaluResultCollection coll = null;
            try {
                coll = MDEvaluResultFactory.getLocalInstance(ctx).getMDEvaluResultCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (coll != null && coll.size() > 0) {
                info.setId(coll.get(0).getId());
            }
        }
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("personNumber", rs.getString("Person.number"));
            result.put("personName", rs.getString("Person.name"));
            if (rs.getObject("evaluScore") != null) {
                result.put("evaluScore", this.df.format(rs.getDouble("evaluScore")));
            }
            if (rs.getString("rank.name") != null) {
                result.put("rank", rs.getString("rank.name"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String spID = (String)this.getContextParameter("spID");
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.MDEvaluResultQuery";
    }
}

