/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.MDEvaluResultCollection;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import java.util.Hashtable;

public class MDEvaluResultProcRankingDataTransmission
extends AbstractDataTransmission {
    boolean isRank = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MDEvaluResultFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = null;
        MDEvaluResultInfo evaluResult = new MDEvaluResultInfo();
        try {
            String personId = null;
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            obj = hsData.get("Number");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString()));
            obj = hsData.get("Name");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            if (personColl == null || personColl.size() <= 0) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
            }
            personId = personColl.get(0).getId().toString();
            filterInfo = new FilterInfo();
            viewInfo = new EntityViewInfo();
            String solutionID = (String)this.getContextParameter("solutionID");
            filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)solutionID));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            viewInfo.setFilter(filterInfo);
            selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            MultiDimentionObjectCollection coll = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
            MultiDimentionObjectInfo objectInfo = null;
            if (coll == null || coll.size() != 1) {
                throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
            }
            objectInfo = coll.get(0);
            evaluResult.setMdObject(objectInfo);
            String spID = (String)this.getContextParameter("spID");
            MultiDimentionSolutionPeriodInfo spinfoInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spID));
            evaluResult.setSolutionPeriod(spinfoInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return evaluResult;
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (this.isSltImportUpdate()) {
            MDEvaluResultInfo info = (MDEvaluResultInfo)coreBaseInfo;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String spID = (String)this.getContextParameter("spID");
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
            filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)info.getMdObject().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isApproved"));
            sic.add(new SelectorItemInfo("ranking"));
            MDEvaluResultCollection coll = null;
            try {
                coll = MDEvaluResultFactory.getLocalInstance(ctx).getMDEvaluResultCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (coll != null && coll.size() > 0) {
                boolean flag = coll.get(0).isIsApproved();
                String rankingName = coll.get(0).getRanking();
                if (flag && UIRuleUtil.isNotNull((String)info.getRanking())) {
                    info.setRanking(rankingName);
                }
                info.setId(coll.get(0).getId());
            }
        }
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }
}

