/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.perf.AppointPersonInfo;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.IMDEvaluGroup;
import com.kingdee.eas.hr.perf.IMultiDimentionObject;
import com.kingdee.eas.hr.perf.MDEvaluGroupException;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectCollection;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MDGroupObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TestPaperCollection;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MDGroupImportDataTransmission
extends AbstractDataTransmission {
    private static final BigDecimal HUNDRED = new BigDecimal("100.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MDEvaluGroupFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        MDEvaluGroupInfo info;
        block16: {
            info = null;
            EvaluRelationInfo relationInfo = null;
            try {
                int size = hsData.size();
                if (size <= 0) break block16;
                info = new MDEvaluGroupInfo();
                Hashtable lineData = null;
                String firstLineGroupName = null;
                String firstLineEvaluObject = null;
                String firstLineNumber = null;
                String temp = null;
                HashSet<String> subGroupNameSet = new HashSet<String>();
                BigDecimal sumWeight = new BigDecimal("0.00");
                BigDecimal weight = null;
                TestPaperInfo paper = null;
                Object obj = null;
                for (int i = 0; i < size; ++i) {
                    lineData = (Hashtable)hsData.get(new Integer(i));
                    if (i == 0) {
                        info = this.buildMDEvaluGroupInfo(ctx, lineData);
                        firstLineGroupName = lineData.get("name").toString().trim();
                        firstLineEvaluObject = lineData.get("evaluObject").toString().trim();
                        firstLineNumber = lineData.get("number").toString().trim();
                    }
                    if ((temp = (obj = (Object)lineData.get("name")) != null ? obj.toString() : null) == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.NAME_NULL_EXECPTION);
                    }
                    if (!firstLineGroupName.equals(temp = temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.GROUP_NAME_NOT_VALID, new Object[]{firstLineNumber, firstLineGroupName, temp});
                    }
                    obj = lineData.get("evaluObject");
                    temp = obj != null ? obj.toString() : null;
                    if (temp == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_OBJ_NULL_EXCEPTION);
                    }
                    if (!firstLineEvaluObject.equals(temp = temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.GROUP_OBJ_NOT_VALID, new Object[]{firstLineNumber, firstLineEvaluObject, temp});
                    }
                    relationInfo = new EvaluRelationInfo();
                    relationInfo.setMDEvaluTypeEnum(MDEvaluTypeEnum.APPOINT);
                    relationInfo.setMdEvaluGroup(info);
                    info.getRelation().add(relationInfo);
                    obj = lineData.get("groupName");
                    temp = obj != null ? obj.toString() : null;
                    if (temp == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_GROUP_NAME_NULL_EXCEPTION);
                    }
                    if (subGroupNameSet.contains(temp = temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_GROUP_NAME_DUP_EXCEPTION, new Object[]{temp, info.getName()});
                    }
                    relationInfo.setName(temp);
                    subGroupNameSet.add(temp);
                    obj = lineData.get("groupWeight");
                    temp = obj != null ? obj.toString() : null;
                    if (temp == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_GROUP_WEIGHT_NULL_EXCEPTION, new Object[]{relationInfo.getName()});
                    }
                    temp = temp.trim();
                    try {
                        weight = new BigDecimal(temp);
                    }
                    catch (Exception ex) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_GROUP_WEIGHT_NULL_EXCEPTION, new Object[]{temp});
                    }
                    relationInfo.setWeight(weight);
                    sumWeight = sumWeight.add(weight);
                    obj = lineData.get("testPaperNumber");
                    temp = obj != null ? obj.toString() : null;
                    if (temp == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_TEST_PAPER_NULL, new Object[]{relationInfo.getName()});
                    }
                    temp = temp.trim();
                    paper = this.getTestPaperInfoByNumber(ctx, temp);
                    relationInfo.setPaper(paper);
                    obj = lineData.get("evaluPerson");
                    temp = obj != null ? obj.toString() : null;
                    if (temp == null || "".equals(temp.trim())) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.APPOINT_EVAL_PERSON_NULL);
                    }
                    temp = temp.trim();
                    this.buildAppointPerson(ctx, temp, relationInfo);
                }
                if (HUNDRED.compareTo(sumWeight) != 0) {
                    throw new MDEvaluGroupException(MDEvaluGroupException.GROUP_WEIGHT_INVALID, new Object[]{info.getName(), sumWeight});
                }
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        return info;
    }

    private void buildAppointPerson(Context ctx, String personNameTokens, EvaluRelationInfo relationInfo) throws EASBizException, BOSException {
        personNameTokens = personNameTokens.replaceAll("\uff0c", ",");
        String objName = null;
        StringTokenizer token = new StringTokenizer(personNameTokens, ",");
        FilterInfo filter = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection coll = null;
        AppointPersonInfo appointPersonInfo = null;
        HashSet set = new HashSet();
        while (token.hasMoreTokens()) {
            objName = token.nextToken();
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
            if (objName.indexOf("_") == -1) {
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName.substring(0, objName.indexOf("_"))));
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)objName.substring(objName.indexOf("_") + 1, objName.length())));
                filter.setMaskString("#0 OR (#1 AND #2)");
            }
            coll = iPersonPosition.getPersonPositionCollection(viewInfo);
            if (coll == null || coll.size() < 1) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVAL_PERSON_NOT_EXIST, new Object[]{objName});
            }
            if (coll.size() > 1) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVAL_PERSON_NOT_UNIQUE, new Object[]{objName});
            }
            if (set.contains(coll.get(0).getPerson().getId())) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_PERSON_DUP_IN_GROUP, new Object[]{objName});
            }
            appointPersonInfo = new AppointPersonInfo();
            appointPersonInfo.setPerson(coll.get(0).getPerson());
            appointPersonInfo.setPositioin(coll.get(0).getPrimaryPosition());
            appointPersonInfo.setEvaluRelation(relationInfo);
            relationInfo.getAppointPerson().add(appointPersonInfo);
        }
    }

    private TestPaperInfo getTestPaperInfoByNumber(Context ctx, String number) throws EASBizException, BOSException {
        TestPaperInfo ret = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        filter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)hrOrgUnitInfo.getId().toString()));
        viewInfo.setFilter(filter);
        TestPaperCollection coll = TestPaperFactory.getLocalInstance(ctx).getTestPaperCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            throw new MDEvaluGroupException(MDEvaluGroupException.TEST_PAPER_NOT_EXIST, new Object[]{number});
        }
        ret = coll.get(0);
        return ret;
    }

    private MDEvaluGroupInfo buildMDEvaluGroupInfo(Context ctx, Hashtable lineData) throws EASBizException, BOSException {
        MDEvaluGroupInfo info = new MDEvaluGroupInfo();
        info.setFellowType(FellowTypeEnum.SAMEJOBLEVEL);
        String solutionID = (String)this.getContextParameter("solutionID");
        String solutionPeriodID = (String)this.getContextParameter("solutionPeriodID");
        MultiDimentionSolutionPeriodInfo solutionPeriod = new MultiDimentionSolutionPeriodInfo();
        solutionPeriod.setId(BOSUuid.read((String)solutionPeriodID));
        info.setSolutionPeriod(solutionPeriod);
        String cellString = null;
        Object obj = lineData.get("number");
        cellString = obj != null ? obj.toString() : null;
        if (cellString == null || "".equals(cellString.trim())) {
            throw new MDEvaluGroupException(MDEvaluGroupException.NUM_NULL_EXCEPTION);
        }
        cellString = cellString.trim();
        info.setNumber(cellString);
        obj = lineData.get("name");
        cellString = obj != null ? obj.toString() : null;
        if (cellString == null || "".equals(cellString.trim())) {
            throw new MDEvaluGroupException(MDEvaluGroupException.NAME_NULL_EXECPTION);
        }
        cellString = cellString.trim();
        info.setName(cellString);
        obj = lineData.get("evaluObject");
        cellString = obj != null ? obj.toString() : null;
        if (cellString == null || "".equals(cellString.trim())) {
            throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_OBJ_NULL_EXCEPTION);
        }
        cellString = cellString.trim();
        cellString = cellString.replaceAll("\uff0c", ",");
        StringTokenizer token = new StringTokenizer(cellString, ",");
        String objName = null;
        MDGroupObjectInfo groupObj = null;
        FilterInfo filter = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        MultiDimentionObjectCollection coll = null;
        IMultiDimentionObject dao = MultiDimentionObjectFactory.getLocalInstance(ctx);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        while (token.hasMoreTokens()) {
            objName = token.nextToken();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)solutionID));
            if (objName.indexOf("_") == -1) {
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)objName.substring(0, objName.indexOf("_"))));
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)objName.substring(objName.indexOf("_") + 1, objName.length())));
                filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4))");
            }
            viewInfo.setFilter(filter);
            coll = dao.getMultiDimentionObjectCollection(viewInfo);
            if (coll == null || coll.size() < 1) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_OBJ_NOT_EXIST, new Object[]{objName});
            }
            if (coll.size() > 1) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_OBJ_NOT_UNIQUE, new Object[]{objName});
            }
            if (set.contains(coll.get(0).getId())) {
                throw new MDEvaluGroupException(MDEvaluGroupException.EVALU_OBJ_DUP_IN_GROUP, new Object[]{objName});
            }
            groupObj = new MDGroupObjectInfo();
            groupObj.setMdEvaluGroup(info);
            groupObj.setMdObject(coll.get(0));
            set.add(coll.get(0).getId());
            info.getGroupObject().add(groupObj);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        MDEvaluGroupInfo info = (MDEvaluGroupInfo)coreBaseInfo;
        try {
            String solutionPeriodID = (String)this.getContextParameter("solutionPeriodID");
            IMDEvaluGroup dao = (IMDEvaluGroup)this.getController(ctx);
            if (this.isSltImportUpdate()) {
                StringBuffer sql = new StringBuffer("SELECT FID FROM T_PF_MDEvaluGroup WHERE FNumber = ");
                sql.append("'");
                sql.append(info.getNumber());
                sql.append("'");
                sql.append(" AND ");
                sql.append(" FSolutionPeriodID = '");
                sql.append(solutionPeriodID);
                sql.append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                ObjectUuidPK pk = null;
                while (rowSet.next()) {
                    pk = new ObjectUuidPK(rowSet.getString("FID"));
                    dao.delete((IObjectPK)pk);
                }
            }
            this.checkNumberDup(ctx, info);
            this.checkNameDup(ctx, info);
            this.checkEvaluObjectValid(ctx, info);
            dao.submit((CoreBaseInfo)info);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void checkNumberDup(Context ctx, MDEvaluGroupInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getSolutionPeriod().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (MDEvaluGroupFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDEvaluGroupException(MDEvaluGroupException.CHECK_NUM_DUP, new Object[]{info.getNumber()});
        }
    }

    private void checkNameDup(Context ctx, MDEvaluGroupInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getSolutionPeriod().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getNumber()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (MDEvaluGroupFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDEvaluGroupException(MDEvaluGroupException.CHECK_NAME_DUP, new Object[]{info.getName()});
        }
    }

    private void checkEvaluObjectValid(Context ctx, MDEvaluGroupInfo info) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        MDGroupObjectCollection coll = info.getGroupObject();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            set.add(coll.get(i).getMdObject().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("mdObject.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.id", (Object)info.getSolutionPeriod().getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("mdObject.person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdObject.person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.number"));
        MDGroupObjectCollection existColl = MDGroupObjectFactory.getLocalInstance(ctx).getMDGroupObjectCollection(viewInfo);
        if (existColl.size() > 0) {
            StringBuffer sb = new StringBuffer();
            int n2 = existColl.size();
            for (int i = 0; i < n2; ++i) {
                sb.append(existColl.get(i).getMdObject().getPerson().getName());
                sb.append("(");
                sb.append(existColl.get(i).getMdEvaluGroup().getNumber());
                sb.append(")");
                sb.append("  ");
            }
            throw new MDEvaluGroupException(MDEvaluGroupException.GROUP_EVALU_OBJ_EXCEPTION, new Object[]{info.getNumber(), sb.toString()});
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return firstData != null && currentData != null && firstData.get(this.getMainField()).equals(currentData.get(this.getMainField()));
    }

    public String getMainField() {
        return "number";
    }
}

