/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.AbstractEvalPersonInfo;
import com.kingdee.eas.hr.perf.AbstractEvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvalPersonCollection;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestCollection;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestFactory;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.IMultiDimEvaluator;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MDSolutionException;
import com.kingdee.eas.hr.perf.MDWfFacadeFactory;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorCollection;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.MultiDimntModeEnum;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractMDWfFacadeControllerBean;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MDWfFacadeControllerBean
extends AbstractMDWfFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.MDWfFacadeControllerBean");
    int DELPROCINSTMAX = 20;
    int TERMINALINSTMAX = 20;
    int CREATEPROCINSTMAX = 3;
    int CREATEFETCHEVALUATORMAX = 50;
    int RESETFETCHEVALUATORMAX = 50;
    int FINISHTEFETCHEVALUATORMAX = 50;
    private static final String RES = "com.kingdee.eas.hr.perf.PerfResource";
    private boolean isFlag;

    @Override
    protected void _startSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        MultiDimntModeEnum solutionMode = this.getSolutionMode(ctx, mdSolutionPeriodID.toString());
        if (MultiDimntModeEnum.MANU_ENTER.equals((Object)solutionMode)) {
            this.directEnterStartSolutionPeriod(ctx, mdSolutionPeriodID);
        } else if (MultiDimntModeEnum.WORKFLOW_APPOINT.equals((Object)solutionMode)) {
            this.appointModeStartSolutionPeriod(ctx, mdSolutionPeriodID);
            this.sendMessage(ctx, mdSolutionPeriodID.toString());
        } else if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)solutionMode)) {
            this.optionalModeStartSolutionPeriod(ctx, mdSolutionPeriodID);
        } else {
            throw new MDSolutionException(MDSolutionException.FETCHSOLUTIONMODE_FAILD);
        }
        this.dealLogInfo(ctx, mdSolutionPeriodID.toString(), "perf_mdSolutionPeriod_start");
    }

    @Override
    protected void _resetSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        MultiDimntModeEnum solutionMode = this.getSolutionMode(ctx, mdSolutionPeriodID.toString());
        if (MultiDimntModeEnum.MANU_ENTER.equals((Object)solutionMode)) {
            this.directEnterResetSolutionPeriod(ctx, mdSolutionPeriodID);
        } else if (MultiDimntModeEnum.WORKFLOW_APPOINT.equals((Object)solutionMode)) {
            this.appointModeResetSolutionPeriod(ctx, mdSolutionPeriodID);
        } else if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)solutionMode)) {
            this.optionalModeResetSolutionPeriod(ctx, mdSolutionPeriodID);
        } else {
            throw new MDSolutionException(MDSolutionException.FETCHSOLUTIONMODE_FAILD);
        }
        this.dealLogInfo(ctx, mdSolutionPeriodID.toString(), "perf_mdSolutionPeriod_reset");
    }

    @Override
    protected void _finishSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        MultiDimntModeEnum solutionMode = this.getSolutionMode(ctx, mdSolutionPeriodID.toString());
        if (MultiDimntModeEnum.MANU_ENTER.equals((Object)solutionMode)) {
            this.directEnterFinishSolutionPeriod(ctx, mdSolutionPeriodID);
        } else if (MultiDimntModeEnum.WORKFLOW_APPOINT.equals((Object)solutionMode)) {
            this.appointModeFinishSolutionPeriod(ctx, mdSolutionPeriodID);
        } else if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)solutionMode)) {
            this.optionalModeFinishSolutionPeriod(ctx, mdSolutionPeriodID);
        } else {
            throw new MDSolutionException(MDSolutionException.FETCHSOLUTIONMODE_FAILD);
        }
        this.dealLogInfo(ctx, mdSolutionPeriodID.toString(), "perf_mdSolutionPeriod_end");
    }

    @Override
    protected void _directEnterStartSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 20, 80);
        this.updateDirectMDEvalPersonStart(ctx, mdSolutionPeriodID.toString());
        this.insertMDEvaluResult(ctx, mdSolutionPeriodID.toString());
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodOnUse(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _appointModeStartSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 20, 80);
        this.updateDirectMDEvalPersonStart(ctx, mdSolutionPeriodID.toString());
        this.insertMDEvaluResult(ctx, mdSolutionPeriodID.toString());
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodOnUse(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _optionalModeStartSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.insertMDEvaluResult(ctx, mdSolutionPeriodID.toString());
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodOnUse(mdSolutionPeriodID.toString());
    }

    private void updateDirectMDEvalPersonStart(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT T_PF_EvalReDetail.FID ");
        sb.append(" FROM T_PF_EvalReDetail INNER JOIN T_PF_MDEvaluator ON T_PF_EvalReDetail.FMDEvaluatorID=T_PF_MDEvaluator.FID ");
        sb.append(" WHERE T_PF_MDEvaluator.FSolutionPeriodID='");
        sb.append(mdSolutionPeriodID);
        sb.append("' ");
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_EvalPerson Set FWfStatus =  ");
        sql.append(20);
        sql.append(" , FPaperState = ");
        sql.append(10);
        sql.append(",FAccptDate= ? WHERE FEvalReDetailID in ( ");
        sql.append(sb.toString());
        sql.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setTimestamp(1, new Timestamp(Calendar.getInstance().getTimeInMillis()));
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private MultiDimEvaluatorCollection getNotDirectEnterMDEvaluatorCollection(Context ctx, HashSet idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        MultiDimEvaluatorCollection dimEvaluatorCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("multiDimObject.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("multiDimObject.person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalReDetails.evalPersons.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalReDetails.evalPersons.person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalReDetails.evalRelation.paper.id"));
        dimEvaluatorCollection = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorCollection(viewInfo);
        return dimEvaluatorCollection;
    }

    private void insertMDEvaluResult(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        MDEvaluResultInfo evaluResultInfo = new MDEvaluResultInfo();
        SelectorItemCollection ssic = new SelectorItemCollection();
        ssic.add(new SelectorItemInfo("id"));
        ssic.add(new SelectorItemInfo("MDSolution.id"));
        ssic.add(new SelectorItemInfo("MDSolution.solutionType"));
        MultiDimentionSolutionPeriodInfo period = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID), ssic);
        boolean isOrg = period.getMDSolution().getSolutionType().equals((Object)EvaluSolutionTypeEnum.ORGUNIT);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO T_PF_MDEVALURESULT (FID, FSolutionPeriodID, FMdObjectID, FPositionID, FAdminOrgUnitID, FJobGradeID, FIsApproved, FIsModify, FDisplayName_");
        sb.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sb.append(" ) ");
        sb.append(" SELECT ");
        sb.append("newbosid('");
        sb.append(evaluResultInfo.getBOSType().toString());
        sb.append("'),'");
        sb.append(mdSolutionPeriodID);
        sb.append("',");
        sb.append(" T_PF_MultiDimentionObject.FID , ");
        sb.append(" T_HR_PersonPosition.FPrimaryPositionID,");
        sb.append(" T_HR_PersonPosition.FPersonDep,");
        sb.append(" T_HR_PersonPosition.FJobGrade,");
        sb.append(" 0,0");
        if (isOrg) {
            sb.append(",T_ORG_Admin.FDisplayname_");
            sb.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        } else {
            sb.append(",''");
        }
        sb.append(" FROM T_PF_MDEvaluator INNER JOIN T_PF_MultiDimentionObject ON T_PF_MDEvaluator.FMDObjectID = T_PF_MultiDimentionObject.FID ");
        sb.append(" INNER JOIN T_HR_PersonPosition ON ");
        if (isOrg) {
            sb.append("T_PF_MultiDimentionObject.FResponserID = T_HR_PersonPosition.FPersonID ");
            sb.append(" INNER JOIN T_ORG_Admin ON T_PF_MultiDimentionObject.FEvaluOrgID=T_ORG_Admin.FID ");
        } else {
            sb.append("T_PF_MultiDimentionObject.FPersonID = T_HR_PersonPosition.FPersonID ");
        }
        sb.append(" WHERE T_PF_MDEvaluator.FSolutionPeriodID = '");
        sb.append(mdSolutionPeriodID);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private HashSet getObjectFromEvaluatorCollection(MultiDimEvaluatorCollection dimEvaluatorCollection) {
        HashSet<String> objectSet = new HashSet<String>();
        if (dimEvaluatorCollection == null || dimEvaluatorCollection.size() == 0) {
            return objectSet;
        }
        int n = dimEvaluatorCollection.size();
        for (int i = 0; i < n; ++i) {
            objectSet.add(dimEvaluatorCollection.get(i).getMultiDimObject().getId().toString());
        }
        return objectSet;
    }

    private EvalPersonCollection getEvalPersonCollectionFromEvaluatorCollection(MultiDimEvaluatorCollection dimEvaluatorCollection) {
        EvalPersonCollection evalPersonCollection = new EvalPersonCollection();
        if (dimEvaluatorCollection == null || dimEvaluatorCollection.size() == 0) {
            return evalPersonCollection;
        }
        int n = dimEvaluatorCollection.size();
        for (int i = 0; i < n; ++i) {
            int m = dimEvaluatorCollection.get(i).getEvalReDetails().size();
            for (int j = 0; j < m; ++j) {
                dimEvaluatorCollection.get(i).getEvalReDetails().get(j).setMdEvaluator(dimEvaluatorCollection.get(i));
                int l = dimEvaluatorCollection.get(i).getEvalReDetails().get(j).getEvalPersons().size();
                for (int k = 0; k < l; ++k) {
                    dimEvaluatorCollection.get(i).getEvalReDetails().get(j).getEvalPersons().get(k).setEvalReDetail(dimEvaluatorCollection.get(i).getEvalReDetails().get(j));
                    evalPersonCollection.add(dimEvaluatorCollection.get(i).getEvalReDetails().get(j).getEvalPersons().get(k));
                }
            }
        }
        return evalPersonCollection;
    }

    private MultiDimEvaluatorCollection getDirectEnterMDEvaluatorCollection(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return null;
        }
        MultiDimEvaluatorCollection dimEvaluatorCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalReDetails.evalPersons.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("multiDimObject.id"));
        dimEvaluatorCollection = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorCollection(viewInfo);
        return dimEvaluatorCollection;
    }

    private void updateDirectMDEvalPersonStart(Context ctx, EvalPersonCollection evalPersonCollection) throws BOSException, EASBizException {
        if (evalPersonCollection == null || evalPersonCollection.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int n = evalPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append("','");
            }
            sb.append(evalPersonCollection.get(i).getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_EvalPerson Set FWfStatus =  ");
        sql.append(20);
        sql.append(" , FPaperState = ");
        sql.append(10);
        sql.append(" WHERE FID in ( '");
        sql.append(sb.toString());
        sql.append("')");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateMDEvaluator(Context ctx, String mdSolutionPeriodID, int onused_value) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE  T_PF_MDEvaluator Set FWfStatus = ?  WHERE FSolutionPeriodID = ? ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, onused_value);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdSolutionPeriodID);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateMDEvaluator(Context ctx, String mdSolutionPeriodID, int wfstate, int auditState) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE  T_PF_MDEvaluator Set FWfStatus = ?  ,FAuditState = ?  WHERE FSolutionPeriodID = ? ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, wfstate);
            pstmt.setInt(2, auditState);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)mdSolutionPeriodID);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void flagPersonNoUser(EvalPersonCollection evalPersonCollection, HashSet personHasUserSet) {
        if (evalPersonCollection == null || personHasUserSet == null || personHasUserSet.size() == 0) {
            return;
        }
        int n = evalPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!personHasUserSet.contains(evalPersonCollection.get(i).getPerson().getId().toString())) continue;
            evalPersonCollection.get(i).put("hasUser", Boolean.TRUE);
        }
    }

    private HashSet getEvalPersonSet(EvalPersonCollection evalPersonCollection) {
        HashSet<String> personSet = new HashSet<String>();
        if (evalPersonCollection == null || evalPersonCollection.size() == 0) {
            return personSet;
        }
        int n = evalPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            personSet.add(evalPersonCollection.get(i).getPerson().getId().toString());
        }
        return personSet;
    }

    private HashSet filterPersonByUser(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        HashSet<String> personHasUserSet = new HashSet<String>();
        if (mdSolutionPeriodID == null) {
            return personHasUserSet;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonFilterByUserQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        try {
            while (rowSet.next()) {
                personHasUserSet.add(rowSet.getString("id"));
            }
        }
        catch (Exception e) {
            throw new MDSolutionException(MDSolutionException.START_FAILD, e);
        }
        return personHasUserSet;
    }

    private boolean isDirectEnter(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdSolutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.MultiDimntModeE", (Object)new Integer(100)));
        return MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    private MultiDimntModeEnum getSolutionMode(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("MDSolution.MultiDimntModeE"));
        MultiDimentionSolutionPeriodInfo info = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID), itemCollection);
        if (info != null) {
            return info.getMDSolution().getMultiDimntModeE();
        }
        return null;
    }

    private void sendSuccessOrFaildMessage(Context ctx, String solutionPeriodName, String bodyStr, boolean flag) throws BOSException, EASBizException {
        String[] ids = new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()};
        String messageStr = flag ? solutionPeriodName + ResourceBase.getString((String)"com.kingdee.eas.hr.perf.MDSolutionResource", (String)"startSuccessMsg", (Locale)ctx.getLocale()) : solutionPeriodName + ResourceBase.getString((String)"com.kingdee.eas.hr.perf.MDSolutionResource", (String)"startFaildMsg", (Locale)ctx.getLocale());
        this.sendMessage(ctx, ids, messageStr, ResourceBase.getString((String)"com.kingdee.eas.hr.perf.MDSolutionResource", (String)"sender", (Locale)ctx.getLocale()), bodyStr);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSolutionPeriodTransactionStatus(Context ctx, String solutionPeriodID, int value) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE  T_PF_MDSolutionPeriod Set FTransactionState = ?   WHERE FID = ? ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, value);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodID);
            pstmt.execute();
        }
        catch (SQLException e1) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e1);
                catch (SQLDataException e) {
                    throw new MDSolutionException(MDSolutionException.START_FAILD, e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _directEnterResetSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.deleteEvaluResultBySolutionPeriod(ctx, mdSolutionPeriodID.toString());
        this.updateEvalRelationDetailResetDirectEnter(ctx, mdSolutionPeriodID.toString());
        this.updateDirectEnterEvalPersonReset(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 10, 40);
        this.deleteNotInitPerson(ctx, mdSolutionPeriodID.toString());
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodUnUse(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _appointModeResetSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.deleteTestPaperByEvaluPerson(ctx, mdSolutionPeriodID.toString());
        this.deleteEvaluResultBySolutionPeriod(ctx, mdSolutionPeriodID.toString());
        this.deleteEvaluRelaQuestBySolutionPeriod(ctx, mdSolutionPeriodID.toString());
        this.updateDirectEnterEvalPersonReset(ctx, mdSolutionPeriodID.toString());
        this.deleteNotInitPerson(ctx, mdSolutionPeriodID.toString());
        this.updateEvalRelationDetailReset(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 10, 40);
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodUnUse(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _optionalModeResetSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.deleteTestPaperByEvaluPerson(ctx, mdSolutionPeriodID.toString());
        this.deleteEvaluResultBySolutionPeriod(ctx, mdSolutionPeriodID.toString());
        this.deleteMDevaluReDetailBySolutionPeriod(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 10, 0);
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodUnUse(mdSolutionPeriodID.toString());
    }

    private void deleteMDevaluReDetailBySolutionPeriod(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluator.solutionPeriod.id", (Object)mdSolutionPeriodID));
        EvalRelationDetailFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteNotInitPerson(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetEvalPersonFromMDSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("Delete  T_PF_EvalPerson  ");
        sql.append(" WHERE FID in ( ");
        sql.append(iqec.getSQL());
        sql.append(")");
        sql.append(" and FIsOrigin = 0 ");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESET_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateEvalRelationDetailResetDirectEnter(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetMDEvaluDetailFromSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_EvalReDetail Set FAvrScore = null  ");
        sql.append(" , FModifyScore = null ");
        sql.append(" WHERE FID in ( ");
        sql.append(iqec.getSQL());
        sql.append(")");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESET_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _directEnterFinishSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.updateDirectMDEvalPersonEnd(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 30);
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodEnd(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _appointModeFinishSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.updateDirectMDEvalPersonEnd(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 30);
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodEnd(mdSolutionPeriodID.toString());
    }

    @Override
    protected void _optionalModeFinishSolutionPeriod(Context ctx, BOSUuid mdSolutionPeriodID) throws BOSException, EASBizException {
        this.updateDirectMDEvalPersonEnd(ctx, mdSolutionPeriodID.toString());
        this.updateMDEvaluator(ctx, mdSolutionPeriodID.toString(), 30);
        MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).setSolutionPeriodEnd(mdSolutionPeriodID.toString());
    }

    private void updateDirectMDEvalPersonEnd(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetEvalPersonFromMDSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_EvalPerson Set FWfStatus =  ");
        sql.append(30);
        sql.append(" WHERE FID in ( ");
        sql.append(iqec.getSQL());
        sql.append(")");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.START_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getEvalPersonSQLBySolutionPeriod(Context ctx, String mdSolutionPeriodID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetEvalPersonFromMDSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        String sql = iqec.getSQL();
        return sql;
    }

    private void updateDirectEnterEvalPersonReset(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID.toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetEvalPersonFromMDSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  t_pf_evalperson Set FScore = null  ");
        sql.append(" , FModifyScore = null ");
        sql.append(" , FRankID = null ");
        sql.append(" , FWfStatus =  ");
        sql.append(10);
        sql.append(" , FPaperState =  ");
        sql.append(0);
        sql.append(" WHERE FID in ( ");
        sql.append(iqec.getSQL());
        sql.append(")");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESET_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateEvalRelationDetailReset(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update  t_pf_evalredetail   set FAvrScore =null , FModifyScore =null   ,  fselected = (select count(fid) from t_pf_evalperson b");
        sb.append("  where t_pf_evalredetail.fid =b.fevalredetailid group by b.fevalredetailid) ");
        sb.append("where fmdevaluatorid in( ");
        sb.append("select fid from t_pf_mdevaluator where fsolutionperiodid='");
        sb.append(mdSolutionPeriodID);
        sb.append("')");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            throw new MDSolutionException(MDSolutionException.RESET_FAILD, e);
        }
    }

    private void updateUnDirectEnterEvalPersonReset(Context ctx, EvalPersonCollection evaluPersonCollection) throws BOSException, EASBizException {
        if (evaluPersonCollection == null || evaluPersonCollection.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int n = evaluPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append("','");
            }
            sb.append(evaluPersonCollection.get(i).getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  t_pf_evalperson Set FScore = null  ");
        sql.append(" , FModifyScore = null ");
        sql.append(" , FRankID = null ");
        sql.append(" , FprocessinstanceID = null ");
        sql.append(" , FWfStatus =  ");
        sql.append(10);
        sql.append(" , FPaperState =  ");
        sql.append(0);
        sql.append(" WHERE FID in ( '");
        sql.append(sb.toString());
        sql.append("')");
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.createStatement();
            pstmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESET_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void deleteEvaluResultBySolutionPeriod(Context ctx, String mdSolutionPeriod) throws BOSException, EASBizException {
        if (mdSolutionPeriod == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriod));
        MDEvaluResultFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteEvaluRelaQuestBySolutionPeriod(Context ctx, String mdSolutionPeriod) throws BOSException, EASBizException {
        if (mdSolutionPeriod == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriod));
        EvaluRelationDetailQuestFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteTestPaperByEvaluPerson(Context ctx, EvalPersonCollection evaluPersonCollection) throws BOSException, EASBizException {
        if (evaluPersonCollection == null || evaluPersonCollection.size() == 0) {
            return;
        }
        HashSet<String> evaluPersonSet = new HashSet<String>();
        int n = evaluPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            evaluPersonSet.add(evaluPersonCollection.get(i).getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalPerson.id", evaluPersonSet, CompareType.INCLUDE));
        TestPageFormFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteTestPaperByEvaluPerson(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluResult.solutionPeriod.id", (Object)mdSolutionPeriodID));
        TestPageFormFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private int countUnTerminalProcess(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null) {
            return 0;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.solutionPeriod.id", (Object)mdSolutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        EvalPersonCollection result = EvalPersonFactory.getLocalInstance(ctx).getEvalPersonCollection(viewInfo);
        return result.size();
    }

    @Override
    public void _reSendTestPage(Context ctx, String solutionPeriodID, String mdEvaluObjectID, List evalRelationDetailID, List evalPersonIds, String testPaperID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || evalRelationDetailID == null || evalPersonIds == null || evalPersonIds.isEmpty()) {
            return;
        }
        this.checkReSendTestPageCondition(ctx, solutionPeriodID);
        Iterator evalRelation = evalRelationDetailID.iterator();
        AbstractEvalRelationDetailInfo detailInfo = null;
        while (evalRelation.hasNext()) {
            detailInfo = this.getReSendEvalRelationDetailByID(ctx, (String)evalRelation.next());
        }
        EvalPersonCollection evalPersons = detailInfo.getEvalPersons();
        EvalPersonCollection reSendEvalPersons = new EvalPersonCollection();
        ArrayList<String> evalPersonID = new ArrayList<String>();
        Iterator it = evalPersonIds.iterator();
        String personid = null;
        while (it.hasNext()) {
            String itName = (String)it.next();
            reSendEvalPersons.add(this.getEvalPersonFromCollectionByID(evalPersons, itName));
            personid = this.getEvalPersonFromCollectionByID(evalPersons, itName).getId().toString();
            evalPersonID.add(this.getEvalPersonFromCollectionByID(evalPersons, itName).getId().toString());
        }
        this.checkEvalPersonIsCancel(reSendEvalPersons);
        try {
            AbstractEvalPersonInfo evalPersonInfo = null;
            int size = reSendEvalPersons.size();
            for (int i = 0; i < size; ++i) {
                evalPersonInfo = reSendEvalPersons.get(i);
                evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSUBMIT);
                evalPersonInfo.setWfStatus(WFStatuEnum.ONUSED);
                evalPersonInfo.setAccptDate(new java.sql.Date(new Date().getTime()));
            }
            if (!MultiDimTestPaperStateEnum.SUBMIT.equals((Object)evalPersonInfo.getPaperState())) {
                this.deleteTestPageFormByEvalPerson(ctx, (EvalPersonInfo)evalPersonInfo);
            }
            this.modifyEvaluPersonStatusAndResult(ctx, reSendEvalPersons);
            detailInfo.setAvrScore(null);
            this.modifyEvalRelationDetailScore(ctx, (EvalRelationDetailInfo)detailInfo);
            this.modifyEvaluResultBySolutionPeriodAndEvaluObject(ctx, solutionPeriodID, mdEvaluObjectID, null);
            this.updateEvaluatorStatusByID(ctx, detailInfo.getMdEvaluator().getId().toString(), false);
            ArrayList<String> solutionPeriod = new ArrayList<String>();
            ArrayList<String> multiDimentionObject = new ArrayList<String>();
            solutionPeriod.add(solutionPeriodID.toString());
            multiDimentionObject.add(mdEvaluObjectID);
            this.insertEvaluRelationDetailQuest(ctx, solutionPeriod, evalRelationDetailID, evalPersonID, multiDimentionObject, testPaperID, true);
            TestPageFormInfo info = TestPageFormFactory.getLocalInstance(ctx).getTestPageForm(personid, solutionPeriodID, mdEvaluObjectID, testPaperID);
            String testPageFormId = info.getId().toString();
            this.updateResultTestPage(ctx, solutionPeriod, evalPersonID, multiDimentionObject, testPaperID);
            this.dealLogInfo(ctx, (EvalRelationDetailInfo)detailInfo, "perf_mdProcTrail_reSendPaper");
        }
        catch (Exception ex) {
            throw new MDSolutionException(MDSolutionException.RESEND_FAILD, ex);
        }
    }

    @Override
    protected void _rsBatchSendTestPage(Context ctx, List mdSolutionPeriodID, List mdEvaluObjectID, List evalRelationDetailID, List evalPersonIds, String testPaperID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null || evalRelationDetailID == null || evalPersonIds == null || evalPersonIds.isEmpty()) {
            return;
        }
        Iterator its = mdSolutionPeriodID.iterator();
        while (its.hasNext()) {
            this.checkReSendTestPageCondition(ctx, (String)its.next());
        }
        EvalPersonCollection reSendEvalPersons = null;
        EvalRelationDetailInfo detailInfo = null;
        Iterator itse = evalRelationDetailID.iterator();
        while (itse.hasNext()) {
            detailInfo = this.getReSendEvalRelationDetailByID(ctx, (String)itse.next());
            EvalPersonCollection evalPersons = detailInfo.getEvalPersons();
            reSendEvalPersons = new EvalPersonCollection();
            for (String sname : evalPersonIds) {
                EvalPersonInfo info = EvalPersonFactory.getLocalInstance(ctx).getEvalPersonInfo((IObjectPK)new ObjectUuidPK(sname));
                reSendEvalPersons.add(info);
            }
            this.checkEvalPersonIsCancel(reSendEvalPersons);
            try {
                EvalPersonInfo evalPersonInfo = null;
                int size = reSendEvalPersons.size();
                for (int i = 0; i < size; ++i) {
                    evalPersonInfo = reSendEvalPersons.get(i);
                    evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSUBMIT);
                    evalPersonInfo.setWfStatus(WFStatuEnum.ONUSED);
                }
                this.deleteTestPageFormByEvalPerson(ctx, reSendEvalPersons);
                this.modifyEvaluPersonStatusAndResult(ctx, reSendEvalPersons);
                detailInfo.setAvrScore(null);
                this.modifyEvalRelationDetailScore(ctx, detailInfo);
                this.updateEvaluatorStatusByID(ctx, detailInfo.getMdEvaluator().getId().toString(), false);
                this.dealLogInfo(ctx, detailInfo, "perf_mdProcTrail_reSendPaper");
            }
            catch (Exception ex) {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD, ex);
            }
        }
        try {
            this.modifyBatchEvaluResultBySolutionPeriodAndEvaluObject(ctx, mdSolutionPeriodID, mdEvaluObjectID, null);
            this.insertEvaluRelationDetailQuest(ctx, mdSolutionPeriodID, evalRelationDetailID, evalPersonIds, mdEvaluObjectID, testPaperID, false);
        }
        catch (Exception ex) {
            throw new MDSolutionException(MDSolutionException.RESEND_FAILD, ex);
        }
    }

    private void updateFATestPage(Context ctx, String evalRelationDetailID, String solutionPeriodID, String evalPersonID, String multiDimentionObjectID, String testPaperID) throws BOSException, EASBizException {
        if (evalRelationDetailID == null || solutionPeriodID == null || multiDimentionObjectID == null || testPaperID == null) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_PF_EvalurelationQuest set FPaperQuestID ='");
        sqlBuf.append(testPaperID);
        sqlBuf.append("' where FEvalRelationID = '");
        sqlBuf.append(evalRelationDetailID);
        sqlBuf.append("' and FSolutionPeriodID = '");
        sqlBuf.append(solutionPeriodID);
        sqlBuf.append("' and FEvalPerson = '");
        sqlBuf.append(evalPersonID);
        sqlBuf.append("' and FMultiDimentionObject = '");
        sqlBuf.append(multiDimentionObjectID);
        sqlBuf.append("'");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    private void updateResultTestPage(Context ctx, String testPageFormId, String testPaperID) throws BOSException, EASBizException {
        if (testPageFormId == null || testPaperID == null) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_PF_TestPageForm set FTestPaperID ='");
        sqlBuf.append(testPaperID);
        sqlBuf.append("' where fid in (");
        sqlBuf.append(testPageFormId);
        sqlBuf.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    private void updateResultTestPage(Context ctx, List mdSolutionPeriodID, List reSendEvalPersonsSetID, List multiDimentionObject, String testPaperID) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null || reSendEvalPersonsSetID == null || testPaperID == null) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_PF_TestPageForm set FTestPaperID ='");
        sqlBuf.append(testPaperID);
        sqlBuf.append("' where fid in (select TESTPAGEFORM.fid from T_PF_TestPageForm  AS TESTPAGEFORM ");
        sqlBuf.append(" INNER JOIN T_PF_MDEVALURESULT AS MDEVALURESULT ON TESTPAGEFORM.FMDEvaluResultID = MDEVALURESULT.FID ");
        sqlBuf.append(" INNER JOIN T_PF_MDSolutionPeriod AS SOLUTIONPERIOD ON MDEVALURESULT.FSolutionPeriodID = SOLUTIONPERIOD.FID ");
        sqlBuf.append(" where MDEVALURESULT.FSolutionPeriodID in (");
        int index1 = 0;
        Iterator iter = mdSolutionPeriodID.iterator();
        while (iter.hasNext()) {
            if (index1 > 0) {
                sqlBuf.append(",");
            }
            ++index1;
            sqlBuf.append("'");
            sqlBuf.append(iter.next().toString());
            sqlBuf.append("'");
        }
        sqlBuf.append(") and FEvalPersonID in (");
        int index = 0;
        Iterator iter2 = reSendEvalPersonsSetID.iterator();
        while (iter2.hasNext()) {
            if (index > 0) {
                sqlBuf.append(",");
            }
            ++index;
            sqlBuf.append("'");
            sqlBuf.append(iter2.next().toString());
            sqlBuf.append("'");
        }
        sqlBuf.append("))");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    private void modifyBatchEvaluResultBySolutionPeriodAndEvaluObject(Context ctx, List solutionPeriodID, List mdEvaluObjectID, BigDecimal score) throws BOSException, EASBizException {
        if (solutionPeriodID == null || mdEvaluObjectID == null) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("UPDATE  T_PF_MDEVALURESULT Set FEvaluScore = ");
        sqlBuf.append(score);
        sqlBuf.append(" where FSolutionPeriodID in (");
        Iterator iter = solutionPeriodID.iterator();
        while (iter.hasNext()) {
            sqlBuf.append("'");
            sqlBuf.append(iter.next().toString());
            sqlBuf.append("'");
        }
        sqlBuf.append(")AND FMdObjectID in (");
        Iterator iters = mdEvaluObjectID.iterator();
        while (iters.hasNext()) {
            sqlBuf.append("'");
            sqlBuf.append(iters.next().toString());
            sqlBuf.append("'");
        }
        sqlBuf.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    private void checkReSendTestPageCondition(Context ctx, String solutionPeriodID) throws BOSException, EASBizException, MDSolutionException {
        this.checkSolutionPeriodStarted(ctx, solutionPeriodID);
        if (this.isDirectEnter(ctx, solutionPeriodID)) {
            throw new MDSolutionException(MDSolutionException.NOLY_WORKLFOW_CAN_RESEND_CANCLE_APPOINT);
        }
    }

    private void checkEvalPersonIsCancel(EvalPersonCollection reSendevalPersons) throws MDSolutionException {
        EvalPersonInfo evalPersonInfo = null;
        EvalPersonCollection cancelPersons = new EvalPersonCollection();
        int size = reSendevalPersons.size();
        for (int i = 0; i < size; ++i) {
            evalPersonInfo = reSendevalPersons.get(i);
            if (!MultiDimTestPaperStateEnum.CANCEL.equals((Object)evalPersonInfo.getPaperState())) continue;
            cancelPersons.add(evalPersonInfo);
        }
        if (!cancelPersons.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            int size2 = cancelPersons.size();
            for (int i = 0; i < size2; ++i) {
                evalPersonInfo = cancelPersons.get(i);
                if (evalPersonInfo == null || evalPersonInfo.getPerson() == null) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(evalPersonInfo.getPerson().getName());
            }
            throw new MDSolutionException(MDSolutionException.CANCLE_NOT_RESEND, new Object[]{sb.toString()});
        }
    }

    private boolean isPersonHasUser(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        return UserFactory.getLocalInstance((Context)ctx).exists(filterInfo);
    }

    private void updateEvaluatorStatusByID(Context ctx, String mdEvaluatorID, boolean isFinish) throws BOSException, EASBizException {
        if (mdEvaluatorID == null) {
            return;
        }
        int state = 0;
        if (isFinish) {
            state = 30;
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.id", (Object)mdEvaluatorID));
            filterInfo.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(20)));
            filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30)));
            filterInfo.setMaskString(" #0 AND #1 AND ( #2 OR #3 )");
            state = EvalPersonFactory.getLocalInstance(ctx).exists(filterInfo) ? 20 : 10;
        }
        String sql = "UPDATE  T_PF_MDEvaluator Set FWfStatus = ?   where FID = ?  ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdEvaluatorID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void deleteProcessInst(Context ctx, EvalPersonInfo evalPersonInfo) throws BOSException, EASBizException {
        EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
        ProcessInstInfo procInst = null;
        if (evalPersonInfo.getProcInstID() != null && evalPersonInfo.getProcInstID().trim().length() > 0) {
            String[] selectors = new String[]{"id", "state"};
            try {
                procInst = enactmentService.getProcessInstInfo(evalPersonInfo.getProcInstID());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (procInst != null) {
                    if (!procInst.getState().startsWith(WfState.CLOSED.getValue())) {
                        enactmentService.terminateProcessInst(procInst.getProcInstId());
                    }
                    enactmentService.deletePhysicsProcessInst(evalPersonInfo.getProcInstID());
                }
            }
            catch (Exception e2) {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD);
            }
        }
    }

    private EvalPersonInfo getEvalPersonFromCollectionByID(EvalPersonCollection evalPersons, String evalPersonID) {
        if (evalPersons == null || evalPersonID == null) {
            return null;
        }
        int n = evalPersons.size();
        for (int i = 0; i < n; ++i) {
            if (!evalPersonID.equals(evalPersons.get(i).getId().toString())) continue;
            return evalPersons.get(i);
        }
        return null;
    }

    private EvalPersonInfo getBatchEvalPersonFromCollectionByID(EvalPersonCollection evalPersons, Set evalPersonID) {
        if (evalPersons == null || evalPersonID == null) {
            return null;
        }
        int n = evalPersonID.size();
        for (int i = 0; i < n; ++i) {
            if (!evalPersons.equals(evalPersons.get(i).getId().toString())) continue;
            return evalPersons.get(i);
        }
        return null;
    }

    private void modifyEvaluResultBySolutionPeriodAndEvaluObject(Context ctx, String solutionPeriodID, String mdEvaluObjectID, BigDecimal score) throws BOSException, EASBizException {
        if (solutionPeriodID == null || mdEvaluObjectID == null) {
            return;
        }
        String sql = "UPDATE  T_PF_MDEVALURESULT Set FEvaluScore = ?   where FSolutionPeriodID = ?  AND FMdObjectID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBigDecimal(1, score);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)mdEvaluObjectID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void modifyEvalRelationDetailScore(Context ctx, EvalRelationDetailInfo detailInfo) throws BOSException, EASBizException {
        if (detailInfo == null) {
            return;
        }
        String sql = "UPDATE  T_PF_EvalReDetail Set FAvrScore = ? , FSelected = ?   where FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBigDecimal(1, detailInfo.getAvrScore());
            pstmt.setInt(2, detailInfo.getSelected());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)detailInfo.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void modifyEvaluPersonStatusAndResult(Context ctx, EvalPersonCollection reSendEvalPersons) throws BOSException, EASBizException {
        if (reSendEvalPersons == null || reSendEvalPersons.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE  t_pf_evalperson Set FScore = null ,FRankID = null ,  FWfStatus = ?  , FPaperState =  ? , FAccptDate = ? where FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            EvalPersonInfo evalPersonInfo = null;
            int size = reSendEvalPersons.size();
            for (int i = 0; i < size; ++i) {
                evalPersonInfo = reSendEvalPersons.get(i);
                pstmt.setInt(1, evalPersonInfo.getWfStatus().getValue());
                pstmt.setInt(2, evalPersonInfo.getPaperState().getValue());
                pstmt.setTimestamp(3, new Timestamp(evalPersonInfo.getAccptDate().getTime()));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)evalPersonInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.RESEND_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void deleteTestPageFormByEvalPerson(Context ctx, EvalPersonInfo evalPersonInfo) throws BOSException, EASBizException {
        if (evalPersonInfo == null) {
            return;
        }
        EvalPersonCollection evalPersonCollection = new EvalPersonCollection();
        evalPersonCollection.add(evalPersonInfo);
        this.deleteTestPageFormByEvalPerson(ctx, evalPersonCollection);
    }

    private void deleteTestPageFormByEvalPerson(Context ctx, EvalPersonCollection evalPersonCollection) throws BOSException, EASBizException {
        if (evalPersonCollection == null || evalPersonCollection.isEmpty()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        int size = evalPersonCollection.size();
        for (int i = 0; i < size; ++i) {
            ids.add(evalPersonCollection.get(i).getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalPerson.id", ids, CompareType.INCLUDE));
        TestPageFormFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private EvalRelationDetailInfo getReSendEvalRelationDetailByID(Context ctx, String evalRelationDetailID) throws BOSException, EASBizException {
        if (evalRelationDetailID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.multiDimObject.id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.multiDimObject.person.name"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.multiDimObject.evaluOrg.name"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.solutionPeriod.name"));
        itemCollection.add(new SelectorItemInfo("evalPersons.person.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.person.name"));
        itemCollection.add(new SelectorItemInfo("evalRelation.paper.id"));
        itemCollection.add(new SelectorItemInfo("selected"));
        itemCollection.add(new SelectorItemInfo("evalPersons.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.workflowID"));
        itemCollection.add(new SelectorItemInfo("evalPersons.procInstID"));
        itemCollection.add(new SelectorItemInfo("evalPersons.wfStatus"));
        itemCollection.add(new SelectorItemInfo("evalPersons.paperState"));
        return EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalRelationDetailID), itemCollection);
    }

    private void checkSolutionPeriodStarted(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        if (!MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDSolutionException(MDSolutionException.CANNOT_RESEND_CANCLE_APPOINT);
        }
    }

    @Override
    public void _cancleTestPage(Context ctx, String solutionPeriodID, String mdEvaluObjectID, String evalPersonID, String evalRelationDetailID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || evalPersonID == null || evalRelationDetailID == null) {
            return;
        }
        StringBuffer logMessage = this.getLog(ctx, solutionPeriodID, mdEvaluObjectID);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MDWfFacadeFactory.getLocalInstance(ctx).getType(), null, (String)logMessage.toString(), (String)"perf_mdProcTrail_cancelPrivacy");
        this.checkReSendTestPageCondition(ctx, solutionPeriodID);
        EvalRelationDetailInfo detailInfo = this.getCancleEvalRelationDetailByID(ctx, evalRelationDetailID);
        EvalPersonInfo evalPersonInfo = this.getEvalPersonFromCollectionByID(detailInfo.getEvalPersons(), evalPersonID);
        if (evalPersonInfo == null) {
            throw new MDSolutionException(MDSolutionException.CANCLE_FAILD);
        }
        evalPersonInfo.setEvalReDetail(detailInfo);
        if (MultiDimTestPaperStateEnum.CANCEL.equals((Object)evalPersonInfo.getPaperState())) {
            throw new MDSolutionException(MDSolutionException.CANCLE_NOT_CANCLE);
        }
        if (this.isTheLastEvaluator(ctx, detailInfo.getEvalPersons())) {
            throw new MDSolutionException(MDSolutionException.GROUP_MUST_LEAVE_ONE_PERSON);
        }
        if (!MultiDimTestPaperStateEnum.SUBMIT.equals((Object)evalPersonInfo.getPaperState())) {
            this.deleteTestPageFormByEvalPerson(ctx, evalPersonInfo);
            evalPersonInfo.setScore(null);
            evalPersonInfo.setRank(null);
        }
        evalPersonInfo.setWfStatus(WFStatuEnum.UNUSED);
        evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.CANCEL);
        try {
            this.modifyCancleEvaluPersonStatusAndResult(ctx, evalPersonInfo);
            detailInfo.setAvrScore(this.countDetailScore(detailInfo));
            detailInfo.setSelected(this.countDetailSelectedPerson(detailInfo));
            this.modifyEvalRelationDetailScore(ctx, detailInfo);
            boolean isFinish = this.needCountEvaluResult(ctx, detailInfo.getMdEvaluator().getId().toString());
            BigDecimal evaluResultScore = null;
            if (isFinish) {
                evaluResultScore = this.countEvaluResultScore(ctx, detailInfo.getMdEvaluator().getId().toString());
            }
            this.modifyEvaluResultBySolutionPeriodAndEvaluObject(ctx, solutionPeriodID, mdEvaluObjectID, evaluResultScore);
            this.updateEvaluatorStatusByID(ctx, detailInfo.getMdEvaluator().getId().toString(), isFinish);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception ex) {
            throw new MDSolutionException(MDSolutionException.CANCLE_FAILD, ex);
        }
    }

    private StringBuffer getLog(Context ctx, String solutionPeriodID, String mdEvaluObjectID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("responser.name"));
        MultiDimentionObjectInfo mdObjectInfo = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(mdEvaluObjectID), sic);
        StringBuffer logMessage = new StringBuffer();
        String objname = null;
        if (mdObjectInfo.getPerson() != null && mdObjectInfo.getPerson().getName() != null) {
            objname = mdObjectInfo.getPerson().getName();
        } else if (mdObjectInfo.getResponser() != null && mdObjectInfo.getResponser().getName() != null) {
            objname = mdObjectInfo.getResponser().getName();
        }
        if (!StringUtils.isEmpty((String)solutionPeriodInfo.getName()) && !StringUtils.isEmpty((String)objname)) {
            logMessage.append(objname);
            logMessage.append("  ");
            logMessage.append(solutionPeriodInfo.getName());
        } else {
            logMessage.append(solutionPeriodInfo.getName());
        }
        return logMessage;
    }

    private int countDetailSelectedPerson(EvalRelationDetailInfo detailInfo) {
        int count = 0;
        int n = detailInfo.getEvalPersons().size();
        for (int i = 0; i < n; ++i) {
            if (detailInfo.getEvalPersons().get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.CANCEL)) continue;
            ++count;
        }
        return count;
    }

    private BigDecimal countEvaluResultScore(Context ctx, String mdEvaluatorID) throws BOSException, EASBizException {
        if (mdEvaluatorID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("evalReDetails.id"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.avrScore"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalRelation.weight"));
        MultiDimEvaluatorInfo dimEvaluatorInfo = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(mdEvaluatorID), itemCollection);
        BigDecimal value = new BigDecimal("0.000000");
        if (dimEvaluatorInfo == null) {
            return value;
        }
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            EvalRelationDetailInfo detailInfo = dimEvaluatorInfo.getEvalReDetails().get(i);
            if (dimEvaluatorInfo.getEvalReDetails().get(i).getAvrScore() == null) continue;
            value = value.add(detailInfo.getAvrScore().multiply(detailInfo.getEvalRelation().getWeight()));
        }
        value = value.multiply(new BigDecimal("0.01"));
        return value;
    }

    private boolean needCountEvaluResult(Context ctx, String mdEavaluatorID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.id", (Object)mdEavaluatorID));
        filterInfo.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        return !EvalPersonFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    private void modifyCancleEvaluPersonStatusAndResult(Context ctx, EvalPersonInfo evalPersonInfo) throws BOSException, EASBizException {
        if (evalPersonInfo == null) {
            return;
        }
        String sql = "UPDATE  t_pf_evalperson Set FScore = ?  ,FRankID = ?  , FprocessinstanceID = null , FWfStatus = ?  , FPaperState =  ?  where FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBigDecimal(1, evalPersonInfo.getScore());
            if (evalPersonInfo.getRank() == null) {
                pstmt.setString(2, null);
            } else {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evalPersonInfo.getRank().getId().toString());
            }
            pstmt.setInt(3, evalPersonInfo.getWfStatus().getValue());
            pstmt.setInt(4, evalPersonInfo.getPaperState().getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)evalPersonInfo.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.CANCLE_FAILD);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private BigDecimal countDetailScore(EvalRelationDetailInfo detailInfo) {
        BigDecimal value = new BigDecimal("0.00");
        if (detailInfo == null) {
            return null;
        }
        int count = 0;
        int n = detailInfo.getEvalPersons().size();
        for (int i = 0; i < n; ++i) {
            if (detailInfo.getEvalPersons().get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.CANCEL)) continue;
            if (detailInfo.getEvalPersons().get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.NOTSUBMIT)) {
                return null;
            }
            if (!detailInfo.getEvalPersons().get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.SUBMIT) || !detailInfo.getEvalPersons().get(i).getWfStatus().equals((Object)WFStatuEnum.CLOSED)) continue;
            if (detailInfo.getEvalPersons().get(i).getScore() != null) {
                value = value.add(detailInfo.getEvalPersons().get(i).getScore());
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        BigDecimal sizeValue = new BigDecimal("" + count);
        sizeValue = sizeValue.setScale(6, 4);
        BigDecimal avr = value.divide(sizeValue, 4);
        avr = avr.setScale(6, 4);
        return avr;
    }

    private boolean isTheLastEvaluator(Context ctx, EvalPersonCollection evalPersons) {
        if (evalPersons == null) {
            return true;
        }
        int count = 0;
        int n = evalPersons.size();
        for (int i = 0; i < n; ++i) {
            if (MultiDimTestPaperStateEnum.CANCEL.equals((Object)evalPersons.get(i).getPaperState())) continue;
            ++count;
        }
        return count <= 1;
    }

    private EvalRelationDetailInfo getCancleEvalRelationDetailByID(Context ctx, String evalRelationDetailID) throws BOSException, EASBizException {
        if (evalRelationDetailID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.person.id"));
        itemCollection.add(new SelectorItemInfo("evalRelation.paper.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.procInstID"));
        itemCollection.add(new SelectorItemInfo("evalPersons.wfStatus"));
        itemCollection.add(new SelectorItemInfo("evalPersons.paperState"));
        itemCollection.add(new SelectorItemInfo("evalPersons.score"));
        itemCollection.add(new SelectorItemInfo("evalPersons.rank.id"));
        return EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalRelationDetailID), itemCollection);
    }

    @Override
    public void _reAppointTestPage(Context ctx, String solutionPeriodID, String mdEvaluObjectID, String personId, String evalRelationDetailID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || personId == null || evalRelationDetailID == null) {
            return;
        }
        StringBuffer logMessage = this.getLog(ctx, solutionPeriodID, mdEvaluObjectID);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MDWfFacadeFactory.getLocalInstance(ctx).getType(), null, (String)logMessage.toString(), (String)"perf_mdProcTrail_reDefEvalPerson");
        this.checkReSendTestPageCondition(ctx, solutionPeriodID);
        EvalRelationDetailInfo detailInfo = this.getReAppointEvalRelationDetailByID(ctx, evalRelationDetailID);
        EvalPersonInfo evalPersonInfo = new EvalPersonInfo();
        evalPersonInfo.setId(BOSUuid.create((BOSObjectType)evalPersonInfo.getBOSType()));
        evalPersonInfo.setEvalReDetail(detailInfo);
        evalPersonInfo.setIsOrigin(false);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        evalPersonInfo.setPerson(personInfo);
        if (this.existSameEvaluator(detailInfo.getEvalPersons(), personId)) {
            throw new MDSolutionException(MDSolutionException.SAME_GROUP_NOT_DOUBLE_EFFECT_EVALUATOR);
        }
        detailInfo.getEvalPersons().add(evalPersonInfo);
        String positionId = this.getPrimaryPositionByPersonId(ctx, personId);
        if (positionId != null) {
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)positionId));
            evalPersonInfo.setPosition(positionInfo);
        }
        evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSUBMIT);
        evalPersonInfo.setWfStatus(WFStatuEnum.ONUSED);
        try {
            this.insertEvalPerson(ctx, evalPersonInfo);
            detailInfo.setAvrScore(null);
            detailInfo.setSelected(this.countDetailSelectedPerson(detailInfo));
            this.modifyEvalRelationDetailScore(ctx, detailInfo);
            this.modifyEvaluResultBySolutionPeriodAndEvaluObject(ctx, solutionPeriodID, mdEvaluObjectID, null);
            this.updateEvaluatorStatusByID(ctx, detailInfo.getMdEvaluator().getId().toString(), false);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception ex) {
            throw new MDSolutionException(MDSolutionException.REAPPOINT_FAIL);
        }
    }

    private boolean existSameEvaluator(EvalPersonCollection evalPersons, String personId) {
        if (evalPersons == null || personId == null) {
            return false;
        }
        int n = evalPersons.size();
        for (int i = 0; i < n; ++i) {
            if (evalPersons.get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.CANCEL) || !evalPersons.get(i).getPerson().getId().toString().equals(personId)) continue;
            return true;
        }
        return false;
    }

    private EvalRelationDetailInfo getReAppointEvalRelationDetailByID(Context ctx, String evalRelationDetailID) throws BOSException, EASBizException {
        if (evalRelationDetailID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.multiDimObject.id"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.multiDimObject.person.name"));
        itemCollection.add(new SelectorItemInfo("mdEvaluator.solutionPeriod.name"));
        itemCollection.add(new SelectorItemInfo("evalPersons.id"));
        itemCollection.add(new SelectorItemInfo("evalPersons.workflowID"));
        itemCollection.add(new SelectorItemInfo("evalPersons.paperState"));
        itemCollection.add(new SelectorItemInfo("evalPersons.person.id"));
        itemCollection.add(new SelectorItemInfo("evalRelation.paper.id"));
        return EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalRelationDetailID), itemCollection);
    }

    private void insertEvalPerson(Context ctx, EvalPersonInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_PF_EvalPerson (FID, FEvalReDetailID, FPersonID, FPositionID, FIsOrigin,FPaperState,FWfStatus) VALUES (?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)info.getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)info.getEvalReDetail().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
            if (info.getPosition() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPosition().getId().toString());
            } else {
                pstmt.setString(4, null);
            }
            pstmt.setBoolean(5, info.isIsOrigin());
            pstmt.setInt(6, info.getPaperState().getValue());
            pstmt.setInt(7, info.getWfStatus().getValue());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.REAPPOINT_FAIL);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void insertEvaluRelationDetailQuest(Context ctx, List solutionPeriodID, List evalRelationID, List evalPersonID, List multiDimentionObjectID, String paperQuestID, boolean isFlag) throws BOSException, EASBizException {
        if (solutionPeriodID == null || evalRelationID == null || paperQuestID == null || evalPersonID == null || multiDimentionObjectID == null) {
            return;
        }
        int size = evalPersonID.size();
        for (int i = 0; i < size; ++i) {
            String multiDimentionObject;
            String evalRelationDetaiID;
            String solutionPeriod;
            if (solutionPeriodID.size() > 1 && evalRelationID.size() > 1 && multiDimentionObjectID.size() > 1) {
                solutionPeriod = solutionPeriodID.get(i).toString();
                evalRelationDetaiID = evalRelationID.get(i).toString();
                multiDimentionObject = multiDimentionObjectID.get(i).toString();
            } else {
                solutionPeriod = solutionPeriodID.get(0).toString();
                evalRelationDetaiID = evalRelationID.get(0).toString();
                multiDimentionObject = multiDimentionObjectID.get(0).toString();
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalRelation.id"));
            EvalRelationDetailInfo evalDetail = EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalRelationDetaiID), sic);
            String evalRelation = evalDetail.getEvalRelation().getId().toString();
            String evalPerson = evalPersonID.get(i).toString();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("evaluRelation", (Object)evalRelation, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriod, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("multiDimentionObject", (Object)multiDimentionObject, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("evalPerson", (Object)evalPerson, CompareType.INCLUDE));
            evi.setFilter(fi);
            EvaluRelationDetailQuestCollection coll = EvaluRelationDetailQuestFactory.getLocalInstance(ctx).getEvaluRelationDetailQuestCollection(evi);
            if (coll != null && coll.size() > 0) {
                this.updateFATestPage(ctx, evalRelation, solutionPeriod, evalPerson, multiDimentionObject, paperQuestID);
                continue;
            }
            this.insertEvaluQuest(ctx, evalRelation, solutionPeriod, evalPerson, multiDimentionObject, paperQuestID, isFlag);
        }
    }

    private void insertEvaluQuest(Context ctx, String evalRelationID, String solutionPeriodID, String evalPersonID, String multiDimentionObjectID, String paperQuestID, boolean isFlag) throws BOSException, EASBizException {
        if (evalRelationID == null || solutionPeriodID == null || multiDimentionObjectID == null || paperQuestID == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_PF_EvalurelationQuest (FID, FSolutionPeriodID,FEvalRelationID,FEvalPerson,FMultiDimentionObject,FPaperQuestID) VALUES (?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            EvaluRelationDetailQuestInfo info = new EvaluRelationDetailQuestInfo();
            String fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
            pstmt.setString(1, fid);
            pstmt.setString(2, solutionPeriodID);
            pstmt.setString(3, evalRelationID);
            pstmt.setString(4, evalPersonID);
            pstmt.setString(5, multiDimentionObjectID);
            pstmt.setString(6, paperQuestID);
            pstmt.addBatch();
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.REAPPOINT_FAIL);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getPrimaryPositionByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        if (personId == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        PositionMemberCollection memberCollection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        if (memberCollection == null) {
            throw new MDSolutionException(MDSolutionException.PERSON_NO_PRIMARY_POSITION);
        }
        if (memberCollection.size() == 0) {
            return null;
        }
        return memberCollection.get(0).getPosition().getId().toString();
    }

    public Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    @Override
    protected void _sendMessage(Context ctx, String[] ids, String messageStr, String senderStr, String bodyStr) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = this.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0) {
            return;
        }
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", messageStr, locale2);
            message.setLocaleStringHeader("sender", senderStr, locale2);
            if (bodyStr == null) {
                message.setLocaleStringHeader("body", messageStr, locale2);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (PfServerUtils.objectIsNull(ids[i])) continue;
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    @Override
    protected void _sendMessage(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)solutionPeriodID)) {
            return;
        }
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, solutionPeriodID);
        this.dealMsgReceiverIsEvalPerson(ctx, mdEvaluatorCollection);
    }

    @Override
    protected void _sendMessage(Context ctx, Set evaluatorIds) throws BOSException, EASBizException {
        if (evaluatorIds == null || evaluatorIds.isEmpty()) {
            return;
        }
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, evaluatorIds);
        this.dealMsgReceiverIsEvalPerson(ctx, mdEvaluatorCollection);
    }

    @Override
    protected void _sendMessage(Context ctx, String evaluatorID, Set msgReceivers) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)evaluatorID) || msgReceivers == null || msgReceivers.isEmpty()) {
            return;
        }
        HashSet<String> mdEvaluators = new HashSet<String>();
        mdEvaluators.add(evaluatorID);
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, mdEvaluators);
        if (mdEvaluatorCollection == null || mdEvaluatorCollection.isEmpty()) {
            return;
        }
        Map positionMap = this.getPersonPositionBymdEvaluator(ctx, mdEvaluatorCollection);
        EvalPersonCollection evalPersonCollection = null;
        MultiDimEvaluatorInfo mdEvaluatorInfo = null;
        FilterInfo filter = null;
        Iterator it = mdEvaluatorCollection.iterator();
        while (it.hasNext()) {
            mdEvaluatorInfo = (MultiDimEvaluatorInfo)it.next();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator", (Object)String.valueOf(mdEvaluatorInfo.getId())));
            filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)MultiDimTestPaperStateEnum.NOTSUBMIT));
            evalPersonCollection = this.getEvalPersonCollectionByFilterInfo(ctx, filter);
            if (PfServerUtils.collectionIsNullOrEmpty((IObjectCollection)evalPersonCollection)) continue;
            this.dealSendMessage(ctx, mdEvaluatorInfo, evalPersonCollection, positionMap, msgReceivers);
        }
    }

    @Override
    protected void _sendMessage(Context ctx, Set evaluatorID, Set evalReDetailID, Set evalPersonIds) throws BOSException, EASBizException {
        if (evaluatorID == null || evaluatorID.isEmpty() || evalReDetailID == null || evalReDetailID.isEmpty() || evalPersonIds == null || evalPersonIds.isEmpty()) {
            return;
        }
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, evaluatorID);
        if (mdEvaluatorCollection == null || mdEvaluatorCollection.isEmpty()) {
            return;
        }
        Map positionMap = this.getPersonPositionBymdEvaluator(ctx, mdEvaluatorCollection);
        EvalPersonCollection evalPersonCollection = null;
        MultiDimEvaluatorInfo mdEvaluatorInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail", (Object)evalReDetailID, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)MultiDimTestPaperStateEnum.NOTSUBMIT));
        Iterator it = mdEvaluatorCollection.iterator();
        while (it.hasNext()) {
            mdEvaluatorInfo = (MultiDimEvaluatorInfo)it.next();
            evalPersonCollection = this.getEvalPersonCollectionByFilterInfo(ctx, filter);
            if (PfServerUtils.collectionIsNullOrEmpty((IObjectCollection)evalPersonCollection)) continue;
            this.dealSendMessage(ctx, mdEvaluatorInfo, evalPersonCollection, positionMap, evalPersonIds);
        }
    }

    private void dealMsgReceiverIsEvalPerson(Context ctx, MultiDimEvaluatorCollection mdEvaluatorCollection) throws BOSException, EASBizException {
        if (mdEvaluatorCollection == null || mdEvaluatorCollection.isEmpty()) {
            return;
        }
        Map positionMap = this.getPersonPositionBymdEvaluator(ctx, mdEvaluatorCollection);
        EvalPersonCollection evalPersonCollection = null;
        MultiDimEvaluatorInfo mdEvaluatorInfo = null;
        HashSet msgReceivers = null;
        FilterInfo filter = null;
        Iterator it = mdEvaluatorCollection.iterator();
        while (it.hasNext()) {
            mdEvaluatorInfo = (MultiDimEvaluatorInfo)it.next();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator", (Object)String.valueOf(mdEvaluatorInfo.getId())));
            filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)MultiDimTestPaperStateEnum.NOTSUBMIT));
            evalPersonCollection = this.getEvalPersonCollectionByFilterInfo(ctx, filter);
            if (PfServerUtils.collectionIsNullOrEmpty((IObjectCollection)evalPersonCollection)) continue;
            msgReceivers = this.getEvalPersonSet(evalPersonCollection);
            this.dealSendMessage(ctx, mdEvaluatorInfo, evalPersonCollection, positionMap, msgReceivers);
        }
    }

    @Override
    protected String _sendTestPaper(Context ctx, String mdSolutionPeriodID, HashSet idSet) throws BOSException, EASBizException {
        if (mdSolutionPeriodID == null || idSet == null || idSet.size() == 0) {
            return null;
        }
        this.updateEvalPersonStartByEvaluator(ctx, idSet);
        this.updateEvaluatorStartByID(ctx, idSet);
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, idSet);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            MultiDimEvaluatorInfo item = new MultiDimEvaluatorInfo();
            item.setId(BOSUuid.read((String)iter.next().toString()));
            mdEvaluatorCollection.add(item);
        }
        this._sendMessage(ctx, idSet);
        return null;
    }

    private void updateEvaluatorStartByID(Context ctx, HashSet idSet) throws BOSException, EASBizException {
        int GROUP = 1000;
        int index = 0;
        HashSet groupSet = null;
        groupSet = new HashSet(GROUP);
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            groupSet.add(iterator.next());
            if ((++index % GROUP != 0 || index <= 0) && (index % GROUP == 0 || index <= 0 || iterator.hasNext())) continue;
            this.updateEvaluatorStartByIDGroup(ctx, groupSet);
            groupSet = new HashSet(GROUP);
        }
    }

    private void updateEvaluatorStartByIDGroup(Context ctx, HashSet idSet) throws BOSException, SQLDataException, MDSolutionException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = idSet.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(iterator.next().toString());
            sb.append("'");
            ++index;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_MDEvaluator Set FWfStatus =  ");
        sql.append(20);
        sql.append(" , FAuditState = ");
        sql.append(80);
        sql.append(" WHERE ");
        sql.append(" FAuditState=");
        sql.append(40);
        sql.append(" and ");
        sql.append(" FID in ( ");
        sql.append(sb.toString());
        sql.append(" )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new MDSolutionException(MDSolutionException.SENDPAPER_FAILD, e);
        }
    }

    private void updateEvalPersonStartByEvaluator(Context ctx, HashSet idSet) throws BOSException, EASBizException {
        int GROUP = 1000;
        int index = 0;
        HashSet groupSet = null;
        groupSet = new HashSet(GROUP);
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            groupSet.add(iterator.next());
            if ((++index % GROUP != 0 || index <= 0) && (index % GROUP == 0 || index <= 0 || iterator.hasNext())) continue;
            this.updateEvalPersonStartByEvaluatorGroup(ctx, groupSet);
            groupSet = new HashSet(GROUP);
        }
    }

    private void updateEvalPersonStartByEvaluatorGroup(Context ctx, HashSet idSet) throws BOSException, SQLDataException, MDSolutionException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.auditState", (Object)new Integer(40)));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetMDEvalPersonByEvaluatorQuery"));
        iqec.setObjectView(viewInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE  T_PF_EvalPerson Set FWfStatus =  ");
        sql.append(20);
        sql.append(" , FPaperState = ");
        sql.append(10);
        sql.append(", FAccptDate= ? WHERE FID in ( ");
        sql.append(iqec.getSQL());
        sql.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setTimestamp(1, new Timestamp(Calendar.getInstance().getTimeInMillis()));
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.SENDPAPER_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String _sendMail(Context ctx, String mdSolutionPeriodID, HashSet idSet) throws BOSException, EASBizException {
        int GROUP = 1000;
        int index = 0;
        HashSet groupSet = null;
        groupSet = new HashSet(GROUP);
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            groupSet.add(iterator.next());
            if ((++index % GROUP != 0 || index <= 0) && (index % GROUP == 0 || index <= 0 || iterator.hasNext())) continue;
            this.sendMailToEvalpersonGroup(ctx, mdSolutionPeriodID, groupSet);
            groupSet = new HashSet(GROUP);
        }
        return null;
    }

    private void sendMailToEvalpersonGroup(Context ctx, String mdSolutionPeriodID, HashSet idSet) throws BOSException, EASBizException {
        String subject;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID), sic);
        String solutionPeriodName = solutionPeriodInfo.getName();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetSendMailToMDEvalPersonByEvaluatorQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        String evaluObjectName = null;
        Object[] variables = null;
        String from = null;
        String to = null;
        String content = subject = ResourceBase.getString((String)RES, (String)"emailWhenSendPaper", (Locale)ctx.getLocale());
        IMultiDimEvaluator ime = MultiDimEvaluatorFactory.getLocalInstance(ctx);
        try {
            while (rowSet.next()) {
                evaluObjectName = rowSet.getString("person.name");
                variables = new Object[]{evaluObjectName, solutionPeriodName};
                from = rowSet.getString("person.id");
                to = rowSet.getString("person1.email");
                if (to == null) continue;
                try {
                    ime.sendMail(from, to, MessageFormat.format(subject, variables), MessageFormat.format(content, variables));
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                }
                catch (EASBizException ex) {
                    logger.error((Object)ex);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }

    @Override
    protected boolean _solutionPeriodOptionalModeCanModify(Context ctx, String mdSolutionPeriodID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdSolutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        return MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    @Override
    protected void _solutionHasten(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        if (solutionPeriodId == null) {
            return;
        }
        this.sendMessage(ctx, solutionPeriodId);
    }

    @Override
    protected void _selectedHasten(Context ctx, Map param) throws BOSException, EASBizException {
        String mdEvaluatorId;
        Map relation;
        List relations = (List)param.get("relations");
        if (relations == null || relations.size() < 1) {
            return;
        }
        HashSet<String> mdEvaluatorIds = new HashSet<String>();
        for (int i = 0; i < relations.size(); ++i) {
            relation = (Map)relations.get(i);
            mdEvaluatorId = (String)relation.get("mdEvaluatorId");
            String multiDimObjectId = (String)relation.get("multiDimObjectId");
            String evaluRelationID = (String)relation.get("evaluRelationID");
            mdEvaluatorIds.add(mdEvaluatorId);
        }
        MultiDimEvaluatorCollection mdEvaluatorCollection = this.getMultiDimEvaluatorCollection(ctx, mdEvaluatorIds);
        Map positionMap = this.getPersonPositionBymdEvaluator(ctx, mdEvaluatorCollection);
        Iterator it = mdEvaluatorCollection.iterator();
        while (it.hasNext()) {
            MultiDimEvaluatorInfo mdEvaluatorInfo = (MultiDimEvaluatorInfo)it.next();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator", (Object)String.valueOf(mdEvaluatorInfo.getId())));
            filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)10));
            HashSet relationDetailIds = new HashSet();
            for (int i = 0; i < relations.size(); ++i) {
                relation = (Map)relations.get(i);
                mdEvaluatorId = (String)relation.get("mdEvaluatorId");
                if (!mdEvaluatorInfo.getId().toString().equals(relation.get("mdEvaluatorId"))) continue;
                relationDetailIds.add(relation.get("evaluRelationID"));
            }
            if (relationDetailIds.size() == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.evalRelation", relationDetailIds, CompareType.INCLUDE));
            EvalPersonCollection evalPersonCollection = this.getEvalPersonCollectionByFilterInfo(ctx, filter);
            if (PfServerUtils.collectionIsNullOrEmpty((IObjectCollection)evalPersonCollection)) continue;
            HashSet msgReceivers = this.getEvalPersonSet(evalPersonCollection);
            this.dealSendMessage(ctx, mdEvaluatorInfo, evalPersonCollection, positionMap, msgReceivers);
        }
    }

    private void dealSendMessage(Context ctx, MultiDimEvaluatorInfo mdEvaluatorInfo, EvalPersonCollection collection, Map positionMap, Set msgReceivers) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        HashMap pmMap = new HashMap();
        this.initMessageParameter(paramMap, mdEvaluatorInfo, collection);
        this.initMessageStringMap(ctx, pmMap, mdEvaluatorInfo, positionMap, msgReceivers);
        this.updateEvaluPersonAcceptTime(ctx, collection);
        Map.Entry mapEntry2 = null;
        String personId = null;
        Set paramSet = null;
        BOSUuid[] userIds = null;
        String param2 = null;
        Message message = null;
        MessageString messageString = null;
        Locale locale2 = null;
        Locale[] lcla = this.getContextLocales(ctx);
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        for (Map.Entry mapEntry2 : pmMap.entrySet()) {
            personId = mapEntry2.getKey().toString();
            messageString = (MessageString)mapEntry2.getValue();
            userIds = this.getUsersByPerson(ctx, personId);
            if (PfServerUtils.objectIsNull(userIds)) continue;
            message = MessageFactory.newMessage((String)"kingdee.workflow");
            for (Locale locale2 : lcla) {
                message.setLocaleStringHeader("title", messageString.getTitle(), locale2);
                message.setLocaleStringHeader("sender", messageString.getSender(), locale2);
                message.setLocaleStringHeader("body", messageString.getTitle(), locale2);
            }
            message.setIntHeader("type", 0);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            if (paramMap.containsKey(personId)) {
                message.setIntHeader("bizType", 70);
                paramSet = (Set)paramMap.get(personId);
                for (String param2 : paramSet) {
                    message.setStringHeader("sourceIDs", "hr_perf_mdEvalu::" + param2);
                    int n = userIds.length;
                    for (int i = 0; i < n; ++i) {
                        if (PfServerUtils.objectIsNull(userIds[i])) continue;
                        message.setStringHeader("receiver", userIds[i].toString());
                        senderAgent.sendMessage(message);
                    }
                }
                continue;
            }
            message.setIntHeader("bizType", 0);
            int n = userIds.length;
            for (int i = 0; i < n; ++i) {
                if (PfServerUtils.objectIsNull(userIds[i])) continue;
                message.setStringHeader("receiver", userIds[i].toString());
                senderAgent.sendMessage(message);
            }
        }
    }

    private void initMessageParameter(Map paramMap, MultiDimEvaluatorInfo mdEvaluatorInfo, EvalPersonCollection collection) {
        EvalPersonInfo evalPersonInfo = null;
        EvalRelationDetailInfo evalReDetailInfo = null;
        String personId = null;
        StringBuffer paramString = null;
        Set paramSet = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            evalPersonInfo = (EvalPersonInfo)it.next();
            evalReDetailInfo = evalPersonInfo.getEvalReDetail();
            if (evalPersonInfo.getPerson() == null || evalReDetailInfo == null) continue;
            personId = evalPersonInfo.getPerson().getId().toString();
            paramString = new StringBuffer();
            paramString.append(mdEvaluatorInfo.getId().toString());
            paramString.append("_");
            paramString.append(mdEvaluatorInfo.getSolutionPeriod().getId().toString());
            paramString.append("_");
            paramString.append(mdEvaluatorInfo.getMultiDimObject().getId().toString());
            paramString.append("_");
            paramString.append(evalReDetailInfo.getId().toString());
            paramString.append("_");
            paramString.append(evalReDetailInfo.getEvalRelation().getPaper().getId().toString());
            paramString.append("_");
            paramString.append(evalPersonInfo.getId().toString());
            paramSet = paramMap.containsKey(personId) ? (Set)paramMap.get(personId) : new HashSet();
            paramSet.add(paramString.toString());
            paramMap.put(personId, paramSet);
        }
    }

    private void updateEvaluPersonAcceptTime(Context ctx, EvalPersonCollection collection) throws BOSException, EASBizException {
        EvalPersonInfo evalPersonInfo = null;
        StringBuffer updateAcceptTimeSql = new StringBuffer();
        updateAcceptTimeSql.append("UPDATE  T_PF_EvalPerson Set FAccptDate = ? ");
        updateAcceptTimeSql.append(" WHERE FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            evalPersonInfo = (EvalPersonInfo)it.next();
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(updateAcceptTimeSql.toString());
                pstmt.setTimestamp(1, new Timestamp(Calendar.getInstance().getTimeInMillis()));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evalPersonInfo.getId().toString());
                pstmt.execute();
            }
            catch (SQLException e) {
                try {
                    throw new MDSolutionException(MDSolutionException.START_FAILD, e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("multiDimObject.id"));
        sic.add(new SelectorItemInfo("multiDimObject.person.name"));
        sic.add(new SelectorItemInfo("multiDimObject.position.name"));
        sic.add(new SelectorItemInfo("multiDimObject.evaluObjectType"));
        sic.add(new SelectorItemInfo("multiDimObject.evaluOrg.id"));
        sic.add(new SelectorItemInfo("multiDimObject.evaluOrg.name"));
        sic.add(new SelectorItemInfo("multiDimObject.responser.id"));
        sic.add(new SelectorItemInfo("multiDimObject.responser.name"));
        sic.add(new SelectorItemInfo("evalReDetails.evalPersons.person.id"));
        sic.add(new SelectorItemInfo("evalReDetails.evalPersons.paperState"));
        return sic;
    }

    private MultiDimEvaluatorCollection getMultiDimEvaluatorCollection(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)solutionPeriodID)) {
            return new MultiDimEvaluatorCollection();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80)));
        MultiDimEvaluatorCollection collection = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorCollection(viewInfo);
        return collection;
    }

    private MultiDimEvaluatorCollection getMultiDimEvaluatorCollection(Context ctx, Set mdEvaluatorIds) throws BOSException, EASBizException {
        if (mdEvaluatorIds == null || mdEvaluatorIds.isEmpty()) {
            return new MultiDimEvaluatorCollection();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (mdEvaluatorIds.size() == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)String.valueOf(mdEvaluatorIds.toArray()[0])));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdEvaluatorIds, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80)));
        MultiDimEvaluatorCollection collection = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorCollection(viewInfo);
        return collection;
    }

    private Map getPersonPositionBymdEvaluator(Context ctx, MultiDimEvaluatorCollection collection) throws BOSException {
        HashMap<String, String> positionMap = new HashMap<String, String>();
        if (collection != null && collection.size() > 0) {
            HashSet<String> personIds = new HashSet<String>();
            MultiDimEvaluatorInfo mdEvaluatorInfo = null;
            MultiDimentionObjectInfo mdObjectInfo = null;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                mdEvaluatorInfo = (MultiDimEvaluatorInfo)it.next();
                mdObjectInfo = mdEvaluatorInfo.getMultiDimObject();
                if (EvaluObjectTypeEnum.PERSON.equals((Object)mdObjectInfo.getEvaluObjectType())) {
                    if (mdObjectInfo.getPerson().getId() == null) continue;
                    personIds.add(mdObjectInfo.getPerson().getId().toString());
                    continue;
                }
                if (!EvaluObjectTypeEnum.ORGUNIT.equals((Object)mdObjectInfo.getEvaluObjectType()) || mdObjectInfo.getResponser().getId() == null) continue;
                personIds.add(mdObjectInfo.getResponser().getId().toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            PersonPositionCollection personPositions = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
            if (personPositions != null && personPositions.size() > 0) {
                PersonPositionInfo personPositionInfo2 = null;
                for (PersonPositionInfo personPositionInfo2 : personPositions) {
                    if (personPositionInfo2 == null || personPositionInfo2.getPrimaryPosition() == null) continue;
                    positionMap.put(personPositionInfo2.getPerson().getId().toString(), personPositionInfo2.getPrimaryPosition().getName());
                }
            }
        }
        return positionMap;
    }

    private EvalPersonCollection getEvalPersonCollectionByFilterInfo(Context ctx, FilterInfo filter) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("paperState"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("evalReDetail.id"));
        sic.add(new SelectorItemInfo("evalReDetail.mdEvaluator.id"));
        sic.add(new SelectorItemInfo("evalReDetail.mdEvaluator.solutionPeriod.id"));
        sic.add(new SelectorItemInfo("evalReDetail.mdEvaluator.solutionPeriod.SPStatuEnum"));
        sic.add(new SelectorItemInfo("evalReDetail.mdEvaluator.multiDimObject.id"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.paper.id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        EvalPersonCollection evalPersonColl = EvalPersonFactory.getLocalInstance(ctx).getEvalPersonCollection(view);
        return evalPersonColl;
    }

    private void initMessageStringMap(Context ctx, Map pmMap, MultiDimEvaluatorInfo mdEvaluatorInfo, Map positionMap, Set msgReceivers) {
        String sender = ResourceBase.getString((String)RES, (String)"sender", (Locale)ctx.getLocale());
        String templateStr = ResourceBase.getString((String)RES, (String)"solutionHasten", (Locale)ctx.getLocale());
        String personName = null;
        String personId = null;
        if (EvaluObjectTypeEnum.PERSON.equals((Object)mdEvaluatorInfo.getMultiDimObject().getEvaluObjectType())) {
            personName = mdEvaluatorInfo.getMultiDimObject().getPerson().getName();
            personId = mdEvaluatorInfo.getMultiDimObject().getPerson().getId().toString();
        } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)mdEvaluatorInfo.getMultiDimObject().getEvaluObjectType())) {
            personName = mdEvaluatorInfo.getMultiDimObject().getResponser().getName();
            personId = mdEvaluatorInfo.getMultiDimObject().getResponser().getId().toString();
        }
        Object[] formatParams = new String[]{personName, String.valueOf(positionMap.get(personId)), mdEvaluatorInfo.getSolutionPeriod().getName()};
        String title = MessageFormat.format(templateStr, formatParams);
        MessageString messageString = new MessageString();
        messageString.setTitle(title);
        messageString.setSender(sender);
        Iterator it = msgReceivers.iterator();
        while (it.hasNext()) {
            personId = String.valueOf(it.next());
            if (pmMap.containsKey(personId)) continue;
            pmMap.put(personId, messageString);
        }
    }

    private BOSUuid[] getUsersByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        BOSUuid[] userIDs = null;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection users = iUser.getCollection("where person='" + personId + "'");
        if (users.size() > 0) {
            userIDs = new BOSUuid[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                userIDs[i] = users.get(i).getId();
            }
        }
        return userIDs;
    }

    private void dealLogInfo(Context ctx, EvalRelationDetailInfo detailInfo, String logItem) throws BOSException, EASBizException {
        String name = null;
        if (detailInfo.getMdEvaluator().getMultiDimObject().getPerson() != null) {
            PersonInfo person = detailInfo.getMdEvaluator().getMultiDimObject().getPerson();
            if (!StringUtils.isEmpty((String)person.getName())) {
                name = person.getName();
            }
        } else {
            AdminOrgUnitInfo org = detailInfo.getMdEvaluator().getMultiDimObject().getEvaluOrg();
            if (!StringUtils.isEmpty((String)org.getName())) {
                name = org.getName();
            }
        }
        StringBuffer retValue = new StringBuffer();
        if (name != null) {
            retValue.append(name);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MultiDimentionObjectFactory.getLocalInstance(ctx).getType(), null, (String)retValue.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void dealLogInfo(Context ctx, String mdSolutionPeriodID, String logItem) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        MultiDimentionSolutionPeriodInfo info = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID), sic);
        StringBuffer retValue = new StringBuffer();
        if (info.getName() != null) {
            retValue.append(info.getName());
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getType(), null, (String)retValue.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _reAppointTestPage1(Context ctx, String solutionPeriodID, String mdEvaluObjectID, Set personIds, String evalRelationDetailID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || personIds.size() < 1 || evalRelationDetailID == null) {
            return;
        }
        StringBuffer logMessage = this.getLog(ctx, solutionPeriodID, mdEvaluObjectID);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MDWfFacadeFactory.getLocalInstance(ctx).getType(), null, (String)logMessage.toString(), (String)"perf_mdProcTrail_reDefEvalPerson");
        this.checkReSendTestPageCondition(ctx, solutionPeriodID);
        EvalRelationDetailInfo detailInfo = this.getReAppointEvalRelationDetailByID(ctx, evalRelationDetailID);
        Iterator iterator = personIds.iterator();
        Iterator iterator1 = personIds.iterator();
        String personId = null;
        while (iterator.hasNext()) {
            personId = iterator.next().toString();
            if (!this.existSameEvaluator(detailInfo.getEvalPersons(), personId)) continue;
            throw new MDSolutionException(MDSolutionException.SAME_GROUP_NOT_DOUBLE_EFFECT_EVALUATOR);
        }
        while (iterator1.hasNext()) {
            personId = iterator1.next().toString();
            this.dealPersonIds(ctx, solutionPeriodID, mdEvaluObjectID, personId, detailInfo);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void dealPersonIds(Context ctx, String solutionPeriodID, String mdEvaluObjectID, String personId, EvalRelationDetailInfo detailInfo) throws EASBizException, BOSException {
        EvalPersonInfo evalPersonInfo = new EvalPersonInfo();
        evalPersonInfo.setId(BOSUuid.create((BOSObjectType)evalPersonInfo.getBOSType()));
        evalPersonInfo.setEvalReDetail(detailInfo);
        evalPersonInfo.setIsOrigin(false);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        evalPersonInfo.setPerson(personInfo);
        detailInfo.getEvalPersons().add(evalPersonInfo);
        String positionId = this.getPrimaryPositionByPersonId(ctx, personId);
        if (positionId != null) {
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)positionId));
            evalPersonInfo.setPosition(positionInfo);
        }
        evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSUBMIT);
        evalPersonInfo.setWfStatus(WFStatuEnum.ONUSED);
        try {
            this.insertEvalPerson(ctx, evalPersonInfo);
            detailInfo.setAvrScore(null);
            detailInfo.setSelected(this.countDetailSelectedPerson(detailInfo));
            this.modifyEvalRelationDetailScore(ctx, detailInfo);
            this.modifyEvaluResultBySolutionPeriodAndEvaluObject(ctx, solutionPeriodID, mdEvaluObjectID, null);
            this.updateEvaluatorStatusByID(ctx, detailInfo.getMdEvaluator().getId().toString(), false);
        }
        catch (Exception ex) {
            throw new MDSolutionException(MDSolutionException.REAPPOINT_FAIL);
        }
    }
}

