/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AuditStateEnum;
import com.kingdee.eas.hr.perf.EvalRelationDetailCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.IMultiDimEvaluator;
import com.kingdee.eas.hr.perf.MDEvaluGroupException;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.app.AbstractMultiDimEvaluatorFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MultiDimEvaluatorFacadeControllerBean
extends AbstractMultiDimEvaluatorFacadeControllerBean {
    private static final String TABLE_NAME = "T_PF_MDEvaluator";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.MultiDimEvaluatorFacadeControllerBean");

    @Override
    protected void _submitEvaluator(Context ctx, String mdEvaluatorID, String mdEvaluGroupID) throws BOSException, EASBizException {
        if (mdEvaluatorID == null || mdEvaluGroupID == null) {
            return;
        }
        MultiDimEvaluatorInfo dimEvaluatorInfo = this.getEvaluatorInfo(ctx, mdEvaluatorID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("SPStatuEnum"));
        MultiDimentionSolutionPeriodInfo mdSolutionPeriodInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(dimEvaluatorInfo.getSolutionPeriod().getId()), sic);
        if (!mdSolutionPeriodInfo.getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
            throw new MDEvaluGroupException(MDEvaluGroupException.SOLUTIONPERIODNOTON);
        }
        if (!dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.UNSUBMIT) && !dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.REBACK)) {
            throw new MDEvaluGroupException(MDEvaluGroupException.CANNOT_SUBMIT);
        }
        MDEvaluGroupInfo evaluGroupInfo = this.getEvaluGroupInfo(ctx, mdEvaluGroupID);
        int n = evaluGroupInfo.getRelation().size();
        for (int i = 0; i < n; ++i) {
            EvalRelationDetailInfo detailInfo = this.getRelationDetailByRelationID(dimEvaluatorInfo.getEvalReDetails(), evaluGroupInfo.getRelation().get(i).getId().toString());
            if (detailInfo == null) {
                throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_LOWER_LIMITED, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(i))});
            }
            if (detailInfo.getEvalPersons().size() < evaluGroupInfo.getRelation().get(i).getMinRestrict()) {
                throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_LOWER_LIMITED, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(i))});
            }
            if (detailInfo.getEvalPersons().size() <= evaluGroupInfo.getRelation().get(i).getPersonRestrict()) continue;
            throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_UPPER_LIMIT, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(i))});
        }
        this.updateMDEvaluatorState(ctx, dimEvaluatorInfo.getId().toString(), 50);
    }

    private String getRelationName(EvaluRelationInfo info) {
        StringBuffer sb = new StringBuffer();
        if (info.getMDEvaluTypeEnum().equals((Object)MDEvaluTypeEnum.APPOINT)) {
            sb.append(info.getName());
            sb.append("(");
            sb.append(MDEvaluTypeEnum.APPOINT.toString());
            sb.append(")");
        } else {
            sb.append(info.getMDEvaluTypeEnum().toString());
        }
        return sb.toString();
    }

    private void updateMDEvaluatorState(Context ctx, String mdEvaluatorID, int onused_value) throws BOSException, EASBizException {
        if (mdEvaluatorID == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE  T_PF_MDEvaluator Set FAuditState = ?  WHERE FID = ? ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, onused_value);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdEvaluatorID);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new MDEvaluGroupException(MDEvaluGroupException.UPDATE_STATE_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private EvalRelationDetailInfo getRelationDetailByRelationID(EvalRelationDetailCollection evalReDetails, String id) {
        if (evalReDetails == null || evalReDetails.size() == 0 || id == null) {
            return null;
        }
        int n = evalReDetails.size();
        for (int i = 0; i < n; ++i) {
            if (!evalReDetails.get(i).getEvalRelation().getId().toString().equals(id)) continue;
            return evalReDetails.get(i);
        }
        return null;
    }

    private MDEvaluGroupInfo getEvaluGroupInfo(Context ctx, String mdEvaluGroupID) throws BOSException, EASBizException {
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("relation.id"));
        itemCollection.add(new SelectorItemInfo("relation.name"));
        itemCollection.add(new SelectorItemInfo("relation.personRestrict"));
        itemCollection.add(new SelectorItemInfo("relation.minRestrict"));
        itemCollection.add(new SelectorItemInfo("relation.weight"));
        itemCollection.add(new SelectorItemInfo("relation.MDEvaluTypeEnum"));
        return MDEvaluGroupFactory.getLocalInstance(ctx).getMDEvaluGroupInfo((IObjectPK)new ObjectUuidPK(mdEvaluGroupID), itemCollection);
    }

    private MultiDimEvaluatorInfo getEvaluatorInfo(Context ctx, String mdEvaluatorID) throws BOSException, EASBizException {
        return MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(mdEvaluatorID));
    }

    @Override
    protected void _auditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(1, idList, ctx);
    }

    @Override
    protected void _antiAuditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(2, idList, ctx);
    }

    @Override
    protected void _backTrack(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(3, idList, ctx);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeAuditAction(int actionType, String[] idList, Context ctx) throws BOSException, EASBizException {
        if (idList == null) return;
        if (idList.length <= 0) {
            return;
        }
        sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append("T_PF_MDEvaluator");
        sb.append(" SET FAuditState = ?");
        sb.append(" WHERE FID IN ( ");
        for (i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(" )");
        conn = null;
        pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            switch (actionType) {
                case 1: {
                    pstmt.setInt(1, AuditStateEnum.AUDITED.getValue());
                    ** break;
                }
                case 2: {
                    pstmt.setInt(1, AuditStateEnum.UNAUDITED.getValue());
                    ** break;
                }
                case 3: {
                    pstmt.setInt(1, AuditStateEnum.REBACK.getValue());
                    ** break;
                }
            }
        }
        catch (SQLException ex) {
            try {
                MultiDimEvaluatorFacadeControllerBean.logger.error((Object)ex);
                throw new EvaluResultException(MDEvaluGroupException.DATABASE_EXCEPPTION);
            }
            catch (Throwable var12_14) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw var12_14;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return;
lbl-1000:
        // 3 sources

        {
            pstmt.execute();
            iMultiDimEvaluator = MultiDimEvaluatorFactory.getLocalInstance(ctx);
            logMessage = null;
            logItem = null;
            logPK = null;
            logItem = actionType == 1 ? "perf_defEvalPersonTrail_audit" : (actionType == 2 ? "perf_defEvalPersonTrail_antiAudit " : "perf_defEvalPersonTrail_ReBack ");
            for (i = 0; i < idList.length; ++i) {
                logMessage = this.getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(idList[i]), iMultiDimEvaluator);
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)MultiDimEvaluatorFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)logItem);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _submitEvaluator(Context ctx, ArrayList mdEvaluatorIDs, String mdGroupID) throws BOSException, EASBizException {
        if (mdEvaluatorIDs != null && mdEvaluatorIDs.size() == 1) {
            String mdEvaluatorID = mdEvaluatorIDs.get(0).toString();
            this._submitEvaluator(ctx, mdEvaluatorID, mdGroupID);
        } else {
            int n = mdEvaluatorIDs.size();
            for (int i = 0; i < n; ++i) {
                String mdEvaluatorID = mdEvaluatorIDs.get(i).toString();
                MultiDimEvaluatorInfo dimEvaluatorInfo = this.getEvaluatorInfo(ctx, mdEvaluatorID);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("SPStatuEnum"));
                MultiDimentionSolutionPeriodInfo mdSolutionPeriodInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(dimEvaluatorInfo.getSolutionPeriod().getId()), sic);
                if (!mdSolutionPeriodInfo.getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
                    throw new MDEvaluGroupException(MDEvaluGroupException.SOLUTIONPERIODNOTON);
                }
                if (!dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.UNSUBMIT) && !dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.REBACK)) {
                    throw new MDEvaluGroupException(MDEvaluGroupException.CANNOT_SUBMIT);
                }
                MDEvaluGroupInfo evaluGroupInfo = this.getEvaluGroupInfo(ctx, mdGroupID);
                int m = evaluGroupInfo.getRelation().size();
                for (int j = 0; j < m; ++j) {
                    if (!MDEvaluTypeEnum.APPOINT.equals((Object)evaluGroupInfo.getRelation().get(j).getMDEvaluTypeEnum())) continue;
                    EvalRelationDetailInfo detailInfo = this.getRelationDetailByRelationID(dimEvaluatorInfo.getEvalReDetails(), evaluGroupInfo.getRelation().get(j).getId().toString());
                    if (detailInfo == null) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_LOWER_LIMITED, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(j))});
                    }
                    if (detailInfo.getEvalPersons().size() < evaluGroupInfo.getRelation().get(j).getMinRestrict()) {
                        throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_LOWER_LIMITED, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(j))});
                    }
                    if (detailInfo.getEvalPersons().size() <= evaluGroupInfo.getRelation().get(j).getPersonRestrict()) continue;
                    throw new MDEvaluGroupException(MDEvaluGroupException.PERSON_UPPER_LIMIT, new Object[]{this.getRelationName(evaluGroupInfo.getRelation().get(j))});
                }
                this.updateMDEvaluatorState(ctx, dimEvaluatorInfo.getId().toString(), 50);
            }
        }
    }

    private String getLogInfo(Context ctx, IObjectPK pk, IMultiDimEvaluator iMultiDimEvaluator) throws BOSException, EASBizException {
        StringBuffer retValue = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("multiDimObject.person.name"));
        sic.add(new SelectorItemInfo("multiDimObject.evaluOrg.dispalyName"));
        sic.add(new SelectorItemInfo("multiDimObject.evaluObjectType"));
        MultiDimEvaluatorInfo info = iMultiDimEvaluator.getMultiDimEvaluatorInfo(pk, sic);
        retValue.append(info.getSolutionPeriod().getName());
        retValue.append("--");
        if (info.getMultiDimObject() != null && info.getMultiDimObject().getEvaluObjectType() != null) {
            if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)info.getMultiDimObject().getEvaluObjectType())) {
                retValue.append(info.getMultiDimObject().getEvaluOrg().getDisplayName());
            } else {
                retValue.append(info.getMultiDimObject().getPerson().getName());
            }
        }
        return retValue.toString();
    }
}

