/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MDSolutionException;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.app.AbstractMultiDimentionObjectControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiDimentionObjectControllerBean
extends AbstractMultiDimentionObjectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.MultiDimentionObjectControllerBean");

    @Override
    protected void _addEvaluObjectBatch(Context ctx, String mdSolutionId, HashSet personSet) throws BOSException, EASBizException {
        if (mdSolutionId == null || personSet == null || personSet.size() == 0) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)mdSolutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        MultiDimentionObjectCollection objectCollection = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
        if (objectCollection != null && objectCollection.size() > 0) {
            int n = objectCollection.size();
            for (int i = 0; i < n; ++i) {
                if (!personSet.contains(objectCollection.get(i).getPerson().getId().toString())) continue;
                personSet.remove(objectCollection.get(i).getPerson().getId().toString());
            }
        }
        if (personSet.size() == 0) {
            return;
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPositionAndAdminQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        MultiDimentionObjectCollection collection = new MultiDimentionObjectCollection();
        HashSet<String> personSet2 = new HashSet<String>();
        if (rowSet.size() != 0) {
            try {
                while (rowSet.next()) {
                    if (personSet2.contains(rowSet.getString("id"))) continue;
                    personSet2.add(rowSet.getString("id"));
                    MultiDimentionObjectInfo objectInfo = new MultiDimentionObjectInfo();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    objectInfo.setPerson(personInfo);
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rowSet.getString("position2.id")));
                    objectInfo.setPosition(positionInfo);
                    objectInfo.setDescription(rowSet.getString("orgUnit.displayName"));
                    objectInfo.setEvaluObjectType(EvaluObjectTypeEnum.PERSON);
                    collection.add(objectInfo);
                }
            }
            catch (Exception e) {
                throw new MDSolutionException(MDSolutionException.ADD_MDOBEJECT_FAILD, e);
            }
        }
        this.batchInsertMDObjects(ctx, mdSolutionId, collection);
    }

    @Override
    protected Map _addEvaluObjectPersonBatch(Context ctx, String mdSolutionId, HashSet personSet) throws BOSException, EASBizException {
        if (mdSolutionId == null || personSet == null || personSet.size() == 0) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)mdSolutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        MultiDimentionObjectCollection objectCollection = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
        if (objectCollection != null && objectCollection.size() > 0) {
            int n = objectCollection.size();
            for (int i = 0; i < n; ++i) {
                if (!personSet.contains(objectCollection.get(i).getPerson().getId().toString())) continue;
                personSet.remove(objectCollection.get(i).getPerson().getId().toString());
            }
        }
        if (personSet.size() == 0) {
            return null;
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPositionAndAdminQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        MultiDimentionObjectCollection collection = new MultiDimentionObjectCollection();
        HashSet<String> personSet2 = new HashSet<String>();
        if (rowSet.size() != 0) {
            try {
                while (rowSet.next()) {
                    if (personSet2.contains(rowSet.getString("id"))) continue;
                    personSet2.add(rowSet.getString("id"));
                    MultiDimentionObjectInfo objectInfo = new MultiDimentionObjectInfo();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    objectInfo.setPerson(personInfo);
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rowSet.getString("position2.id")));
                    objectInfo.setPosition(positionInfo);
                    objectInfo.setDescription(rowSet.getString("orgUnit.displayName"));
                    objectInfo.setEvaluObjectType(EvaluObjectTypeEnum.PERSON);
                    collection.add(objectInfo);
                }
            }
            catch (Exception e) {
                throw new MDSolutionException(MDSolutionException.ADD_MDOBEJECT_FAILD, e);
            }
        }
        return this.batchInsertMDObjects(ctx, mdSolutionId, collection);
    }

    private Map batchInsertMDObjects(Context ctx, String mdSolutionId, MultiDimentionObjectCollection collection) throws SQLDataException, MDSolutionException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap<BOSUuid, String> map = new HashMap<BOSUuid, String>();
        try {
            String sql = "INSERT INTO T_PF_MultiDimentionObject (FID, FControlUnitID, FDescription_L1, FDescription_L2, FDescription_L3, FMDSolutionID, FEvaluObjectType, FPersonID, FPositionID, FEvaluOrgID, FResponserID) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            MultiDimentionObjectInfo info = null;
            EvaluObjectTypeEnum objectType = null;
            String id = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                String description = info.getDescription();
                String sdescription = description != null ? STConverter.tc2sc((String)description) : null;
                String tdescription = description != null ? STConverter.sc2tc((String)description) : null;
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setId(BOSUuid.read((String)id));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setString(3, description);
                pstmt.setString(4, sdescription);
                pstmt.setString(5, tdescription);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)mdSolutionId);
                objectType = info.getEvaluObjectType();
                pstmt.setInt(7, objectType.getValue());
                if (EvaluObjectTypeEnum.PERSON.equals((Object)objectType)) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)info.getPerson().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)info.getPosition().getId().toString());
                    pstmt.setString(10, null);
                    pstmt.setString(11, null);
                    map.put(info.getPerson().getId(), id);
                } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)objectType)) {
                    pstmt.setString(8, null);
                    pstmt.setString(9, info.getPosition().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)info.getEvaluOrg().getId().toString());
                    if (info.getResponser() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)11, (String)info.getResponser().getId().toString());
                    } else {
                        pstmt.setString(11, null);
                    }
                    map.put(info.getEvaluOrg().getId(), id);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new MDSolutionException(MDSolutionException.ADD_MDOBEJECT_FAILD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private HashMap getOrgNumberName(Context ctx, HashSet longNumberSet) throws BOSException, EASBizException {
        HashSet<String> numberSet = new HashSet<String>();
        Iterator iterator = longNumberSet.iterator();
        while (iterator.hasNext()) {
            String longNumber = iterator.next().toString();
            while (longNumber.indexOf("!") != -1) {
                numberSet.add(longNumber);
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
            numberSet.add(longNumber);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", numberSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("longNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("longNumber"));
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
        HashMap<String, String> longnumberNameMap = new HashMap<String, String>();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                longnumberNameMap.put(coll.get(i).getLongNumber(), coll.get(i).getName());
            }
        }
        return longnumberNameMap;
    }

    protected String _getLongNameByLongNumber(HashMap longNumberNameMap, String longNumber) {
        StringBuffer sb = new StringBuffer();
        String oldLongNumber = longNumber;
        sb.append(longNumberNameMap.get(longNumber));
        while (longNumber.indexOf("!") != -1) {
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            sb.insert(0, "/");
            sb.insert(0, longNumberNameMap.get(longNumber).toString());
        }
        return sb.toString();
    }

    @Override
    protected IObjectPK[] _deleteEvaluObjectBatch(Context ctx, HashSet evaluObjectSet) throws BOSException, EASBizException {
        ArrayList<String> canNotDelIdList;
        HashSet<String> delIDSet;
        block10: {
            delIDSet = new HashSet<String>();
            canNotDelIdList = new ArrayList<String>();
            HashSet referedIDSet = MultiDimentionSolutionFacadeFactory.getLocalInstance(ctx).getReferedEvaluObjectIDSet(evaluObjectSet, SolutionPeriodStatusEnum.ON_EVALU);
            HashSet endIDSet = MultiDimentionSolutionFacadeFactory.getLocalInstance(ctx).getReferedEvaluObjectIDSet(evaluObjectSet, SolutionPeriodStatusEnum.END_EVALU);
            endIDSet.removeAll(referedIDSet);
            Iterator it = evaluObjectSet.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                if (referedIDSet.contains(id)) {
                    canNotDelIdList.add(id);
                    continue;
                }
                if (endIDSet.contains(id)) continue;
                delIDSet.add(id);
            }
            FilterInfo fi = new FilterInfo();
            if (delIDSet.size() > 0) {
                fi.getFilterItems().add(new FilterItemInfo("multiDimObject.id", delIDSet, CompareType.INCLUDE));
                MultiDimEvaluatorFactory.getLocalInstance(ctx).delete(fi);
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("mdObject.id", delIDSet, CompareType.INCLUDE));
                MDGroupObjectFactory.getLocalInstance(ctx).delete(fi);
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", delIDSet, CompareType.INCLUDE));
                MultiDimentionObjectFactory.getLocalInstance(ctx).delete(fi);
            }
            if (endIDSet.size() <= 0) break block10;
            String sql = "UPDATE T_PF_MultiDimentionObject SET FDELETED = 1 WHERE FID = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                Iterator iter = endIDSet.iterator();
                while (iter.hasNext()) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)iter.next().toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)endIDSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.SPStatuEnum", (Object)new Integer(100)));
            MultiDimEvaluatorFactory.getLocalInstance(ctx).delete(fi);
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)endIDSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum", (Object)new Integer(100)));
            MDGroupObjectFactory.getLocalInstance(ctx).delete(fi);
        }
        ObjectUuidPK[] pk = new ObjectUuidPK[canNotDelIdList.size()];
        int size = canNotDelIdList.size();
        for (int i = 0; i < size; ++i) {
            pk[i] = new ObjectUuidPK((String)canNotDelIdList.get(i));
        }
        if (delIDSet.size() == 0) {
            return pk;
        }
        return pk;
    }

    @Override
    protected HashMap _getLongNameByLongNumber(Context ctx, HashSet longNumerSet) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (longNumerSet == null || longNumerSet.size() == 0) {
            return resultMap;
        }
        HashMap orgNumberNameMap = this.getOrgNumberName(ctx, longNumerSet);
        Iterator iterator = longNumerSet.iterator();
        while (iterator.hasNext()) {
            String longNumber = iterator.next().toString();
            resultMap.put(longNumber, this._getLongNameByLongNumber(orgNumberNameMap, longNumber));
        }
        return resultMap;
    }

    @Override
    protected Set _addEvaluObjectOrgBatch(Context ctx, String solutionId, Set orgUnitIds) throws BOSException, EASBizException {
        if (solutionId == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnitIds;
        }
        this.removeExistOrgUnitId(ctx, solutionId, orgUnitIds);
        if (orgUnitIds.isEmpty()) {
            return orgUnitIds;
        }
        Map managers = this._getOrgUnitManager(ctx, orgUnitIds);
        MultiDimentionObjectCollection collection = this.assembleObjectCollection(orgUnitIds, managers);
        this.batchInsertMDObjects(ctx, solutionId, collection);
        Iterator it = managers.keySet().iterator();
        while (it.hasNext()) {
            orgUnitIds.remove(it.next());
        }
        return orgUnitIds;
    }

    @Override
    protected Map _addEvaluObjectOrgBatch2(Context ctx, String solutionId, Set orgUnitIds) throws BOSException, EASBizException {
        if (solutionId == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return new HashMap();
        }
        this.removeExistOrgUnitId(ctx, solutionId, orgUnitIds);
        if (orgUnitIds.isEmpty()) {
            return new HashMap();
        }
        Map managers = this._getOrgUnitManager(ctx, orgUnitIds);
        MultiDimentionObjectCollection collection = this.assembleObjectCollection(orgUnitIds, managers);
        return this.batchInsertMDObjects(ctx, solutionId, collection);
    }

    private void removeExistOrgUnitId(Context ctx, String solutionId, Set orgUnitIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)solutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluOrg.id", (Object)orgUnitIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluOrg.id"));
        MultiDimentionObjectCollection objectCollection = MultiDimentionObjectFactory.getLocalInstance(ctx).getMultiDimentionObjectCollection(viewInfo);
        if (objectCollection != null && objectCollection.size() > 0) {
            String orgUnitId = null;
            int n = objectCollection.size();
            for (int i = 0; i < n; ++i) {
                orgUnitId = objectCollection.get(i).getEvaluOrg().getId().toString();
                if (!orgUnitIds.contains(orgUnitId)) continue;
                orgUnitIds.remove(orgUnitId);
            }
        }
    }

    @Override
    protected Map _getOrgUnitManager(Context ctx, Set orgUnitIds) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "OrgUnitManagerQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        HashMap<String, PersonInfo> managers = new HashMap<String, PersonInfo>();
        PersonInfo personInfo = null;
        try {
            while (rowSet.next()) {
                if (managers.keySet().contains(rowSet.getString("id")) || rowSet.getString("responser.id") == null) continue;
                personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)rowSet.getString("responser.id")));
                personInfo.put("responPosition", (Object)rowSet.getString("responsePosition.id"));
                managers.put(rowSet.getString("id"), personInfo);
            }
        }
        catch (Exception e) {
            throw new MDSolutionException(MDSolutionException.ADD_MDOBEJECT_FAILD, e);
        }
        return managers;
    }

    private MultiDimentionObjectCollection assembleObjectCollection(Set orgUnitIds, Map managers) throws MDSolutionException {
        MultiDimentionObjectCollection collection = new MultiDimentionObjectCollection();
        MultiDimentionObjectInfo objectInfo = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        Iterator it = orgUnitIds.iterator();
        String orgUnitId = null;
        PersonInfo person = null;
        while (it.hasNext()) {
            orgUnitId = (String)it.next();
            if (managers.get(orgUnitId) == null) continue;
            objectInfo = new MultiDimentionObjectInfo();
            adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
            objectInfo.setEvaluOrg(adminOrgUnitInfo);
            person = (PersonInfo)managers.get(orgUnitId);
            objectInfo.setResponser(person);
            PositionInfo position = new PositionInfo();
            position.setId(BOSUuid.read((String)((String)person.get("responPosition"))));
            objectInfo.setPosition(position);
            objectInfo.setEvaluObjectType(EvaluObjectTypeEnum.ORGUNIT);
            collection.add(objectInfo);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void _setResponser(Context ctx, String mdObjectId, IObjectValue responser) throws BOSException, EASBizException {
        if (mdObjectId == null || responser == null) {
            return;
        }
        String sql = "update T_PF_MultiDimentionObject set FResponserID = ? where FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)((PersonInfo)responser).getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdObjectId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            SQLUtils.cleanup(pstmt, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

