/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.IMultiDimentionSolutionPeriod;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.app.AbstractMultiDimentionSolutionControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MultiDimentionSolutionControllerBean
extends AbstractMultiDimentionSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.MultiDimentionSolutionControllerBean");

    @Override
    protected void _closeEvaluSolution(Context ctx, IObjectPK evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, BOSUuid.read((String)evaluSolutionId.toString()), 102);
    }

    @Override
    protected void _startEvaluSolution(Context ctx, BOSUuid evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, evaluSolutionId, 101);
    }

    private void setEvaluSolutionStatus(Context ctx, BOSUuid evaluSolutionId, int status) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_MultiDimentionSolution SET FSolutionStatuEn = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, status);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluSolutionId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        MultiDimentionSolutionInfo info = (MultiDimentionSolutionInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        if (info != null && info.getSolutionType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)String.valueOf(info.getSolutionType().getValue())));
        }
        return filter;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        IObjectPK pk = super._submit(ctx, model);
        FilterInfo filterInfo = new FilterInfo();
        MultiDimentionSolutionInfo solution = (MultiDimentionSolutionInfo)model;
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.SolutionStatuEn", (Object)new Integer(102), CompareType.NOTEQUALS));
        if (MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            solution.setSolutionStatuEn(SolutionStatusEnum.ONUSED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("SolutionStatuEn"));
            MultiDimentionSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        }
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MultiDimentionSolutionInfo info = (MultiDimentionSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        if (info.getSolutionType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionType", (Object)String.valueOf(info.getSolutionType().getValue())));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _unStartEvaluSolution(Context ctx, BOSUuid evaluSolutionId) throws BOSException, EASBizException {
        this.setEvaluSolutionStatus(ctx, evaluSolutionId, 100);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        MultiDimentionSolutionInfo evaluSolutionInfo = (MultiDimentionSolutionInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)pk.toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.startDate"));
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.endDate"));
        IMultiDimentionSolutionPeriod solutionPeriod = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx);
        MultiDimentionSolutionPeriodCollection coll = solutionPeriod.getMultiDimentionSolutionPeriodCollection(evi);
        MultiDimentionSolutionPeriodInfo info = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE  T_PF_MDSolutionPeriod SET FNAME_L1 = ? , FNAME_L2 = ? ,FNAME_L3 = ?  WHERE FID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                AssessPeriodInfo assessPeriod = info.getAssessPeriod();
                StringBuffer sb = new StringBuffer();
                if (assessPeriod == null) continue;
                sb.append(evaluSolutionInfo.getName());
                sb.append(" ");
                sb.append(assessPeriod.getStartDate());
                sb.append("----");
                sb.append(assessPeriod.getEndDate());
                String sname = STConverter.tc2sc((String)sb.toString());
                String tname = STConverter.sc2tc((String)sb.toString());
                pstmt.setString(1, sb.toString());
                pstmt.setString(2, sname);
                pstmt.setString(3, tname);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getId().toString());
                pstmt.addBatch();
            }
            if (coll.size() > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        DataBaseInfo dataBase = this.getDataBaseInfo(ctx, pk);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        if (iCodingRuleManager.isExist((IObjectValue)dataBase, companyID, "solutionType") && iCodingRuleManager.isUseIntermitNumber((IObjectValue)dataBase, companyID, "solutionType")) {
            iCodingRuleManager.recycleNumber((IObjectValue)dataBase, companyID, "solutionType", "", dataBase.getNumber());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _isSelfMode(Context ctx, String mdSolutionID) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)mdSolutionID));
        fi.getFilterItems().add(new FilterItemInfo("MultiDimntModeE", (Object)new Integer(102)));
        return MultiDimentionSolutionFactory.getLocalInstance(ctx).exists(fi);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MultiDimentionSolutionInfo info = (MultiDimentionSolutionInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"HRO")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID, "solutionType") && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID, "solutionType", ""));
        }
        super._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }
}

