/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.FetchTypeEnum;
import com.kingdee.eas.hr.perf.NDSolutionTableFactory;
import com.kingdee.eas.hr.perf.NDSolutionTableInfo;
import com.kingdee.eas.hr.perf.app.AbstractNDFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NDFacadeControllerBean
extends AbstractNDFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.NDFacadeControllerBean");

    @Override
    protected void _calculate(Context ctx, Collection resultIds, FetchTypeEnum fetchType, List realRule) throws BOSException, EASBizException {
        if (resultIds == null || resultIds.isEmpty() || realRule == null || realRule.isEmpty()) {
            return;
        }
        NDSolutionTableInfo tableInfo = this.getTableInfoByResultId(ctx, resultIds);
        if (tableInfo == null) {
            return;
        }
        this.removeNullItem(realRule);
        if (realRule.isEmpty()) {
            return;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)this.getQuerySQL(resultIds, fetchType, tableInfo));
        Connection conn = null;
        PreparedStatement pstmt = null;
        String pkColumn = tableInfo.getPk();
        Iterator it = realRule.iterator();
        String[] item = (String[])it.next();
        String rankId = item[0];
        int count = Integer.parseInt(item[1]);
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(this.getUpdateSQL(tableInfo));
            rowSet.beforeFirst();
            while (rowSet.next()) {
                pstmt.setString(1, rankId);
                pstmt.setString(2, rowSet.getString(pkColumn));
                pstmt.addBatch();
                if (++index < count || !it.hasNext()) continue;
                item = (String[])it.next();
                rankId = item[0];
                count = Integer.parseInt(item[1]);
                index = 0;
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private NDSolutionTableInfo getTableInfoByResultId(Context ctx, Collection resultIds) throws EASBizException, BOSException {
        Object id = resultIds.iterator().next();
        if (id instanceof BOSUuid) {
            return NDSolutionTableFactory.getInstance().getTableInfo(ctx, (BOSUuid)id);
        }
        return null;
    }

    private String getQuerySQL(Collection resultIds, FetchTypeEnum fetchType, NDSolutionTableInfo tableInfo) {
        String prefix = "r.";
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(prefix + tableInfo.getPk());
        sql.append(" from ");
        sql.append(" (");
        sql.append(tableInfo.getQuerySQL());
        sql.append(") as r ");
        sql.append(" where r.FID in (");
        sql.append(this.assembleString(resultIds));
        sql.append(") order by ");
        if (FetchTypeEnum.EVALU_SCORE.equals((Object)fetchType)) {
            sql.append(this.handleField(prefix + tableInfo.getTargetScore()));
        } else if (FetchTypeEnum.MODIFY_SCORE.equals((Object)fetchType)) {
            sql.append(this.handleField(prefix + tableInfo.getModifiedScore()));
        } else {
            sql.append(" case when ");
            sql.append(prefix + tableInfo.getModifiedScore());
            sql.append(" is null then ");
            sql.append(this.handleField(prefix + tableInfo.getTargetScore()));
            sql.append(" else ");
            sql.append(this.handleField(prefix + tableInfo.getModifiedScore()));
            sql.append(" end ");
        }
        sql.append(" desc, ");
        sql.append(prefix + tableInfo.getObjectNumber());
        sql.append(" asc");
        return sql.toString();
    }

    private String assembleString(Collection resultIds) {
        StringBuffer sb = new StringBuffer();
        Iterator it = resultIds.iterator();
        Object id = null;
        while (it.hasNext()) {
            id = it.next();
            if (id == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(id.toString());
            sb.append("'");
        }
        return sb.toString();
    }

    private String handleField(String score) {
        StringBuffer sql = new StringBuffer();
        sql.append(" case when ");
        sql.append(score);
        sql.append(" is null then 0");
        sql.append(" else ");
        sql.append(score);
        sql.append(" end ");
        return sql.toString();
    }

    private String getUpdateSQL(NDSolutionTableInfo tableInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(tableInfo.getTableName());
        sql.append(" set ");
        sql.append(tableInfo.getRank());
        sql.append(" = ?");
        sql.append(" where ");
        sql.append(tableInfo.getPk());
        sql.append(" = ?");
        return sql.toString();
    }

    private void removeNullItem(List realRule) {
        Iterator it = realRule.iterator();
        String[] item = null;
        while (it.hasNext()) {
            item = (String[])it.next();
            if (item != null && item.length == 2 && Integer.parseInt(item[1]) > 0) continue;
            it.remove();
        }
    }

    @Override
    protected Map _getRankAmount(Context ctx, Collection resultIds) throws BOSException, EASBizException {
        if (resultIds == null || resultIds.isEmpty()) {
            return null;
        }
        NDSolutionTableInfo tableInfo = this.getTableInfoByResultId(ctx, resultIds);
        if (tableInfo == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(tableInfo.getRank());
        sql.append(", count(*) from ");
        sql.append(tableInfo.getTableName());
        sql.append(" where ");
        sql.append(tableInfo.getPk());
        sql.append(" in (");
        sql.append(this.assembleString(resultIds));
        sql.append(")");
        sql.append(" group by ");
        sql.append(tableInfo.getRank());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> counts = new HashMap<String, String>();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                counts.put(rowSet.getString(1), rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return counts;
    }

    @Override
    protected void _calculate(Context ctx, IObjectValue solutionPeriodInfo, IMetaDataPK queryPk, FilterInfo condition, FetchTypeEnum fetchType, List realRule) throws BOSException, EASBizException {
        this._calculate(ctx, this.getResultIds(ctx, queryPk, condition), fetchType, realRule);
    }

    @Override
    protected Map _getRankAmount(Context ctx, IMetaDataPK queryPk, FilterInfo condition) throws BOSException, EASBizException {
        return this._getRankAmount(ctx, this.getResultIds(ctx, queryPk, condition));
    }

    private Collection getResultIds(Context ctx, IMetaDataPK queryPk, FilterInfo condition) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPk);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(condition);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList<BOSUuid> resultIds = new ArrayList<BOSUuid>();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("id") == null) continue;
                resultIds.add(BOSUuid.read((String)rowSet.getString("id")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultIds;
    }

    @Override
    protected String _getNDRuleID(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        String sql = "select FParentID from T_PF_NDSolutionPeriod where FSolutionPeriodId = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionPeriodId});
        try {
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

