/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.AbstractEvaluResultInfo;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleHelper;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDeployEntryCollection;
import com.kingdee.eas.hr.perf.TargetDeployEntryFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetGradeModeEnum;
import com.kingdee.eas.hr.perf.TargetScoreComputeFacadeFactory;
import com.kingdee.eas.hr.perf.WfParam;
import com.kingdee.eas.hr.perf.app.AbstractNodeProcesserControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class NodeProcesserControllerBean
extends AbstractNodeProcesserControllerBean {
    private static final long serialVersionUID = -61166L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.NodeProcesserControllerBean");

    @Override
    protected void _countTotalTargetEvaluScore(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        int i;
        int n;
        EvaluResultInfo evaluResultInfo = null;
        HashMap<BOSUuid, DataBaseInfo> rankMap = new HashMap<BOSUuid, DataBaseInfo>();
        WfParam wfParam = new WfParam(ctx, BOSUuid.read((String)solutionPeriodID), BOSUuid.read((String)evaluObjectID));
        if (wfParam.isRankGroup()) {
            RankCollection rankCollection = wfParam.getTargetRankCollection();
            n = rankCollection.size();
            for (i = 0; i < n; ++i) {
                rankMap.put(rankCollection.get(i).getId(), rankCollection.get(i));
            }
        }
        TargetEvaluStoreCollection targetEvaluStoreCollection = wfParam.getTargetEvaluStoreCollection();
        n = targetEvaluStoreCollection.size();
        for (i = 0; i < n; ++i) {
            rankMap.put(targetEvaluStoreCollection.get(i).getId(), targetEvaluStoreCollection.get(i));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("evaluResult.id", (Object)wfParam.getEvaluResultInfo().getId());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("nodeScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNode.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNode.canGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluDetails.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluDetails.targetScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluDetails.targetEvaluStore.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluDetails.rank.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluDetails.weight"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.targetGradeModeLink.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.targetGradeModeLink.maxGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.targetGradeModeLink.minGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.gradeMode.maxGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.gradeMode.minGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.rankConvertRule.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluResult.solutionPeriod.evaluSolution.allocateTarget"));
        NodeProcesserCollection nodeProcesserCollection = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserCollection(viewInfo);
        BigDecimal totalValue = new BigDecimal("0.000000");
        BigDecimal percent = new BigDecimal("0.010000");
        BigDecimal min = wfParam.getTargetGradeModeLink().getMinGrade().setScale(6, 4);
        BigDecimal max = wfParam.getTargetGradeModeLink().getMaxGrade().setScale(6, 4);
        NodeProcesserInfo info = null;
        BigDecimal nodeScore = null;
        BigDecimal weight = null;
        boolean flag = false;
        int n2 = nodeProcesserCollection.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            info = nodeProcesserCollection.get(i2);
            if (!info.getEvaluNode().isCanGrade()) continue;
            EvaluNodeInfo nodeInfo = wfParam.getNode(info.getEvaluNode().getId().toString());
            weight = nodeInfo.getWeight().setScale(6, 4);
            nodeScore = info.getNodeScore();
            if (weight == null || nodeScore == null) {
                flag = false;
                break;
            }
            flag = true;
            totalValue = info.getEvaluResult().getSolutionPeriod().getEvaluSolution().getAllocateTarget() == 2 ? totalValue.add(nodeScore) : totalValue.add(nodeScore.multiply(weight).multiply(percent));
        }
        TargetGradeModeEnum gradeMode = this.getTargetGradeMode(ctx, wfParam.getEvaluResultInfo().getId().toString());
        if (flag) {
            GradeModeInfo gradeModeInfo = wfParam.getGradeMode();
            BigDecimal gradeMax = gradeModeInfo.getMaxGrade().setScale(6, 4);
            BigDecimal gradeMin = gradeModeInfo.getMinGrade().setScale(6, 4);
            totalValue = totalValue.multiply(gradeMax).divide(max);
            evaluResultInfo = wfParam.getEvaluResultInfo();
            SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID));
            EvaluSolutionInfo evaluSolution = solutionPeriodInfo.getEvaluSolution();
            try {
                if (TargetGradeModeEnum.RANK_GROUP.equals((Object)gradeMode)) {
                    evaluResultInfo.setTargetEvaluScore(null);
                    evaluResultInfo.setEvaluateSum(null);
                } else {
                    PrecisionMaintainInfo PMInfo = this.getPrecisionMaintainInfo(ctx, evaluSolution.getId().toString());
                    if (PMInfo != null) {
                        switch (PMInfo.getTotalPrecisionType().getValue()) {
                            case 10: {
                                evaluResultInfo.setTargetEvaluScore(totalValue.setScale(PMInfo.getTotalPrecision(), 4));
                                evaluResultInfo.setEvaluateSum(totalValue.setScale(PMInfo.getTotalPrecision(), 4));
                                break;
                            }
                            case 20: {
                                evaluResultInfo.setTargetEvaluScore(totalValue.setScale(PMInfo.getTotalPrecision(), 0));
                                evaluResultInfo.setEvaluateSum(totalValue.setScale(PMInfo.getTotalPrecision(), 0));
                                break;
                            }
                            case 30: {
                                evaluResultInfo.setTargetEvaluScore(totalValue.setScale(PMInfo.getTotalPrecision(), 1));
                                evaluResultInfo.setEvaluateSum(totalValue.setScale(PMInfo.getTotalPrecision(), 1));
                            }
                        }
                    } else {
                        evaluResultInfo.setTargetEvaluScore(totalValue);
                        evaluResultInfo.setEvaluateSum(totalValue);
                    }
                    RankInfo rank = this.getEvaluResultRankByTotalScore(ctx, evaluResultInfo.getSolutionPeriod().getEvaluSolution(), totalValue);
                    if (rank != null) {
                        evaluResultInfo.setPerfRank(rank);
                    }
                }
                EvaluResultFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(evaluResultInfo.getId()), (CoreBaseInfo)evaluResultInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        String sql = "UPDATE T_PF_EvalWFObjects SET FStatus = ? WHERE FEvalWorkFlowID = ? AND  FEvaluObjectID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 30);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)wfParam.getEvalWorkFlowID().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)evaluObjectID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private BigDecimal remodifyNodeScore(Context ctx, String evaluNodeId, BigDecimal nodeScore) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("evaluNode.id", (Object)evaluNodeId);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        TargetDeployEntryCollection entryColl = TargetDeployEntryFactory.getLocalInstance(ctx).getTargetDeployEntryCollection(viewInfo);
        HashSet<String> entrySet = new HashSet<String>();
        entrySet.add("");
        for (int i = 0; i < entryColl.size(); ++i) {
            entrySet.add(entryColl.get(i).getEvaluTarget().getId().toString());
        }
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("evaluTarget.id", entrySet, CompareType.INCLUDE);
        filter1.getFilterItems().add(filterItem1);
        viewInfo1.setFilter(filter1);
        viewInfo1.getSelector().add(new SelectorItemInfo("values"));
        viewInfo1.getSelector().add(new SelectorItemInfo("weight"));
        EvaluGroupTargetCollection gcoll = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(viewInfo1);
        BigDecimal weight = BigDecimal.ZERO;
        for (int j = 0; j < gcoll.size(); ++j) {
            weight = weight.add(gcoll.get(j).getWeight());
        }
        if (weight.equals(BigDecimal.ZERO)) {
            return nodeScore;
        }
        nodeScore.add(new BigDecimal("0.000000"));
        return nodeScore.multiply(new BigDecimal(100)).divide(weight, 6);
    }

    public PrecisionMaintainInfo getPrecisionMaintainInfo(Context ctx, String evaluSolutionID) throws Exception {
        PrecisionMaintainInfo info = null;
        if (evaluSolutionID != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PrecisionMaintainCollection col = PrecisionMaintainFactory.getLocalInstance(ctx).getPrecisionMaintainCollection(view);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        return info;
    }

    private BigDecimal countNodeProcesserSubTotal(Context ctx, WfParam wfParam, HashMap rankMap, NodeProcesserInfo nodeProcesserInfo) throws BOSException, EASBizException {
        BigDecimal value = new BigDecimal("0.0000000");
        BigDecimal percent = new BigDecimal("0.010000");
        BigDecimal min = wfParam.getTargetGradeModeLink().getMinGrade();
        EvaluNodeInfo nodeInfo = wfParam.getNode(nodeProcesserInfo.getEvaluNode().getId().toString());
        if (!nodeInfo.isCanGrade()) {
            return min;
        }
        BigDecimal itemScore = null;
        int n = nodeProcesserInfo.getEvaluDetails().size();
        for (int i = 0; i < n; ++i) {
            TargetEvaluStoreInfo targetEvaluStoreInfo;
            EvaluDetailInfo evaluDetailInfo = nodeProcesserInfo.getEvaluDetails().get(i);
            if (rankMap.containsKey(evaluDetailInfo.getTargetEvaluStore().getId())) {
                targetEvaluStoreInfo = (TargetEvaluStoreInfo)rankMap.get(evaluDetailInfo.getTargetEvaluStore().getId());
            } else {
                targetEvaluStoreInfo = wfParam.getTargetEvaluStoreInfoById(evaluDetailInfo.getTargetEvaluStore().getId());
                rankMap.put(targetEvaluStoreInfo.getId(), targetEvaluStoreInfo);
            }
            BigDecimal weight = targetEvaluStoreInfo.getWeight().setScale(6, 4);
            if (wfParam.isRankGroup()) {
                RankInfo rankInfo;
                if (rankMap.containsKey(evaluDetailInfo.getRank().getId())) {
                    rankInfo = (RankInfo)rankMap.get(evaluDetailInfo.getRank().getId());
                } else {
                    rankInfo = RankFactory.getLocalInstance(ctx).getRankInfo((IObjectPK)new ObjectUuidPK(evaluDetailInfo.getRank().getId()));
                    rankMap.put(rankInfo.getId(), rankInfo);
                }
                itemScore = rankInfo.getGrade().setScale(6, 4);
            } else {
                itemScore = evaluDetailInfo.getTargetScore().setScale(6, 4);
            }
            value = value.add(itemScore.multiply(weight).multiply(percent));
        }
        return value;
    }

    @Override
    protected void _updateEvaluResultRankInfo(Context ctx, String evaluResultID, String rankID) throws BOSException, EASBizException {
        if (evaluResultID == null || rankID == null) {
            return;
        }
        String sql = "UPDATE T_PF_EvaluResult SET FPerfRankID = ? WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)rankID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluResultID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _saveBatch(Context ctx, HashMap needSaveValue) throws BOSException, EASBizException {
        Iterator iterator = needSaveValue.keySet().iterator();
        while (iterator.hasNext()) {
            IObjectPK pk = this.save(ctx, (CoreBaseInfo)needSaveValue.get(iterator.next()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NodeProcesserInfo info = (NodeProcesserInfo)model;
        if (info.getRank() != null) {
            String sql = "UPDATE T_PF_EvaluResult SET FPerfRankID = ? WHERE FID = ?";
            Object[] params = new Object[]{info.getRank().getId().toString(), info.getEvaluResult().getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        ((NodeProcesserInfo)model).setProcessTime(new Date());
        IObjectPK pk = super._submit(ctx, model);
        if (pk != null) {
            String stateUpdateSql = " update T_PF_NodeProcesser set FWorkedState=? where fid=? ";
            Object[] params = new Object[]{new Integer(30), pk.toString()};
            DbUtil.execute((Context)ctx, (String)stateUpdateSql, (Object[])params);
        }
        if (info.getEvaluNode().getNodeLevel() == 1) {
            if (info.getEvaluResult() == null || info.getEvaluResult().getSolutionPeriod() == null) {
                return pk;
            }
            String spId = info.getEvaluResult().getSolutionPeriod().getId().toString();
            if (info.getEvaluResult() == null || info.getEvaluResult().getEvaluObject() == null) {
                return pk;
            }
            String objId = info.getEvaluResult().getEvaluObject().getId().toString();
            TargetScoreComputeFacadeFactory.getLocalInstance(ctx).updateAchieveDataState(spId, objId, true);
        }
        return pk;
    }

    @Override
    protected Map _getNodeProcesserInfoOfTheNode(Context ctx, String[] nodeSeqs, String evaluObjectID, String solutionPeriodID) throws BOSException, EASBizException {
        if (nodeSeqs == null || nodeSeqs.length == 0) {
            return null;
        }
        HashMap<String, NodeProcesserInfo> ret = new HashMap<String, NodeProcesserInfo>();
        FilterInfo filter = null;
        EntityViewInfo viewInfo = null;
        AbstractEvaluResultInfo evaluResult = null;
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluObject.objectID"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.evaluSolution.scoreToNextNode"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.evaluSolution.allocateTarget"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.evaluSolution.deliverMode"));
        IEvaluResult iEvaluResult = EvaluResultFactory.getLocalInstance(ctx);
        EvaluResultCollection coll = iEvaluResult.getEvaluResultCollection(viewInfo);
        if (coll != null && coll.size() > 1) {
            evaluResult = coll.get(0);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("evaluObject", (Object)evaluObjectID));
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodID));
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)evaluResult.getId().toString(), CompareType.NOTEQUALS));
            iEvaluResult.delete(fi);
        } else if (coll != null && coll.size() == 1) {
            evaluResult = coll.get(0);
        }
        int isAllocateTarget = evaluResult.getSolutionPeriod().getEvaluSolution().getAllocateTarget();
        boolean isScoreToNextNode = evaluResult.getSolutionPeriod().getEvaluSolution().isScoreToNextNode();
        DeliverModeEnum deliverMode = evaluResult.getSolutionPeriod().getEvaluSolution().getDeliverMode();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalWorkFlow.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalWorkFlow.wfLevels"));
        EvalWFObjectsCollection objColl = EvalWFObjectsFactory.getLocalInstance(ctx).getEvalWFObjectsCollection(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)objColl.get(0).getEvalWorkFlow().getId().toString()));
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < nodeSeqs.length; ++i) {
            set.add(new Integer(nodeSeqs[i]));
        }
        filter.getFilterItems().add(new FilterItemInfo("seqNumber", set, CompareType.INCLUDE));
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("nodes.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalWorkFlow.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evalWorkFlow.wfLevels"));
        EvaluNodeCollection nodeColl = EvaluNodeFactory.getLocalInstance(ctx).getEvaluNodeCollection(viewInfo);
        EvaluNodeInfo nodeInfo = null;
        NodeProcesserInfo info = null;
        int size = nodeColl.size();
        for (int index = 0; index < size; ++index) {
            nodeInfo = nodeColl.get(index);
            nodeInfo.setEvalWorkFlow(objColl.get(0).getEvalWorkFlow());
            info = new NodeProcesserInfo();
            info.setEvaluNode(nodeInfo);
            info.setEvaluResult((EvaluResultInfo)evaluResult);
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("weight"));
            sic.add(new SelectorItemInfo("formulaScore"));
            sic.add(new SelectorItemInfo("realValue"));
            sic.add(new SelectorItemInfo("uniteTarget"));
            sic.add(new SelectorItemInfo("values"));
            sic.add(new SelectorItemInfo("formulaRank.id"));
            sic.add(new SelectorItemInfo("formulaRank.name"));
            sic.add(new SelectorItemInfo("formulaRank.grade"));
            sic.add(new SelectorItemInfo("evaluTarget.*"));
            sic.add(new SelectorItemInfo("evaluTarget.formula.id"));
            sic.add(new SelectorItemInfo("evaluTarget.formula.name"));
            sic.add(new SelectorItemInfo("evaluTarget.formula.achieveItem.dataPrecision"));
            sic.add(new SelectorItemInfo("evaluTarget.formula.achieveItem.dataType"));
            sic.add(new SelectorItemInfo("evaluTarget.type.id"));
            sic.add(new SelectorItemInfo("evaluTarget.type.name"));
            sic.add(new SelectorItemInfo("evaluTarget.secondType.name"));
            sic.add(new SelectorItemInfo("evaluTarget.type.number"));
            sic.add(new SelectorItemInfo("creator.person.id"));
            sic.add(new SelectorItemInfo("creator.person.name"));
            sic.add(new SelectorItemInfo("multiTable.*"));
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("seqNumber"));
            sorter.add(new SorterItemInfo("evaluTarget.type.number"));
            sorter.add(new SorterItemInfo("evaluTarget.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("thresholdValue"));
            viewInfo.getSelector().add(new SelectorItemInfo("standardValue"));
            viewInfo.getSelector().add(new SelectorItemInfo("challengeValue"));
            viewInfo.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.evaluGroupTargetType.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.evaluGroupTargetType.performTargetType.*"));
            TargetEvaluStoreCollection targetStoreColl = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(viewInfo);
            HashSet<String> pIds = new HashSet<String>();
            HashMap<String, String> primaryPosition = new HashMap<String, String>();
            int j = targetStoreColl.size();
            for (int i = 0; i < j; ++i) {
                TargetEvaluStoreInfo tsInfo = targetStoreColl.get(i);
                if (tsInfo.getCreator() == null || tsInfo.getCreator().getPerson() == null) continue;
                pIds.add(tsInfo.getCreator().getPerson().getId().toString());
            }
            if (pIds.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("person.id", pIds, CompareType.INCLUDE));
                fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
                evi.setFilter(fi);
                evi.getSelector().add(new SelectorItemInfo("position.name"));
                evi.getSelector().add(new SelectorItemInfo("person.id"));
                PositionMemberCollection pmColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
                int n = pmColl.size();
                for (int m = 0; m < n; ++m) {
                    PositionMemberInfo pmInfo = pmColl.get(m);
                    primaryPosition.put(pmInfo.getPerson().getId().toString(), pmInfo.getPosition().getName());
                }
            }
            if (isAllocateTarget == 0) {
                this.generateEvaluDetailsForUnAllocateMode(info, targetStoreColl, primaryPosition, isScoreToNextNode);
            } else {
                this.generateEvaluDetailsForAllocateTarget(ctx, info, targetStoreColl, primaryPosition, isScoreToNextNode);
            }
            info.setProcesserName(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName());
            info.setEvaluer(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            ret.put("" + nodeInfo.getSeqNumber(), info);
        }
        return ret;
    }

    private void generateEvaluDetailsForAllocateTarget(Context ctx, NodeProcesserInfo info, TargetEvaluStoreCollection targetStoreColl, Map primaryPosition, boolean isScoreToNextNode) throws BOSException, EASBizException {
        FilterInfo filter1 = new FilterInfo();
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        viewInfo1.setFilter(filter1);
        SelectorItemCollection sic1 = viewInfo1.getSelector();
        filter1.getFilterItems().add(new FilterItemInfo("evaluNode.id", (Object)info.getEvaluNode().getId().toString()));
        sic1.add(new SelectorItemInfo("evaluTarget.id"));
        sic1.add(new SelectorItemInfo("evaluNode.id"));
        TargetDeployEntryCollection collEntry = TargetDeployEntryFactory.getLocalInstance(ctx).getTargetDeployEntryCollection(viewInfo1);
        HashSet<String> storeIdSet = new HashSet<String>();
        for (int i = 0; i < collEntry.size(); ++i) {
            storeIdSet.add(collEntry.get(i).getEvaluTarget().getId().toString());
        }
        TargetEvaluStoreCollection retColl = new TargetEvaluStoreCollection();
        for (int j = 0; j < targetStoreColl.size(); ++j) {
            if (!storeIdSet.contains(targetStoreColl.get(j).getEvaluTarget().getId().toString())) continue;
            retColl.add(targetStoreColl.get(j));
        }
        this.generateEvaluDetailsForUnAllocateMode(info, retColl, primaryPosition, isScoreToNextNode);
    }

    private void generateEvaluDetailsForUnAllocateMode(NodeProcesserInfo info, TargetEvaluStoreCollection targetStoreColl, Map primaryPosition, boolean isScoreToNextNode) {
        int n = targetStoreColl.size();
        for (int i = 0; i < n; ++i) {
            TargetEvaluStoreInfo tsInfo = targetStoreColl.get(i);
            EvaluDetailInfo detailInfo = new EvaluDetailInfo();
            detailInfo.setNodeProcesser(info);
            detailInfo.setTargetEvaluStore(tsInfo);
            detailInfo.setSeq(info.getEvaluDetails().size());
            detailInfo.setWeight(tsInfo.getWeight());
            detailInfo.setCompValue(tsInfo.getRealValue());
            if (!isScoreToNextNode) {
                detailInfo.setTargetScore(tsInfo.getFormulaScore());
            }
            detailInfo.setRank(tsInfo.getFormulaRank());
            info.getEvaluDetails().add(detailInfo);
            if (tsInfo.getCreator() == null || tsInfo.getCreator().getPerson() == null) continue;
            String personId = tsInfo.getCreator().getPerson().getId().toString();
            tsInfo.put("creatorPosition", primaryPosition.get(personId));
        }
    }

    private void generateEvaluDetailsForAllocateTarget(Context ctx, String evaluObjectID, NodeProcesserInfo info, TargetEvaluStoreCollection targetStoreColl, Map primaryPosition, DeliverModeEnum deliverMode) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("evaluNode.id", (Object)info.getEvaluNode().getId().toString()));
        StringBuffer sql = new StringBuffer("select FEvaluGroupID from t_pf_evalugroupobject WHERE FEvaluObjectID");
        sql.append("='");
        sql.append(evaluObjectID);
        sql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("parent.evaluGroup.id", (Object)sql.toString(), CompareType.INNER));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluTarget.id"));
        sic.add(new SelectorItemInfo("evaluTarget.seqNumber"));
        sic.add(new SelectorItemInfo("evaluTarget.number"));
        sic.add(new SelectorItemInfo("evaluTarget.type.number"));
        viewInfo.getSorter().add(new SorterItemInfo("evaluTarget.seqNumber"));
        viewInfo.getSorter().add(new SorterItemInfo("evaluTarget.type.number"));
        viewInfo.getSorter().add(new SorterItemInfo("evaluTarget.number"));
        TargetDeployEntryCollection targetDepEntryColl = TargetDeployEntryFactory.getLocalInstance(ctx).getTargetDeployEntryCollection(viewInfo);
        HashMap<String, BigDecimal> allocateMap = new HashMap<String, BigDecimal>();
        String targetID = "";
        int n = targetDepEntryColl.size();
        for (int i = 0; i < n; ++i) {
            if (DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode)) {
                targetID = targetDepEntryColl.get(i).getEvaluTargetType().getId().toString();
            } else {
                targetDepEntryColl.get(i).getEvaluTarget().getId().toString();
            }
            allocateMap.put(targetID, targetDepEntryColl.get(i).getWeight());
        }
        BigDecimal weight = null;
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        EvaluDetailInfo detailInfo = null;
        int n2 = targetStoreColl.size();
        for (int i = 0; i < n2; ++i) {
            targetEvaluStoreInfo = targetStoreColl.get(i);
            if (DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode)) {
                targetID = targetEvaluStoreInfo.getEvaluTargetStoreType().getEvaluGroupTargetType().getPerformTargetType().getId().toString();
            } else if (targetDepEntryColl.get(i) != null && targetDepEntryColl.get(i).getEvaluTarget() != null) {
                targetDepEntryColl.get(i).getEvaluTarget().getId().toString();
            }
            weight = (BigDecimal)allocateMap.get(targetID);
            if (weight == null && !DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode) || DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode) && !allocateMap.containsKey(targetID)) continue;
            detailInfo = new EvaluDetailInfo();
            detailInfo.setNodeProcesser(info);
            detailInfo.setTargetEvaluStore(targetEvaluStoreInfo);
            detailInfo.setSeq(info.getEvaluDetails().size());
            detailInfo.setWeight(weight);
            if (DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode)) {
                detailInfo.setWeight(targetEvaluStoreInfo.getWeight());
            }
            detailInfo.setCompValue(targetEvaluStoreInfo.getRealValue());
            detailInfo.setTargetScore(targetEvaluStoreInfo.getFormulaScore());
            detailInfo.setRank(targetEvaluStoreInfo.getFormulaRank());
            info.getEvaluDetails().add(detailInfo);
            if (targetEvaluStoreInfo.getCreator() == null || targetEvaluStoreInfo.getCreator().getPerson() == null) continue;
            String personId = targetEvaluStoreInfo.getCreator().getPerson().getId().toString();
            targetEvaluStoreInfo.put("creatorPosition", primaryPosition.get(personId));
        }
    }

    @Override
    protected IRowSet _getNodeProForPrint(Context ctx, String evaluObjectID, String solutionPeriodID) throws BOSException, EASBizException {
        if (evaluObjectID == null || solutionPeriodID == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.number"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        EvaluResultCollection coll = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(viewInfo);
        DynamicRowSet rowSet = null;
        try {
            if (coll.size() > 0) {
                EvaluResultInfo info = coll.get(0);
                rowSet = new DynamicRowSet(5);
                rowSet.setColInfo(1, new ColInfo("evaluObject.name", "evaluObject.name", 12, null));
                rowSet.setColInfo(2, new ColInfo("evaluObject.number", "evaluObject.number", 12, null));
                rowSet.setColInfo(3, new ColInfo("adminOrgUnit.name", "adminOrgUnit.name", 12, null));
                rowSet.setColInfo(4, new ColInfo("position.name", "position.name", 12, null));
                rowSet.setColInfo(5, new ColInfo("jobGrade.name", "jobGrade.name", 12, null));
                rowSet.moveToInsertRow();
                rowSet.updateString("evaluObject.name", info.getEvaluObject().getName());
                rowSet.updateString("evaluObject.number", info.getEvaluObject().getNumber());
                rowSet.updateString("adminOrgUnit.name", info.getAdminOrgUnit() != null ? info.getAdminOrgUnit().getName() : null);
                rowSet.updateString("position.name", info.getPosition() != null ? info.getPosition().getName() : null);
                rowSet.updateString("jobGrade.name", info.getJobGrade() != null ? info.getJobGrade().getName() : null);
                rowSet.insertRow();
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    private TargetGradeModeEnum getTargetGradeMode(Context ctx, String evaluResultID) throws BOSException, EASBizException {
        EvaluResultInfo evaluResultInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.targetGradeMode"));
        evaluResultInfo = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultInfo((IObjectPK)new ObjectUuidPK(evaluResultID), sic);
        TargetGradeModeEnum targetGradeModeEnum = null;
        if (evaluResultInfo != null) {
            targetGradeModeEnum = evaluResultInfo.getSolutionPeriod().getEvaluSolution().getTargetGradeMode();
        }
        return targetGradeModeEnum;
    }

    private RankInfo getEvaluResultRankByTotalScore(Context ctx, EvaluSolutionInfo evaluSolutionInfo, BigDecimal totalScore) throws BOSException, EASBizException {
        GradeModeInfo solutionGradeMode = evaluSolutionInfo.getGradeMode();
        RankConvertRuleInfo rankConvertRuleInfo = evaluSolutionInfo.getRankConvertRule();
        if (rankConvertRuleInfo != null && rankConvertRuleInfo.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.minScore"));
            sic.add(new SelectorItemInfo("entries.maxScore"));
            sic.add(new SelectorItemInfo("entries.maxScoreCondition"));
            sic.add(new SelectorItemInfo("entries.minScoreCondition"));
            sic.add(new SelectorItemInfo("entries.rank.id"));
            sic.add(new SelectorItemInfo("entries.rank.name"));
            sic.add(new SelectorItemInfo("entries.rank.grade"));
            rankConvertRuleInfo = RankConvertRuleFactory.getLocalInstance(ctx).getRankConvertRuleInfo((IObjectPK)new ObjectUuidPK(rankConvertRuleInfo.getId().toString()), sic);
            return RankConvertRuleHelper.getRank(solutionGradeMode, rankConvertRuleInfo, totalScore);
        }
        return null;
    }

    @Override
    protected HashMap _getWebUrl(Context ctx) throws BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("URL", PerfUtils.getURL(ctx));
        return resultMap;
    }
}

