/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.TestQuestionInfo;
import com.kingdee.eas.hr.perf.app.AbstractOrgMDEvaluDetailReportFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgMDEvaluDetailReportFacadeControllerBean
extends AbstractOrgMDEvaluDetailReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.OrgMDEvaluDetailReportFacadeControllerBean");
    private Map qIdNumberMap = new LinkedHashMap();
    private Map paramNumMap = new HashMap();
    private boolean isRank = false;
    private static boolean isQuest = false;
    private String testPaperBeforId;
    private static String testPaperQuest;
    private static String testPaperName;
    private static String testPaperType;
    private static Map paperQuestMap;
    private static Set evalRelationID;
    private static Set multiDimentionObjcetID;
    private static Set evalPersonsID;
    private static String solutionPeriodID;
    private static Map faMap;
    private IRowSet rowQuestSet;
    private static String testPaperID;
    private static int evalPersonSize;

    @Override
    public IRowSet _getResult(Context ctx, String spId, String paperId, Set orgIds) throws BOSException, EASBizException {
        if (spId == null || paperId == null) {
            return null;
        }
        this.testPaperBeforId = paperId;
        if (!(orgIds != null && orgIds.size() != 0 || (orgIds = PerfUtils.getAdminRangeSet(ctx)) != null && orgIds.size() != 0)) {
            return null;
        }
        this.getPageQuest(ctx, spId, paperId);
        Set qIds = this.getQuestionIds(ctx, paperId);
        Set rIds = this.getEvaluResultIds(ctx, spId, paperId, orgIds);
        this.isRank = this.initIsRank(ctx, spId);
        if (qIds == null || rIds == null || qIds.size() == 0 || rIds.size() == 0 || this.qIdNumberMap.size() == 0) {
            return null;
        }
        faMap = this.getPaperQuestID(ctx, spId, orgIds, rIds);
        this.rowQuestSet = this.getTempTableQuery(ctx, solutionPeriodID, paperId);
        isQuest = false;
        testPaperQuest = null;
        if (this.rowQuestSet.size() > 0) {
            this.getEvaluandQuest(paperId);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tName = null;
        try {
            tName = this.createTempTable(ctx, pool, spId, paperId, orgIds);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        this.initTempTable(ctx, tName, spId, orgIds, rIds, paperId);
        IRowSet rowSet = this.queryQuestionAvgScore(ctx, qIds, rIds);
        if (rowSet == null || rowSet.size() <= 0) {
            // empty if block
        }
        if (isQuest && paperQuestMap != null && paperQuestMap.size() > 0) {
            for (Map.Entry entry : paperQuestMap.entrySet()) {
                Object key = entry.getKey();
                String value = entry.getValue().toString();
                String evaluValue = value.substring(0, value.indexOf(","));
                String mdObjctValue = value.substring(value.indexOf(",") + 1, value.indexOf(":"));
                String testPaperValue = value.substring(value.indexOf(":") + 1, value.length());
                evalPersonSize = 0;
                evalPersonSize = this.getPaperQuestSize(ctx, spId, evaluValue, mdObjctValue);
                StringBuffer updateSql = new StringBuffer(" update ");
                updateSql.append(tName);
                updateSql.append(" set paperQuestID = ?,EvalRelationDetailSelected = ? ");
                updateSql.append(" where evaluRelationID = ? ").append("and multiDimentionObjcetID =?");
                Connection conn = null;
                PreparedStatement ps = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    ps = conn.prepareStatement(updateSql.toString());
                    ps.setString(1, "1");
                    ps.setInt(2, evalPersonSize);
                    ps.setString(3, evaluValue);
                    ps.setString(4, mdObjctValue);
                    ps.execute();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException(e.getMessage(), e.getCause());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps);
                        SQLUtils.cleanup((Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup((Connection)conn);
            }
        }
        if (!isQuest || testPaperQuest == null || !paperId.equals(testPaperQuest)) {
            // empty if block
        }
        this.fillQScoreIntoTable(ctx, qIds, tName, rowSet);
        this.fillAvgScoreIntoTable(ctx, tName);
        StringBuffer sqlbuf = new StringBuffer();
        sqlbuf.append("select * from " + tName);
        sqlbuf.append(" order by orgID,EvaluRelationName ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlbuf.toString());
        pool.releaseTable(tName);
        return row;
    }

    private Map getPaperQuestID(Context ctx, String spId, Set orgIds, Set rIds) throws BOSException {
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.MDEvaluResultDetailInnerQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        String innerQuery = queryExecutor.getSQL();
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FID ,mdObject.FEvaluOrgID,r.FDisplayName_");
        sql.append(locale);
        sql.append(" ,r.FEvaluScore,r.FModifiedScore ");
        sql.append(" ,innerQuery.EvaluRelationName,innerQuery.RelationDetailSelected ");
        sql.append(" ,innerQuery.EvaluRelationWeight,innerQuery.RelationDetailAvrScore as RelationDetailAvrScore ,innerQuery.EvaluRelationId as EvaluRelationId, ");
        sql.append(" innerQuery.TESTPAPERID as TESTPAPERFID,mdObject.fid as MDOBJECTFID from T_PF_MDEVALURESULT r ");
        sql.append(" left outer join T_PF_MultiDimentionObject mdObject on r.FMdObjectID =  mdObject.fid ");
        sql.append(" left outer join (").append(innerQuery).append(")  innerQuery ").append("on r.FMdObjectID = innerQuery.MDObjectId and r.FSolutionPeriodID = innerQuery.MDSolutionPeriodId");
        sql.append(" where ");
        sql.append(" r.FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and r.FID in (");
        int i = 0;
        Iterator it = rIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> mapObjcts = new HashMap<String, String>();
        try {
            int index = 0;
            while (row.next()) {
                mapObjcts.put("evaluRelaionIds" + ++index, row.getString("EvaluRelationId") + "," + row.getString("MDOBJECTFID") + ":" + row.getString("RelationDetailAvrScore"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return mapObjcts;
    }

    private void getPageQuest(Context ctx, String solutionId, String testPaperId) throws BOSException {
        solutionPeriodID = solutionId;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionId, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("paperQuest", (Object)testPaperId, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
    }

    private String getEvaluandQuest(String testPaper) throws BOSException {
        int index = 0;
        Iterator iter = faMap.entrySet().iterator();
        boolean isContinue = false;
        evalRelationID = new HashSet();
        multiDimentionObjcetID = new HashSet();
        evalPersonsID = new HashSet();
        isQuest = false;
        paperQuestMap = new HashMap();
        testPaperQuest = testPaper;
        testPaperID = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            String value = entry.getValue().toString();
            String evaluValue = value.substring(0, value.indexOf(","));
            String mdObjctValue = value.substring(value.indexOf(",") + 1, value.indexOf(":"));
            String testPaperValue = value.substring(value.indexOf(":") + 1, value.length());
            try {
                IRowSet rowQuest = this.rowQuestSet.createCopy();
                while (rowQuest.next()) {
                    String rowsetValue = rowQuest.getString("FEvalRelationID").toString();
                    String mdobjct = rowQuest.getString("FMultiDimentionObject").toString();
                    String evalPersonValue = rowQuest.getString("FMultiDimentionObject").toString();
                    if (!evaluValue.equals(rowsetValue) && evaluValue != rowsetValue || !mdobjct.equals(mdObjctValue) && mdobjct != mdObjctValue) continue;
                    ++index;
                    testPaperQuest = testPaper;
                    testPaperID = testPaperValue;
                    isContinue = true;
                    isQuest = true;
                    evalRelationID.add(rowsetValue);
                    multiDimentionObjcetID.add(mdObjctValue);
                    evalPersonsID.add(evalPersonValue);
                    paperQuestMap.put("paperQuestMap" + index, rowsetValue + "," + mdObjctValue + ":" + evalPersonValue);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return testPaperQuest;
    }

    private IRowSet getTempTableQuery(Context ctx, String solutionperiod, String testPaperId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FEvalRelationID,FMultiDimentionObject from T_PF_EvalurelationQuest ");
        sql.append("where FPaperQuestID ='");
        sql.append(testPaperId);
        sql.append("' and FSolutionPeriodID = '");
        sql.append(solutionperiod);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private int getPaperQuestSize(Context ctx, String solutionPeriod, String evalRelationID, String objectID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_PF_EvalurelationQuest where ");
        sql.append(" FSolutionPeriodID ='");
        sql.append(solutionPeriod);
        sql.append("' and FEvalRelationID ='");
        sql.append(evalRelationID);
        sql.append("' and FMultiDimentionObject = '");
        sql.append(objectID);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet.size();
    }

    private Set getHRAndAdminRangeOrgUnitIds(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> orgIds = new HashSet<String>();
        try {
            while (row.next()) {
                orgIds.add(row.getString("FFromUnitID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return orgIds;
    }

    private void fillAvgScoreIntoTable(Context ctx, String tName) throws BOSException, EASBizException {
        String column;
        if (tName == null) {
            return;
        }
        StringBuffer sql = new StringBuffer("select avg(tatalScore) tatalScore,avg(adjustScore) adjustScore,avg(EvalRelationDetailAvrScore) EvalRelationDetailAvrScore,");
        Collection coll = this.qIdNumberMap.values();
        int i = 0;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(" , ");
            }
            column = it.next().toString();
            sql.append(" avg(").append(column).append(") ").append(column);
            ++i;
        }
        sql.append(" from ").append(tName);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer updateSql = new StringBuffer("update ");
        updateSql.append(tName);
        updateSql.append(" set ");
        try {
            if (row.next()) {
                updateSql.append(" tatalScore = ").append(row.getDouble("tatalScore")).append(",");
                updateSql.append(" adjustScore = ").append(row.getDouble("adjustScore")).append(",");
                if (isQuest) {
                    updateSql.append(" paperQuestID =  ").append("'1'").append(",");
                }
                updateSql.append(" EvalRelationDetailAvrScore = ").append(row.getDouble("EvalRelationDetailAvrScore")).append(",");
                i = 0;
                Iterator it2 = coll.iterator();
                while (it2.hasNext()) {
                    if (i != 0) {
                        updateSql.append(",");
                    }
                    column = it2.next().toString();
                    updateSql.append(column).append(" = ").append(row.getDouble(column));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        updateSql.append(" where FID = 'avgData'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void fillQScoreIntoTable(Context ctx, Set qIds, String tName, IRowSet rowSet) throws SQLDataException, BOSException {
        String qID;
        String rID;
        if (qIds == null || qIds.size() == 0 || tName == null || rowSet == null) {
            return;
        }
        HashMap map = new HashMap();
        try {
            while (rowSet.next()) {
                Map<String, Double> qIdScore;
                double avgScore = rowSet.getDouble("avgScore");
                rID = rowSet.getString("rID");
                qID = rowSet.getString("qID");
                if (map.containsKey(rID)) {
                    qIdScore = (Map)map.get(rID);
                    qIdScore.put(qID, new Double(avgScore));
                    continue;
                }
                qIdScore = new HashMap();
                qIdScore.put(qID, new Double(avgScore));
                map.put(rID, qIdScore);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String updateSql = this.getUpdateSql(ctx, tName, qIds);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (Map.Entry entry : map.entrySet()) {
                rID = entry.getKey().toString();
                Map qIdScore = (Map)entry.getValue();
                ps = conn.prepareStatement(updateSql);
                for (Map.Entry entry2 : this.paramNumMap.entrySet()) {
                    qID = entry2.getKey().toString();
                    Integer index = (Integer)entry2.getValue();
                    if (qIdScore.containsKey(qID)) {
                        ps.setObject(index, qIdScore.get(qID));
                        continue;
                    }
                    ps.setNull(index, 8);
                }
                ps.setString(qIds.size() + 1, rID);
                ps.execute();
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup(ps);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private boolean initIsRank(Context ctx, String spId) throws BOSException, EASBizException {
        if (spId == null) {
            return false;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)spId));
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.EvaluModeEnum"));
        evi.setFilter(fi);
        MultiDimentionSolutionPeriodCollection coll = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodCollection(evi);
        if (coll.size() > 0) {
            return EvaluModeEnum.RANK_GROUP.equals((Object)coll.get(0).getMDSolution().getEvaluModeEnum());
        }
        return false;
    }

    private IRowSet queryQuestionAvgScore(Context ctx, Set qIds, Set rIds) throws BOSException {
        int k = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(t.avgScore*t.weight)*0.01 avgScore, t.rID rID, t.qid qID from ");
        sql.append("( ");
        if (this.isRank) {
            sql.append("select AVG(rank.FGrade) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid ");
            sql.append("from T_PF_PaperQueDetail qScore ");
            sql.append("left join T_PF_Rank rank on qScore.FRankID = rank.FID ");
        } else {
            sql.append("select AVG(qScore.FScore) avgScore ,mResult.FID rID , eRelation.FID lID, eR.FWeight weight,qScore.FPaperQueID qid ");
            sql.append("from T_PF_PaperQueDetail qScore ");
        }
        sql.append("left join T_PF_TestPageForm      pForm on qScore.FTestPageFormID = pForm.FID ");
        sql.append("left join T_PF_MDEVALURESULT     mResult on pForm.FMDEvaluResultID = mResult.FID ");
        sql.append("left join T_PF_EvalPerson        ePerson on pForm.FEvalPersonID = ePerson.FID ");
        sql.append("left join T_PF_EvalReDetail      eRelation on ePerson.FEvalReDetailID = eRelation.FID ");
        sql.append("left join T_PF_EvaluRelation     eR        on  eRelation.FEvalRelationID = eR.FID ");
        sql.append("where mResult.FID in ");
        sql.append("( ");
        k = 0;
        Iterator it = rIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("and qScore.FPaperQueID in ");
        sql.append("( ");
        k = 0;
        it = qIds.iterator();
        while (it.hasNext()) {
            if (k != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++k;
        }
        sql.append(" ) ");
        sql.append("group by mResult.FID,eRelation.FID,qScore.FPaperQueID,eR.FWeight,eR.FID ");
        if (this.isRank) {
            sql.append("having AVG(rank.FGrade) is not null ");
        } else {
            sql.append("having AVG(qScore.FScore) is not null ");
        }
        sql.append(") ");
        sql.append("t ");
        sql.append(" group by t.rID,t.qid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private void initTempTable(Context ctx, String tName, String spId, Set orgIds, Set rIds, String paperId) throws BOSException, EASBizException {
        if (tName == null || spId == null || orgIds == null || orgIds.size() == 0 || rIds == null || rIds.size() == 0) {
            return;
        }
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.MDEvaluResultDetailInnerQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        String innerQuery = queryExecutor.getSQL();
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(tName).append(" (FID,orgID,orgName,tatalScore,adjustScore,EvaluRelationName,EvalRelationDetailSelected,EvaluRelationWeight,EvalRelationDetailAvrScore,");
        sql.append(" evaluRelationID, multiDimentionObjcetID ) ");
        sql.append(" (select r.FID ,mdObject.FEvaluOrgID,r.FDisplayName_");
        sql.append(locale);
        sql.append(" ,r.FEvaluScore,r.FModifiedScore ");
        sql.append(" ,innerQuery.EvaluRelationName,innerQuery.RelationDetailSelected ");
        sql.append(" ,innerQuery.EvaluRelationWeight,innerQuery.RelationDetailAvrScore,innerQuery.EvaluRelationId as EvaluRelationId, ");
        sql.append(" mdObject.fid as MDOBJECTFID from T_PF_MDEVALURESULT r ");
        sql.append(" left outer join T_PF_MultiDimentionObject mdObject on r.FMdObjectID =  mdObject.fid ");
        sql.append(" left outer join (").append(innerQuery).append(")  innerQuery ").append("on r.FMdObjectID = innerQuery.MDObjectId and r.FSolutionPeriodID = innerQuery.MDSolutionPeriodId");
        sql.append(" where ");
        sql.append("  innerQuery.TestPaperId = '").append(paperId).append("'");
        sql.append(" and  r.FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and r.FID in (");
        int i = 0;
        Iterator it = rIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(")").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String avgSql = "insert into " + tName + " (FID, orgID,orgName) " + " values('avgData','avgData','avgData') ";
        DbUtil.execute((Context)ctx, (String)avgSql);
    }

    private String getUpdateSql(Context ctx, String tName, Set qIds) {
        if (tName == null || qIds == null || qIds.size() == 0) {
            return null;
        }
        StringBuffer updateSql = new StringBuffer("update ");
        updateSql.append(tName);
        int k = 0;
        Iterator it = qIds.iterator();
        while (it.hasNext()) {
            String fieldName;
            String qId = it.next().toString();
            if (k == 0) {
                fieldName = this.qIdNumberMap.get(qId).toString();
                updateSql.append(" set ").append(fieldName).append(" = ? ");
                if (this.qIdNumberMap.containsKey(qId)) {
                    this.paramNumMap.put(qId, new Integer(1));
                }
            } else {
                updateSql.append(",");
                if (this.qIdNumberMap.containsKey(qId)) {
                    fieldName = this.qIdNumberMap.get(qId).toString();
                    updateSql.append(fieldName).append(" = ? ");
                    this.paramNumMap.put(qId, new Integer(k + 1));
                }
            }
            ++k;
        }
        updateSql.append(" where FID = ? ");
        return updateSql.toString();
    }

    private Set getEvaluResultIds(Context ctx, String spId, String paperId, Set orgIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(" select T_PF_MDEVALURESULT.fid rID from T_PF_MDEVALURESULT T_PF_MDEVALURESULT \r");
        sql.append(" left outer join T_PF_MultiDimentionObject T_PF_MultiDimentionObject on T_PF_MultiDimentionObject.fid=T_PF_MDEVALURESULT.FMdObjectID \r");
        sql.append(" left outer join T_PF_MDEvaluator T_PF_MDEvaluator on T_PF_MDEvaluator.FMDObjectID=T_PF_MultiDimentionObject.fid  \r");
        sql.append(" left outer join T_PF_EvalReDetail T_PF_EvalReDetail on T_PF_EvalReDetail.FMDEvaluatorID=T_PF_MDEvaluator.fid  \r");
        sql.append(" left outer join T_PF_EvaluRelation T_PF_EvaluRelation on T_PF_EvalReDetail.FEvalRelationID=T_PF_EvaluRelation.fid   \r");
        sql.append(" where ");
        sql.append("  T_PF_MDEVALURESULT.FSolutionPeriodID='");
        sql.append(spId);
        sql.append("' \r");
        sql.append(" and T_PF_MultiDimentionObject.FEvaluOrgID in ");
        sql.append(" ( ");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        Iterator it = orgIds.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        sql.append(" )");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                set.add(row.getString("rID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return set;
    }

    private Set getQuestionIds(Context ctx, String paperId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.name"));
        sic.add(new SelectorItemInfo("testQuestion.number"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        PaperQuestionsCollection pqColl = PaperQuestionsFactory.getLocalInstance(ctx).getPaperQuestionsCollection(evi);
        HashSet<String> questionIds = new HashSet<String>();
        int j = pqColl.size();
        for (int i = 0; i < j; ++i) {
            TestQuestionInfo tqInfo = pqColl.get(i).getTestQuestion();
            questionIds.add(pqColl.get(i).getId().toString());
            this.qIdNumberMap.put(pqColl.get(i).getId().toString(), "F" + i);
        }
        return questionIds;
    }

    private String createTempTable(Context ctx, TempTablePool pool, String spId, String paperId, Set orgIds) throws Exception {
        int i = 0;
        Collection coll = this.qIdNumberMap.values();
        if (coll == null || coll.size() == 0 || pool == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(" create table ");
        sql.append("tt");
        sql.append(" (  FID Varchar(44),");
        sql.append(" orgID varchar(44),");
        sql.append(" orgName nvarchar(400),");
        sql.append(" tatalScore NUMERIC(28,10), ");
        sql.append(" adjustScore NUMERIC(28,10), ");
        sql.append(" EvaluRelationName nvarchar(400), ");
        sql.append(" EvalRelationDetailSelected NUMERIC(10), ");
        sql.append(" EvaluRelationWeight NUMERIC(28,10), ");
        sql.append(" EvalRelationDetailAvrScore NUMERIC(28,10), ");
        sql.append(" evaluRelationID nvarchar(80),");
        sql.append(" multiDimentionObjcetID nvarchar(80), ");
        sql.append("paperQuestID nvarchar(80),");
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            String column = it.next().toString();
            if (i != 0) {
                sql.append(" , ");
            }
            sql.append(column).append("  ").append("NUMERIC(28,10)");
            ++i;
        }
        sql.append(")");
        pool = TempTablePool.getInstance((Context)ctx);
        String tName = pool.createTempTable(sql.toString());
        return tName;
    }

    @Override
    protected IRowSet _getData(Context ctx, String spId, String paperId, Set orgIds) throws BOSException, EASBizException {
        return null;
    }
}

