/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.app.AbstractPersonBatchFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonBatchFacadeControllerBean
extends AbstractPersonBatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.PersonBatchFacadeControllerBean");

    @Override
    protected Map _getSupervisor(Context ctx, Set personIdSet, String hierarchyId, boolean isPrimary) throws BOSException, EASBizException {
        HashMap<String, PersonCollection> supervisorMap = new HashMap<String, PersonCollection>();
        if (personIdSet == null || personIdSet.size() == 0) {
            return supervisorMap;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)personIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        if (isPrimary) {
            filter.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)isPrimary));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("supervisor.id"));
        evi.getSelector().add(new SelectorItemInfo("supervisor.name"));
        evi.setFilter(filter);
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app.GetPersonSupervisorQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        try {
            PersonInfo supervisor = null;
            PersonCollection coll = null;
            String personId = null;
            while (rowSet.next()) {
                personId = rowSet.getString("id");
                if (supervisorMap.get(personId) != null) {
                    coll = (PersonCollection)supervisorMap.get(personId);
                } else {
                    coll = new PersonCollection();
                    supervisorMap.put(personId, coll);
                }
                supervisor = new PersonInfo();
                supervisor.setId(BOSUuid.read((String)rowSet.getString("supervisor.id")));
                supervisor.setName(rowSet.getString("supervisor.name"));
                coll.add(supervisor);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return supervisorMap;
    }
}

