/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class PersonalEvaluResultDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.PersonalEvaluResultDataTransmission");
    GradeModeInfo gradeMode = null;
    boolean isRank = false;
    private DecimalFormat df = new DecimalFormat("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EvaluResultFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        EvaluResultInfo ret;
        block21: {
            Object obj = null;
            ret = new EvaluResultInfo();
            try {
                String personId = null;
                FilterInfo filterInfo = new FilterInfo();
                EntityViewInfo viewInfo = new EntityViewInfo();
                obj = hsData.get("personNumber");
                if (obj == null || "".equals(obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString()));
                obj = hsData.get("personName");
                if (obj == null || "".equals(obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
                viewInfo.setFilter(filterInfo);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
                if (personColl == null || personColl.size() <= 0) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
                }
                personId = personColl.get(0).getId().toString();
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                String solutionID = (String)this.getContextParameter("solutionID");
                filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionID));
                filterInfo.getFilterItems().add(new FilterItemInfo("objectID", (Object)personId));
                viewInfo.setFilter(filterInfo);
                selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                EvaluObjectCollection coll = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectCollection(viewInfo);
                EvaluObjectInfo objectInfo = null;
                if (coll == null || coll.size() != 1) {
                    throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
                }
                objectInfo = coll.get(0);
                ret.setEvaluObject(objectInfo);
                if (this.gradeMode == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("gradeMode.id"));
                    sic.add(new SelectorItemInfo("gradeMode.minGrade"));
                    sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
                    sic.add(new SelectorItemInfo("inputMode"));
                    EvaluSolutionInfo s = EvaluSolutionFactory.getLocalInstance(ctx).getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID), sic);
                    this.gradeMode = s.getGradeMode();
                }
                String spID = (String)this.getContextParameter("spID");
                SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spID));
                ret.setSolutionPeriod(spInfo);
                obj = hsData.get("evaluScore");
                if (obj != null && !"".equals(obj.toString().trim())) {
                    BigDecimal score = null;
                    try {
                        score = new BigDecimal(obj.toString());
                    }
                    catch (Exception ex) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    if (this.gradeMode.getMaxGrade().compareTo(score) == -1 || this.gradeMode.getMinGrade().compareTo(score) == 1) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    PrecisionMaintainInfo PMInfo = PersonalEvaluResultDataTransmission.getPrecisionMaintainInfo(ctx, solutionID);
                    if (PMInfo != null) {
                        switch (PMInfo.getTotalPrecisionType().getValue()) {
                            case 10: {
                                ret.setTargetEvaluScore(score.setScale(PMInfo.getTotalPrecision(), 4));
                                break;
                            }
                            case 20: {
                                ret.setTargetEvaluScore(score.setScale(PMInfo.getTotalPrecision(), 0));
                                break;
                            }
                            case 30: {
                                ret.setTargetEvaluScore(score.setScale(PMInfo.getTotalPrecision(), 1));
                            }
                        }
                    } else {
                        ret.setTargetEvaluScore(new BigDecimal(obj.toString()));
                        ret.setEvaluateSum(new BigDecimal(obj.toString()));
                    }
                }
                if ((obj = hsData.get("rank")) == null || "".equals(obj.toString().trim())) break block21;
                String rankGroupID = (String)this.getContextParameter("rankGroupID");
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                if (rankGroupID != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)rankGroupID));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)"%noRankGroupID%"));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
                viewInfo.setFilter(filterInfo);
                RankInfo rank = null;
                RankCollection rankColl = RankFactory.getLocalInstance(ctx).getRankCollection(viewInfo);
                if (rankColl != null && rankColl.size() > 0) {
                    rank = rankColl.get(0);
                    ret.setPerfRank(rank);
                    break block21;
                }
                throw new EvaluResultException(EvaluResultException.RANK_ERROR);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        return ret;
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (this.isSltImportUpdate()) {
            EvaluResultInfo info = (EvaluResultInfo)coreBaseInfo;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String spID = (String)this.getContextParameter("spID");
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)info.getEvaluObject().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            EvaluResultCollection coll = null;
            try {
                coll = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (coll != null && coll.size() > 0) {
                info.setId(coll.get(0).getId());
            }
        }
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String solutionID = (String)this.getContextParameter("solutionID2");
            PrecisionMaintainInfo PMInfo = PersonalEvaluResultDataTransmission.getPrecisionMaintainInfo(ctx, solutionID);
            result.put("personNumber", rs.getString("Person.number"));
            result.put("personName", rs.getString("Person.name"));
            if (rs.getObject("targetEvaluScore") != null) {
                BigDecimal score = rs.getBigDecimal("targetEvaluScore");
                if (PMInfo != null) {
                    switch (PMInfo.getTotalPrecisionType().getValue()) {
                        case 10: {
                            result.put("evaluScore", score.setScale(PMInfo.getTotalPrecision(), 4));
                            break;
                        }
                        case 20: {
                            result.put("evaluScore", score.setScale(PMInfo.getTotalPrecision(), 0));
                            break;
                        }
                        case 30: {
                            result.put("evaluScore", score.setScale(PMInfo.getTotalPrecision(), 1));
                        }
                    }
                } else {
                    result.put("evaluScore", this.df.format(rs.getDouble("targetEvaluScore")));
                }
            }
            if (rs.getString("perfRank.name") != null) {
                result.put("rank", rs.getString("perfRank.name"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String spID = (String)this.getContextParameter("spID");
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.PersonalEvaluResultQuery";
    }

    public static PrecisionMaintainInfo getPrecisionMaintainInfo(Context ctx, String evaluSolutionID) throws Exception {
        PrecisionMaintainInfo info = null;
        if (evaluSolutionID != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PrecisionMaintainCollection col = PrecisionMaintainFactory.getLocalInstance(ctx).getPrecisionMaintainCollection(view);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        return info;
    }
}

