/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AuditStatusEnum;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import java.util.Hashtable;

public class PersonalEvaluResultRankingDataTransmission
extends AbstractDataTransmission {
    GradeModeInfo gradeMode = null;
    boolean isRank = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EvaluResultFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private String getObStr(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = null;
        EvaluResultInfo evaluResult = new EvaluResultInfo();
        try {
            String personId = null;
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            obj = hsData.get("Number");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString()));
            obj = hsData.get("Name");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            if (personColl == null || personColl.size() <= 0) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
            }
            personId = personColl.get(0).getId().toString();
            filterInfo = new FilterInfo();
            viewInfo = new EntityViewInfo();
            String solutionID = (String)this.getContextParameter("solutionID");
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionID));
            filterInfo.getFilterItems().add(new FilterItemInfo("objectID", (Object)personId));
            viewInfo.setFilter(filterInfo);
            selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            EvaluObjectCollection coll = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectCollection(viewInfo);
            EvaluObjectInfo objectInfo = null;
            if (coll == null || coll.size() != 1) {
                throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
            }
            objectInfo = coll.get(0);
            evaluResult.setEvaluObject(objectInfo);
            String spID = (String)this.getContextParameter("spID");
            SolutionPeriodInfo spinfoInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spID));
            evaluResult.setSolutionPeriod(spinfoInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return evaluResult;
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (this.isSltImportUpdate()) {
            EvaluResultInfo info = (EvaluResultInfo)coreBaseInfo;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String spID = (String)this.getContextParameter("spID");
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)info.getEvaluObject().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isModified"));
            sic.add(new SelectorItemInfo("auditStatus"));
            sic.add(new SelectorItemInfo("ranking"));
            EvaluResultCollection coll = null;
            try {
                coll = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (coll != null && coll.size() > 0) {
                AuditStatusEnum status = coll.get(0).getAuditStatus();
                String rankingName = coll.get(0).getRanking();
                if (AuditStatusEnum.AUDITING.equals((Object)status) || AuditStatusEnum.PASS.equals((Object)status)) {
                    info.setRanking(rankingName);
                }
                info.setId(coll.get(0).getId());
            }
        }
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }
}

