/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.PlanFreqTypeException;
import com.kingdee.eas.hr.perf.PlanFreqTypeInfo;
import com.kingdee.eas.hr.perf.app.AbstractPlanFreqTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class PlanFreqTypeControllerBean
extends AbstractPlanFreqTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.PlanFreqTypeControllerBean");

    @Override
    protected IObjectCollection _getEnableList(Context ctx) throws BOSException, EASBizException {
        String oql = "where isEnable = 1";
        return this.getPlanFreqTypeCollection(ctx, oql);
    }

    @Override
    protected IObjectValue _getDefault(Context ctx) throws BOSException, EASBizException {
        String oql = "where isDefault = 1";
        if (this.exists(ctx, oql)) {
            return this.getPlanFreqTypeInfo(ctx, oql);
        }
        return null;
    }

    @Override
    protected void _setEnable(Context ctx, boolean flag, String planFreqTypeId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)planFreqTypeId));
        PlanFreqTypeInfo info = this.getPlanFreqTypeInfo(ctx, (IObjectPK)pk);
        info.setIsEnable(flag);
        this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    @Override
    protected void _setDefault(Context ctx, String planFreqTypeId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)planFreqTypeId));
        PlanFreqTypeInfo info = this.getPlanFreqTypeInfo(ctx, (IObjectPK)pk);
        info.setIsDefault(true);
        this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlanFreqTypeInfo info = (PlanFreqTypeInfo)model;
        if (info.isIsDefault() && !info.isIsEnable()) {
            throw new PlanFreqTypeException(PlanFreqTypeException.ERROR_SET_DEFAULT);
        }
        if (this.exists(ctx, "where type=" + info.getType().getValue())) {
            throw new PlanFreqTypeException(PlanFreqTypeException.EXIST_PLAN_FREQTYPE);
        }
        if (info.isIsDefault()) {
            this.delDefault(ctx);
        }
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, model);
    }

    private void delDefault(Context ctx) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_PlanFreqType SET FIsDefault=0";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PlanFreqTypeInfo oldInfo = this.getPlanFreqTypeInfo(ctx, pk);
        PlanFreqTypeInfo info = (PlanFreqTypeInfo)model;
        if (oldInfo.isIsDefault() && oldInfo.isIsEnable() && !info.isIsEnable()) {
            throw new PlanFreqTypeException(PlanFreqTypeException.DEFAULT_FREQTYPE_NOT_ENABLE);
        }
        if (info.isIsDefault() && !info.isIsEnable()) {
            throw new PlanFreqTypeException(PlanFreqTypeException.ERROR_SET_DEFAULT);
        }
        if (info.isIsDefault()) {
            this.delDefault(ctx);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return "";
        }
        PlanFreqTypeInfo info = (PlanFreqTypeInfo)super._getValue(ctx, pk);
        String str = "";
        if (info.getType() != null) {
            str = info.getType().toString();
        }
        return str;
    }
}

