/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.RankException;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.app.AbstractRankControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RankControllerBean
extends AbstractRankControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.RankControllerBean");
    private static final String TABLE_NAME = " T_PF_Rank ";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAddNew(ctx, model);
        this.verdictSerial(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkAddNew(ctx, model);
        this.verdictSerial(ctx, model);
        return super._addnew(ctx, model);
    }

    private void verdictSerial(Context ctx, IObjectValue model) throws BOSException {
        RankInfo info = (RankInfo)model;
        String groupID = info.getGroup().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        int count = super.getCollection(ctx, viewInfo).size();
        info.setSerial(count);
    }

    private static FilterInfo getNoDUPNumberFilter(IObjectValue model, Context ctx) throws BOSException {
        RankInfo info = (RankInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getGroup().getId().toString(), CompareType.EQUALS));
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        return filter;
    }

    private static FilterInfo getNoDUPNameFilter(IObjectValue model, Context ctx) throws BOSException {
        RankInfo info = (RankInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getGroup().getId().toString(), CompareType.EQUALS));
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        return filter;
    }

    private void checkAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        RankInfo info = (RankInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new RankException(RankException.NUMBER_NOT_ALLOW_NULL);
        }
        FilterInfo filter = RankControllerBean.getNoDUPNumberFilter(model, ctx);
        if (super._exists(ctx, filter)) {
            throw new RankException(RankException.NUMBER_NOT_ALLOW_DUP);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new RankException(RankException.NAME_NOT_ALLOW_NULL);
        }
        filter = RankControllerBean.getNoDUPNameFilter(model, ctx);
        if (super._exists(ctx, filter)) {
            throw new RankException(RankException.NAME_NOT_ALLOW_DUP);
        }
        if (info.getGrade() == null) {
            throw new RankException(RankException.GRADE_NOT_ALLOW_NULL);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAddNew(ctx, model);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updateSerial(Context ctx, String[] idList) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_Rank SET FSerial = ? WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < idList.length; ++i) {
                pstmt.setInt(1, i);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)idList[i]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new RankException(RankException.DB_ASSESS_ERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }
}

