/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.GradeModeException;
import com.kingdee.eas.hr.perf.IRank;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankException;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupEnum;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.app.AbstractRankGroupControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RankGroupControllerBean
extends AbstractRankGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.RankGroupControllerBean");
    private static final String TABLE = " T_PF_RankGroup ";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        RankGroupInfo info = (RankGroupInfo)model;
        super._checkNumberBlank(ctx, model);
        super._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        if (info.getGradeMode() == null) {
            throw new RankException(RankException.GRADE_MODE_NOT_ALLOW_NULL);
        }
        if (!this.existDefaultGroup(ctx)) {
            info.setIsDefault(RankGroupEnum.YES);
        } else if (info.getIsDefault().equals((Object)RankGroupEnum.YES)) {
            this.disableOldDefaultGradeMode(ctx);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRank iRank = RankFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("group.id", (Object)pk.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(item);
        iRank.delete(filter);
        super._delete(ctx, pk);
    }

    private boolean existDefaultGroup(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(0), CompareType.EQUALS));
        FilterInfo newFilterInfo = new FilterInfo();
        newFilterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.mergeFilter(newFilterInfo, "and");
        return super._exists(ctx, filter);
    }

    private void disableOldDefaultGradeMode(Context ctx) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_RankGroup SET FIsDefault = ? WHERE ( FIsDefault = ? ) AND (FHROrgUnitID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 10);
            pstmt.setInt(2, 0);
            String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)hrOrgUnitID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new GradeModeException(GradeModeException.ERROR_DATABASE);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RankGroupInfo dataBaseInfo = (RankGroupInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)dataBaseInfo.getName()));
        if (this._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RankGroupInfo dataBaseInfo = (RankGroupInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected boolean _isRefByOther(Context ctx, String id) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rankGroup.id", (Object)id));
        if (SynSolutionFactory.getLocalInstance(ctx).exists(filter)) {
            return true;
        }
        if (TestPaperFactory.getLocalInstance(ctx).exists(filter)) {
            return true;
        }
        if (RankConvertRuleFactory.getLocalInstance(ctx).exists(filter)) {
            return true;
        }
        filter.getFilterItems().add(new FilterItemInfo("targetRankGroup.id", (Object)id));
        filter.setMaskString("#0 or #1");
        if (EvaluSolutionFactory.getLocalInstance(ctx).exists(filter)) {
            return true;
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("RankGroup.id", (Object)id));
        return MultiDimentionSolutionFactory.getLocalInstance(ctx).exists(filter);
    }
}

