/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.perf.EvalRelationDetailCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.IEvalRelationDetail;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.app.AbstractSelfEvaluatorListUIHandler;
import com.kingdee.jdbc.rowset.IRowSet;

public class SelfEvaluatorListUIHandler
extends AbstractSelfEvaluatorListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        SelectorItemCollection sic;
        request.setQuery(null);
        super._handleInit(request, response, context);
        String currentMDID = (String)request.get("currentMDID");
        String currentSolutionPeriodID = (String)request.get("currentSolutionPeriodID");
        String personID = null;
        if (currentMDID != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("multiDimObject.id"));
            sic.add(new SelectorItemInfo("multiDimObject.person.id"));
            MultiDimEvaluatorInfo mdei = MultiDimEvaluatorFactory.getLocalInstance(context).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(currentMDID), sic);
            personID = mdei.getMultiDimObject().getPerson().getId().toString();
            PersonInfo person = (PersonInfo)PersonFactory.getLocalInstance((Context)context).getValue((IObjectPK)new ObjectUuidPK(personID));
            this.getPositionReferToPerson(context, person);
        }
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.operateDescript"));
        if (currentSolutionPeriodID != null) {
            MultiDimentionSolutionPeriodFactory.getLocalInstance(context).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(currentSolutionPeriodID), sic);
        }
    }

    private PositionInfo getPositionReferToPerson(Context context, PersonInfo person) throws Exception {
        if (person == null) {
            return null;
        }
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)context);
        PositionInfo positionInfo = null;
        if (person.getId() == null) {
            return null;
        }
        PositionMemberCollection positionMemberCollection = iPositionMember.getPositionsByPerson(person.getId());
        positionInfo = positionMemberCollection == null || positionMemberCollection.size() == 0 ? null : positionMemberCollection.get(0).getPosition();
        return positionInfo;
    }

    @Override
    protected void _handleActionFirstRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionPreRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionNextRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionEndRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public ResponseContext tableRequestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVirtualModel(false);
        ResponseContext rep = super.tableRequestData(request, response, context);
        String currentMDID = (String)request.get("currentMDID");
        if (currentMDID != null) {
            this.handleOnGetRowSet(context, request.getRowSet(), currentMDID);
        }
        return rep;
    }

    public void handleOnGetRowSet(Context context, IRowSet rowSet, String currentMDID) throws Exception {
        String type = null;
        IEvalRelationDetail ierd = EvalRelationDetailFactory.getLocalInstance(context);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = null;
        if (rowSet != null) {
            String id;
            while (rowSet.next()) {
                type = rowSet.getString("MDEvaluTypeEnum");
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", (Object)currentMDID));
                filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)rowSet.getString("id")));
                viewInfo.setFilter(filter);
                EvalRelationDetailCollection coll = ierd.getEvalRelationDetailCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    rowSet.updateString("mdEvaluGroup.number", "" + coll.get(0).getSelected());
                    continue;
                }
                rowSet.updateString("mdEvaluGroup.number", "0");
            }
            rowSet.beforeFirst();
            if (rowSet.next() && (id = rowSet.getString("id")) != null) {
                this.fillSelectedTable(context, id, currentMDID);
            }
            rowSet.beforeFirst();
        }
    }

    private void fillSelectedTable(Context context, String relationID, String currentMDID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)relationID));
        filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", (Object)currentMDID));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sic = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("person.number");
        sic.add(item);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "SelectedEvalPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.setObjectView(viewInfo);
        exec.executeQuery();
    }

    protected IQueryExecutor getQueryExecutor(RequestContext request, ResponseContext response, Context context) throws Exception {
        IQueryExecutor exec = super.getQueryExecutor(request, response, context);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected FilterInfo getDefaultFilterForQuery(RequestContext request, Context context) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", request.get("currentMDID")));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", request.get("currentSolutionPeriodID")));
        return filter;
    }
}

