/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.AbortInHandlerException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.perf.AuditStateEnum;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectCollection;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MDGroupObjectInfo;
import com.kingdee.eas.hr.perf.MDPersonFacadeFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorCollection;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionObjectCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SelfSelectEvaluatorHelp;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractSelfSelectEvaluatorUIHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;

public class SelfSelectEvaluatorUIHandler
extends AbstractSelfSelectEvaluatorUIHandler {
    protected FilterInfo getDefaultFilterForQuery(RequestContext request, Context context) throws Exception {
        LinkedHashSet<String> mdEvaluObject = new LinkedHashSet<String>();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        MultiDimentionObjectCollection coll = MultiDimentionObjectFactory.getLocalInstance(context).getMultiDimentionObjectCollection(evi);
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            mdEvaluObject.add(coll.get(i).getId().toString());
        }
        MDGroupObjectCollection collection = new MDGroupObjectCollection();
        if (!mdEvaluObject.isEmpty()) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("mdObject.id", mdEvaluObject, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MultiDimntModeE", (Object)new Integer(102)));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum", (Object)SolutionPeriodStatusEnum.UN_EVALU, CompareType.NOTEQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.mdEvaluGroup.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.operateDescript"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.hidePaperWeight"));
            collection = MDGroupObjectFactory.getLocalInstance(context).getMDGroupObjectCollection(viewInfo);
        }
        String firstSPId = null;
        String firstMDId = null;
        int n2 = collection.size();
        for (int i = 0; i < n2; ++i) {
            if (!collection.get(i).getMdEvaluGroup().getSolutionPeriod().getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) continue;
            firstSPId = collection.get(i).getMdEvaluGroup().getSolutionPeriod().getId().toString();
            firstMDId = collection.get(i).getMdObject().getId().toString();
            break;
        }
        FilterInfo fi = new FilterInfo();
        if (collection.size() == 0) {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)"%noeas%"));
            fi.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)"%noeas%"));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)(firstSPId == null ? "%noeas%" : firstSPId)));
            fi.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)(firstMDId == null ? "%noeas%" : firstMDId)));
        }
        return fi;
    }

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.init(request, response, context);
    }

    private void init(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.refreshAll(request, response, context);
    }

    private void getSolutionPeriodAndEvaluGroup(RequestContext request, Context context) throws BOSException, EASBizException {
        HashSet mdEvaluObject = (HashSet)request.get("mdEvaluObject");
        String mdSolutionPeriodID = null;
        String mdEvaluObjectID = null;
        String mdEvaluGroupID = null;
        if (mdEvaluObject != null && mdEvaluObject.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)mdEvaluObject, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.MultiDimntModeE", (Object)new Integer(102)));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum", (Object)SolutionPeriodStatusEnum.UN_EVALU, CompareType.NOTEQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.SPStatuEnum"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.mdEvaluGroup.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.operateDescript"));
            viewInfo.getSelector().add(new SelectorItemInfo("mdEvaluGroup.solutionPeriod.MDSolution.hidePaperWeight"));
            MDGroupObjectCollection coll = MDGroupObjectFactory.getLocalInstance(context).getMDGroupObjectCollection(viewInfo);
            HashMap<String, MDGroupObjectInfo> solutionPeriodToObject = new HashMap<String, MDGroupObjectInfo>();
            ArrayList<MultiDimentionSolutionPeriodInfo> onEvaluSolutionPeriod = new ArrayList<MultiDimentionSolutionPeriodInfo>();
            ArrayList<MultiDimentionSolutionPeriodInfo> endEvaluedSolutionPeriod = new ArrayList<MultiDimentionSolutionPeriodInfo>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                solutionPeriodToObject.put(coll.get(i).getMdEvaluGroup().getSolutionPeriod().getId().toString(), coll.get(i));
                if (coll.get(i).getMdEvaluGroup().getSolutionPeriod().getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
                    onEvaluSolutionPeriod.add(coll.get(i).getMdEvaluGroup().getSolutionPeriod());
                    continue;
                }
                endEvaluedSolutionPeriod.add(coll.get(i).getMdEvaluGroup().getSolutionPeriod());
            }
            if (onEvaluSolutionPeriod.size() > 0) {
                mdSolutionPeriodID = ((CoreBaseInfo)onEvaluSolutionPeriod.get(0)).getId().toString();
                request.put("solutionPeriodInfo", onEvaluSolutionPeriod.get(0));
            } else if (endEvaluedSolutionPeriod.size() > 0) {
                // empty if block
            }
            if (mdSolutionPeriodID != null) {
                mdEvaluObjectID = ((MDGroupObjectInfo)solutionPeriodToObject.get(mdSolutionPeriodID)).getMdObject().getId().toString();
                mdEvaluGroupID = ((MDGroupObjectInfo)solutionPeriodToObject.get(mdSolutionPeriodID)).getMdEvaluGroup().getId().toString();
            }
            request.put("mdSolutionPeriodID", (Object)mdSolutionPeriodID);
            request.put("mdEvaluObjectID", (Object)mdEvaluObjectID);
            request.put("mdEvaluGroupID", mdEvaluGroupID);
            if (mdEvaluObjectID == null || mdSolutionPeriodID == null || mdEvaluGroupID == null) {
                return;
            }
        }
    }

    private void getMDEvaluGroup(RequestContext request, Context context) throws BOSException, EASBizException {
        String mdEvaluGroupID = (String)request.get("mdEvaluGroupID");
        if (mdEvaluGroupID != null) {
            SelectorItemCollection itemCollection = new SelectorItemCollection();
            itemCollection.add(new SelectorItemInfo("id"));
            itemCollection.add(new SelectorItemInfo("relation.id"));
            itemCollection.add(new SelectorItemInfo("relation.name"));
            itemCollection.add(new SelectorItemInfo("relation.personRestrict"));
            itemCollection.add(new SelectorItemInfo("relation.minRestrict"));
            itemCollection.add(new SelectorItemInfo("relation.weight"));
            itemCollection.add(new SelectorItemInfo("relation.MDEvaluTypeEnum"));
            itemCollection.add(new SelectorItemInfo("fellowType"));
            MDEvaluGroupInfo evaluGroupInfo = MDEvaluGroupFactory.getLocalInstance(context).getMDEvaluGroupInfo((IObjectPK)new ObjectUuidPK(mdEvaluGroupID), itemCollection);
            request.put("evaluGroupInfo", (Object)evaluGroupInfo);
        }
    }

    private HashSet initEvaluObject(RequestContext request, Context context) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        MultiDimentionObjectCollection collection = MultiDimentionObjectFactory.getLocalInstance(context).getMultiDimentionObjectCollection(viewInfo);
        HashSet<String> mdEvaluObject = new HashSet<String>();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            mdEvaluObject.add(collection.get(i).getId().toString());
        }
        request.put("mdEvaluObject", mdEvaluObject);
        return mdEvaluObject;
    }

    private void operateAddEvalPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
        EvalRelationDetailInfo detailInfo;
        EvaluRelationInfo evaluRelationInfo = (EvaluRelationInfo)request.get("evaluRelationInfo");
        EvalRelationDetailInfo detailInfo2 = (EvalRelationDetailInfo)request.get("detailInfo2");
        HashMap selectedMap = (HashMap)request.get("selectedMap");
        MultiDimEvaluatorInfo dimEvaluatorInfo = (MultiDimEvaluatorInfo)request.get("dimEvaluatorInfo");
        MDEvaluGroupInfo evaluGroupInfo = (MDEvaluGroupInfo)request.get("evaluGroupInfo");
        String mdSolutionPeriodID = (String)request.get("mdSolutionPeriodID");
        String mdEvaluObjectID = (String)request.get("mdEvaluObjectID");
        if (evaluRelationInfo == null || selectedMap == null || selectedMap.size() == 0) {
            return;
        }
        if (detailInfo2 == null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)evaluRelationInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("mdEvaluator.id", (Object)dimEvaluatorInfo.getId().toString()));
            if (EvalRelationDetailFactory.getLocalInstance(context).exists(filter)) {
                return;
            }
            detailInfo = new EvalRelationDetailInfo();
            detailInfo.setMdEvaluator(dimEvaluatorInfo);
            detailInfo.setEvalRelation(evaluRelationInfo);
            StringBuffer sb = new StringBuffer();
            if (MDEvaluTypeEnum.APPOINT.equals((Object)evaluRelationInfo.getMDEvaluTypeEnum())) {
                sb.append(evaluRelationInfo.getName());
                sb.append("(");
                sb.append(evaluRelationInfo.getMDEvaluTypeEnum().toString());
                sb.append(")");
            } else {
                sb.append(evaluRelationInfo.getMDEvaluTypeEnum().toString());
            }
            String sname = STConverter.tc2sc((String)sb.toString());
            String tname = STConverter.sc2tc((String)sb.toString());
            detailInfo.setName(sname, new Locale("L2"));
            detailInfo.setName(tname, new Locale("L3"));
            detailInfo.setName(sb.toString(), new Locale("L1"));
        } else {
            detailInfo = (EvalRelationDetailInfo)detailInfo2.clone();
        }
        for (Map.Entry entry : selectedMap.entrySet()) {
            if (SelfSelectEvaluatorHelp.existPerson(detailInfo.getEvalPersons(), entry.getKey().toString())) continue;
            EvalPersonInfo evalPersonInfo = new EvalPersonInfo();
            detailInfo.getEvalPersons().add(evalPersonInfo);
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)entry.getKey().toString()));
            evalPersonInfo.setPerson(pInfo);
            if (entry.getValue() != null) {
                PositionInfo posInfo = new PositionInfo();
                posInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                evalPersonInfo.setPosition(posInfo);
            }
            evalPersonInfo.setIsOrigin(true);
            evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSEND);
            evalPersonInfo.setWfStatus(WFStatuEnum.UNUSED);
        }
        detailInfo.setSelected(detailInfo.getEvalPersons().size());
        if (evaluRelationInfo.getPersonRestrict() < detailInfo.getEvalPersons().size()) {
            throw new AbortInHandlerException();
        }
        request.put("detailInfo", (Object)detailInfo);
        detailInfo = this.submitDetailInfo(request, response, context);
        int index = -1;
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            if (!dimEvaluatorInfo.getEvalReDetails().get(i).getId().toString().equals(detailInfo.getId().toString())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            dimEvaluatorInfo.getEvalReDetails().get(index).setSelected(detailInfo.getSelected());
            dimEvaluatorInfo.getEvalReDetails().get(index).put("evalPersons", (Object)detailInfo.getEvalPersons());
        } else {
            dimEvaluatorInfo.getEvalReDetails().add(detailInfo);
        }
        this.loadDataToTable(request, response, context);
    }

    private void loadDataToTable(RequestContext request, ResponseContext response, Context context) throws Exception {
        String mdSolutionPeriodID = (String)request.get("mdSolutionPeriodID");
        String mdEvaluObjectID = (String)request.get("mdEvaluObjectID");
        FilterInfo filterInfo = new FilterInfo();
        if (mdSolutionPeriodID == null || mdSolutionPeriodID.trim().length() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)"%noeas%"));
            filterInfo.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)"%noeas%"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
            filterInfo.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)mdEvaluObjectID));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalPersonSelectedQuery"));
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.executeQuery();
        request.setVirtualModel(true);
        request.setQueryPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalPersonSelectedQuery"));
        request.setQuery(viewInfo);
        request.setQueryUuid((Uuid)request.get("queryUuid"));
        request.setLength(50);
        super.tableRequestData(request, response, context);
    }

    private EvalRelationDetailInfo submitDetailInfo(RequestContext request, ResponseContext response, Context context) throws Exception {
        EvalRelationDetailInfo detailInfo = (EvalRelationDetailInfo)request.get("detailInfo");
        MDEvaluGroupInfo evaluGroupInfo = (MDEvaluGroupInfo)request.get("evaluGroupInfo");
        this.checkExistEvalutorAndRelation(request, response, context);
        IObjectPK objectPK = EvalRelationDetailFactory.getLocalInstance(context).submit(detailInfo);
        response.put((Object)"evaluRelationDetailId", (Object)objectPK);
        EvalRelationDetailInfo detailInfo2 = EvalRelationDetailFactory.getLocalInstance(context).getEvalRelationDetailInfo(objectPK);
        return detailInfo2;
    }

    private void refreshAll(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.initEvaluObject(request, context);
        this.getSolutionPeriodAndEvaluGroup(request, context);
        this.refreshMe(request, response, context);
    }

    private void refreshMe(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.getMDEvaluGroup(request, context);
        this.getEvaluatorBySolutionPeriodAndEvaluObject(request, context);
        if (this.solutionPeriodEvaluatorCanModify(request, context)) {
            this.operateSelfRelation(request, response, context);
        }
        this.loadDataToTable(request, response, context);
    }

    private void operateSelfRelation(RequestContext request, ResponseContext response, Context context) throws Exception {
        MultiDimEvaluatorInfo dimEvaluatorInfo = (MultiDimEvaluatorInfo)request.get("dimEvaluatorInfo");
        MDEvaluGroupInfo evaluGroupInfo = (MDEvaluGroupInfo)request.get("evaluGroupInfo");
        if (dimEvaluatorInfo == null || evaluGroupInfo == null) {
            return;
        }
        EvaluRelationInfo evaluRelationInfo = SelfSelectEvaluatorHelp.getEvaluRelationByTypeAndName(evaluGroupInfo.getRelation(), MDEvaluTypeEnum.SELF, null);
        if (evaluRelationInfo == null) {
            return;
        }
        EvalRelationDetailInfo detailInfo = SelfSelectEvaluatorHelp.getEvalRelationByRelationID(dimEvaluatorInfo.getEvalReDetails(), evaluRelationInfo.getId().toString());
        if (detailInfo != null && detailInfo.getEvalPersons() != null && detailInfo.getEvalPersons().size() > 0) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        PositionInfo positionInfo = SelfSelectEvaluatorUIHandler.getPositionInfo(context, ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString());
        String position = null;
        if (positionInfo != null) {
            position = positionInfo.getId().toString();
        }
        map.put(ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString(), position);
        request.put("selectedMap", map);
        request.put("evaluRelationInfo", (Object)evaluRelationInfo);
        request.put("detailInfo", (Object)detailInfo);
        request.put("detailInfo2", (Object)detailInfo);
        this.operateAddEvalPerson(request, response, context);
    }

    public static PositionInfo getPositionInfo(Context context, String id) throws Exception {
        if (id == null) {
            return null;
        }
        PositionInfo positionInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)id));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        CoreBaseCollection coll = PositionMemberFactory.getLocalInstance((Context)context).getCollection(evi);
        if (coll.size() != 0) {
            positionInfo = ((PositionMemberInfo)coll.get(0)).getPosition();
        }
        return positionInfo;
    }

    private boolean solutionPeriodEvaluatorCanModify(RequestContext request, Context context) {
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)request.get("solutionPeriodInfo");
        MultiDimEvaluatorInfo dimEvaluatorInfo = (MultiDimEvaluatorInfo)request.get("dimEvaluatorInfo");
        if (solutionPeriodInfo != null) {
            if (solutionPeriodInfo.getSPStatuEnum().equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
                return dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.UNSUBMIT) || dimEvaluatorInfo.getAuditState().equals((Object)AuditStateEnum.REBACK);
            }
            return false;
        }
        return false;
    }

    private MultiDimEvaluatorInfo getEvaluatorBySolutionPeriodAndEvaluObject(RequestContext request, Context context) throws BOSException, EASBizException {
        String mdSolutionPeriodID = (String)request.get("mdSolutionPeriodID");
        String mdEvaluObjectID = (String)request.get("mdEvaluObjectID");
        if (mdSolutionPeriodID == null || mdEvaluObjectID == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)mdEvaluObjectID));
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        MultiDimEvaluatorCollection collection = MultiDimEvaluatorFactory.getLocalInstance(context).getMultiDimEvaluatorCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            throw new AbortInHandlerException();
        }
        request.put("dimEvaluatorInfo", (Object)collection.get(0));
        return collection.get(0);
    }

    private boolean checkExistEvaluator(RequestContext request, ResponseContext response, Context context) throws Exception {
        String evaluatorID = (String)request.get("evaluatorID");
        if (evaluatorID == null) {
            this.refreshAll(request, response, context);
            throw new AbortInHandlerException();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaluatorID));
        if (!MultiDimEvaluatorFactory.getLocalInstance(context).exists(filterInfo)) {
            this.refreshAll(request, response, context);
            throw new AbortInHandlerException();
        }
        return false;
    }

    private void checkExistEvalutorAndRelation(RequestContext request, ResponseContext response, Context context) throws Exception {
        EvalRelationDetailInfo detailInfo = (EvalRelationDetailInfo)request.get("detailInfo");
        MDEvaluGroupInfo evaluGroupInfo = (MDEvaluGroupInfo)request.get("evaluGroupInfo");
        String relationID = detailInfo.getEvalRelation().getId().toString();
        EvaluRelationInfo evaluRelationInfo = SelfSelectEvaluatorHelp.getEvaluRelationByID(evaluGroupInfo.getRelation(), relationID);
        String name = evaluRelationInfo.getMDEvaluTypeEnum().toString();
        if (!SelfSelectEvaluatorHelp.checkEvaluRelationExist(context, relationID)) {
            request.put("evaluatorID", (Object)detailInfo.getMdEvaluator().getId().toString());
            this.checkExistEvaluator(request, response, context);
            this.refreshMe(request, response, context);
            throw new AbortInHandlerException();
        }
        if (this.evaluRelationHasModify(context, relationID, evaluGroupInfo)) {
            this.refreshMe(request, response, context);
            throw new AbortInHandlerException();
        }
        request.put("evaluatorID", (Object)detailInfo.getMdEvaluator().getId().toString());
        this.checkExistEvaluator(request, response, context);
    }

    private boolean evaluRelationHasModify(Context context, String relationID, MDEvaluGroupInfo evaluGroupInfo) throws BOSException, EASBizException {
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("id"));
        itemCollection.add(new SelectorItemInfo("name"));
        itemCollection.add(new SelectorItemInfo("personRestrict"));
        itemCollection.add(new SelectorItemInfo("mdEvaluGroup.fellowType"));
        itemCollection.add(new SelectorItemInfo("MDEvaluTypeEnum"));
        EvaluRelationInfo evaluRelationInfo = EvaluRelationFactory.getLocalInstance(context).getEvaluRelationInfo((IObjectPK)new ObjectUuidPK(relationID), itemCollection);
        return SelfSelectEvaluatorHelp.checkRelationIsModify(evaluRelationInfo, SelfSelectEvaluatorHelp.getEvaluRelationByID(evaluGroupInfo.getRelation(), relationID), evaluGroupInfo.getFellowType());
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionAddEvalPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
        MDEvaluTypeEnum typeEnum = (MDEvaluTypeEnum)((Object)request.get("typeEnum"));
        if (!MDEvaluTypeEnum.APPOINT.equals((Object)typeEnum)) {
            if (MDEvaluTypeEnum.SELF.equals((Object)typeEnum)) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString());
            FellowTypeEnum fellowType = (FellowTypeEnum)((Object)request.get("FellowType"));
            EvalRelationDetailInfo detailInfo = (EvalRelationDetailInfo)request.get("detailInfo");
            HashSet personSet = (HashSet)MDPersonFacadeFactory.getLocalInstance(context).getPersonByRelationType(set, typeEnum, fellowType).get(ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString());
            if (detailInfo != null && detailInfo.getEvalPersons() != null) {
                int n = detailInfo.getEvalPersons().size();
                for (int i = 0; i < n; ++i) {
                    personSet.remove(detailInfo.getEvalPersons().get(i).getPerson().getId().toString());
                }
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)personSet, CompareType.INCLUDE));
            Object rowSet = null;
            if (personSet == null || personSet.size() == 0) {
                rowSet = null;
            } else {
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPrimaryPositionAdminQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fi);
                exec.setObjectView(evi);
                exec.executeQuery();
            }
        }
    }

    @Override
    protected void _handleActionDelEvalPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleAddRelation(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.put("detailInfo2", request.get("detailInfo"));
        this.operateAddEvalPerson(request, response, context);
    }

    public void handleAddAppoint(RequestContext request, ResponseContext response, Context context) throws Exception {
        HashSet set = (HashSet)request.get("set");
        request.put("selectedMap", (Object)SelfSelectEvaluatorUIHandler.getPrimaryPositionMap(context, set));
        request.put("detailInfo2", request.get("detailInfo"));
        this.operateAddEvalPerson(request, response, context);
    }

    public static HashMap getPrimaryPositionMap(Context context, HashSet personSet) throws Exception {
        HashMap<String, String> personPositionMap = new HashMap<String, String>();
        if (personSet == null) {
            return personPositionMap;
        }
        Iterator iterator = personSet.iterator();
        while (iterator.hasNext()) {
            personPositionMap.put(iterator.next().toString(), null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        PositionMemberCollection coll = PositionMemberFactory.getLocalInstance((Context)context).getPositionMemberCollection(evi);
        if (coll.size() != 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                personPositionMap.put(coll.get(i).getPerson().getId().toString(), coll.get(i).getPosition().getId().toString());
            }
        }
        return personPositionMap;
    }
}

