/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvaluGroupCollection;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionException;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.IEvalWorkFlow;
import com.kingdee.eas.hr.perf.IEvaluGroup;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IEvaluGroupTargetType;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.app.AbstractSolutionPeriodControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SolutionPeriodControllerBean
extends AbstractSolutionPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SolutionPeriodControllerBean");

    @Override
    protected void _startSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setSolutionPeriodStatus(ctx, solutionPeriodId, 101);
    }

    @Override
    protected void _finishSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setSolutionPeriodStatus(ctx, solutionPeriodId, 102);
    }

    @Override
    protected void _resetSolutionPeriod(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        this.setSolutionPeriodStatus(ctx, solutionPeriodId, 100);
    }

    private void setSolutionPeriodStatus(Context ctx, String solutionPeriodId, int status) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_SolutionPeriod SET FStatus = ? WHERE FID = ?";
        if (status == 102) {
            sql = "UPDATE T_PF_SolutionPeriod SET FCanInputAchData = 0, FStatus = ? WHERE FID = ?";
        }
        if (status == 100) {
            sql = "UPDATE T_PF_SolutionPeriod SET FCanInputAchData = 1, FStatus = ? WHERE FID = ?";
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, status);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SolutionPeriodInfo info = (SolutionPeriodInfo)model;
        EvaluSolutionInfo solution = info.getEvaluSolution();
        solution.setSolutionStatus(SolutionStatusEnum.ONUSED);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionStatus"));
        EvaluSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        SolutionPeriodInfo info = this.getSolutionPeriodInfo(ctx, pk);
        if (info.getStatus().equals((Object)SolutionPeriodStatusEnum.ON_EVALU) || info.getStatus().equals((Object)SolutionPeriodStatusEnum.END_EVALU)) {
            throw new EvaluSolutionException(EvaluSolutionException.CAN_NOT_DEL_SOLUTIONPERIOD);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("delivered", (Object)new Integer(1)));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("delivered"));
        EvaluGroupCollection evaluGroupCollection = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupCollection(evi);
        if (evaluGroupCollection.size() > 0) {
            throw new EvaluSolutionException(EvaluSolutionException.CAN_NOT_DEL_SOLUTIONPERIOD_DELIVERED);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)pk.toString()));
        ITargetEvaluStore evaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        evaluStore.delete(fi);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.id", (Object)pk.toString()));
        IEvaluGroupTargetType targetType = EvaluGroupTargetTypeFactory.getLocalInstance(ctx);
        targetType.delete(filter);
        IEvaluGroupTarget target = EvaluGroupTargetFactory.getLocalInstance(ctx);
        target.delete(filter);
        IEvaluGroupObject object = EvaluGroupObjectFactory.getLocalInstance(ctx);
        object.delete(filter);
        IEvaluGroup evaluGroup = EvaluGroupFactory.getLocalInstance(ctx);
        evaluGroup.delete(fi);
        IEvaluTarget evaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        evaluTarget.delete(fi);
        IEvalWorkFlow evalWorkFlow = EvalWorkFlowFactory.getLocalInstance(ctx);
        evalWorkFlow.delete(fi);
        super._delete(ctx, pk);
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)info.getEvaluSolution().getId().toString()));
        EvaluSolutionInfo solution = info.getEvaluSolution();
        if (!SolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            solution.setSolutionStatus(SolutionStatusEnum.UNUSED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("solutionStatus"));
            EvaluSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        }
    }

    @Override
    protected int _getStatus(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            int n;
            String sql = "SELECT FStatus FROM T_PF_SolutionPeriod WHERE FID = ?";
            conn = null;
            pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionPeriodId);
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt("FStatus");
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return 0;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SolutionPeriodInfo oldInfo = null;
        if (((SolutionPeriodInfo)model).getId() != null) {
            oldInfo = this.getSolutionPeriodInfo(ctx, (IObjectPK)new ObjectUuidPK(((SolutionPeriodInfo)model).getId().toString()));
        }
        IObjectPK pk = super._submit(ctx, model);
        this.handleSolutionPeriodData(ctx, oldInfo, pk);
        return pk;
    }

    private void handleSolutionPeriodData(Context ctx, SolutionPeriodInfo oldInfo, IObjectPK pk) throws BOSException, EASBizException {
        SolutionPeriodInfo newSolutionPeriodInfo = this.getSolutionPeriodInfo(ctx, pk);
        if (oldInfo != null && !oldInfo.isEmpty() && !oldInfo.getFormSolution().getId().equals((Object)newSolutionPeriodInfo.getFormSolution().getId())) {
            HashMap<String, String> idMap = null;
            FilterInfo fi = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            ArrayList idList = new ArrayList();
            fi.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.id", (Object)oldInfo.getId().toString()));
            view.setFilter(fi);
            IEvaluGroupTarget iEvaluGroupTarget = EvaluGroupTargetFactory.getLocalInstance(ctx);
            EvaluGroupTargetCollection evaluGroupTargetCollection = iEvaluGroupTarget.getEvaluGroupTargetCollection(view);
            int size = evaluGroupTargetCollection.size();
            for (int j = 0; j < size; ++j) {
                EvaluGroupTargetInfo evaluGroupTargetInfo = evaluGroupTargetCollection.get(j);
                idMap = new HashMap<String, String>();
                idMap.put("EGTID", evaluGroupTargetInfo.getId().toString());
                idMap.put("ETID", evaluGroupTargetInfo.getEvaluTarget().getId().toString());
                idMap.put("SPID", oldInfo.getId().toString());
                idList.add(idMap);
            }
            if (idList != null && idList.size() > 0) {
                EvaluGroupTargetFactory.getLocalInstance(ctx).delete(idList);
            }
            fi = new FilterInfo();
            view = new EntityViewInfo();
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)oldInfo.getId().toString()));
            view.setFilter(fi);
            IEvaluGroup iEvaluGroup = EvaluGroupFactory.getLocalInstance(ctx);
            EvaluGroupCollection evaluGroupCollection = iEvaluGroup.getEvaluGroupCollection(view);
            int size2 = evaluGroupCollection.size();
            for (int i = 0; i < size2; ++i) {
                EvaluGroupInfo evaluGroupInfo = evaluGroupCollection.get(i);
                evaluGroupInfo.setSavedTemplateTarget(false);
                iEvaluGroup.update((IObjectPK)new ObjectUuidPK(evaluGroupInfo.getId()), (CoreBaseInfo)evaluGroupInfo);
            }
        }
    }
}

