/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.SumPersonCollection;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumResultCollection;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumResultInfo;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import java.util.Hashtable;

public class SumEvaluResultRankingDataTransmission
extends AbstractDataTransmission {
    boolean isRank = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SumResultFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private String getObStr(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = null;
        SumResultInfo sumResult = new SumResultInfo();
        try {
            String personId = null;
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            obj = hsData.get("Number");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString()));
            obj = hsData.get("Name");
            if (obj == null || "".equals(obj.toString())) {
                throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)obj.toString()));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            if (personColl == null || personColl.size() <= 0) {
                throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
            }
            personId = personColl.get(0).getId().toString();
            filterInfo = new FilterInfo();
            viewInfo = new EntityViewInfo();
            String solutionID = (String)this.getContextParameter("solutionID");
            filterInfo.getFilterItems().add(new FilterItemInfo("SumSolution.id", (Object)solutionID));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            viewInfo.setFilter(filterInfo);
            selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            SumPersonCollection coll = SumPersonFactory.getLocalInstance(ctx).getSumPersonCollection(viewInfo);
            SumPersonInfo objectInfo = null;
            if (coll == null || coll.size() != 1) {
                throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
            }
            objectInfo = coll.get(0);
            sumResult.setSumPerson(objectInfo);
            String spID = (String)this.getContextParameter("solutionID");
            SumSolutionInfo spinfoInfo = SumSolutionFactory.getLocalInstance(ctx).getSumSolutionInfo((IObjectPK)new ObjectUuidPK(spID));
            sumResult.getSumPerson().setSumSolution(spinfoInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return sumResult;
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (this.isSltImportUpdate()) {
            SumResultInfo info = (SumResultInfo)coreBaseInfo;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String solutionID = (String)this.getContextParameter("solutionID");
            filter.getFilterItems().add(new FilterItemInfo("SumPerson.sumSolution", (Object)solutionID));
            filter.getFilterItems().add(new FilterItemInfo("SumPerson.id", (Object)info.getSumPerson().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("audited"));
            sic.add(new SelectorItemInfo("ranking"));
            SumResultCollection coll = null;
            try {
                coll = SumResultFactory.getLocalInstance(ctx).getSumResultCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (coll != null && coll.size() > 0) {
                boolean flag = coll.get(0).isAudited();
                String rankingName = coll.get(0).getRanking();
                if (flag && UIRuleUtil.isNotNull((String)rankingName)) {
                    info.setRanking(rankingName);
                }
                info.setId(coll.get(0).getId());
            }
        }
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }
}

