/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.ISumItem;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.app.AbstractSumItemControllerBean;
import com.kingdee.eas.hr.perf.app.ISumCalculator;
import org.apache.log4j.Logger;

public class SumItemControllerBean
extends AbstractSumItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SumItemControllerBean");
    private static final long serialVersionUID = -61166L;

    @Override
    protected void _calculate(Context ctx, IObjectCollection sumItems, IObjectValue solution, String tableName) throws BOSException, EASBizException {
        SumItemCollection coll = (SumItemCollection)sumItems;
        SumItemInfo sumItem = null;
        ISumCalculator calculator = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            sumItem = coll.get(i);
            try {
                if ("com.kingdee.eas.hr.perf.client.SumPropertyItemUI".equals(sumItem.getCalculator())) continue;
                calculator = (ISumCalculator)Class.forName(sumItem.getCalculator()).newInstance();
                calculator.calculate(ctx, sumItem, (SumSolutionInfo)solution, tableName);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)sumItem, (Throwable)ex);
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
        }
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws EvaluResultException, EASBizException, BOSException {
        SumItemInfo info = (SumItemInfo)model;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        ISumItem iSumItem = SumItemFactory.getLocalInstance(ctx);
        SumItemCollection coll = null;
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)info.getSumSolution().getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        viewInfo.setFilter(filter);
        coll = iSumItem.getSumItemCollection(viewInfo);
        if (coll != null && coll.size() > 0 && (info.getId() == null || coll.get(0).getId() != null && info.getId() != null && !coll.get(0).getId().toString().equals(info.getId().toString()))) {
            throw new EvaluResultException(EvaluResultException.ITEM_NUMBER_DEMP);
        }
        filter = new FilterInfo();
        viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)info.getSumSolution().getId()));
        filter.getFilterItems().add(new FilterItemInfo("title", (Object)info.getTitle()));
        viewInfo.setFilter(filter);
        coll = null;
        coll = iSumItem.getSumItemCollection(viewInfo);
        if (coll != null && coll.size() > 0 && (info.getId() == null || coll.get(0).getId() != null && info.getId() != null && !coll.get(0).getId().toString().equals(info.getId().toString()))) {
            throw new EvaluResultException(EvaluResultException.ITEM_NAME_DEMP);
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }
}

