/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.GradeDealModeEnum;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.app.ISumCalculator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;

public class SumOrgNodeScore
implements ISumCalculator {
    @Override
    public void calculate(Context ctx, SumItemInfo sumItem, SumSolutionInfo solution, String tableName) throws EASBizException, BOSException {
        String solutionPeriodID = null;
        String evaluObjectID = null;
        String evalWorkFlowID = null;
        String evaluNodeID = null;
        HashMap map = null;
        try {
            map = PFXMLBean.TransXMLToMap(sumItem.getSumDetail());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        if (map != null) {
            solutionPeriodID = (String)map.get("solutionPeriodID");
            evaluObjectID = (String)map.get("evaluObjectID");
            evalWorkFlowID = (String)map.get("evalWorkFlowID");
            evaluNodeID = (String)map.get("evaluNodeID");
        }
        if (solutionPeriodID == null || evaluNodeID == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.minGrade"));
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        BigDecimal evalMaxGrade = spInfo.getEvaluSolution().getGradeMode().getMaxGrade();
        BigDecimal evalminGrade = spInfo.getEvaluSolution().getGradeMode().getMinGrade();
        BigDecimal sumMaxGrade = solution.getGradeMode().getMaxGrade();
        BigDecimal sumMinGrade = solution.getGradeMode().getMinGrade();
        boolean isConvert = GradeDealModeEnum.UNITY.equals((Object)solution.getGradeDealMode());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(tableName);
        sb.append(" SET ");
        sb.append(sumItem.getNumber());
        sb.append(" = ");
        if (isConvert) {
            sb.append("(SELECT ((n.FNodeScore-?)/?)*?+? ");
        } else {
            sb.append("(SELECT n.FNodeScore ");
        }
        Object[] params = null;
        if (StringUtils.isEmpty((String)evaluObjectID)) {
            sb.append(" from T_PF_SumPerson p \n");
            sb.append(" inner join T_PF_EvaluObject obj on obj.FObjectID = p.FAdminOrgUnitID \n");
            sb.append(" inner join T_PF_EvaluResult r on r.FEvaluObjectID = obj.FID \n");
            sb.append(" inner join T_PF_NodeProcesser n ON n.FEvaluResultID = r.FID");
            sb.append(" WHERE r.FSolutionPeriodID = ? and n.FEvaluNodeID = ? and ");
            sb.append(tableName);
            sb.append(".FID = p.FID )");
            params = isConvert ? new Object[]{evalminGrade, evalMaxGrade.subtract(evalminGrade), sumMaxGrade.subtract(sumMinGrade), sumMinGrade, solutionPeriodID, evaluNodeID} : new Object[]{solutionPeriodID, evaluNodeID};
        } else {
            sb.append(" FROM T_PF_NodeProcesser n INNER JOIN T_PF_EvaluResult r ON n.FEvaluResultID = r.FID");
            sb.append(" WHERE r.FEvaluObjectID = ? and r.FSolutionPeriodID = ? and n.FEvaluNodeID = ?)");
            params = isConvert ? new Object[]{evalminGrade, evalMaxGrade.subtract(evalminGrade), sumMaxGrade.subtract(sumMinGrade), sumMinGrade, evaluObjectID, solutionPeriodID, evaluNodeID} : new Object[]{evaluObjectID, solutionPeriodID, evaluNodeID};
        }
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }
}

