/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;

public class SumPersonAssessUnitTransmission
extends AbstractDataTransmission {
    private static final String RES = "com.kingdee.eas.hr.perf.PerfResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SumPersonFactory.getLocalInstance(ctx);
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.validateImportData(hsData);
        SumSolutionInfo sumSolution = this.getCurrentSumSolution();
        if (sumSolution != null && sumSolution.getId() != null) {
            StringBuffer oql = new StringBuffer();
            oql.append("select id,name,number,sumSolution.id,person.number,person.id,assessUnit.id,assessUnit.name,assessUnit.number,assessUnit.displayName where ");
            oql.append("sumSolution.id = '");
            oql.append(sumSolution.getId().toString());
            oql.append("' and person.number='");
            oql.append(hsData.get("number").toString());
            oql.append("'");
            boolean isPerson = true;
            try {
                SumPersonInfo sumPerson = (SumPersonInfo)this.getController(ctx).getValue(oql.toString());
                if (sumPerson == null) {
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"notFoundSumPerson"), hsData.get("number"), hsData.get("evaluObject")));
                }
                isPerson = false;
                if (hsData.get("Pnumber") == null || StringUtils.isEmpty((String)hsData.get("Pnumber").toString())) {
                    sumPerson.setAssessUnit(null);
                } else {
                    oql = new StringBuffer();
                    oql.append("select id,name,number where number='");
                    oql.append(hsData.get("Pnumber"));
                    oql.append("'");
                    AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getValue(oql.toString());
                    if (adminOrgUnit == null) {
                        throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"notFoundAdminOrgUnit"), hsData.get("Pnumber"), hsData.get("perfO")));
                    }
                    sumPerson.setAssessUnit(adminOrgUnit);
                }
                return sumPerson;
            }
            catch (ObjectNotFoundException e) {
                if (isPerson) {
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"notFoundSumPerson"), hsData.get("number"), hsData.get("evaluObject")));
                }
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"notFoundAdminOrgUnit"), hsData.get("Pnumber"), hsData.get("perfO")));
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        throw new TaskExternalException(EASResource.getString((String)RES, (String)"notFoundSumSolution"));
    }

    private void validateImportData(Hashtable hsData) throws TaskExternalException {
        if (hsData.get("number") == null || StringUtils.isEmpty((String)hsData.get("number").toString().trim())) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"empNumberCouldNotBeNull"));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("number", rs.getString("person.number"));
            result.put("evaluObject", rs.getString("person.name"));
            if (rs.getString("assessUnit.number") != null) {
                result.put("Pnumber", rs.getString("assessUnit.number"));
            }
            if (rs.getString("assessUnit.name") != null) {
                result.put("perfO", rs.getString("assessUnit.name"));
            }
            if (rs.getString("adminOrgUnit.number") != null) {
                result.put("orgNumber", rs.getString("adminOrgUnit.number"));
            }
            if (rs.getString("adminOrgUnit.displayName") != null) {
                result.put("orgName", rs.getString("adminOrgUnit.displayName"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return (String)this.getContextParameter().get("queryInfo");
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        try {
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)this.getCurrentSumSolution().getId()));
        }
        catch (TaskExternalException e) {
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)"nodata"));
        }
        return filter;
    }

    private SumSolutionInfo getCurrentSumSolution() throws TaskExternalException {
        SumSolutionInfo sumSolutionInfo = (SumSolutionInfo)this.getContextParameter().get("sumSolution");
        if (sumSolutionInfo == null) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"notFoundSumSolution"));
        }
        return sumSolutionInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo != null && coreBaseInfo instanceof SumPersonInfo) {
            try {
                this.getController(ctx).submit(coreBaseInfo);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }
}

