/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.GradeDealModeEnum;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.app.ISumCalculator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SumPersonNodeScore
implements ISumCalculator {
    private static final Logger logger = CoreUIObject.getLogger(SumPersonNodeScore.class);

    @Override
    public void calculate(Context ctx, SumItemInfo sumItem, SumSolutionInfo solution, String tableName) throws EASBizException, BOSException {
        Object[] params;
        StringBuffer sb;
        block25: {
            boolean isConvert;
            BigDecimal sumMinGrade;
            BigDecimal sumMaxGrade;
            BigDecimal evalminGrade;
            BigDecimal evalMaxGrade;
            Integer nodeLevel;
            String evalWorkFlowID;
            String evaluObjectID;
            block24: {
                String solutionPeriodID = null;
                evaluObjectID = null;
                evalWorkFlowID = null;
                nodeLevel = null;
                HashMap itemMap = null;
                HashMap map = null;
                try {
                    map = PFXMLBean.TransXMLToMap(sumItem.getSumDetail());
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage(), e.getCause());
                }
                if (map != null) {
                    solutionPeriodID = (String)map.get("solutionPeriodID");
                    if (map.get("evaluObjectID") != null) {
                        evaluObjectID = (String)map.get("evaluObjectID");
                    }
                    if (evaluObjectID != null) {
                        evalWorkFlowID = (String)map.get("evalWorkFlowID");
                        nodeLevel = new Integer(map.get("nodeLevel").toString());
                    } else {
                        itemMap = (HashMap)map.get("item");
                    }
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("evaluSolution.id"));
                sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.id"));
                sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.maxGrade"));
                sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.minGrade"));
                sic.add(new SelectorItemInfo("evaluSolution.deduction"));
                sic.add(new SelectorItemInfo("evaluSolution.totalScore"));
                sic.add(new SelectorItemInfo("evaluSolution.evaluRule.ruleMode"));
                SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
                evalMaxGrade = null;
                evalminGrade = null;
                if (spInfo.getEvaluSolution().getTargetGradeModeLink() != null) {
                    evalMaxGrade = spInfo.getEvaluSolution().getTargetGradeModeLink().getMaxGrade();
                    evalminGrade = spInfo.getEvaluSolution().getTargetGradeModeLink().getMinGrade();
                    if (evalminGrade == null || evalminGrade.equals(new BigDecimal("0"))) {
                        evalminGrade = new BigDecimal("1");
                        evalMaxGrade = evalMaxGrade.add(new BigDecimal("1"));
                    }
                } else if (spInfo.getEvaluSolution().isDeduction()) {
                    BigDecimal min = new BigDecimal("-1");
                    evalMaxGrade = spInfo.getEvaluSolution().getTotalScore();
                    evalminGrade = min.multiply(spInfo.getEvaluSolution().getTotalScore());
                } else {
                    evalMaxGrade = spInfo.getEvaluSolution().getTotalScore();
                    evalminGrade = new BigDecimal("1");
                    evalMaxGrade = evalMaxGrade.add(new BigDecimal("1"));
                }
                sumMaxGrade = solution.getGradeMode().getMaxGrade();
                sumMinGrade = solution.getGradeMode().getMinGrade();
                if (sumMinGrade == null || sumMinGrade.equals(new BigDecimal("0"))) {
                    sumMinGrade = new BigDecimal("1");
                    sumMaxGrade = sumMaxGrade.add(new BigDecimal("1"));
                }
                isConvert = GradeDealModeEnum.UNITY.equals((Object)solution.getGradeDealMode());
                sb = new StringBuffer();
                sb.append("UPDATE ");
                sb.append(tableName);
                sb.append(" SET ");
                sb.append(sumItem.getNumber());
                sb.append(" = ");
                params = null;
                if (evaluObjectID != null) break block24;
                String sql = null;
                Connection conn = null;
                PreparedStatement pstmt = null;
                if (isConvert) {
                    sb.append(" (SELECT (((to_number(sum(nodeProcesser.FNodeScore*evalnode.FWeight))/to_number(sum(evalnode.FWeight)))-?)/?)*?+?");
                } else {
                    sb.append(" (SELECT (to_number(sum(nodeProcesser.FNodeScore*evalnode.FWeight))/to_number(sum(evalnode.FWeight)))");
                }
                sb.append(" FROM T_PF_sumPerson sPerson");
                sb.append(" INNER JOIN T_PF_EvaluObject eObject ON sPerson.FPersonID = eObject.FObjectID");
                sb.append(" INNER JOIN T_PF_EvaluResult result ON eObject.FID = result.FEvaluObjectID");
                sb.append(" INNER JOIN T_PF_NodeProcesser nodeProcesser ON result.FID = nodeProcesser.FEvaluResultID");
                sb.append(" INNER JOIN T_PF_EvaluNode evalnode ON nodeProcesser.FEvaluNodeID = evalnode.FID");
                sb.append(" INNER JOIN T_PF_EvalWorkFlow  flow ON evalnode.FEvalWorkFlowID = flow.FID");
                sb.append(" WHERE evalnode.FEvalWorkFlowID=? AND evalnode.FnodeLevel=? AND evalnode.FWeight IS NOT NULL AND nodeProcesser.FNodeScore IS NOT NULL  AND evalnode.FWeight <> 0 AND nodeProcesser.FNodeScore <> 0 ");
                sb.append(" AND ");
                sb.append(tableName);
                sb.append(".FID = sPerson.FID");
                sb.append(" GROUP BY result.FID,evalnode.FnodeLevel)");
                sb.append(" WHERE ");
                sb.append(tableName);
                sb.append(".FID IN(");
                sb.append(" SELECT sumPerson.FID FROM T_PF_SumPerson sumPerson");
                sb.append(" INNER JOIN T_PF_EvaluObject evaluObject ON sumPerson.FPersonID=evaluObject.FObjectID");
                sb.append(" INNER JOIN T_PF_EvalWFObjects flowObject ON flowObject.FEvaluObjectID = evaluObject.FID");
                sb.append(" WHERE  sumPerson.FID IS NOT NULL AND sumPerson.FPersonID IS NOT NULL AND  flowObject.FEvalWorkFlowID = ? AND FSumSolutionID = ?  ");
                sb.append(")");
                sql = sb.toString();
                Iterator iterator = itemMap.keySet().iterator();
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    pstmt = conn.prepareStatement(sql);
                    String flowID = null;
                    while (iterator.hasNext()) {
                        if (isConvert) {
                            pstmt.setBigDecimal(1, evalminGrade);
                            pstmt.setBigDecimal(2, evalMaxGrade.subtract(evalminGrade));
                            pstmt.setBigDecimal(3, sumMaxGrade.subtract(sumMinGrade));
                            pstmt.setBigDecimal(4, sumMinGrade);
                            flowID = iterator.next().toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)flowID);
                            pstmt.setInt(6, Integer.parseInt(itemMap.get(flowID).toString()));
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)flowID);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)solution.getId().toString());
                        } else {
                            flowID = iterator.next().toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)flowID);
                            pstmt.setInt(2, Integer.parseInt(itemMap.get(flowID).toString()));
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)flowID);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)solution.getId().toString());
                        }
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)("SumPersonNodeScore.java sql is:" + sql + " param is:" + itemMap.toString()), (Throwable)exc);
                        throw new BOSException("SumPersonNodeScore.java execute exception : " + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block25;
            }
            if (isConvert) {
                sb.append(" (SELECT (((to_number(sum(nodeProcesser.FNodeScore*evalnode.FWeight))/to_number(sum(evalnode.FWeight)))-?)/?)*?+?");
            } else {
                sb.append(" (SELECT (to_number(sum(nodeProcesser.FNodeScore*evalnode.FWeight))/to_number(sum(evalnode.FWeight)))");
            }
            sb.append(" FROM T_PF_EvaluResult result");
            sb.append(" INNER JOIN T_PF_NodeProcesser nodeProcesser ON result.FID = nodeProcesser.FEvaluResultID");
            sb.append(" INNER JOIN T_PF_EvaluNode evalnode ON nodeProcesser.FEvaluNodeID = evalnode.FID");
            sb.append(" WHERE result.FEvaluObjectID=? AND evalnode.FEvalWorkFlowID=? AND evalnode.FnodeLevel=? ");
            sb.append(" AND evalnode.FWeight IS NOT NULL AND evalnode.FWeight <> 0 ) ");
            params = isConvert ? new Object[]{evalminGrade, evalMaxGrade.subtract(evalminGrade), sumMaxGrade.subtract(sumMinGrade), sumMinGrade, evaluObjectID, evalWorkFlowID, nodeLevel} : new Object[]{evaluObjectID, evalWorkFlowID, nodeLevel};
        }
        if (params != null) {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
    }
}

