/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.IRankConvertRule;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumResultInfo;
import com.kingdee.eas.hr.perf.app.AbstractSumResultControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class SumResultControllerBean
extends AbstractSumResultControllerBean {
    private static final long serialVersionUID = -61166L;
    private static final String TABLE_NAME = " T_PF_SumResult ";

    @Override
    protected void _audit(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_PF_SumResult SET FAudited = ?,FAuditDate = ?,FAuditorID = ? WHERE FID IN ( ");
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = super.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            stmt.setInt(1, 1);
            stmt.setTimestamp(2, new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime()));
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)3, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
            for (int i = 0; i < size; ++i) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)(i + 4), (String)((String)idList.get(i)));
            }
            String logMessage = null;
            IObjectPK logPK = null;
            for (int i = 0; i < size; ++i) {
                logMessage = this._getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SumResultFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)"perf_sumResult_audit");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
            stmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _unAudit(Context ctx, List idList) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_PF_SumResult SET FAudited = ?,FAuditDate = ?,FAuditorID = ? WHERE FID IN ( ");
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = super.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            stmt.setInt(1, 0);
            stmt.setDate(2, null);
            stmt.setString(3, null);
            stmt.setString(4, null);
            for (int i = 0; i < size; ++i) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)(i + 4), (String)((String)idList.get(i)));
            }
            String logMessage = null;
            IObjectPK logPK = null;
            for (int i = 0; i < size; ++i) {
                logMessage = this._getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SumResultFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)"perf_sumResult_unAudit");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
            stmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException();
                catch (EASBizException e) {
                    throw new BOSException();
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _convertModfiedSocreToRank(Context ctx, String[] idList, String ruleID) throws BOSException, EASBizException {
        this.convertScoreToRank(ctx, idList, ruleID, "FModifyScore");
    }

    @Override
    protected void _convertTotalScoreToRank(Context ctx, String[] idList, String ruelID) throws BOSException, EASBizException {
        this.convertScoreToRank(ctx, idList, ruelID, "FScore");
    }

    private void convertScoreToRank(Context ctx, String[] idList, String convertRuleID, String colName) throws BOSException, EASBizException {
        IRankConvertRule iRankConvertRule = RankConvertRuleFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.minScore"));
        sic.add(new SelectorItemInfo("entries.maxScore"));
        sic.add(new SelectorItemInfo("entries.minScoreCondition"));
        sic.add(new SelectorItemInfo("entries.maxScoreCondition"));
        sic.add(new SelectorItemInfo("entries.rank.id"));
        RankConvertRuleInfo rule = (RankConvertRuleInfo)iRankConvertRule.getValue((IObjectPK)new ObjectUuidPK(convertRuleID), sic);
        RankConvertRuleDetailCollection coll = rule.getEntries();
        if (coll != null && coll.size() > 0) {
            RankConvertRuleDetailInfo detail = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                StringBuffer header = new StringBuffer();
                header.append("UPDATE ");
                header.append(TABLE_NAME);
                header.append(" SET FRankID = ? , FRankConvertRuleID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        header.append(" , ");
                    }
                    header.append("'");
                    header.append(idList[k]);
                    header.append("'");
                }
                header.append(" ) ) and ");
                conn = this.getConnection(ctx);
                String headerSql = header.toString();
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    detail = coll.get(i);
                    StringBuffer sql = new StringBuffer();
                    sql.append(headerSql);
                    sql.append(" ( ");
                    sql.append(" ? ");
                    sql.append(this.transForSql(detail.getMinScoreCondition()));
                    sql.append(colName);
                    sql.append(" ) and ");
                    sql.append(" ( ");
                    sql.append(colName);
                    sql.append(this.transForSql(detail.getMaxScoreCondition()));
                    sql.append(" ? ) ");
                    pstmt = conn.prepareStatement(sql.toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)detail.getRank().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                    pstmt.setBigDecimal(3, detail.getMinScore());
                    pstmt.setBigDecimal(4, detail.getMaxScore());
                    pstmt.execute();
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer nullSQL = new StringBuffer();
                nullSQL.append("UPDATE");
                nullSQL.append(TABLE_NAME);
                nullSQL.append(" SET FRankID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        nullSQL.append(" , ");
                    }
                    nullSQL.append("'");
                    nullSQL.append(idList[k]);
                    nullSQL.append("'");
                }
                nullSQL.append(" ) ) and ");
                nullSQL.append(colName);
                nullSQL.append(" IS NULL ");
                pstmt = conn.prepareStatement(nullSQL.toString());
                pstmt.setString(1, null);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
                String maxRankID = null;
                String minRankID = null;
                BigDecimal maxGrade = rule.getGradeMode().getMaxGrade();
                BigDecimal minGrade = rule.getGradeMode().getMinGrade();
                int n2 = coll.size();
                for (int i = 0; i < n2; ++i) {
                    detail = coll.get(i);
                    if (detail.getMinScoreCondition().equals("\u2264")) {
                        if (detail.getMaxScoreCondition().equals("\u2264")) {
                            if (maxGrade.compareTo(detail.getMinScore()) >= 0 && maxGrade.compareTo(detail.getMaxScore()) <= 0) {
                                maxRankID = detail.getRank().getId().toString();
                            }
                            if (minGrade.compareTo(detail.getMinScore()) < 0 || minGrade.compareTo(detail.getMaxScore()) > 0) continue;
                            minRankID = detail.getRank().getId().toString();
                            continue;
                        }
                        if (maxGrade.compareTo(detail.getMinScore()) >= 0 && maxGrade.compareTo(detail.getMaxScore()) < 0) {
                            maxRankID = detail.getRank().getId().toString();
                        }
                        if (minGrade.compareTo(detail.getMinScore()) < 0 || minGrade.compareTo(detail.getMaxScore()) >= 0) continue;
                        minRankID = detail.getRank().getId().toString();
                        continue;
                    }
                    if (detail.getMaxScoreCondition().equals("\u2264")) {
                        if (maxGrade.compareTo(detail.getMinScore()) > 0 && maxGrade.compareTo(detail.getMaxScore()) <= 0) {
                            maxRankID = detail.getRank().getId().toString();
                        }
                        if (minGrade.compareTo(detail.getMinScore()) <= 0 || minGrade.compareTo(detail.getMaxScore()) > 0) continue;
                        minRankID = detail.getRank().getId().toString();
                        continue;
                    }
                    if (maxGrade.compareTo(detail.getMinScore()) > 0 && maxGrade.compareTo(detail.getMaxScore()) < 0) {
                        maxRankID = detail.getRank().getId().toString();
                    }
                    if (minGrade.compareTo(detail.getMinScore()) <= 0 || minGrade.compareTo(detail.getMaxScore()) >= 0) continue;
                    minRankID = detail.getRank().getId().toString();
                }
                StringBuffer sqlOutMax = new StringBuffer();
                sqlOutMax.append(headerSql);
                sqlOutMax.append(" ( ");
                sqlOutMax.append(colName);
                sqlOutMax.append(" > ");
                sqlOutMax.append(" ? ");
                sqlOutMax.append(" ) ");
                pstmt = conn.prepareStatement(sqlOutMax.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)maxRankID);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                pstmt.setBigDecimal(3, maxGrade);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
                StringBuffer sqlOutMin = new StringBuffer();
                sqlOutMin.append(headerSql);
                sqlOutMin.append(" ( ");
                sqlOutMin.append(colName);
                sqlOutMin.append(" < ");
                sqlOutMin.append(" ? ");
                sqlOutMin.append(" ) ");
                pstmt = conn.prepareStatement(sqlOutMin.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)minRankID);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                pstmt.setBigDecimal(3, minGrade);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
            }
            catch (SQLException ex) {
                try {
                    throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION, ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String transForSql(String condition) {
        if (condition.equals("\u2264")) {
            return " <= ";
        }
        return " < ";
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sumPerson.person.name"));
        SumResultInfo sumResultInfo = (SumResultInfo)this._getValue(ctx, pk, sic);
        return sumResultInfo.getLogInfo();
    }
}

