/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFactory;
import com.kingdee.eas.hr.perf.ISumItem;
import com.kingdee.eas.hr.perf.PerfFormuleException;
import com.kingdee.eas.hr.perf.SumExpInfo;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumResultInfo;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.SumStateEnum;
import com.kingdee.eas.hr.perf.app.AbstractSumSolutionControllerBean;
import com.kingdee.eas.hr.perf.app.formula.KScriptToKSQL;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SumSolutionControllerBean
extends AbstractSumSolutionControllerBean {
    private static final long serialVersionUID = -61166L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SumSolutionControllerBean");
    private static final int MAX_SIZE = 50;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SumSolutionInfo info = (SumSolutionInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID));
        }
        super._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _calulate(Context ctx, String id) throws BOSException, EASBizException {
        SumSolutionInfo solution = this.getSumSolutionInfoById(ctx, id);
        SumItemCollection items = this.getSumItems(ctx, id);
        if (items == null) {
            return;
        }
        String tableName = null;
        Connection conn = super.getConnection(ctx);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = this.getTempTable(ctx, items, true, conn, pool);
            this.initTempTable(ctx, solution, tableName);
            ISumItem iSumItem = SumItemFactory.getLocalInstance(ctx);
            iSumItem.calculate(items, solution, tableName);
            String ksql = solution.getSumExp().getSql();
            if (ksql == null || "".equals(ksql.trim())) {
                throw new PerfFormuleException(PerfFormuleException.FORMULAITEM_NOTIN_SCHEMEITEMS);
            }
            ksql = ksql.replaceAll("@", tableName);
            logger.info((Object)("calculate sum solution :" + solution.getNumber() + ksql));
            StringTokenizer tokens = new StringTokenizer(ksql, ";");
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                while (tokens.hasMoreTokens()) {
                    stmt.execute(tokens.nextToken());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new PerfFormuleException(PerfFormuleException.FORMULAITEM_NOTIN_SCHEMEITEMS, ex);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            this.generateErrorInfo(ctx, items, tableName);
            this.generateDetailInfo(ctx, tableName, items);
            this.generateSumResult(ctx, id);
            this.transTempResult(ctx, tableName, items);
            solution.setState(SumStateEnum.DONE);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("state"));
            SumSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
            this.dealLogInfo(ctx, solution, "perf_SumSolution_calculate");
        }
        finally {
            if (tableName != null) {
                try {
                    pool.releaseTable(tableName);
                    SQLUtils.cleanup((Connection)conn);
                }
                catch (Exception ex) {
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
            }
        }
    }

    private void generateDetailInfo(Context ctx, String tableName, SumItemCollection items) throws BOSException {
        String sqlTemplete = "update " + tableName + " set FDetail#  =  CONCAT( FDetail#,  CONCAT('@=' ,CONCAT(TOCHAR(@), ';'))) WHERE @ IS NOT NULL";
        String sql = null;
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            sql = sqlTemplete.replaceAll("@", items.get(i).getNumber());
            sql = sql.replaceAll("#", "" + (i + 50) / 50);
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void transTempResult(Context ctx, String tableName, SumItemCollection items) throws BOSException {
        String sqlTemplete = "UPDATE T_PF_SumResult SET @ = (SELECT temp.@ FROM " + tableName + " temp WHERE temp.FID = T_PF_SumResult.FSumPersonID ) WHERE T_PF_SumResult.FSumPersonID IN (SELECT FID FROM " + tableName + " )";
        DbUtil.execute((Context)ctx, (String)sqlTemplete.replaceAll("@", "FScore"));
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PF_SumResult SET @ = ");
        sql.append("(SELECT ");
        int count = (items.size() + 50 - 1) / 50;
        for (int i = 1; i <= count; ++i) {
            sql.append("temp.@");
            sql.append(i);
            sql.append("||");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" FROM ");
        sql.append(tableName);
        sql.append(" temp WHERE temp.FID = T_PF_SumResult.FSumPersonID ) WHERE T_PF_SumResult.FSumPersonID IN (SELECT FID FROM ");
        sql.append(tableName);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString().replaceAll("@", "FError"));
        DbUtil.execute((Context)ctx, (String)sql.toString().replaceAll("@", "FDetail"));
    }

    private void generateSumResult(Context ctx, String solutionID) throws BOSException {
        String clear = "DELETE FROM T_PF_SumResult WHERE FSumPersonID IN ( SELECT FID FROM T_PF_SumPerson WHERE FSumSolutionID = ?)";
        String sql = "SELECT FID FROM T_PF_SumPerson WHERE FSumSolutionID = ?";
        Connection conn = null;
        PreparedStatement clearPstmt = null;
        PreparedStatement pstmtPerson = null;
        PreparedStatement pstmt = null;
        String insert = "INSERT INTO T_PF_SumResult (FID,FSumPersonID,FModified,FAudited) VALUES (?,?,?,?)";
        try {
            conn = super.getConnection(ctx);
            clearPstmt = conn.prepareStatement(clear);
            DbUtil.prepareVarcharParam((PreparedStatement)clearPstmt, (int)1, (String)solutionID);
            clearPstmt.execute();
            pstmtPerson = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmtPerson, (int)1, (String)solutionID);
            ResultSet result = pstmtPerson.executeQuery();
            pstmt = conn.prepareStatement(insert);
            BOSObjectType bosType = new SumResultInfo().getBOSType();
            while (result.next()) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)bosType).toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)result.getString("FID"));
                pstmt.setInt(3, 0);
                pstmt.setInt(4, 0);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(clearPstmt);
                SQLUtils.cleanup(pstmtPerson);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)clearPstmt);
        SQLUtils.cleanup((Statement)pstmtPerson);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet _previewCalculate(Context ctx, String id) throws BOSException, EASBizException {
        SumSolutionInfo solution = this.getSumSolutionInfoById(ctx, id);
        SumItemCollection items = this.getSumItems(ctx, id);
        String tableName = null;
        IRowSet rowSet = null;
        Connection conn = super.getConnection(ctx);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = this.getTempTable(ctx, items, false, conn, pool);
            this.initTempTable(ctx, solution, tableName);
            ISumItem iSumItem = SumItemFactory.getLocalInstance(ctx);
            iSumItem.calculate(items, solution, tableName);
            String ksql = solution.getSumExp().getSql();
            if (ksql == null || "".equals(ksql.trim())) {
                throw new PerfFormuleException(PerfFormuleException.FORMULAITEM_NOTIN_SCHEMEITEMS);
            }
            ksql = ksql.replaceAll("@", tableName);
            logger.debug((Object)("calculate sum solution :" + solution.getNumber() + ksql));
            StringTokenizer tokens = new StringTokenizer(ksql, ";");
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                while (tokens.hasMoreTokens()) {
                    stmt.execute(tokens.nextToken());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new PerfFormuleException(PerfFormuleException.FORMULAITEM_NOTIN_SCHEMEITEMS, ex);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            this.generateErrorInfo(ctx, items, tableName);
            rowSet = this.getTemResult(ctx, tableName, items);
            this.dealLogInfo(ctx, solution, "perf_SumSolution_preview");
        }
        finally {
            if (tableName != null) {
                try {
                    pool.releaseTable(tableName);
                    SQLUtils.cleanup((Connection)conn);
                }
                catch (Exception ex) {
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
            }
        }
        return rowSet;
    }

    private void generateErrorInfo(Context ctx, SumItemCollection items, String tableName) throws BOSException {
        String sqlTemplete = "UPDATE " + tableName + " SET FError# =  CONCAT(FError#,' @ ') WHERE @ IS NULL";
        String sql = null;
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            if (items.get(i).getNumber().startsWith("FITEM000")) continue;
            sql = sqlTemplete.replaceAll("@", items.get(i).getNumber());
            sql = sql.replaceAll("#", "" + (i + 50) / 50);
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private IRowSet getTemResult(Context ctx, String tableName, SumItemCollection items) throws BOSException {
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("SELECT result.FID FID,person.FNumber personNumber , ");
        sql.append("person.FName");
        sql.append(locale);
        sql.append(" personName , ");
        sql.append(" position.FName");
        sql.append(locale);
        sql.append(" positionName , ");
        sql.append(" job.FName");
        sql.append(locale);
        sql.append(" job , ");
        sql.append(" sumPerson.FAdminOrgUnit");
        sql.append(locale);
        sql.append(" orgName ,");
        sql.append("result.FScore fScore , ");
        String itemNumber = null;
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            sql.append("result.");
            itemNumber = items.get(i).getNumber();
            sql.append(itemNumber);
            sql.append(" ");
            sql.append(itemNumber);
            sql.append(" , ");
        }
        int count = (items.size() + 50 - 1) / 50;
        for (int i = 1; i <= count; ++i) {
            sql.append("result.FError");
            sql.append(i);
            sql.append("||");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" fError ");
        sql.append(" FROM ");
        sql.append(tableName);
        sql.append(" result ");
        sql.append(" INNER JOIN T_PF_SumPerson sumPerson on sumPerson.FID = result.FID");
        sql.append(" INNER JOIN T_BD_Person person on sumPerson.FPersonID = person.FID");
        sql.append(" INNER JOIN T_ORG_Position position on sumPerson.FPositionID = position.FID");
        sql.append(" LEFT JOIN T_ORG_Job job on job.FID=position.FJobID");
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private SumSolutionInfo getSumSolutionInfoById(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("gradeMode.*"));
        sic.add(new SelectorItemInfo("sumExp.id"));
        sic.add(new SelectorItemInfo("sumExp.sql"));
        sic.add(new SelectorItemInfo("gradeDealMode"));
        SumSolutionInfo solution = SumSolutionFactory.getLocalInstance(ctx).getSumSolutionInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return solution;
    }

    private void initTempTable(Context ctx, SumSolutionInfo solution, String tableName) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sb.append("insert ");
        sb.append(tableName);
        sb.append(" (FID,FITEM0001,FITEM0002,FITEM0003,FITEM0004,FITEM0005,FITEM0006,FITEM0007) ");
        sb.append(" select sp.FID");
        sb.append(",");
        sb.append("p.Fnumber");
        sb.append(",");
        sb.append("p.Fname_");
        sb.append(locale);
        sb.append(",");
        sb.append("pos.Fname_");
        sb.append(locale);
        sb.append(",");
        sb.append("jg.Fname_");
        sb.append(locale);
        sb.append(",");
        sb.append("sp.FAdminOrgUnit_");
        sb.append(locale);
        sb.append(",");
        sb.append("admin.FDisPlayName_");
        sb.append(locale);
        sb.append(",");
        sb.append("job.Fname_");
        sb.append(locale);
        sb.append(" from T_PF_SumPerson  sp");
        sb.append(" inner join T_BD_Person p on p.FID=sp.FPersonID ");
        sb.append(" left join T_HR_PersonPosition pp on pp.FPersonID = p.FID");
        sb.append(" left join T_HR_JobGrade jg on pp.FJobGrade =jg.FID");
        sb.append(" left join T_ORG_Position pos on pos.FID=sp.FPositionID");
        sb.append(" left join T_ORG_Job job on job.FID=pos.FJobID");
        sb.append(" left join T_ORG_Admin admin on admin.FID=sp.FAdminOrgUnitID");
        sb.append(" where sp.FSumSolutionID = ?");
        Object[] params = new Object[]{solution.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    private SumItemCollection getSumItems(Context ctx, String solutionID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("calculator"));
        sic.add(new SelectorItemInfo("sumDetail"));
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        viewInfo.getSorter().add(sorterItem);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)solutionID));
        viewInfo.setFilter(filter);
        SumItemCollection ret = null;
        ret = SumItemFactory.getLocalInstance(ctx).getSumItemCollection(viewInfo);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private String getTempTable(Context ctx, SumItemCollection items, boolean isNeedDetail, Connection conn, TempTablePool pool) throws BOSException {
        StringBuffer sql = new StringBuffer("create table ");
        sql.append("t1");
        sql.append(" (  FID Varchar(44) NOT NULL ,");
        sql.append("   FITEM0001 nvarchar(160),");
        sql.append("   FITEM0002 nvarchar(160),");
        sql.append("   FITEM0003 nvarchar(160),");
        sql.append("   FITEM0004 nvarchar(160),");
        sql.append("   FITEM0005 nvarchar(160),");
        sql.append("   FITEM0006 nvarchar(160),");
        sql.append("   FITEM0007 nvarchar(160),");
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            if (items.get(i).getNumber().startsWith("FITEM000")) continue;
            sql.append(items.get(i).getNumber());
            sql.append(" Decimal(28,10) ");
            sql.append(",");
        }
        sql.append("FScore Decimal(28,10) ,");
        int size = items.size();
        int count = (size + 50 - 1) / 50;
        for (int i = 1; i <= count; ++i) {
            sql.append("FError");
            sql.append(i);
            sql.append(" Nvarchar(2000) DEFAULT ' ',");
            if (!isNeedDetail) continue;
            sql.append("FDetail");
            sql.append(i);
            sql.append(" Nvarchar(2000) DEFAULT ' ',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        String tableName = null;
        try {
            tableName = pool.createTempTable(sql.toString());
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return tableName;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        DataBaseInfo dataBase = this.getDataBaseInfo(ctx, pk);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        if (iCodingRuleManager.isExist((IObjectValue)dataBase, companyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)dataBase, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)dataBase, companyID, dataBase.getNumber());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)pk.toString()));
        SumPersonFactory.getLocalInstance(ctx).delete(filter);
        SumItemFactory.getLocalInstance(ctx).delete(filter);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        int MAX_LEN = 3000;
        String RES = "com.kingdee.eas.hr.perf.PerfResource";
        String result_l1 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l1"));
        String result_l2 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l2"));
        String result_l3 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l3"));
        SumSolutionInfo solution = (SumSolutionInfo)model;
        if (solution.getSumExp().getScript() != null && solution.getSumExp().getScript().length() > 3000) {
            throw new PerfFormuleException(PerfFormuleException.TOO_LONG_SCRIPT);
        }
        if (solution.getId() == null) {
            return super._submit(ctx, model);
        }
        String script = solution.getSumExp().getScript();
        if (script != null && !"".equals(script.trim())) {
            script = script.trim();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)solution.getId().toString()));
            boolean flag = false;
            if (SumItemFactory.getLocalInstance(ctx).exists(filter)) {
                flag = true;
            } else if (!(result_l1.equals(script) || result_l2.equals(script) || result_l3.equals(script))) {
                flag = true;
            }
            if (flag) {
                KScriptToKSQL k2k = new KScriptToKSQL();
                ctx.put((Object)"hr_perf_formual_id", (Object)solution.getId().toString());
                ctx.put((Object)"hr_perf_formual_tableName", (Object)"@");
                ctx.put((Object)"is_platform", (Object)new Boolean(false));
                solution.getSumExp().setSql(k2k.translateScript(ctx, solution.getSumExp().getScript()));
                ctx.remove((Object)"hr_perf_formual_id");
                ctx.remove((Object)"hr_perf_formual_tableName");
                if (solution.getSumExp().getSql() != null && solution.getSumExp().getSql().length() > 3000) {
                    throw new PerfFormuleException(PerfFormuleException.TOO_LONG_SQL);
                }
            }
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _copySolution(Context ctx, IObjectValue solution, IObjectValue assessPeriod, boolean isCopySumExp) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        SumSolutionInfo newSolutionInfo = (SumSolutionInfo)solution;
        AssessPeriodInfo assessPeriodInfo = (AssessPeriodInfo)assessPeriod;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        if (isCopySumExp) {
            sic.add(new SelectorItemInfo("sumExp.*"));
        }
        SumSolutionInfo oldInfo = this.getSumSolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(newSolutionInfo.getId().toString()), sic);
        SumExpInfo sumExpInfo = null;
        if (isCopySumExp) {
            sumExpInfo = oldInfo.getSumExp();
            sumExpInfo.setId(null);
        } else {
            sumExpInfo = newSolutionInfo.getSumExp();
        }
        oldInfo.setId(null);
        oldInfo.setSumExp(sumExpInfo);
        oldInfo.setName(newSolutionInfo.getName());
        oldInfo.setNumber(newSolutionInfo.getNumber());
        oldInfo.setState(SumStateEnum.TODO);
        oldInfo.setAssessPeriod(assessPeriodInfo);
        IObjectPK pk = this._submit(ctx, (IObjectValue)oldInfo);
        oldInfo.setId(BOSUuid.read((String)pk.toString()));
        if (isCopySumExp) {
            viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)newSolutionInfo.getId().toString()));
            viewInfo.setFilter(filterInfo);
            SumItemCollection sumItemColl = SumItemFactory.getLocalInstance(ctx).getSumItemCollection(viewInfo);
            IORMappingDAO sumItemDao = ORMappingDAO.getInstance((BOSObjectType)new BOSObjectType("8F0AB68B"), (Context)ctx, (Connection)this.getConnection(ctx));
            SumItemInfo sumItemInfo = null;
            Iterator it = sumItemColl.iterator();
            while (it.hasNext()) {
                sumItemInfo = (SumItemInfo)it.next();
                sumItemInfo.setSumSolution(oldInfo);
                sumItemInfo.setId(BOSUuid.create((String)"8F0AB68B"));
                sumItemDao.addNewBatch((IObjectValue)sumItemInfo);
            }
            sumItemDao.executeBatch();
        }
        viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        StringBuffer sql = new StringBuffer();
        sql.append("select FPersonID from T_PF_SumPerson WHERE FSumSolutionID ='");
        sql.append(newSolutionInfo.getId().toString());
        sql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql.toString(), CompareType.INNER));
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("personDep.id"));
        selector.add(new SelectorItemInfo("personDep.displayName"));
        selector.add(new SelectorItemInfo("primaryPosition.id"));
        PersonPositionCollection coll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
        SumPersonInfo sumPersonInfo = new SumPersonInfo();
        String insertSql = "INSERT INTO T_PF_SumPerson(FID,FSumSolutionID,FPersonID,FPositionID,FAdminOrgUnit_l1,FAdminOrgUnit_l2,FAdminOrgUnit_l3) VALUES(?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        BOSObjectType type = sumPersonInfo.getBOSType();
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(insertSql);
            PersonPositionInfo personPositionInfo = null;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                personPositionInfo = coll.get(i);
                if (personPositionInfo.getPerson() == null || personPositionInfo.getPrimaryPosition() == null || personPositionInfo.getPersonDep() == null) continue;
                pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                pstmt.setString(2, pk.toString());
                pstmt.setString(3, personPositionInfo.getPerson().getId().toString());
                pstmt.setString(4, personPositionInfo.getPrimaryPosition().getId().toString());
                pstmt.setString(5, personPositionInfo.getPersonDep().getDisplayName(LocaleUtils.getLocale((String)"l1")));
                pstmt.setString(6, personPositionInfo.getPersonDep().getDisplayName(LocaleUtils.getLocale((String)"l2")));
                pstmt.setString(7, personPositionInfo.getPersonDep().getDisplayName(LocaleUtils.getLocale((String)"l3")));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SumSolutionInfo info = (SumSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private void dealLogInfo(Context ctx, SumSolutionInfo info, String logItem) throws BOSException, EASBizException {
        String name = null;
        if (!StringUtils.isEmpty((String)info.getName())) {
            name = info.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)EvaluFormSolutionFactory.getLocalInstance(ctx).getType(), null, (String)name, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

