/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.GradeDealModeEnum;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.app.ISumCalculator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SumSynNodeScore
implements ISumCalculator {
    private static final Logger logger = CoreUIObject.getLogger(SumSynNodeScore.class);

    @Override
    public void calculate(Context ctx, SumItemInfo sumItem, SumSolutionInfo solution, String tableName) throws EASBizException, BOSException {
        block21: {
            Object[] params;
            StringBuffer sb;
            boolean isConvert;
            BigDecimal sumMinGrade;
            BigDecimal sumMaxGrade;
            BigDecimal evalminGrade;
            BigDecimal evalMaxGrade;
            boolean isRank;
            Integer nodeLevel;
            String evalWorkFlowID;
            String evaluObjectID;
            block20: {
                String solutionPeriodID = null;
                evaluObjectID = null;
                evalWorkFlowID = null;
                nodeLevel = null;
                HashMap itemMap = null;
                isRank = false;
                HashMap map = null;
                try {
                    map = PFXMLBean.TransXMLToMap(sumItem.getSumDetail());
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage(), e.getCause());
                }
                if (map != null) {
                    solutionPeriodID = (String)map.get("solutionPeriodID");
                    evaluObjectID = (String)map.get("evaluObjectID");
                    isRank = Boolean.valueOf((String)map.get("rank"));
                    if (evaluObjectID != null) {
                        evalWorkFlowID = (String)map.get("evalWorkFlowID");
                        nodeLevel = new Integer(map.get("nodeLevel").toString());
                    } else {
                        itemMap = (HashMap)map.get("item");
                    }
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("solution.id"));
                sic.add(new SelectorItemInfo("solution.gradeMode.id"));
                sic.add(new SelectorItemInfo("solution.gradeMode.maxGrade"));
                sic.add(new SelectorItemInfo("solution.gradeMode.minGrade"));
                SynSolutionPeriodInfo spInfo = SynSolutionPeriodFactory.getLocalInstance(ctx).getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
                evalMaxGrade = spInfo.getSolution().getGradeMode().getMaxGrade();
                evalminGrade = spInfo.getSolution().getGradeMode().getMinGrade();
                sumMaxGrade = solution.getGradeMode().getMaxGrade();
                sumMinGrade = solution.getGradeMode().getMinGrade();
                isConvert = GradeDealModeEnum.UNITY.equals((Object)solution.getGradeDealMode());
                sb = new StringBuffer();
                sb.append("UPDATE ");
                sb.append(tableName);
                sb.append(" SET ");
                sb.append(sumItem.getNumber());
                sb.append(" = ");
                if (isRank) {
                    if (isConvert) {
                        sb.append(" (SELECT ((to_number(avg(rank.FGrade))-?)/?)*?+?");
                    } else {
                        sb.append(" (SELECT to_number(avg(rank.FGrade))");
                    }
                } else if (isConvert) {
                    sb.append(" (SELECT ((to_number(avg(nodeProcesser.FScore))-?)/?)*?+?");
                } else {
                    sb.append(" (SELECT to_number(avg(nodeProcesser.FScore))");
                }
                params = null;
                if (evaluObjectID != null) break block20;
                String sql = null;
                Connection conn = null;
                PreparedStatement pstmt = null;
                sb.append(" FROM T_PF_sumPerson sPerson");
                sb.append(" INNER JOIN T_PF_SynEvaluObject eObject ON sPerson.FPersonID = eObject.FPersonID");
                sb.append(" INNER JOIN T_PF_SYNEVALURESULT result ON eObject.FID = result.FSynObjectID");
                sb.append(" INNER JOIN T_PF_SynNodeProcesser nodeProcesser ON result.FID = nodeProcesser.FEvaluResultID");
                sb.append(" INNER JOIN T_PF_SynFlowNode node ON nodeProcesser.FEvaluNodeID = node.FID");
                sb.append(" INNER JOIN T_PF_SynEvaluFlow  flow ON node.FEvalWorkFlowID = flow.FID");
                if (isRank) {
                    sb.append(" INNER JOIN T_PF_Rank rank ON nodeProcesser.FRankID = rank.FID");
                }
                sb.append(" WHERE node.FEvalWorkFlowID=? AND node.FNodeLevel=?");
                sb.append(" AND ");
                sb.append(tableName);
                sb.append(".FID = sPerson.FID");
                sb.append(" GROUP BY result.FID,node.FNodeLevel)");
                sb.append(" WHERE ");
                sb.append(tableName);
                sb.append(".FID IN(");
                sb.append(" SELECT sumPerson.FID FROM T_PF_SumPerson sumPerson");
                sb.append(" INNER JOIN T_PF_SynEvaluObject evaluObject ON sumPerson.FPersonID=evaluObject.FPersonID");
                sb.append(" INNER JOIN T_PF_SynFlowObject flowObject ON flowObject.FEvaluObjectID = evaluObject.FID");
                sb.append(" WHERE flowObject.FEvalWorkFlowID = ? AND FSumSolutionID = ?");
                sb.append(")");
                sql = sb.toString();
                Iterator iterator = itemMap.keySet().iterator();
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    pstmt = conn.prepareStatement(sql);
                    while (iterator.hasNext()) {
                        String flowID;
                        if (isConvert) {
                            pstmt.setBigDecimal(1, evalminGrade);
                            pstmt.setBigDecimal(2, evalMaxGrade.subtract(evalminGrade));
                            pstmt.setBigDecimal(3, sumMaxGrade.subtract(sumMinGrade));
                            pstmt.setBigDecimal(4, sumMinGrade);
                            flowID = iterator.next().toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)flowID);
                            pstmt.setInt(6, Integer.parseInt(itemMap.get(flowID).toString()));
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)flowID);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)solution.getId().toString());
                        } else {
                            flowID = iterator.next().toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)flowID);
                            pstmt.setInt(2, Integer.parseInt(itemMap.get(flowID).toString()));
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)flowID);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)solution.getId().toString());
                        }
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)("SumSynNodeScore.java sql is:" + sql + " param is:" + itemMap.toString()), (Throwable)exc);
                        throw new BOSException("SumSynNodeScore.java execute exception : " + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block21;
            }
            sb.append(" FROM T_PF_SYNEVALURESULT result");
            sb.append(" INNER JOIN T_PF_SynNodeProcesser nodeProcesser ON result.FID = nodeProcesser.FEvaluResultID");
            sb.append(" INNER JOIN T_PF_SynFlowNode node ON nodeProcesser.FEvaluNodeID = node.FID");
            if (isRank) {
                sb.append(" INNER JOIN T_PF_Rank rank ON nodeProcesser.FRankID = rank.FID");
            }
            sb.append(" WHERE result.FSynObjectID=? AND node.FEvalWorkFlowID=? AND node.FNodeLevel=?)");
            params = isConvert ? new Object[]{evalminGrade, evalMaxGrade.subtract(evalminGrade), sumMaxGrade.subtract(sumMinGrade), sumMinGrade, evaluObjectID, evalWorkFlowID, nodeLevel} : new Object[]{evaluObjectID, evalWorkFlowID, nodeLevel};
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
    }
}

