/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IRank;
import com.kingdee.eas.hr.perf.ISynEvaluObject;
import com.kingdee.eas.hr.perf.ISynEvaluResult;
import com.kingdee.eas.hr.perf.ISynSolutionPeriod;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultCollection;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;

public class SynEvaluResultDataTransmission
extends AbstractDataTransmission {
    private IPerson iPerson = null;
    private ISynEvaluObject iSynEvaluObject = null;
    private ISynSolutionPeriod isp = null;
    private IRank iRank = null;
    private Object obj = null;
    private GradeModeInfo gradeMode = null;
    private boolean isRank = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SynEvaluResultFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                SynEvaluResultInfo info = (SynEvaluResultInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String spID = (String)this.getContextParameter("spID");
                filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
                filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)info.getMdObject().getId().toString()));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                ISynEvaluResult iSynEvaluResult = (ISynEvaluResult)this.getController(ctx);
                SynEvaluResultCollection coll = iSynEvaluResult.getSynEvaluResultCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        SynEvaluResultInfo ret;
        block19: {
            ret = new SynEvaluResultInfo();
            try {
                if (this.iPerson == null) {
                    this.iPerson = PersonFactory.getLocalInstance((Context)ctx);
                }
                if (this.iSynEvaluObject == null) {
                    this.iSynEvaluObject = SynEvaluObjectFactory.getLocalInstance(ctx);
                }
                if (this.isp == null) {
                    this.isp = SynSolutionPeriodFactory.getLocalInstance(ctx);
                }
                if (this.iRank == null) {
                    this.iRank = RankFactory.getLocalInstance(ctx);
                }
                String personId = null;
                FilterInfo filterInfo = new FilterInfo();
                EntityViewInfo viewInfo = new EntityViewInfo();
                this.obj = hsData.get("personNumber");
                if (this.obj == null || "".equals(this.obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.obj.toString()));
                this.obj = hsData.get("personName");
                if (this.obj == null || "".equals(this.obj.toString())) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NAME_NULL);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.obj.toString()));
                viewInfo.setFilter(filterInfo);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                PersonCollection personColl = this.iPerson.getPersonCollection(viewInfo);
                if (personColl == null || personColl.size() <= 0) {
                    throw new EvaluResultException(EvaluResultException.PERSON_NUMBER_NAME_ERROR);
                }
                personId = personColl.get(0).getId().toString();
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                String solutionID = (String)this.getContextParameter("solutionID");
                filterInfo.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionID));
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
                viewInfo.setFilter(filterInfo);
                selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                CoreBaseCollection coll = this.iSynEvaluObject.getCollection(viewInfo);
                SynEvaluObjectInfo objectInfo = null;
                if (coll == null || coll.size() != 1) {
                    throw new EvaluResultException(EvaluResultException.NO_PERSON_IN_SOLUTION);
                }
                objectInfo = (SynEvaluObjectInfo)coll.get(0);
                ret.setMdObject(objectInfo);
                if (this.gradeMode == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("gradeMode.id"));
                    sic.add(new SelectorItemInfo("gradeMode.minGrade"));
                    sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
                    sic.add(new SelectorItemInfo("inputMode"));
                    SynSolutionInfo s = SynSolutionFactory.getLocalInstance(ctx).getSynSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID), sic);
                    this.gradeMode = s.getGradeMode();
                    this.isRank = EvaluModeEnum.RANK_GROUP.equals((Object)s.getInputMode());
                }
                String spID = (String)this.getContextParameter("spID");
                SynSolutionPeriodInfo spInfo = this.isp.getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spID));
                ret.setSolutionPeriod(spInfo);
                if (!this.isRank) {
                    this.obj = hsData.get("evaluScore");
                    if (this.obj == null || "".equals(this.obj.toString())) break block19;
                    BigDecimal score = null;
                    try {
                        score = new BigDecimal(this.obj.toString());
                    }
                    catch (Exception ex) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    if (this.gradeMode.getMaxGrade().compareTo(score) == -1 || this.gradeMode.getMinGrade().compareTo(score) == 1) {
                        throw new EvaluResultException(EvaluResultException.SCORE_OUT_OFRANGE);
                    }
                    ret.setEvaluScore(new BigDecimal(this.obj.toString()));
                    break block19;
                }
                this.obj = hsData.get("rank");
                if (this.obj == null || "".equals(this.obj.toString())) break block19;
                String rankGroupID = (String)this.getContextParameter("rankGroupID");
                filterInfo = new FilterInfo();
                viewInfo = new EntityViewInfo();
                if (rankGroupID != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)rankGroupID));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("group", (Object)"%noRankGroupID%"));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.obj.toString()));
                viewInfo.setFilter(filterInfo);
                RankInfo rank = null;
                RankCollection rankColl = this.iRank.getRankCollection(viewInfo);
                if (rankColl != null && rankColl.size() > 0) {
                    rank = rankColl.get(0);
                    ret.setRank(rank);
                    break block19;
                }
                throw new EvaluResultException(EvaluResultException.RANK_ERROR);
            }
            catch (EASBizException ex) {
                throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        return ret;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("personNumber", rs.getString("person.number"));
            result.put("personName", rs.getString("person.name"));
            BigDecimal score = rs.getBigDecimal("evaluScore");
            if (score != null) {
                DecimalFormat f = new DecimalFormat("0.00");
                result.put("evaluScore", f.format(score));
            }
            if (rs.getString("rank.name") != null) {
                result.put("rank", rs.getString("rank.name"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String spID = (String)this.getContextParameter("spID");
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spID));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.SynEvaluResultExportQuery";
    }
}

