/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluResultException;
import com.kingdee.eas.hr.perf.IRankConvertRule;
import com.kingdee.eas.hr.perf.ISynEvaluResult;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.app.AbstractSynEvaluResultFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SynEvaluResultFacadeControllerBean
extends AbstractSynEvaluResultFacadeControllerBean {
    private static final long serialVersionUID = -65535L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SynEvaluResultFacadeControllerBean");
    private static final String TABLE_NAME = " T_PF_SYNEVALURESULT ";

    @Override
    protected void _updateScoreAndPerfRank(Context ctx, HashMap changedScore, HashMap changedPerfRank) throws BOSException, EASBizException {
        String sqlScore = " UPDATE  T_PF_SYNEVALURESULT  SET FEvaluScore = ? WHERE ( FID = ? )";
        String sqlPerfRank = " UPDATE  T_PF_SYNEVALURESULT  SET FRankID = ? WHERE ( FID = ? )";
        String sqlAll = " UPDATE  T_PF_SYNEVALURESULT  SET FEvaluScore = ? , FRankID = ? WHERE ( FID = ? )";
        HashSet commonSet = new HashSet();
        for (Object keyObj : changedScore.keySet()) {
            if (!changedPerfRank.keySet().contains(keyObj)) continue;
            commonSet.add(keyObj);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String key2 = null;
        try {
            conn = this.getConnection(ctx);
            if (commonSet.size() > 0) {
                pstmt = conn.prepareStatement(sqlAll);
                for (String key2 : commonSet) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(2, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)key2);
                    changedScore.remove(key2);
                    changedPerfRank.remove(key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedScore.size() > 0) {
                pstmt = conn.prepareStatement(sqlScore);
                for (String key2 : changedScore.keySet()) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedPerfRank.size() > 0) {
                pstmt = conn.prepareStatement(sqlPerfRank);
                for (String key2 : changedPerfRank.keySet()) {
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(1, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new EvaluResultException(EvaluResultException.DATABASE_EXCEPPTION);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _antiAuditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(false, idList, ctx);
    }

    @Override
    protected void _auditBill(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.executeAuditAction(true, idList, ctx);
    }

    @Override
    protected void _convertModfiedSocreToRank(Context ctx, String[] idList, BOSUuid convertRuleID) throws BOSException, EASBizException {
        this.convertScoreToRank(idList, convertRuleID, "FModifiedScore", ctx);
    }

    @Override
    protected void _convertTotalScoreToRank(Context ctx, String[] idList, BOSUuid convertRuleID) throws BOSException, EASBizException {
        this.convertScoreToRank(idList, convertRuleID, "FEvaluScore", ctx);
    }

    private void executeAuditAction(boolean direction, String[] idList, Context ctx) throws BOSException, EASBizException {
        if (idList == null || idList.length <= 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE");
        sb.append(TABLE_NAME);
        sb.append("SET FIsApproved = ? , FAuditorID = ? , FAuditDate = ?");
        sb.append(" WHERE FID IN ( ");
        for (int i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(" )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        String auditorID = null;
        Timestamp date = null;
        if (direction) {
            auditorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            date = new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            if (direction) {
                pstmt.setInt(1, 1);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)auditorID);
                pstmt.setTimestamp(3, date);
            } else {
                pstmt.setInt(1, 0);
                pstmt.setString(2, null);
                pstmt.setTimestamp(3, null);
            }
            pstmt.execute();
            ISynEvaluResult iSynEvaluResult = SynEvaluResultFactory.getLocalInstance(ctx);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            String logMessage = null;
            String logItem = null;
            IObjectPK logPK = null;
            logItem = direction ? "perf_synEvaluResult_audit" : "perf_synEvaluResult_antiAudit";
            int length = idList.length;
            for (int i = 0; i < length; ++i) {
                logMessage = this.getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(idList[i]), iSynEvaluResult, iPerson);
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SynEvaluResultFactory.getLocalInstance(ctx).getType(), null, (String)logMessage, (String)logItem);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void convertScoreToRank(String[] idList, BOSUuid convertRuleID, String colName, Context ctx) throws BOSException, EASBizException {
        IRankConvertRule iRankConvertRule = RankConvertRuleFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.minScore"));
        sic.add(new SelectorItemInfo("entries.maxScore"));
        sic.add(new SelectorItemInfo("entries.minScoreCondition"));
        sic.add(new SelectorItemInfo("entries.maxScoreCondition"));
        sic.add(new SelectorItemInfo("entries.rank.id"));
        RankConvertRuleInfo rule = (RankConvertRuleInfo)iRankConvertRule.getValue((IObjectPK)new ObjectUuidPK(convertRuleID), sic);
        RankConvertRuleDetailCollection coll = rule.getEntries();
        if (coll != null && coll.size() > 0) {
            RankConvertRuleDetailInfo detail = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                StringBuffer header = new StringBuffer();
                header.append("UPDATE ");
                header.append(TABLE_NAME);
                header.append(" SET FRankID = ? , FRankConvertRuleID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        header.append(" , ");
                    }
                    header.append("'");
                    header.append(idList[k]);
                    header.append("'");
                }
                header.append(" ) ) and ");
                conn = this.getConnection(ctx);
                String headerSql = header.toString();
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    detail = coll.get(i);
                    StringBuffer sql = new StringBuffer();
                    sql.append(headerSql);
                    sql.append(" ( ");
                    sql.append(" ? ");
                    sql.append(this.transForSql(detail.getMinScoreCondition()));
                    sql.append(colName);
                    sql.append(" ) and ");
                    sql.append(" ( ");
                    sql.append(colName);
                    sql.append(this.transForSql(detail.getMaxScoreCondition()));
                    sql.append(" ? ) ");
                    pstmt = conn.prepareStatement(sql.toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)detail.getRank().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)convertRuleID.toString());
                    pstmt.setBigDecimal(3, detail.getMinScore());
                    pstmt.setBigDecimal(4, detail.getMaxScore());
                    pstmt.execute();
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer nullSQL = new StringBuffer();
                nullSQL.append("UPDATE");
                nullSQL.append(TABLE_NAME);
                nullSQL.append(" SET FRankID = ? WHERE (FID IN ( ");
                for (int k = 0; k < idList.length; ++k) {
                    if (k > 0) {
                        nullSQL.append(" , ");
                    }
                    nullSQL.append("'");
                    nullSQL.append(idList[k]);
                    nullSQL.append("'");
                }
                nullSQL.append(" ) ) and ");
                nullSQL.append(colName);
                nullSQL.append(" IS NULL ");
                pstmt = conn.prepareStatement(nullSQL.toString());
                pstmt.setString(1, null);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String transForSql(String condition) {
        if (condition.equals("\u2264")) {
            return " <= ";
        }
        return " < ";
    }

    @Override
    protected void _updateEvalPersonModifyScore(Context ctx, HashMap modifiedSocreMap) throws BOSException, EASBizException {
        if (modifiedSocreMap == null || modifiedSocreMap.size() == 0) {
            return;
        }
        String sql = "UPDATE T_PF_EvalPerson SET FModifyScore = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id2 = null;
            BigDecimal score = null;
            for (String id2 : modifiedSocreMap.keySet()) {
                score = (BigDecimal)modifiedSocreMap.get(id2);
                pstmt.setBigDecimal(1, score);
                pstmt.setString(2, id2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateRelationDetailModifyScore(Context ctx, HashMap modifyScoreMap) throws BOSException, EASBizException {
        if (modifyScoreMap == null || modifyScoreMap.size() == 0) {
            return;
        }
        String sql = "UPDATE T_PF_EvalReDetail SET FModifyScore = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id2 = null;
            BigDecimal score = null;
            for (String id2 : modifyScoreMap.keySet()) {
                score = (BigDecimal)modifyScoreMap.get(id2);
                pstmt.setBigDecimal(1, score);
                pstmt.setString(2, id2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateEvalPersonModifyScoreAndPerfRank(Context ctx, HashMap changedScore, HashMap changedPerfRank) throws BOSException {
        String sqlScore = " UPDATE T_PF_EvalPerson  SET FModifyScore = ? WHERE ( FID = ? )";
        String sqlPerfRank = " UPDATE T_PF_EvalPerson  SET FRankID = ? WHERE ( FID = ? )";
        String sqlAll = " UPDATE T_PF_EvalPerson  SET FModifyScore = ? , FRankID = ? WHERE ( FID = ? )";
        HashSet commonSet = new HashSet();
        for (Object keyObj : changedScore.keySet()) {
            if (!changedPerfRank.keySet().contains(keyObj)) continue;
            commonSet.add(keyObj);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String key2 = null;
        try {
            conn = this.getConnection(ctx);
            if (commonSet.size() > 0) {
                pstmt = conn.prepareStatement(sqlAll);
                for (String key2 : commonSet) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(2, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)key2);
                    changedScore.remove(key2);
                    changedPerfRank.remove(key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedScore.size() > 0) {
                pstmt = conn.prepareStatement(sqlScore);
                for (String key2 : changedScore.keySet()) {
                    pstmt.setBigDecimal(1, (BigDecimal)changedScore.get(key2));
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            if (changedPerfRank.size() > 0) {
                pstmt = conn.prepareStatement(sqlPerfRank);
                for (String key2 : changedPerfRank.keySet()) {
                    if (changedPerfRank.get(key2) != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)((String)changedPerfRank.get(key2)));
                    } else {
                        pstmt.setString(1, null);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)key2);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String getLogInfo(Context ctx, IObjectPK pk, ISynEvaluResult iSynEvaluResult, IPerson iPerson) throws BOSException, EASBizException {
        StringBuffer retValue = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("mdObject.person.name"));
        SynEvaluResultInfo resultInfo = iSynEvaluResult.getSynEvaluResultInfo(pk, sic);
        if (resultInfo.getMdObject() != null && resultInfo.getMdObject().getPerson() != null) {
            retValue.append(resultInfo.getMdObject().getPerson().getName());
        }
        retValue.append("  ");
        retValue.append(resultInfo.getSolutionPeriod().getName());
        return retValue.toString();
    }
}

