/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.ISynFlowObject;
import com.kingdee.eas.hr.perf.SynFlowObjectCollection;
import com.kingdee.eas.hr.perf.SynFlowObjectFactory;
import com.kingdee.eas.hr.perf.SynFlowObjectInfo;
import com.kingdee.eas.hr.perf.SynNodeProcesserFactory;
import com.kingdee.eas.hr.perf.SynNodeProcesserInfo;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractSynNodeProcesserControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SynNodeProcesserControllerBean
extends AbstractSynNodeProcesserControllerBean {
    private static final long serialVersionUID = -61166L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SynNodeProcesserControllerBean");

    @Override
    protected void _countTotalTargetEvaluScore(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        String pack = "com.kingdee.eas.hr.perf.app";
        String query = "SynNodeEvaluResultQuery";
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynNodeEvaluResultQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)evaluObjectID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        Connection conn = null;
        PreparedStatement prst = null;
        boolean isGrade = false;
        try {
            BigDecimal score = null;
            String rankID = null;
            while (rowSet.next()) {
                boolean bl = isGrade = 100 == rowSet.getInt("solution.inputMode");
                if (isGrade) {
                    score = rowSet.getBigDecimal("score");
                    if (score == null) continue;
                    break;
                }
                rankID = rowSet.getString("rank.id");
                if (rankID == null || "".equals(rankID.trim())) continue;
            }
            String sql = "UPDATE T_PF_SYNEVALURESULT SET FEvaluScore = ?, FRankID = ? WHERE (FSolutionPeriodID = ? ) and (FSynObjectID = ?)";
            conn = this.getConnection(ctx);
            prst = conn.prepareStatement(sql);
            if (isGrade) {
                prst.setBigDecimal(1, score);
                prst.setString(2, null);
            } else {
                prst.setBigDecimal(1, null);
                prst.setString(2, rankID);
            }
            prst.setString(3, solutionPeriodID);
            prst.setString(4, evaluObjectID);
            prst.execute();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectID));
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
            viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            ISynFlowObject isfo = SynFlowObjectFactory.getLocalInstance(ctx);
            SynFlowObjectCollection coll = isfo.getSynFlowObjectCollection(viewInfo);
            SynFlowObjectInfo info = coll.get(0);
            info.setStatus(WFStatuEnum.CLOSED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("status"));
            isfo.updatePartial((CoreBaseInfo)info, sic);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prst, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prst, (Connection)conn);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SynNodeProcesserInfo info = (SynNodeProcesserInfo)model;
        String sql = "UPDATE T_PF_SYNEVALURESULT SET FEvaluScore = ?, FRankID = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (info.getScore() != null) {
                pstmt.setBigDecimal(1, info.getScore());
            } else {
                pstmt.setBigDecimal(1, null);
            }
            if (info.getRank() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)info.getRank().getId().toString());
            } else {
                pstmt.setString(2, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getEvaluResult().getId().toString());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SynNodeProcesserFactory.getLocalInstance(ctx).getType(), null, (String)info.getProcesserName(), (String)"perf_synEvaluResult_inputForm");
            pstmt.executeUpdate();
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return super._submit(ctx, model);
    }
}

