/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.ISynSolutionPeriod;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluItemFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.SynFlowObjectInfo;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.app.AbstractSynSolutionControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SynSolutionControllerBean
extends AbstractSynSolutionControllerBean {
    private static final long serialVersionUID = -61166L;
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SynSolutionControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SynSolutionInfo info = (SynSolutionInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID));
        }
        super._checkNumberDup(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SynSolutionInfo info = (SynSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SynSolutionInfo info = (SynSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SynSolutionInfo solution = (SynSolutionInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solution.getId().toString()));
        if (SynSolutionPeriodFactory.getLocalInstance(ctx).exists(filter)) {
            solution.setStatus(SolutionStatusEnum.ONUSED);
        } else {
            solution.setStatus(SolutionStatusEnum.UNUSED);
        }
        super._update(ctx, pk, model);
        SynSolutionInfo evaluSolutionInfo = (SynSolutionInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solution.id", (Object)pk.toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.startDate"));
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.endDate"));
        ISynSolutionPeriod solutionPeriod = SynSolutionPeriodFactory.getLocalInstance(ctx);
        SynSolutionPeriodCollection coll = solutionPeriod.getSynSolutionPeriodCollection(evi);
        SynSolutionPeriodInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            AssessPeriodInfo assessPeriod = info.getAssessPeriod();
            StringBuffer sb = new StringBuffer();
            if (assessPeriod != null) {
                sb.append(evaluSolutionInfo.getName());
                sb.append(" ");
                sb.append(assessPeriod.getStartDate());
                sb.append("----");
                sb.append(assessPeriod.getEndDate());
                info.setName(sb.toString());
            }
            solutionPeriod.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        DataBaseInfo dataBase = this.getDataBaseInfo(ctx, pk);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        if (iCodingRuleManager.isExist((IObjectValue)dataBase, companyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)dataBase, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)dataBase, companyID, dataBase.getNumber());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)pk.toString()));
        SynEvaluObjectFactory.getLocalInstance(ctx).delete(filter);
        SynEvaluItemFactory.getLocalInstance(ctx).delete(filter);
        super._delete(ctx, pk);
    }

    @Override
    protected void _closeSolution(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_SynSolution SET FStatus = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 102);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _addObjectToFlow(Context ctx, String[] ids, String flowID, String solutionPeriodID) throws BOSException, EASBizException {
        String sql = "INSERT INTO T_PF_SynFlowObject (FID,FStatus,FEvaluObjectID,FEvalWorkFlowID) VALUES (?,?,?,?)";
        String rsql = "INSERT INTO T_PF_SynEvaluResult (FID, FSolutionPeriodID, FSynObjectID,FIsApproved,FIsModify)VALUES (?,?,?,?,?)";
        StringBuffer sb = new StringBuffer();
        sb.append("update t_pf_synevaluresult ");
        sb.append("set fpositionid = ");
        sb.append("(select p.FPrimarypositionid from t_hr_personposition p inner join t_pf_synevaluobject o on p.fpersonid = o.fpersonid where  t_pf_synevaluresult.fsynobjectid = o.fid) ");
        sb.append(",");
        sb.append("FAdminOrgUnitID = ");
        sb.append("(select p.FPersonDep from t_hr_personposition p inner join t_pf_synevaluobject o on p.fpersonid = o.fpersonid where  t_pf_synevaluresult.fsynobjectid = o.fid) ");
        sb.append(",");
        sb.append("FJobGradeID = ");
        sb.append("(select p.FJobGrade from t_hr_personposition p inner join t_pf_synevaluobject o on p.fpersonid = o.fpersonid where  t_pf_synevaluresult.fsynobjectid = o.fid) ");
        sb.append(" where t_pf_synevaluresult.fid = ").append("?");
        SynFlowObjectInfo info = new SynFlowObjectInfo();
        SynEvaluResultInfo result = new SynEvaluResultInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt2 = conn.prepareStatement(rsql);
            pstmt3 = conn.prepareStatement(sb.toString());
            String rid = null;
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setInt(2, 10);
                pstmt.setString(3, ids[i]);
                pstmt.setString(4, flowID);
                pstmt.addBatch();
                rid = BOSUuid.create((BOSObjectType)result.getBOSType()).toString();
                pstmt2.setString(1, rid);
                pstmt2.setString(2, solutionPeriodID);
                pstmt2.setString(3, ids[i]);
                pstmt2.setBoolean(4, false);
                pstmt2.setBoolean(5, false);
                pstmt2.addBatch();
                pstmt3.setString(1, rid);
                pstmt3.addBatch();
            }
            pstmt.executeBatch();
            pstmt2.executeBatch();
            pstmt3.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt2);
                SQLUtils.cleanup(pstmt3, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt2);
        SQLUtils.cleanup((Statement)pstmt3, (Connection)conn);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        SynSolutionInfo info = (SynSolutionInfo)model;
        String companyID = null;
        if (ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)"ControlUnit")).getString("id");
        } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id");
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && info.getNumber() == null) {
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyID));
        }
        super._checkNumberDup(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        FilterInfo filterInfo = new FilterInfo();
        SynSolutionInfo solution = (SynSolutionInfo)model;
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.status", (Object)new Integer(102), CompareType.NOTEQUALS));
        if (SynSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            solution.setStatus(SolutionStatusEnum.ONUSED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("status"));
            SynSolutionFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        }
        return pk;
    }
}

