/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.ISynEvaluFlow;
import com.kingdee.eas.hr.perf.ISynEvaluItem;
import com.kingdee.eas.hr.perf.ISynSolution;
import com.kingdee.eas.hr.perf.ISynSolutionPeriod;
import com.kingdee.eas.hr.perf.ISynWorkFlowFacade;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MDSolutionException;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.MultiDimntModeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynConcArgsCollection;
import com.kingdee.eas.hr.perf.SynConcArgsInfo;
import com.kingdee.eas.hr.perf.SynEvaluFlowCollection;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynEvaluItemCollection;
import com.kingdee.eas.hr.perf.SynEvaluItemFactory;
import com.kingdee.eas.hr.perf.SynEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectCollection;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeCollection;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynFlowObjectCollection;
import com.kingdee.eas.hr.perf.SynFlowObjectFactory;
import com.kingdee.eas.hr.perf.SynFlowObjectInfo;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemCollection;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractSynSolutionFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynSolutionFacadeControllerBean
extends AbstractSynSolutionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SynSolutionFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.hr.perf.PerfResource";

    @Override
    protected void _addSynEvaluObject(Context ctx, HashSet personIDSet, String solutionID) throws BOSException, EASBizException {
        if (solutionID == null || personIDSet == null || personIDSet.size() == 0) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionID));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        SynEvaluObjectCollection objectCollection = SynEvaluObjectFactory.getLocalInstance(ctx).getSynEvaluObjectCollection(viewInfo);
        if (objectCollection != null && objectCollection.size() > 0) {
            int n = objectCollection.size();
            for (int i = 0; i < n; ++i) {
                personIDSet.remove(objectCollection.get(i).getPerson().getId().toString());
            }
        }
        if (personIDSet.size() == 0) {
            return;
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPositionAndAdminQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        SynEvaluObjectCollection collection = new SynEvaluObjectCollection();
        HashSet<String> personSet2 = new HashSet<String>();
        if (rowSet.size() != 0) {
            try {
                while (rowSet.next()) {
                    if (personSet2.contains(rowSet.getString("id"))) continue;
                    personSet2.add(rowSet.getString("id"));
                    SynEvaluObjectInfo objectInfo = new SynEvaluObjectInfo();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    objectInfo.setPerson(personInfo);
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rowSet.getString("position2.id")));
                    objectInfo.setDescription(rowSet.getString("orgUnit.displayName"));
                    collection.add(objectInfo);
                }
            }
            catch (Exception e) {
                throw new MDSolutionException(MDSolutionException.ADD_MDOBEJECT_FAILD, e);
            }
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_PF_SynEvaluObject (FID, FDescription_L1, FDescription_L2, FDescription_L3, FPersonID, FSolutionID) VALUES (?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            SynEvaluObjectInfo info = null;
            String id = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                String description = info.getDescription();
                String sdescription = STConverter.tc2sc((String)description);
                String tdescription = STConverter.sc2tc((String)description);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setId(BOSUuid.read((String)id));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                pstmt.setString(2, description);
                pstmt.setString(3, sdescription);
                pstmt.setString(4, tdescription);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)solutionID);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected IObjectPK[] _deleteEvaluObjectBatch(Context ctx, HashSet evaluObjectSet) throws BOSException, EASBizException {
        ArrayList<String> canNotDelIdList;
        HashSet<String> delIDSet;
        block10: {
            delIDSet = new HashSet<String>();
            canNotDelIdList = new ArrayList<String>();
            HashSet referedIDSet = this._getReferedEvaluObjectIDSet(ctx, evaluObjectSet, SolutionPeriodStatusEnum.ON_EVALU);
            HashSet endIDSet = this._getReferedEvaluObjectIDSet(ctx, evaluObjectSet, SolutionPeriodStatusEnum.END_EVALU);
            endIDSet.removeAll(referedIDSet);
            Iterator it = evaluObjectSet.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                if (referedIDSet.contains(id)) {
                    canNotDelIdList.add(id);
                    continue;
                }
                if (endIDSet.contains(id)) continue;
                delIDSet.add(id);
            }
            if (delIDSet.size() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", delIDSet, CompareType.INCLUDE));
                SynFlowObjectFactory.getLocalInstance(ctx).delete(fi);
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", delIDSet, CompareType.INCLUDE));
                SynEvaluObjectFactory.getLocalInstance(ctx).delete(fi);
            }
            if (endIDSet.size() <= 0) break block10;
            String sql = "UPDATE T_PF_SynEvaluObject SET FDELETED = 1 WHERE FID = ?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                Iterator iter = endIDSet.iterator();
                while (iter.hasNext()) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)iter.next().toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)endIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.status", (Object)new Integer(100)));
            SynFlowObjectFactory.getLocalInstance(ctx).delete(filter);
        }
        ObjectUuidPK[] pk = new ObjectUuidPK[canNotDelIdList.size()];
        int size = canNotDelIdList.size();
        for (int i = 0; i < size; ++i) {
            pk[i] = new ObjectUuidPK((String)canNotDelIdList.get(i));
        }
        if (delIDSet.size() == 0) {
            return pk;
        }
        return pk;
    }

    @Override
    protected HashSet _getReferedEvaluObjectIDSet(Context ctx, HashSet set, SolutionPeriodStatusEnum status) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.status", (Object)new Integer(status.getValue())));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        SynFlowObjectCollection coll = SynFlowObjectFactory.getLocalInstance(ctx).getSynFlowObjectCollection(viewInfo);
        HashSet<String> result = new HashSet<String>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            result.add(coll.get(i).getEvaluObject().getId().toString());
        }
        return result;
    }

    @Override
    protected void _startSolutionPeriod(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solution.id"));
        SynSolutionPeriodInfo info = SynSolutionPeriodFactory.getLocalInstance(ctx).getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        SynSolutionInfo solution = info.getSolution();
        solution.setStatus(SolutionStatusEnum.ONUSED);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("status"));
        SynSolutionPeriodFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)solution, sic);
        SynSolutionPeriodInfo period = new SynSolutionPeriodInfo();
        period.setStatus(SolutionPeriodStatusEnum.ON_EVALU);
        period.setId(BOSUuid.read((String)solutionPeriodID));
        SynSolutionPeriodFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)period, sic);
        this.startDirectEnterSolutionPeriod(ctx, info.getSolution().getId().toString(), solutionPeriodID);
    }

    private void startDirectEnterSolutionPeriod(Context ctx, String solutionID, String solutionPeriodID) throws BOSException, EASBizException {
        String pack = "com.kingdee.eas.hr.perf.app";
        String query = "SynEvaluObjectToStartQuery";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionID));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynEvaluObjectToStartQuery"));
        iqec.setObjectView(viewInfo);
        String sql = "INSERT INTO T_PF_SynEvaluResult (FID, FSolutionPeriodID, FSynObjectID,FIsApproved,FIsModify)VALUES (?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        SynEvaluResultInfo result = new SynEvaluResultInfo();
        BOSObjectType BOSType = result.getBOSType();
        try {
            IRowSet rowSet = iqec.executeQuery();
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            while (rowSet.next()) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)BOSType).toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodID);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)rowSet.getString("id"));
                pstmt.setBoolean(4, false);
                pstmt.setBoolean(5, false);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void checkBeforeStart(Context ctx, BOSUuid mdSolutionPeriodId) throws BOSException, EASBizException, MDSolutionException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("MDSolution.id"));
        selectorItemCollection.add(new SelectorItemInfo("MDSolution.RankGroup.id"));
        selectorItemCollection.add(new SelectorItemInfo("MDSolution.MultiDimntModeE"));
        MultiDimentionSolutionPeriodInfo mdspInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodId), selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)mdSolutionPeriodId.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        if (MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDSolutionException(MDSolutionException.SOLUTION_EXIST_STARTED);
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)mdSolutionPeriodId.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(100)));
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionState", (Object)new Integer(10)));
        filterInfo.getFilterItems().add(new FilterItemInfo("lastOperateTime", (Object)PerfUtils.getDateBefore(), CompareType.GREATER));
        if (MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDSolutionException(MDSolutionException.SOLUTIONPERIOD_PROCESSING);
        }
        if (mdspInfo.getMDSolution().getRankGroup().getId() == null) {
            throw new MDSolutionException(MDSolutionException.RANKGROUP_NOT_NULL);
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodId.toString()));
        if (!MDEvaluGroupFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDSolutionException(MDSolutionException.SOLUTIONPERIOD_NO_EVALUGROUP);
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.id", (Object)mdSolutionPeriodId.toString()));
        if (!MDGroupObjectFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new MDSolutionException(MDSolutionException.EVALUGROUP_NO_EVALUOBJECT);
        }
        if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)mdspInfo.getMDSolution().getMultiDimntModeE())) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodId.toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(40), CompareType.NOTEQUALS));
            if (MultiDimEvaluatorFactory.getLocalInstance(ctx).exists(filterInfo)) {
                throw new MDSolutionException(MDSolutionException.SELFMODE_NOT_ALL_AUDITED);
            }
        }
    }

    @Override
    protected void _resetSolutionPeriod(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        if (solutionPeriodID == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        if (!SynSolutionPeriodFactory.getLocalInstance(ctx).exists(filter)) {
            return;
        }
        SynWorkFlowFacadeFactory.getLocalInstance(ctx).stopSolutionPeriod(BOSUuid.read((String)solutionPeriodID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        SynSolutionPeriodInfo info = SynSolutionPeriodFactory.getLocalInstance(ctx).getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SynSolutionPeriodFactory.getLocalInstance(ctx).getType(), null, (String)info.getName(), (String)"perf_SynSolutionPeriod_reset");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _finishSolutionPeriod(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        if (solutionPeriodID == null) {
            return;
        }
        ISynWorkFlowFacade flowFacade = SynWorkFlowFacadeFactory.getLocalInstance(ctx);
        flowFacade.closeSolutionPeriod(BOSUuid.read((String)solutionPeriodID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        SynSolutionPeriodInfo info = SynSolutionPeriodFactory.getLocalInstance(ctx).getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SynSolutionPeriodFactory.getLocalInstance(ctx).getType(), null, (String)info.getName(), (String)"perf_SynSolutionPeriod_end");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected boolean _isAllEvaluObjectInFlow(Context ctx, String solutionID, String solutionPeriodID) throws BOSException, EASBizException {
        boolean ret = true;
        String sql = "SELECT count(*) count FROM T_PF_SynEvaluObject WHERE (FSolutionID = ? AND FID NOT IN (SELECT FEvaluObjectID FROM T_PF_SynFlowObject WHERE FEvalWorkFlowID IN (SELECT FID FROM T_PF_SynEvaluFlow WHERE FSolutionPeriodID = ? )))";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)solutionID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)solutionPeriodID);
            ResultSet set = pstmt.executeQuery();
            if (set.next()) {
                int count = set.getInt("count");
                ret = count == 0;
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return ret;
    }

    @Override
    protected void _setSynFlowObjectStatus(Context ctx, String solutionPeriodID, String evaluObjectID, WFStatuEnum status) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_SynFlowObject SET FStatus = ? WHERE (FEvaluObjectID = ? ) AND ( FEvalWorkFlowID IN (SELECT FID FROM T_PF_SynEvaluFlow where FSolutionPeriodID = ? ))";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, status.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evaluObjectID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)solutionPeriodID);
            pstmt.execute();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateFlowObject(Context ctx, HashSet selectedSet, HashSet delSet, String workFlowID) throws BOSException, EASBizException {
        Connection conn;
        block12: {
            if (selectedSet.size() == 0 && delSet.size() == 0) {
                return;
            }
            String sql = "INSERT INTO T_PF_SynFlowObject (FID, FEvaluObjectID,FEvalWorkFlowID,FStatus) VALUES (?,?,?,?)";
            String delsql = "DELETE FROM T_PF_SynFlowObject WHERE (FEvaluObjectID = ?) AND (FEvalWorkFlowID = ?)";
            SynFlowObjectInfo info = new SynFlowObjectInfo();
            conn = null;
            PreparedStatement pstmt = null;
            try {
                Iterator iter;
                conn = this.getConnection(ctx);
                if (selectedSet.size() > 0) {
                    pstmt = conn.prepareStatement(sql);
                    iter = selectedSet.iterator();
                    while (iter.hasNext()) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)((String)iter.next()));
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)workFlowID);
                        pstmt.setInt(4, 10);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (delSet.size() > 0) {
                    pstmt = conn.prepareStatement(delsql);
                    iter = delSet.iterator();
                    while (iter.hasNext()) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)((String)iter.next()));
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)workFlowID);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                if (pstmt == null) break block12;
            }
            catch (Exception ex) {
                try {
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        SQLUtils.cleanup(pstmt);
                    }
                    if (conn != null) {
                        SQLUtils.cleanup((Connection)conn);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        if (conn != null) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _copySolution(Context ctx, IObjectValue solution, IObjectValue assessPeriod, IObjectValue solutionPeriod) throws BOSException, EASBizException {
        SynSolutionInfo info = (SynSolutionInfo)solution;
        AssessPeriodInfo assessPeriodInfo = (AssessPeriodInfo)assessPeriod;
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)solutionPeriod;
        ISynSolution ies = SynSolutionFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        SynSolutionInfo oldSolution = ies.getSynSolutionInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
        oldSolution.setNumber(info.getNumber());
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L1")), LocaleUtils.getLocale((String)"L1"));
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L2")), LocaleUtils.getLocale((String)"L2"));
        oldSolution.setName(info.getName(LocaleUtils.getLocale((String)"L3")), LocaleUtils.getLocale((String)"L3"));
        oldSolution.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        oldSolution.setId(null);
        oldSolution.setStatus(SolutionStatusEnum.UNUSED);
        IObjectPK pk = ies.submit((CoreBaseInfo)oldSolution);
        oldSolution.setId(BOSUuid.read((String)pk.toString()));
        String oldID = null;
        String newID = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        ISynEvaluItem isei = SynEvaluItemFactory.getLocalInstance(ctx);
        SynEvaluItemCollection coll = isei.getSynEvaluItemCollection(viewInfo);
        SynEvaluItemInfo item = null;
        HashMap<String, SynEvaluItemInfo> itemMap = new HashMap<String, SynEvaluItemInfo>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            item = coll.get(i);
            oldID = item.getId().toString();
            item.setId(null);
            item.setSolution(oldSolution);
            newID = isei.submit(item).toString();
            item = isei.getSynEvaluItemInfo((IObjectPK)new ObjectUuidPK(newID));
            itemMap.put(oldID, item);
        }
        ISynSolutionPeriod isp = SynSolutionPeriodFactory.getLocalInstance(ctx);
        SynSolutionPeriodInfo spInfo = new SynSolutionPeriodInfo();
        spInfo.setId(null);
        spInfo.setStatus(SolutionPeriodStatusEnum.UN_EVALU);
        spInfo.setSolution(oldSolution);
        spInfo.setAssessPeriod(assessPeriodInfo);
        StringBuffer sb = new StringBuffer();
        sb.append(oldSolution.getName());
        sb.append(" ");
        sb.append(assessPeriodInfo.getStartDate());
        sb.append("----");
        sb.append(assessPeriodInfo.getEndDate());
        Locale locale = ctx.getLocale();
        if (locale.equals(new Locale("L2"))) {
            spInfo.setName(sb.toString(), locale);
            spInfo.setName(STConverter.sc2tc((String)sb.toString()), new Locale("L3"));
        } else if (locale.equals(new Locale("L3"))) {
            spInfo.setName(sb.toString(), locale);
            spInfo.setName(STConverter.tc2sc((String)sb.toString()), new Locale("L2"));
        } else {
            spInfo.setName(sb.toString());
        }
        spInfo.setStartDate(solutionPeriodInfo.getStartDate());
        spInfo.setEndDate(solutionPeriodInfo.getEndDate());
        spInfo.setTitle(ResourceBase.getString((String)RES, (String)"formTitle", (Locale)ctx.getLocale()));
        String newSolutionPeriodID = isp.submit((CoreBaseInfo)spInfo).toString();
        SynSolutionPeriodInfo newSolutionPeriod = isp.getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(newSolutionPeriodID));
        String oldSolutionPeriodID = solutionPeriodInfo.getId().toString();
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)oldSolutionPeriodID));
        viewInfo.setFilter(filter);
        ISynEvaluFlow iewf = SynEvaluFlowFactory.getLocalInstance(ctx);
        ISynWorkFlowFacade isynwffacade = SynWorkFlowFacadeFactory.getLocalInstance(ctx);
        SynEvaluFlowCollection flowColl = iewf.getSynEvaluFlowCollection(viewInfo);
        SynEvaluFlowInfo flowInfo = null;
        SynFlowNodeCollection nodeColl = null;
        SynFlowNodeInfo nodeInfo = null;
        SynConcArgsCollection concColl = null;
        SynConcArgsInfo concInfo = null;
        SynNodeEvaluItemCollection itemColl = null;
        SynNodeEvaluItemInfo itemInfo = null;
        int n2 = flowColl.size();
        for (int i = 0; i < n2; ++i) {
            int l;
            flowInfo = flowColl.get(i);
            oldID = flowInfo.getId().toString();
            flowInfo.setId(null);
            flowInfo.setSolutionPeriod(newSolutionPeriod);
            flowInfo.put("wfObjects", null);
            nodeColl = flowInfo.getEvaluNodes();
            int k = nodeColl.size();
            for (l = 0; l < k; ++l) {
                nodeInfo = nodeColl.get(l);
                nodeInfo.setId(null);
                nodeInfo.setEvalWorkFlow(flowInfo);
                itemColl = nodeInfo.getNodeEvaluItems();
                int q = itemColl.size();
                for (int p = 0; p < q; ++p) {
                    itemInfo = itemColl.get(p);
                    item = (SynEvaluItemInfo)itemMap.get(itemInfo.getEvaluItem().getId().toString());
                    itemInfo.setEvaluItem(item);
                    itemInfo.setId(null);
                    itemInfo.setNode(nodeInfo);
                }
            }
            concColl = flowInfo.getConcurArgs();
            k = concColl.size();
            for (l = 0; l < k; ++l) {
                concInfo = concColl.get(l);
                concInfo.setId(null);
                concInfo.setEvalWorkFlow(flowInfo);
            }
            newID = isynwffacade.addNewWorkFlow(flowInfo).toString();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)SynSolutionFactory.getLocalInstance(ctx).getType(), null, (String)info.getName(), (String)"perf_SynSolution_copy");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected Map _getAssessPeriodNames(Context ctx, Set idSet) throws BOSException {
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        sb.append("select solution.FID as ID,assessPeriod.FName");
        sb.append(locale);
        sb.append(" as NAME");
        sb.append(" from T_PF_SynSolutionPeriod solutionPeriod");
        sb.append(" inner join T_PF_SynSolution solution on solutionPeriod.FSolutionID = solution.FID");
        sb.append(" left outer join T_PF_AssessPeriod assessPeriod on solutionPeriod.FAssessPeriodID = assessPeriod.FID");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String id = null;
            String name = null;
            if (idSet == null) {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            } else {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    if (!idSet.contains(id)) continue;
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return map;
    }
}

