/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SynCommDetailCollection;
import com.kingdee.eas.hr.perf.SynCommDetailInfo;
import com.kingdee.eas.hr.perf.SynEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultCollection;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynNodeProcesserCollection;
import com.kingdee.eas.hr.perf.SynNodeProcesserFactory;
import com.kingdee.eas.hr.perf.SynNodeProcesserInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.app.AbstractSynWebFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SynWebFacadeControllerBean
extends AbstractSynWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.SynWebFacadeControllerBean");

    @Override
    protected IObjectValue _getSynSolutionPeriodById(Context ctx, String solutionPeriodID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("title"));
        sic.add(new SelectorItemInfo("solution.id"));
        sic.add(new SelectorItemInfo("solution.inputMode"));
        sic.add(new SelectorItemInfo("solution.canViewMultiResult"));
        sic.add(new SelectorItemInfo("solution.canViewMultiAuditResult"));
        sic.add(new SelectorItemInfo("solution.evalRemark"));
        sic.add(new SelectorItemInfo("solution.rankGroup.id"));
        sic.add(new SelectorItemInfo("solution.gradeMode.id"));
        sic.add(new SelectorItemInfo("solution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("solution.gradeMode.minGrade"));
        SynSolutionPeriodInfo info = SynSolutionPeriodFactory.getLocalInstance(ctx).getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        return info;
    }

    @Override
    protected HashMap _getPersonInfoByEvalor(Context ctx, String evaluObjectID, String solutionPeriodID) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("mdObject.id"));
        sic.add(new SelectorItemInfo("mdObject.person.id"));
        sic.add(new SelectorItemInfo("mdObject.person.name"));
        sic.add(new SelectorItemInfo("mdObject.person.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)evaluObjectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        evi.setFilter(fi);
        SynEvaluResultCollection coll = SynEvaluResultFactory.getLocalInstance(ctx).getSynEvaluResultCollection(evi);
        if (coll != null && coll.size() > 0) {
            SynEvaluResultInfo info = coll.get(0);
            map.put("id", info.getMdObject().getPerson().getId().toString());
            map.put("name", info.getMdObject().getPerson().getName());
            map.put("number", info.getMdObject().getPerson().getNumber());
            map.put("AdminOrgUnitName", info.getAdminOrgUnit().getName());
            map.put("AdminOrgUnitDisplayName", info.getAdminOrgUnit().getDisplayName());
            map.put("Position", info.getPosition().getName());
            if (info.getJobGrade() != null) {
                map.put("JobGrade", info.getJobGrade().getName());
            }
        }
        return map;
    }

    @Override
    protected IObjectCollection _getExistNode(Context ctx, String solutionPeriodID, String evaluObjectID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod", (Object)solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.mdObject.id", (Object)evaluObjectID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluNode.seqNumber"));
        sic.add(new SelectorItemInfo("evaluNode.id"));
        sic.add(new SelectorItemInfo("evaluNode.nodeName"));
        sic.add(new SelectorItemInfo("evaluNode.canGrade"));
        sic.add(new SelectorItemInfo("evaluNode.levelName"));
        sic.add(new SelectorItemInfo("evaluNode.canEvaluateLevel"));
        sic.add(new SelectorItemInfo("evaluNode.canComment"));
        sic.add(new SelectorItemInfo("comments.id"));
        sic.add(new SelectorItemInfo("comments.comment"));
        sic.add(new SelectorItemInfo("comments.nodeProcesser.id"));
        sic.add(new SelectorItemInfo("comments.evaluItem.id"));
        sic.add(new SelectorItemInfo("comments.evaluItem.content"));
        sic.add(new SelectorItemInfo("comments.evaluItem.number"));
        sic.add(new SelectorItemInfo("evaluer.id"));
        sic.add(new SelectorItemInfo("evaluer.name"));
        sic.add(new SelectorItemInfo("rank.id"));
        sic.add(new SelectorItemInfo("rank.name"));
        sic.add(new SelectorItemInfo("score"));
        SynNodeProcesserCollection coll = SynNodeProcesserFactory.getLocalInstance(ctx).getSynNodeProcesserCollection(viewInfo);
        return coll;
    }

    @Override
    protected IObjectValue _getSynNodeProcesserInfoOfTheNode(Context ctx, String solutionPeriodID, String evaluObjectID, String nodeID) throws BOSException, EASBizException {
        if (nodeID == null || "".equals(nodeID.trim())) {
            return null;
        }
        SynNodeProcesserInfo info = new SynNodeProcesserInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setEvaluer(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("synObject.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("SynFlowNode.seqNumber", (Object)new Integer(Integer.parseInt(nodeID)));
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("synEvaluObject2.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "GetSynNewNodeRefInfoQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        String resultID = "";
        String evaluNodeID = "";
        SynEvaluItemInfo itemInfo = null;
        SynCommDetailInfo commInfo = null;
        SynEvaluResultInfo evaluResultInfo = null;
        SynFlowNodeInfo nodeInfo = null;
        try {
            while (rowSet.next()) {
                if (evaluResultInfo == null && !PerfUtils.objectIsNull(resultID = rowSet.getString("synEvaluResult.id"))) {
                    evaluResultInfo = new SynEvaluResultInfo();
                    evaluResultInfo.setId(BOSUuid.read((String)resultID));
                    info.setEvaluResult(evaluResultInfo);
                }
                if (nodeInfo == null && !PerfUtils.objectIsNull(evaluNodeID = rowSet.getString("SynFlowNode.id"))) {
                    nodeInfo = new SynFlowNodeInfo();
                    nodeInfo.setId(BOSUuid.read((String)evaluNodeID));
                    nodeInfo.setSeqNumber(rowSet.getInt("SynFlowNode.seqNumber"));
                    nodeInfo.setNodeName(rowSet.getString("SynFlowNode.nodeName"));
                    nodeInfo.setLevelName(rowSet.getString("SynFlowNode.levelName"));
                    nodeInfo.setCanComment(rowSet.getBoolean("SynFlowNode.canComment"));
                    nodeInfo.setCanGrade(rowSet.getBoolean("SynFlowNode.canGrade"));
                    nodeInfo.setCanEvaluateLevel(rowSet.getBoolean("SynFlowNode.canEvaluateLevel"));
                    info.setEvaluNode(nodeInfo);
                }
                if (PerfUtils.objectIsNull(rowSet.getString("evaluItem.id"))) continue;
                itemInfo = new SynEvaluItemInfo();
                itemInfo.setId(BOSUuid.read((String)rowSet.getString("evaluItem.id")));
                itemInfo.setNumber(rowSet.getString("evaluItem.number"));
                itemInfo.setContent(rowSet.getString("evaluItem.content"));
                commInfo = new SynCommDetailInfo();
                commInfo.setId(BOSUuid.create((BOSObjectType)commInfo.getBOSType()));
                commInfo.setEvaluItem(itemInfo);
                commInfo.setNodeProcesser(info);
                info.getComments().add(commInfo);
            }
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        info.setProcesserName(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName());
        SynNodeProcesserFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        return info;
    }

    @Override
    protected IObjectCollection _getRankByGroupId(Context ctx, String groupid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("serial"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupid));
        viewInfo.setFilter(filter);
        RankCollection ranks = RankFactory.getLocalInstance(ctx).getRankCollection(viewInfo);
        return ranks;
    }

    protected SynNodeProcesserInfo unitSynNodeProcesser(Context ctx, HttpServletRequest request) throws BOSException, EASBizException {
        String processerid = request.getParameter("processerid").replaceAll(" ", "+");
        boolean isGrade = true;
        String isgrade = request.getParameter("isgrade").trim();
        if ("true".equals(isgrade)) {
            isGrade = true;
        }
        if ("false".equals(isgrade)) {
            isGrade = false;
        }
        SynNodeProcesserInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluNode.id"));
        sic.add(new SelectorItemInfo("evaluNode.canComment"));
        sic.add(new SelectorItemInfo("evaluNode.canGrade"));
        sic.add(new SelectorItemInfo("evaluNode.canEvaluateLevel"));
        sic.add(new SelectorItemInfo("comments.id"));
        sic.add(new SelectorItemInfo("comments.comment"));
        sic.add(new SelectorItemInfo("comments.evaluItem.id"));
        sic.add(new SelectorItemInfo("comments.evaluItem.number"));
        sic.add(new SelectorItemInfo("comments.evaluItem.content"));
        info = SynNodeProcesserFactory.getLocalInstance(ctx).getSynNodeProcesserInfo((IObjectPK)new ObjectUuidPK(processerid), sic);
        if (info != null) {
            SynCommDetailCollection commColl = info.getComments();
            SynFlowNodeInfo node = info.getEvaluNode();
            if (node.isCanComment()) {
                for (int i = 0; i < commColl.size(); ++i) {
                    SynCommDetailInfo commInfo = commColl.get(i);
                    String comment = request.getParameter(commInfo.getEvaluItem().getId().toString()).trim();
                    commInfo.setComment(comment);
                }
            }
        }
        SynFlowNodeInfo node = info.getEvaluNode();
        if (isGrade) {
            if (node.isCanGrade()) {
                String requestScore = request.getParameter("nodescore").trim();
                BigDecimal score = new BigDecimal(requestScore);
                info.setScore(score);
            }
        } else if (node.isCanEvaluateLevel()) {
            String rankid = request.getParameter("rankid").replaceAll(" ", "+");
            RankInfo rankInfo = new RankInfo();
            rankInfo.setId(BOSUuid.read((String)rankid));
            info.setRank(rankInfo);
        }
        return info;
    }

    @Override
    protected void _saveSynPaperForm(Context ctx, HttpServletRequest request) throws BOSException, EASBizException {
        SynNodeProcesserInfo processer = this.unitSynNodeProcesser(ctx, request);
        SynNodeProcesserFactory.getLocalInstance(ctx).save((CoreBaseInfo)processer);
    }

    @Override
    protected void _submitSynPaperForm(Context ctx, HttpServletRequest request) throws BOSException, EASBizException {
        SynNodeProcesserInfo processer = this.unitSynNodeProcesser(ctx, request);
        String assignmentID = request.getParameter("assignmentID");
        processer.setExtendedProperty("assignmentID", assignmentID);
        processer.setExtendedProperty("isAddNew", "isAddNew");
        SynNodeProcesserFactory.getLocalInstance(ctx).submit((CoreBaseInfo)processer);
    }
}

