/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PersonBatchFacadeFactory;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererFactory;
import com.kingdee.eas.hr.perf.TargetDelivererInfo;
import com.kingdee.eas.hr.perf.app.AbstractTargetDeliverFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TargetDeliverFacadeControllerBean
extends AbstractTargetDeliverFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TargetDeliverFacadeControllerBean");
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";

    @Override
    protected String _getTargetDeliverString(Context ctx, String evaluObjectId, boolean isOrg) throws BOSException, EASBizException {
        if (evaluObjectId == null) {
            return "";
        }
        SelectorItemCollection sic = this.getSelector(isOrg);
        EvaluObjectInfo evaluObject = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectId), sic);
        EvaluObjectCollection coll = new EvaluObjectCollection();
        coll.add(evaluObject);
        Map delivers = this.getEvaluTargetDeliver(ctx, coll, isOrg);
        String deliverString = this.getDeliverString(ctx, evaluObject, isOrg, delivers);
        return deliverString;
    }

    @Override
    protected Map _getSolutionTargetDeliverString(Context ctx, String evaluSolutionId, boolean isOrg) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getSelector(isOrg));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        evi.setFilter(fi);
        EvaluObjectCollection evaluObjectColl = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectCollection(evi);
        Map delivers = this.getEvaluTargetDeliver(ctx, evaluObjectColl, isOrg);
        Map map = this.getDeliverString(ctx, evaluObjectColl, isOrg, delivers);
        return map;
    }

    private Map getEvaluObjectSupervisor(Context ctx, boolean isOrg, EvaluObjectCollection evaluObjectColl) throws BOSException, EASBizException {
        HashSet<String> personIdSet = new HashSet<String>();
        int n = evaluObjectColl.size();
        for (int i = 0; i < n; ++i) {
            if (!isOrg || evaluObjectColl.get(i).getResponser() == null) continue;
            personIdSet.add(evaluObjectColl.get(i).getResponser().getId().toString());
        }
        if (personIdSet.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        Map supervisorMap = PersonBatchFacadeFactory.getLocalInstance(ctx).getSupervisor(personIdSet, "00000000-0000-0000-0000-000000000001396FCAD0", false);
        return supervisorMap;
    }

    private Map getDeliverString(Context ctx, EvaluObjectCollection evaluObjectColl, boolean isOrg, Map supervisorMap) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EvaluObjectInfo evaluObjectInfo = null;
        String deliverString = null;
        int size = evaluObjectColl.size();
        for (int i = 0; i < size; ++i) {
            evaluObjectInfo = evaluObjectColl.get(i);
            if (evaluObjectInfo == null) continue;
            deliverString = this.getDeliverString(ctx, evaluObjectColl.get(i), isOrg, supervisorMap);
            map.put(evaluObjectInfo.getId().toString(), deliverString);
        }
        return map;
    }

    @Override
    protected Map _getTargetDeliverString(Context ctx, Set idSet, boolean isOrg) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getSelector(isOrg));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        evi.setFilter(fi);
        EvaluObjectCollection evaluObjectColl = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectCollection(evi);
        Map delivers = this.getEvaluTargetDeliver(ctx, evaluObjectColl, isOrg);
        Map map = this.getDeliverString(ctx, evaluObjectColl, isOrg, delivers);
        return map;
    }

    private SelectorItemCollection getSelector(boolean isOrg) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("objectId");
        if (isOrg) {
            sic.add("responser");
        }
        sic.add("oneself");
        sic.add("superior");
        sic.add("appointPerson");
        sic.add("targetDeliverers.person.id");
        sic.add("targetDeliverers.person.name");
        return sic;
    }

    private String getDeliverString(Context ctx, EvaluObjectInfo evaluObjectInfo, boolean isOrg, Map deliverMap) throws BOSException, EASBizException {
        if (evaluObjectInfo.getId() == null) {
            return "";
        }
        if (!isOrg ? evaluObjectInfo.getObjectID() == null : evaluObjectInfo.getResponser() == null) {
            return "";
        }
        StringBuffer deliverString = new StringBuffer();
        String selfStr = EASResource.getString((String)this.resourcePath, (String)"deliver_personal_oneself");
        String supStr = EASResource.getString((String)this.resourcePath, (String)"deliver_personal_supervisor");
        if (isOrg) {
            selfStr = EASResource.getString((String)this.resourcePath, (String)"deliver_org_oneself");
            supStr = EASResource.getString((String)this.resourcePath, (String)"deliver_org_supervisor");
        }
        PersonInfo personInfo = null;
        PersonCollection delivers = (PersonCollection)deliverMap.get(evaluObjectInfo.getId().toString());
        if (delivers != null && delivers.size() > 0) {
            int i;
            PersonCollection superior = new PersonCollection();
            PersonCollection oneself = new PersonCollection();
            PersonCollection appointPerson = new PersonCollection();
            int len = delivers.size();
            for (i = 0; i < len; ++i) {
                personInfo = delivers.get(i);
                if (personInfo == null) continue;
                if ("0".equals(personInfo.get("deliverType"))) {
                    oneself.add(personInfo);
                    continue;
                }
                if ("1".equals(personInfo.get("deliverType"))) {
                    superior.add(personInfo);
                    continue;
                }
                appointPerson.add(personInfo);
            }
            if (superior.size() > 0) {
                len = superior.size();
                for (i = 0; i < len; ++i) {
                    personInfo = superior.get(i);
                    deliverString.append(personInfo.getName()).append(supStr).append(",");
                }
            }
            if (oneself.size() > 0) {
                len = oneself.size();
                for (i = 0; i < len; ++i) {
                    personInfo = oneself.get(i);
                    deliverString.append(personInfo.getName()).append(selfStr).append(",");
                }
            }
            if (appointPerson.size() > 0) {
                len = appointPerson.size();
                for (i = 0; i < len; ++i) {
                    personInfo = appointPerson.get(i);
                    deliverString.append(personInfo.getName()).append(",");
                }
            }
            if (deliverString.length() > 0) {
                deliverString.replace(deliverString.lastIndexOf(","), deliverString.length(), "");
            }
        }
        return deliverString.toString();
    }

    @Override
    protected void _saveTargetDelivers(Context ctx, String evaluObjectID, Set addPersons, Set delPersons) throws BOSException, EASBizException {
        if (evaluObjectID == null) {
            return;
        }
        if (delPersons != null && delPersons.size() > 0) {
            StringBuffer delSql = new StringBuffer();
            delSql.append("delete from t_pf_targetDeliverer where fevaluObjectID = '");
            delSql.append(evaluObjectID);
            delSql.append("' and fpersonId in (");
            delSql.append(PerfUtils.convertSetToString(delPersons));
            delSql.append(")");
            DbUtil.execute((Context)ctx, (String)delSql.toString());
        }
        if (addPersons != null && addPersons.size() > 0) {
            StringBuffer addSql = new StringBuffer();
            addSql.append("insert into t_pf_targetDeliverer (FID, fpersonid, fevaluObjectid) values (newbosid('2FC98B8E'), ?, ?)");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(addSql.toString());
                Iterator iter = addPersons.iterator();
                while (iter.hasNext()) {
                    pstmt.setString(1, (String)iter.next());
                    pstmt.setString(2, evaluObjectID);
                    pstmt.addBatch();
                }
                logger.info((Object)addSql.toString());
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.info((Object)addSql.toString());
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    protected void _synTargetDeliver_unused(Context ctx, String evaluSolutionId, String evaluObjectId, boolean isOrg) throws BOSException, EASBizException {
        if (evaluSolutionId == null || evaluObjectId == null) {
            return;
        }
        IEvaluObject ievaluObject = EvaluObjectFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("targetDeliverers.id"));
        sic.add(new SelectorItemInfo("targetDeliverers.person.id"));
        EvaluObjectInfo evaluObject = ievaluObject.getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectId), sic);
        if (evaluObject == null) {
            return;
        }
        HashSet<String> targetDelivers = new HashSet<String>();
        if (evaluObject != null) {
            TargetDelivererCollection coll = evaluObject.getTargetDeliverers();
            TargetDelivererInfo deliver = null;
            String personId = null;
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    deliver = coll.get(i);
                    if (deliver == null || deliver.getPerson() == null || deliver.getPerson().getId() == null) continue;
                    personId = deliver.getPerson().getId().toString();
                    targetDelivers.add(personId);
                }
            }
        }
        HashSet<String> evaluObjects = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_pf_evaluObject where fevaluSolutionId = '");
        sql.append(evaluSolutionId);
        sql.append("' and fid != '");
        sql.append(evaluObjectId);
        sql.append("' and FDeleted = 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                evaluObjects.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.info((Object)sql.toString());
            throw new BOSException((Throwable)e);
        }
        if (evaluObjects.size() <= 0) {
            return;
        }
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from t_pf_targetDeliverer where fevaluObjectID in (");
        delSql.append(PerfUtils.convertSetToString(evaluObjects));
        delSql.append(")");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        if (targetDelivers.size() <= 0) {
            return;
        }
        String addSql = "insert into t_pf_targetDeliverer (FID, fpersonid, fevaluObjectid) values (newbosid('2FC98B8E'), ?, ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(addSql);
            Iterator iter = evaluObjects.iterator();
            Iterator iter2 = null;
            String objectId = null;
            int count = 0;
            while (iter.hasNext()) {
                objectId = (String)iter.next();
                iter2 = targetDelivers.iterator();
                while (iter2.hasNext()) {
                    pstmt.setString(1, (String)iter2.next());
                    pstmt.setString(2, objectId);
                    pstmt.addBatch();
                }
                if (++count != 50) continue;
                pstmt.executeBatch();
                count = 0;
            }
            if (count > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            logger.info((Object)addSql.toString());
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        StringBuffer del = new StringBuffer();
        if (!isOrg) {
            del.append("delete from t_pf_targetDeliverer where fid in (select deliver.fid from t_pf_targetDeliverer deliver inner join t_pf_evaluObject evaluObject ");
            del.append("on deliver.fpersonid = evaluObject.fobjectId where evaluObject.fevaluSolutionid = '");
            del.append(evaluSolutionId);
            del.append("' and deliver.fevaluObjectid = evaluObject.fid)");
        } else {
            del.append("delete from t_pf_targetDeliverer where fid in (select deliver.fid from t_pf_targetDeliverer deliver inner join t_pf_evaluObject evaluObject ");
            del.append("on deliver.fpersonid = evaluObject.FResponserID where evaluObject.fevaluSolutionid = '");
            del.append(evaluSolutionId);
            del.append("' and deliver.fevaluObjectid = evaluObject.fid)");
        }
        DbUtil.execute((Context)ctx, (String)del.toString());
    }

    @Override
    protected void _synTargetDeliver(Context ctx, String evaluSolutionId, String evaluObjectId, boolean isOrg) throws BOSException, EASBizException {
        if (evaluSolutionId == null || evaluObjectId == null) {
            return;
        }
        IEvaluObject ievaluObject = EvaluObjectFactory.getLocalInstance(ctx);
        EvaluObjectInfo evaluObject = ievaluObject.getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectId));
        if (evaluObject != null) {
            HashSet<String> evaluObjects = new HashSet<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select fid from t_pf_evaluObject where fevaluSolutionId = '");
            sql.append(evaluSolutionId);
            sql.append("' and fid != '");
            sql.append(evaluObjectId);
            sql.append("' and FDeleted = 0");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    evaluObjects.add(rowSet.getString("fid"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.info((Object)sql.toString());
                throw new BOSException((Throwable)e);
            }
            if (evaluObjects.size() <= 0) {
                return;
            }
            StringBuffer ids = new StringBuffer();
            Iterator itor = evaluObjects.iterator();
            while (itor.hasNext()) {
                ids.append("'");
                ids.append(itor.next().toString());
                ids.append("',");
            }
            if (ids.length() > 0) {
                ids.replace(ids.lastIndexOf(","), ids.length(), "");
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pf_evaluObject set FOneself=?,FSuperior=? where fid in(");
            updateSql.append(ids.toString());
            updateSql.append(");");
            Integer one = new Integer(1);
            Integer zero = new Integer(0);
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{evaluObject.isOneself() ? one : zero, evaluObject.isSuperior() ? one : zero});
        }
    }

    @Override
    protected void _synTargetDeliverToEvaluObjectSet(Context ctx, Set objectIdSet, String evaluObjectId, boolean isOrg) throws BOSException, EASBizException {
        IEvaluObject ievaluObject = EvaluObjectFactory.getLocalInstance(ctx);
        EvaluObjectInfo evaluObject = ievaluObject.getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectId));
        if (evaluObject != null) {
            if (objectIdSet.size() <= 0) {
                return;
            }
            StringBuffer ids = new StringBuffer();
            Iterator itor = objectIdSet.iterator();
            while (itor.hasNext()) {
                ids.append("'");
                ids.append(itor.next().toString());
                ids.append("',");
            }
            if (ids.length() > 0) {
                ids.replace(ids.lastIndexOf(","), ids.length(), "");
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pf_evaluObject set FOneself=?,FSuperior=? where fid in(");
            updateSql.append(ids.toString());
            updateSql.append(");");
            Integer one = new Integer(1);
            Integer zero = new Integer(0);
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{evaluObject.isOneself() ? one : zero, evaluObject.isSuperior() ? one : zero});
        }
    }

    private Map getEvaluTargetDeliver(Context ctx, EvaluObjectCollection evaluObjects, boolean isOrg) throws BOSException, EASBizException {
        HashMap<String, PersonCollection> map = new HashMap<String, PersonCollection>();
        if (evaluObjects != null && evaluObjects.size() > 0) {
            EvaluObjectCollection oneselfEvaluObject = new EvaluObjectCollection();
            EvaluObjectCollection superiorEvaluObject = new EvaluObjectCollection();
            EvaluObjectCollection appointPersonEvaluObject = new EvaluObjectCollection();
            int len = evaluObjects.size();
            for (int i = 0; i < len; ++i) {
                EvaluObjectInfo evaluObjectInfo = evaluObjects.get(i);
                if (evaluObjectInfo.isOneself()) {
                    oneselfEvaluObject.add(evaluObjectInfo);
                }
                if (evaluObjectInfo.isSuperior()) {
                    superiorEvaluObject.add(evaluObjectInfo);
                }
                if (!evaluObjectInfo.isAppointPerson()) continue;
                appointPersonEvaluObject.add(evaluObjectInfo);
            }
            Map oneself = this.getEvaluTargetDeliverOneself(ctx, oneselfEvaluObject, isOrg);
            Map superior = this.getEvaluTargetDeliverSuperior(ctx, superiorEvaluObject, isOrg);
            Map appointPerson = this.getEvaluTargetDeliverAppointPerson(ctx, appointPersonEvaluObject, isOrg);
            int len2 = evaluObjects.size();
            for (int i = 0; i < len2; ++i) {
                int j;
                int k;
                PersonCollection temps;
                PersonInfo person;
                String evaluObjectId = evaluObjects.get(i).getId().toString();
                PersonCollection persons = (PersonCollection)map.get(evaluObjectId);
                if (persons == null) {
                    persons = new PersonCollection();
                    map.put(evaluObjects.get(i).getId().toString(), persons);
                }
                if ((person = (PersonInfo)oneself.get(evaluObjectId)) != null && !persons.containsObject((IObjectValue)person)) {
                    persons.add(person);
                }
                if ((temps = (PersonCollection)superior.get(evaluObjectId)) != null && temps.size() > 0) {
                    k = temps.size();
                    for (j = 0; j < k; ++j) {
                        if (persons.containsObject(temps.getObject(j))) continue;
                        persons.add(temps.get(j));
                    }
                }
                if ((temps = (PersonCollection)appointPerson.get(evaluObjectId)) == null || temps.size() <= 0) continue;
                k = temps.size();
                for (j = 0; j < k; ++j) {
                    if (persons.containsObject(temps.getObject(j))) continue;
                    persons.add(temps.get(j));
                }
            }
        }
        return map;
    }

    private Map getEvaluTargetDeliverOneself(Context ctx, EvaluObjectCollection evaluObjects, boolean isOrg) throws BOSException {
        HashMap map = new HashMap();
        if (evaluObjects != null && evaluObjects.size() > 0) {
            HashMap<String, String> ids = new HashMap<String, String>();
            int len = evaluObjects.size();
            for (int i = 0; i < len; ++i) {
                EvaluObjectInfo tmp = evaluObjects.get(i);
                if (!tmp.isOneself()) continue;
                if (!isOrg) {
                    ids.put(tmp.getObjectID(), tmp.getId().toString());
                    continue;
                }
                if (tmp.getResponser() == null) continue;
                ids.put(tmp.getResponser().getId().toString(), tmp.getId().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("number"));
            evi.setSelector(selectors);
            fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids.keySet()), CompareType.INCLUDE));
            evi.setFilter(fi);
            PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
            if (persons != null && persons.size() > 0) {
                int len2 = persons.size();
                for (int i = 0; i < len2; ++i) {
                    PersonInfo person = persons.get(i);
                    person.put("deliverType", (Object)"0");
                    map.put(ids.get(person.getId().toString()), person);
                }
            }
        }
        return map;
    }

    private Map getEvaluTargetDeliverSuperior(Context ctx, EvaluObjectCollection evaluObjects, boolean isOrg) throws EASBizException, BOSException {
        HashMap map = new HashMap();
        if (evaluObjects != null && evaluObjects.size() > 0) {
            Map supervisorMap;
            if (isOrg) {
                return this.getEvaluTargetDeliverSuperior_org(ctx, evaluObjects);
            }
            HashMap<String, String> ids = new HashMap<String, String>();
            int len = evaluObjects.size();
            for (int i = 0; i < len; ++i) {
                EvaluObjectInfo tmp = evaluObjects.get(i);
                if (!tmp.isSuperior()) continue;
                ids.put(tmp.getObjectID(), tmp.getId().toString());
            }
            if (ids.size() > 0 && (supervisorMap = PersonBatchFacadeFactory.getLocalInstance(ctx).getSupervisor(ids.keySet(), "00000000-0000-0000-0000-000000000001396FCAD0", false)) != null && supervisorMap.size() > 0) {
                Set keys = supervisorMap.keySet();
                for (Object key : keys) {
                    if (key == null || ids.get(key) == null) continue;
                    PersonCollection persons = (PersonCollection)supervisorMap.get(key);
                    if (persons != null && persons.size() > 0) {
                        int len2 = persons.size();
                        for (int i = 0; i < len2; ++i) {
                            persons.get(i).put("deliverType", (Object)"1");
                        }
                    }
                    map.put(ids.get(key), supervisorMap.get(key));
                }
            }
        }
        return map;
    }

    private Map getEvaluTargetDeliverSuperior_org(Context ctx, EvaluObjectCollection evaluObjects) throws EASBizException, BOSException {
        HashMap<String, PersonCollection> map = new HashMap<String, PersonCollection>();
        HashMap<String, String> ids = new HashMap<String, String>();
        HashSet<String> orgIds = new HashSet<String>();
        int len = evaluObjects.size();
        for (int i = 0; i < len; ++i) {
            EvaluObjectInfo tmp = evaluObjects.get(i);
            if (!tmp.isSuperior()) continue;
            ids.put(tmp.getObjectID(), tmp.getId().toString());
            orgIds.add(tmp.getObjectID());
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", null));
        fi.setMaskString("#0 and (#1 or #2)");
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "ESOrgUnitAboutQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        try {
            while (rowSet.next()) {
                String key;
                String orgId = rowSet.getString("id");
                if (StringUtils.isEmpty((String)orgId) || (key = (String)ids.get(orgId)) == null) continue;
                if (map.get(key) == null) {
                    map.put(key, new PersonCollection());
                }
                PersonCollection delivers = (PersonCollection)map.get(key);
                if (rowSet.getString("responser.id") == null || rowSet.getString("deliverer.id") == null) continue;
                PersonInfo responserInfo = new PersonInfo();
                responserInfo.setId(BOSUuid.read((String)rowSet.getString("deliverer.id")));
                responserInfo.setName(rowSet.getString("deliverer.name"));
                responserInfo.put("deliverType", (Object)"1");
                if (delivers.contains(responserInfo)) continue;
                delivers.add(responserInfo);
            }
        }
        catch (SQLException sqe) {
            throw new BOSException((Throwable)sqe);
        }
        return map;
    }

    private Map getEvaluTargetDeliverAppointPerson(Context ctx, EvaluObjectCollection evaluObjects, boolean isOrg) throws BOSException {
        HashMap<String, PersonCollection> map = new HashMap<String, PersonCollection>();
        if (evaluObjects != null && evaluObjects.size() > 0) {
            HashMap<String, String> ids = new HashMap<String, String>();
            int len = evaluObjects.size();
            for (int i = 0; i < len; ++i) {
                EvaluObjectInfo tmp = evaluObjects.get(i);
                if (!tmp.isAppointPerson()) continue;
                ids.put(tmp.getId().toString(), tmp.getId().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("person.id"));
            selectors.add(new SelectorItemInfo("person.name"));
            selectors.add(new SelectorItemInfo("person.number"));
            selectors.add(new SelectorItemInfo("evaluObject.id"));
            selectors.add(new SelectorItemInfo("evaluObject.name"));
            selectors.add(new SelectorItemInfo("evaluObject.number"));
            evi.setSelector(null);
            fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", new HashSet(ids.keySet()), CompareType.INCLUDE));
            evi.setSelector(selectors);
            evi.setFilter(fi);
            TargetDelivererCollection targetDelivers = TargetDelivererFactory.getLocalInstance(ctx).getTargetDelivererCollection(evi);
            if (targetDelivers != null && targetDelivers.size() > 0) {
                int len2 = targetDelivers.size();
                for (int i = 0; i < len2; ++i) {
                    TargetDelivererInfo info = targetDelivers.get(i);
                    if (info == null || info.getPerson() == null) continue;
                    PersonInfo person = info.getPerson();
                    person.put("deliverType", (Object)"2");
                    PersonCollection persons = (PersonCollection)map.get(info.getEvaluObject().getId().toString());
                    if (persons == null) {
                        persons = new PersonCollection();
                        map.put(info.getEvaluObject().getId().toString(), persons);
                    }
                    persons.add(info.getPerson());
                }
            }
        }
        return map;
    }

    @Override
    protected IObjectCollection _getTargetDeliverPersons(Context ctx, String evaluObjectId, boolean isOrg) throws BOSException, EASBizException {
        if (evaluObjectId == null) {
            return null;
        }
        SelectorItemCollection sic = this.getSelector(isOrg);
        EvaluObjectInfo evaluObject = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectId), sic);
        EvaluObjectCollection coll = new EvaluObjectCollection();
        coll.add(evaluObject);
        Map delivers = this.getEvaluTargetDeliver(ctx, coll, isOrg);
        return (IObjectCollection)delivers.get(evaluObjectId);
    }

    @Override
    protected Map _getTargetDeliverPersons(Context ctx, IObjectCollection evaluObjectCollection, boolean isOrg) throws BOSException, EASBizException {
        if (evaluObjectCollection == null || evaluObjectCollection.size() < 1) {
            return null;
        }
        return this.getEvaluTargetDeliver(ctx, (EvaluObjectCollection)evaluObjectCollection, isOrg);
    }
}

