/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluRuleTool;
import com.kingdee.eas.hr.perf.EvaluSolutionException;
import com.kingdee.eas.hr.perf.EvaluSolutionRuleFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.ITargetDeliverer;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.ITargetEvaluStoreParent;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreSQLException;
import com.kingdee.eas.hr.perf.TargetStateEnum;
import com.kingdee.eas.hr.perf.app.AbstractTargetEvaluStoreControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TargetEvaluStoreControllerBean
extends AbstractTargetEvaluStoreControllerBean {
    private static final long serialVersionUID = -61166L;

    @Override
    protected void _deleteAll(Context ctx, String targetEvaluStoreID) throws BOSException, EASBizException {
        TargetEvaluStoreInfo info = (TargetEvaluStoreInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(targetEvaluStoreID));
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(targetEvaluStoreID));
        FilterItemInfo item = new FilterItemInfo("evaluTarget.id", (Object)info.getEvaluTarget().getId().toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        if (!this._exists(ctx, filter)) {
            iEvaluTarget.delete((IObjectPK)new ObjectUuidPK(info.getEvaluTarget().getId()));
        }
    }

    public IObjectPK[] delete(Context arg0, FilterInfo arg1) throws BOSException, EASBizException {
        IObjectPK[] pks = super.delete(arg0, arg1);
        return super.delete(arg0, arg1);
    }

    @Override
    protected void _saveTargetEvaluStoreData(Context ctx, Set targetStoreIdSet, IObjectCollection editStroeCollection, IObjectCollection editTargetCollection, IObjectCollection addStoreCollection, IObjectCollection addGroupTargetColl) throws BOSException, EASBizException {
        HashSet<String> evaluTargetIds = new HashSet<String>();
        Iterator iter = targetStoreIdSet.iterator();
        while (iter.hasNext()) {
            String storeId = iter.next().toString();
            TargetEvaluStoreInfo storeInfo = this.getTargetEvaluStoreInfo(ctx, (IObjectPK)new ObjectUuidPK(storeId));
            EvaluTargetInfo evaluTargetInfo = storeInfo.getEvaluTarget();
            evaluTargetIds.add(evaluTargetInfo.getId().toString());
        }
        if (evaluTargetIds.size() > 0) {
            FilterInfo filterInfo3 = new FilterInfo();
            filterInfo3.getFilterItems().add(new FilterItemInfo("evaluTarget.id", (Object)targetStoreIdSet, CompareType.INCLUDE));
            EvaluGroupTargetFactory.getLocalInstance(ctx).delete(filterInfo3);
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo("id", evaluTargetIds, CompareType.INCLUDE));
            EvaluTargetFactory.getLocalInstance(ctx).delete(filterInfo1);
        }
        if (targetStoreIdSet.size() > 0) {
            FilterInfo filterInfo2 = new FilterInfo();
            filterInfo2.getFilterItems().add(new FilterItemInfo("id", (Object)targetStoreIdSet, CompareType.INCLUDE));
            this.delete(ctx, filterInfo2);
        }
        if (!editStroeCollection.isEmpty() && editStroeCollection.size() > 0) {
            CoreBaseCollection updateStoreColl = new CoreBaseCollection();
            for (int i = 0; i < editStroeCollection.size(); ++i) {
                updateStoreColl.add((CoreBaseInfo)((TargetEvaluStoreInfo)editStroeCollection.getObject(i)));
            }
            this.update(ctx, updateStoreColl);
        }
        if (!editTargetCollection.isEmpty() && editTargetCollection.size() > 0) {
            CoreBaseCollection updateTargetColl = new CoreBaseCollection();
            for (int i = 0; i < editTargetCollection.size(); ++i) {
                updateTargetColl.add((CoreBaseInfo)((EvaluTargetInfo)editTargetCollection.getObject(i)));
            }
            EvaluTargetFactory.getLocalInstance(ctx).update(updateTargetColl);
        }
        if (!addStoreCollection.isEmpty() && addStoreCollection.size() > 0) {
            this._batchSubmit(ctx, addStoreCollection);
        }
        if (!addGroupTargetColl.isEmpty() && addGroupTargetColl.size() > 0) {
            CoreBaseCollection addGroupColl = new CoreBaseCollection();
            for (int i = 0; i < addGroupTargetColl.size(); ++i) {
                addGroupColl.add((CoreBaseInfo)((EvaluGroupTargetInfo)addGroupTargetColl.getObject(i)));
            }
            EvaluGroupTargetFactory.getLocalInstance(ctx).addnew(addGroupColl);
        }
    }

    @Override
    protected boolean _isRefered(Context ctx, String ID) throws BOSException, EASBizException {
        TargetEvaluStoreInfo info = (TargetEvaluStoreInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(ID));
        return info.isIsDelivered();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return "";
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        TargetEvaluStoreInfo info = (TargetEvaluStoreInfo)super._getValue(ctx, pk, sic);
        if (info != null) {
            if (info.getSolutionPeriod() != null && info.getEvaluObject() != null) {
                return info.getSolutionPeriod().getName() + "_" + info.getEvaluObject().getName();
            }
            return " ";
        }
        return " ";
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TargetEvaluStoreInfo info = (TargetEvaluStoreInfo)this.getValue(ctx, pk);
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        super._delete(ctx, pk);
        FilterItemInfo item = new FilterItemInfo("evaluTarget.id", (Object)info.getEvaluTarget().getId().toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        if (!this._exists(ctx, filter)) {
            iEvaluTarget.delete((IObjectPK)new ObjectUuidPK(info.getEvaluTarget().getId()));
        }
    }

    @Override
    protected IObjectCollection _getPersonalSubAndDeliverEvaluObject(Context ctx, BOSUuid currentPersonID) throws BOSException, EASBizException {
        PersonCollection ret = new PersonCollection();
        IPersonFacade facade = PersonFacadeFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = facade.getSubordinate(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001396FCAD0"), currentPersonID);
        PersonInfo person = null;
        HashSet<String> subSet = new HashSet<String>();
        if (personColl != null && personColl.size() > 0) {
            int n = personColl.size();
            for (int i = 0; i < n; ++i) {
                person = personColl.get(i);
                if (person.getId().equals((Object)currentPersonID)) continue;
                subSet.add(person.getId().toString());
                ret.add(person);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.evaluObjectType", (Object)new Integer(100), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        if (subSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", subSet, CompareType.NOTINCLUDE));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        ITargetDeliverer iTargetDeliverer = TargetDelivererFactory.getLocalInstance(ctx);
        TargetDelivererCollection coll = iTargetDeliverer.getTargetDelivererCollection(viewInfo);
        if (coll != null) {
            String id = null;
            HashSet<String> evaluObjectIdSet = new HashSet<String>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                person = new PersonInfo();
                id = coll.get(i).getEvaluObject().getObjectID();
                person.setId(BOSUuid.read((String)id));
                person.setName(coll.get(i).getEvaluObject().getName());
                ret.add(person);
                if (subSet.contains(id)) continue;
                person.put("deliver", (Object)"true");
                evaluObjectIdSet.add(coll.get(i).getEvaluObject().getId().toString());
                person.put("evaluObject", evaluObjectIdSet);
            }
        }
        return ret;
    }

    @Override
    protected Map _getOrgSubAndDeliverEvaluObject(Context ctx, BOSUuid currentPersonID) throws BOSException, EASBizException {
        LinkedHashMap ret = new LinkedHashMap();
        LinkedHashMap directEvaluObject = new LinkedHashMap();
        LinkedHashMap orgMap = new LinkedHashMap();
        this.initInChargedAdminOrgUnit(ctx, currentPersonID, orgMap, directEvaluObject);
        this.initOwnDirectSubAdiminOrgUnit(ctx, currentPersonID, orgMap);
        this.initTempResponserAdminOrgUnit(ctx, currentPersonID, orgMap, directEvaluObject);
        this.initDelivererObjectOrg(ctx, currentPersonID, orgMap);
        ret.put("directEvaluObject", directEvaluObject);
        ret.put("orgMap", orgMap);
        return ret;
    }

    private void initInChargedAdminOrgUnit(Context ctx, BOSUuid currentPersonID, HashMap orgMap, HashMap directEvaluObject) throws BOSException, EASBizException {
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "InChargedAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        String id = null;
        try {
            while (rowSet.next()) {
                orgUnit = new AdminOrgUnitInfo();
                id = rowSet.getString("AdminOrgUnit.id");
                orgUnit.setId(BOSUuid.read((String)id));
                orgUnit.setName(rowSet.getString("AdminOrgUnit.name"));
                directEvaluObject.put(id, orgUnit);
                orgMap.put(id, orgUnit);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void initOwnDirectSubAdiminOrgUnit(Context ctx, BOSUuid currentPersonID, HashMap orgMap) throws BOSException, EASBizException {
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SubAdminOrgUnitByPositionQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("PositionMember.isPrimary", (Object)new Boolean(true)));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        String id = null;
        try {
            while (rowSet.next()) {
                id = rowSet.getString("id");
                orgUnit = new AdminOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)id));
                orgUnit.setName(rowSet.getString("name"));
                orgMap.put(id, orgUnit);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void initDelivererObjectOrg(Context ctx, BOSUuid currentPersonID, HashMap orgMap) throws BOSException, EASBizException {
        ITargetDeliverer iTargetDeliverer = TargetDelivererFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.evaluObjectType", (Object)new Integer(101), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)new Boolean(false)));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        TargetDelivererCollection coll = iTargetDeliverer.getTargetDelivererCollection(viewInfo);
        AdminOrgUnitInfo admin = null;
        if (coll != null) {
            HashSet<BOSUuid> evaluObjectIdSet = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)coll.get(i).getEvaluObject().getObjectID()));
                admin.setName(coll.get(i).getEvaluObject().getName());
                if (!orgMap.keySet().contains(admin.getId().toString())) {
                    admin.put("deliver", (Object)"true");
                    evaluObjectIdSet.add(coll.get(i).getEvaluObject().getId());
                    admin.put("evaluObject", evaluObjectIdSet);
                }
                orgMap.put(admin.getId().toString(), admin);
            }
        }
    }

    private void initTempResponserAdminOrgUnit(Context ctx, BOSUuid currentPersonID, HashMap orgMap, HashMap directEvaluObject) throws BOSException, EASBizException {
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "TempResponseAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("responser.id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Boolean(false)));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = iqec.executeQuery();
            AdminOrgUnitInfo orgUnit = null;
            while (rowSet.next()) {
                orgUnit = new AdminOrgUnitInfo();
                String id = rowSet.getString("adminOrgUnit.id");
                orgUnit.setId(BOSUuid.read((String)id));
                orgUnit.setName(rowSet.getString("adminOrgUnit.name"));
                directEvaluObject.put(id, orgUnit);
                orgMap.put(id, orgUnit);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void initSubTempResponserAdminOrgUnit(Context ctx, BOSUuid currentPersonID, HashMap orgMap) throws BOSException, EASBizException {
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SubTempResponseAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)currentPersonID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = iqec.executeQuery();
            AdminOrgUnitInfo orgUnit = null;
            String id = null;
            while (rowSet.next()) {
                id = rowSet.getString("adminOrgUnit.id");
                orgUnit = new AdminOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)id));
                orgUnit.setName(rowSet.getString("adminOrgUnit.name"));
                orgMap.put(id, orgUnit);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    protected IObjectCollection _batchSubmit(Context ctx, IObjectCollection targetEvaluStoreColls) throws EASBizException, BOSException {
        TargetEvaluStoreInfo info = null;
        EvaluTargetInfo evaluTargetInfo = null;
        IObjectPK pk = null;
        String logStr = null;
        if (targetEvaluStoreColls.size() > 0) {
            info = (TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(0);
            logStr = this.getLog(ctx, info);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TargetEvaluStoreFactory.getLocalInstance(ctx).getType(), null, logStr, (String)"perf_TragetItem_update");
        ITargetEvaluStore iTargetEvaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        int n = targetEvaluStoreColls.size();
        for (int i = 0; i < n; ++i) {
            info = (TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(i);
            evaluTargetInfo = info.getEvaluTarget();
            pk = iEvaluTarget.submit((CoreBaseInfo)evaluTargetInfo);
            evaluTargetInfo.setId(BOSUuid.read((String)pk.toString()));
            pk = iTargetEvaluStore.submit((CoreBaseInfo)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return targetEvaluStoreColls;
    }

    private String getLog(Context ctx, TargetEvaluStoreInfo info) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        EvaluObjectInfo evaluObjectInfo = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(info.getEvaluObject().getId().toString()), sic);
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(info.getSolutionPeriod().getId().toString()), sic);
        StringBuffer retValue = new StringBuffer();
        if (evaluObjectInfo != null && evaluObjectInfo.getName() != null) {
            retValue.append(evaluObjectInfo.getName());
        }
        retValue.append("   ");
        if (solutionPeriodInfo != null && solutionPeriodInfo.getName() != null) {
            retValue.append(solutionPeriodInfo.getName());
        }
        return retValue.toString();
    }

    private void checkTotalWeight(Context ctx, IObjectCollection targetEvaluStoreColls) throws BOSException, TargetEvaluStoreSQLException, EvaluSolutionException {
        TargetEvaluStoreInfo info = null;
        if (targetEvaluStoreColls.size() <= 0) {
            return;
        }
        info = (TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(0);
        boolean isControlWeight = info.getSolutionPeriod().getEvaluSolution().isIsControlWeight();
        if (!isControlWeight) {
            HashSet<String> ids = new HashSet<String>();
            int n = targetEvaluStoreColls.size();
            for (int i = 0; i < n; ++i) {
                if (((TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(i)).getId() == null) continue;
                ids.add(((TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(i)).getId().toString());
            }
            BOSUuid assessPeriodID = info.getSolutionPeriod().getAssessPeriod().getId();
            BOSUuid evaluSolutionID = info.getSolutionPeriod().getEvaluSolution().getId();
            String evaluObjectID = info.getString("evaluObject.objectID");
            BigDecimal totalWeight = new BigDecimal("0.00");
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "TargetEvaluStoreWeightQuery"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodID.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)evaluObjectID, CompareType.EQUALS));
            if (ids.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.NOTINCLUDE));
                filter.setMaskString("#0 and #1 and #2 and #3");
            } else {
                filter.setMaskString("#0 and #1 and #2");
            }
            viewInfo.setFilter(filter);
            iqec.setObjectView(viewInfo);
            IRowSet rowSet = iqec.executeQuery();
            try {
                if (rowSet.next()) {
                    totalWeight = rowSet.getBigDecimal("sumWeight");
                }
            }
            catch (SQLException ex) {
                throw new TargetEvaluStoreSQLException(TargetEvaluStoreSQLException.SQLEXCEPTION);
            }
            int n2 = targetEvaluStoreColls.size();
            for (int i = 0; i < n2; ++i) {
                info = (TargetEvaluStoreInfo)targetEvaluStoreColls.getObject(i);
                totalWeight = totalWeight.add(info.getWeight());
            }
            if (totalWeight.compareTo(new BigDecimal("100.00")) > 0) {
                throw new EvaluSolutionException(EvaluSolutionException.TARGETFULL);
            }
        }
    }

    @Override
    protected void _updateAchieveDataValue(Context ctx, IObjectCollection targetEvaluStoreCollection, String evaluType) throws BOSException {
        if (targetEvaluStoreCollection.size() != 0 || targetEvaluStoreCollection != null) {
            Connection conn = null;
            PreparedStatement prst = null;
            String sql = "update T_PF_TargetEvaluStore set fThresholdvalue = ?, fStandardValue = ?, fChallengeValue= ? where fid = ?";
            try {
                conn = this.getConnection(ctx);
                prst = conn.prepareStatement(sql);
                Iterator iter = targetEvaluStoreCollection.iterator();
                TargetEvaluStoreInfo info = null;
                while (iter.hasNext()) {
                    info = (TargetEvaluStoreInfo)iter.next();
                    prst.setBigDecimal(1, info.getThresholdValue());
                    prst.setBigDecimal(2, info.getStandardValue());
                    prst.setBigDecimal(3, info.getChallengeValue());
                    prst.setString(4, info.getId().toString());
                    prst.addBatch();
                }
                prst.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(prst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)prst, (Connection)conn);
        }
        if (targetEvaluStoreCollection.size() != 0 || targetEvaluStoreCollection != null) {
            HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
            EntityViewInfo evi = new EntityViewInfo();
            for (TargetEvaluStoreInfo value : targetEvaluStoreCollection) {
                idSet.add(value.getId());
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("thresholdValue");
            sic.add("standardValue");
            sic.add("challengeValue");
            sic.add("solutionPeriod.id");
            sic.add("evaluObject.objectID");
            sic.add("evaluTarget.formula.achieveItem.id");
            evi.setSelector(sic);
            TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
            StringBuffer upd_sql = new StringBuffer();
            upd_sql.append("update  t_pf_achieveData");
            upd_sql.append(" set FThresholdValue = ?,FStandardValue = ? ,FChallengeValue = ? ");
            upd_sql.append(" where FAchieveItemID = ?\u3000");
            upd_sql.append(" and FSolutionPeriodID = ?");
            if ("person".equals(evaluType)) {
                upd_sql.append(" and FPersonID = ?");
            } else {
                upd_sql.append(" and FOrgUnitID = ?");
            }
            Connection conn = null;
            PreparedStatement prst = null;
            conn = this.getConnection(ctx);
            try {
                prst = conn.prepareStatement(upd_sql.toString());
                TargetEvaluStoreInfo storeInfo = null;
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    storeInfo = coll.get(i);
                    if (storeInfo.getEvaluTarget().getFormula() == null || storeInfo.getEvaluTarget().getFormula().getAchieveItem() == null) continue;
                    storeInfo.getId().toString();
                    storeInfo.getSolutionPeriod().getId();
                    storeInfo.getEvaluObject().getId();
                    prst.setBigDecimal(1, storeInfo.getThresholdValue());
                    prst.setBigDecimal(2, storeInfo.getStandardValue());
                    prst.setBigDecimal(3, storeInfo.getChallengeValue());
                    prst.setString(4, storeInfo.getEvaluTarget().getFormula().getAchieveItem().getId().toString());
                    prst.setString(5, storeInfo.getSolutionPeriod().getId().toString());
                    prst.setString(6, storeInfo.getEvaluObject().getObjectID());
                    prst.addBatch();
                }
                prst.executeBatch();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)prst, (Connection)conn);
            }
            Iterator idIterator = idSet.iterator();
            String id = null;
            while (idIterator.hasNext()) {
                id = idIterator.next().toString();
                try {
                    IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TargetEvaluStoreFactory.getLocalInstance(ctx).getType(), null, (String)this._getLogInfo(ctx, (IObjectPK)new ObjectUuidPK(id)), (String)"perf_TargetEvaluStore_update");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _updateTargetValue(Context ctx, IObjectCollection targetEvaluStoreCollection, String evaluType) throws BOSException {
        if (targetEvaluStoreCollection.size() != 0 || targetEvaluStoreCollection != null) {
            Connection conn = null;
            PreparedStatement prst = null;
            String sql = "update T_PF_TargetEvaluStore set fThresholdvalue = ?, fStandardValue = ?, fChallengeValue= ? where fid = ?";
            try {
                conn = this.getConnection(ctx);
                prst = conn.prepareStatement(sql);
                Iterator iter = targetEvaluStoreCollection.iterator();
                TargetEvaluStoreInfo info = null;
                while (iter.hasNext()) {
                    info = (TargetEvaluStoreInfo)iter.next();
                    prst.setBigDecimal(1, info.getThresholdValue());
                    prst.setBigDecimal(2, info.getStandardValue());
                    prst.setBigDecimal(3, info.getChallengeValue());
                    prst.setString(4, info.getId().toString());
                    prst.addBatch();
                }
                prst.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(prst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)prst, (Connection)conn);
        }
        if (targetEvaluStoreCollection.size() != 0 || targetEvaluStoreCollection != null) {
            HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
            EntityViewInfo evi = new EntityViewInfo();
            for (TargetEvaluStoreInfo value : targetEvaluStoreCollection) {
                idSet.add(value.getId());
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("thresholdValue");
            sic.add("standardValue");
            sic.add("challengeValue");
            sic.add("solutionPeriod.id");
            sic.add("evaluObject.objectID");
            sic.add("evaluTarget.formula.achieveItem.id");
            evi.setSelector(sic);
            TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
            StringBuffer upd_sql = new StringBuffer();
            upd_sql.append("update  t_pf_achieveData");
            upd_sql.append(" set FThresholdValue = ?,FStandardValue = ? ,FChallengeValue = ? ");
            upd_sql.append(" where FAchieveItemID = ?\u3000");
            upd_sql.append(" and FSolutionPeriodID = ?");
            if ("person".equals(evaluType)) {
                upd_sql.append(" and FPersonID = ?");
            } else {
                upd_sql.append(" and FOrgUnitID = ?");
            }
            Connection conn = null;
            PreparedStatement prst = null;
            conn = this.getConnection(ctx);
            try {
                prst = conn.prepareStatement(upd_sql.toString());
                TargetEvaluStoreInfo storeInfo = null;
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    storeInfo = coll.get(i);
                    if (storeInfo.getEvaluTarget().getFormula() == null) continue;
                    storeInfo.getId().toString();
                    storeInfo.getSolutionPeriod().getId();
                    storeInfo.getEvaluObject().getId();
                    prst.setBigDecimal(1, storeInfo.getThresholdValue());
                    prst.setBigDecimal(2, storeInfo.getStandardValue());
                    prst.setBigDecimal(3, storeInfo.getChallengeValue());
                    prst.setString(4, storeInfo.getEvaluTarget().getFormula().getAchieveItem().getId().toString());
                    prst.setString(5, storeInfo.getSolutionPeriod().getId().toString());
                    prst.setString(6, storeInfo.getEvaluObject().getObjectID());
                    prst.addBatch();
                }
                prst.executeBatch();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)prst, (Connection)conn);
            }
        }
    }

    @Override
    protected void _auditTarget(Context ctx, List targetIdList) throws BOSException {
        StringBuffer idBuf = new StringBuffer();
        int size = targetIdList.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                idBuf.append("(");
            }
            idBuf.append("'").append(targetIdList.get(i)).append("'");
            if (i != size - 1) {
                idBuf.append(",");
                continue;
            }
            idBuf.append(")");
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_PF_TargetEvaluStore set FAuditStatus = 20 where fid in ").append(idBuf);
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    @Override
    protected void _addByGroupTargetGroupObject(Context ctx, Set evaluGroupIdSet, boolean isAdbdolute) throws BOSException, EASBizException {
        String evaluGroupId = null;
        Iterator iterator = evaluGroupIdSet.iterator();
        Connection conn = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        Map absoluterFitMap = EvaluSolutionRuleFacadeFactory.getLocalInstance(ctx).isAbsoluteFitRuleSolutionPhase(evaluGroupIdSet);
        try {
            while (iterator.hasNext()) {
                evaluGroupId = iterator.next().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("solutionPeriod.id"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.deliverMode"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.modifyContent"));
                sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.evaluRule.EvaluRuleToolClassName"));
                EvaluGroupInfo evaluGroupInfo = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId), sic);
                EvaluGroupTargetCollection groupTargetColl = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(this.getEntityViewInfo(BOSUuid.read((String)evaluGroupId)));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filterInfo);
                EvaluGroupObjectCollection evaluGroupObjectCollection = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectCollection(view);
                String creatorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String controlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                HashSet<String> evaluObjectIDset = new HashSet<String>();
                for (int l = 0; l < evaluGroupObjectCollection.size(); ++l) {
                    evaluObjectIDset.add(evaluGroupObjectCollection.get(l).getEvaluObject().getId().toString());
                }
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)evaluGroupInfo.getSolutionPeriod().getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", evaluObjectIDset, CompareType.INCLUDE));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fi);
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.getSelector().add(new SelectorItemInfo("evaluObject"));
                evi.getSelector().add(new SelectorItemInfo("solutionPeriod"));
                ITargetEvaluStoreParent storeParentInstance = TargetEvaluStoreParentFactory.getLocalInstance(ctx);
                TargetEvaluStoreParentCollection storeParentCollection = storeParentInstance.getTargetEvaluStoreParentCollection(evi);
                HashMap<String, TargetEvaluStoreParentInfo> storeParentMap = new HashMap<String, TargetEvaluStoreParentInfo>();
                for (int m = 0; m < storeParentCollection.size(); ++m) {
                    storeParentMap.put(storeParentCollection.get(m).getEvaluObject().getId().toString(), storeParentCollection.get(m));
                }
                CoreBaseCollection updateStoreParentColl = new CoreBaseCollection();
                TargetEvaluStoreParentInfo storeParentInfo = null;
                TargetStateEnum targetStateEnum = (Boolean)absoluterFitMap.get(evaluGroupId) != false ? TargetStateEnum.DELIEVERED : TargetStateEnum.unSubmit;
                boolean modifyFormSolutionContent = evaluGroupInfo.getSolutionPeriod().getEvaluSolution().isModifyContent();
                if (modifyFormSolutionContent) {
                    targetStateEnum = TargetStateEnum.unSubmit;
                }
                String ruleToolClassName = evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getEvaluRule().getEvaluRuleToolClassName();
                EvaluRuleTool evaluRuleTool = (EvaluRuleTool)Class.forName(ruleToolClassName).newInstance();
                evaluRuleTool.setCtx(ctx);
                String storeParentId = null;
                for (int n = 0; n < evaluGroupObjectCollection.size(); ++n) {
                    if (storeParentMap.get(evaluGroupObjectCollection.get(n).getEvaluObject().getId().toString()) != null) {
                        TargetEvaluStoreParentInfo tempInfo = (TargetEvaluStoreParentInfo)storeParentMap.get(evaluGroupObjectCollection.get(n).getEvaluObject().getId().toString());
                        tempInfo.setState(targetStateEnum);
                        tempInfo.setSolutionDeliverd(true);
                        updateStoreParentColl.add((CoreBaseInfo)tempInfo);
                        continue;
                    }
                    storeParentInfo = new TargetEvaluStoreParentInfo();
                    storeParentId = BOSUuid.create((BOSObjectType)storeParentInfo.getBOSType()).toString();
                    storeParentInfo.setId(BOSUuid.read((String)storeParentId));
                    storeParentInfo.setSolutionPeriod(evaluGroupInfo.getSolutionPeriod());
                    storeParentInfo.setEvaluObject(evaluGroupObjectCollection.get(n).getEvaluObject());
                    storeParentInfo.setState(targetStateEnum);
                    storeParentInfo.setSolutionDeliverd(true);
                    updateStoreParentColl.add((CoreBaseInfo)storeParentInfo);
                    storeParentMap.put(evaluGroupObjectCollection.get(n).getEvaluObject().getId().toString(), storeParentInfo);
                }
                TargetEvaluStoreParentFactory.getLocalInstance(ctx).save(updateStoreParentColl);
                String sql0 = "INSERT INTO T_PF_TargetEvaluStore (FID, FCreatorID, FCreateTime, FControlUnitID, FWeight, FIsDelivered, FEvaluObjectID, FEvaluTargetID, FSolutionPeriodID, FHROrgUnitID, FUniteTarget,FThresholdValue,FStandardValue,FChallengeValue,FMultiTableID,FValues,FParentID,FState,FdeleteableByUndeliver,FSeqNumber) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmt = conn.prepareStatement(sql0);
                StringBuffer sql1 = new StringBuffer();
                sql1.append("Insert into t_pf_evalutarget");
                sql1.append("(fid,FCreateTime,FLastUpdateTime,FThresholdValue,FChallengeValue,FStandardValue,FReservedField2,FFirstTypeWeight,");
                sql1.append("FFirstTypeScore,FSecondTypeWeight,FSecondTypeScore,FReportFrequency,FSeqNumber,FDataPrecision,");
                sql1.append("FPrecisionType,FTargetType,FKind,FContent2,FStandard2,FDescription,FNumber,FValue,FContent,FStandard,FReservedField2text,");
                sql1.append("FReservedField3,FReservedField4,FReservedField5,FReservedField6,FScoringMethod,FEvaluationSide,FReservedField1,FUnit,FTypeID,");
                sql1.append("FControlUnitID,FLastUpdateUserID,FCreatorID,FSolutionPeriodID,FTargetID,FSecondTypeID,FFormulaID) ");
                sql1.append(" select ?,FCreateTime,FLastUpdateTime,FThresholdValue,FChallengeValue,FStandardValue,FReservedField2,FFirstTypeWeight,");
                sql1.append("FFirstTypeScore,FSecondTypeWeight,FSecondTypeScore,FReportFrequency,FSeqNumber,FDataPrecision,");
                sql1.append("FPrecisionType,FTargetType,FKind,FContent2,FStandard2,FDescription,FNumber,FValue,FContent,FStandard,FReservedField2text,");
                sql1.append("FReservedField3,FReservedField4,FReservedField5,FReservedField6,FScoringMethod,FEvaluationSide,FReservedField1,FUnit,FTypeID,");
                sql1.append("FControlUnitID,FLastUpdateUserID,FCreatorID,FSolutionPeriodID,FTargetID,FSecondTypeID,FFormulaID ");
                sql1.append(" from t_pf_evalutarget where fid= ? ");
                pstmt1 = conn.prepareStatement(sql1.toString());
                EvaluGroupTargetInfo groupTargetInfo = null;
                EvaluTargetInfo targetInfo = null;
                int count = 0;
                String hrUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
                boolean isAddEvalutarget = false;
                boolean isAddEvalutarget0 = false;
                EvaluGroupObjectInfo info = null;
                for (int i = 0; i < groupTargetColl.size(); ++i) {
                    groupTargetInfo = groupTargetColl.get(i);
                    targetInfo = groupTargetInfo.getEvaluTarget();
                    if (targetInfo == null) continue;
                    boolean isGroupTargetWhole = evaluRuleTool.isGroupTargetWhole(groupTargetInfo);
                    int size = evaluGroupObjectCollection.size();
                    for (int j = 0; j < size; ++j) {
                        String tempEvaluTargetId;
                        ++count;
                        info = (EvaluGroupObjectInfo)evaluGroupObjectCollection.getObject(j);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)new TargetEvaluStoreInfo().getBOSType()).toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)creatorID);
                        pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)controlUnitID);
                        pstmt.setBigDecimal(5, groupTargetInfo.getWeight() == null ? new BigDecimal("0") : groupTargetInfo.getWeight());
                        pstmt.setInt(6, 0);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)info.getEvaluObject().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)evaluGroupInfo.getSolutionPeriod().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)hrUnit);
                        if (modifyFormSolutionContent) {
                            pstmt.setInt(11, 0);
                            tempEvaluTargetId = BOSUuid.create((BOSObjectType)targetInfo.getBOSType()).toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)tempEvaluTargetId);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)1, (String)tempEvaluTargetId);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)2, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                            isAddEvalutarget = true;
                            isAddEvalutarget0 = true;
                        } else if (!isGroupTargetWhole) {
                            pstmt.setInt(11, 0);
                            tempEvaluTargetId = BOSUuid.create((BOSObjectType)targetInfo.getBOSType()).toString();
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)tempEvaluTargetId);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)1, (String)tempEvaluTargetId);
                            DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)2, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                            isAddEvalutarget = true;
                            isAddEvalutarget0 = true;
                        } else {
                            pstmt.setInt(11, 1);
                        }
                        if (targetInfo.getThresholdValue() != null) {
                            pstmt.setBigDecimal(12, targetInfo.getThresholdValue());
                        } else {
                            pstmt.setNull(12, 3);
                        }
                        if (targetInfo.getStandardValue() != null) {
                            pstmt.setBigDecimal(13, targetInfo.getStandardValue());
                        } else {
                            pstmt.setNull(13, 3);
                        }
                        if (targetInfo.getChallengeValue() != null) {
                            pstmt.setBigDecimal(14, targetInfo.getChallengeValue());
                        } else {
                            pstmt.setNull(14, 3);
                        }
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)groupTargetInfo.getMultiTable().getId().toString());
                        pstmt.setBigDecimal(16, groupTargetInfo.getValues());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)17, (String)((TargetEvaluStoreParentInfo)storeParentMap.get(info.getEvaluObject().getId().toString())).getId().toString());
                        if (modifyFormSolutionContent) {
                            pstmt.setInt(18, 3);
                        } else if (!isGroupTargetWhole) {
                            pstmt.setInt(18, 3);
                        } else {
                            pstmt.setInt(18, 2);
                        }
                        pstmt.setInt(19, 1);
                        pstmt.setInt(20, targetInfo.getSeqNumber());
                        pstmt.addBatch();
                        if (isAddEvalutarget0) {
                            pstmt1.addBatch();
                            isAddEvalutarget0 = false;
                        }
                        if (count != 1000) continue;
                        pstmt.executeBatch();
                        if (isAddEvalutarget) {
                            pstmt1.executeBatch();
                            isAddEvalutarget = false;
                        }
                        count = 0;
                    }
                }
                if (count > 0) {
                    pstmt.executeBatch();
                    if (isAddEvalutarget) {
                        pstmt1.executeBatch();
                        isAddEvalutarget = false;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt1);
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private EntityViewInfo getEntityViewInfo(BOSUuid evaluGroupId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("values"));
        evi.getSelector().add(new SelectorItemInfo("multiTable.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standardValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.challengeValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.firstTypeWeight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.firstTypeScore"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.content"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.seqNumber"));
        return evi;
    }

    @Override
    protected void _addnew(Context ctx, String evaluGroupId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        if (evaluObjectIdSet.isEmpty()) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.deliverMode"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.allocateTarget"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.modifyContent"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.evaluRule.EvaluRuleToolClassName"));
        EvaluGroupInfo evaluGroupInfo = EvaluGroupFactory.getLocalInstance(ctx).getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(evaluGroupId), sic);
        EvaluGroupTargetCollection groupTargetColl = EvaluGroupTargetFactory.getLocalInstance(ctx).getEvaluGroupTargetCollection(this.getEntityViewInfo(BOSUuid.read((String)evaluGroupId)));
        Connection conn = this.getConnection(ctx);
        PreparedStatement pstmtUpdateParent = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        TargetEvaluStoreParentCollection storeParentColl = this.getStoreParentId(ctx, evaluGroupInfo.getSolutionPeriod().getId().toString(), evaluObjectIdSet);
        HashMap<String, String> storeParentMap = new HashMap<String, String>();
        TargetEvaluStoreParentInfo parentInfo = null;
        int size = storeParentColl.size();
        for (int i = 0; i < size; ++i) {
            parentInfo = storeParentColl.get(i);
            storeParentMap.put(parentInfo.getEvaluObject().getId().toString(), parentInfo.getId().toString());
        }
        try {
            Map absoluterFitMap;
            HashSet<String> evaluGroupIdSet = new HashSet<String>();
            evaluGroupIdSet.add(evaluGroupId);
            TargetStateEnum targetStateEnum = evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getAllocateTarget() == 1 ? TargetStateEnum.DELIEVERED : ((Boolean)(absoluterFitMap = EvaluSolutionRuleFacadeFactory.getLocalInstance(ctx).isAbsoluteFitRuleSolutionPhase(evaluGroupIdSet)).get(evaluGroupId) != false ? TargetStateEnum.DELIEVERED : TargetStateEnum.unSubmit);
            boolean modifyFormSolutionContent = evaluGroupInfo.getSolutionPeriod().getEvaluSolution().isModifyContent();
            if (modifyFormSolutionContent) {
                targetStateEnum = TargetStateEnum.unSubmit;
            }
            String sqlUpdateParent = "update t_pf_targetevalustoreparent set FState= ?,FSolutionDeliverd = 1 where FEvaluObjectID in (" + PerfUtils.convertSetToString(evaluObjectIdSet) + ") AND FSOLUTIONPERIODID = ? ";
            pstmtUpdateParent = conn.prepareStatement(sqlUpdateParent);
            pstmtUpdateParent.setInt(1, targetStateEnum.getValue());
            pstmtUpdateParent.setString(2, evaluGroupInfo.getSolutionPeriod().getId().toString());
            String sql0 = "INSERT INTO T_PF_TargetEvaluStore (FID, FCreatorID, FCreateTime, FControlUnitID, FWeight, FIsDelivered, FEvaluObjectID, FEvaluTargetID, FSolutionPeriodID, FHROrgUnitID, FUniteTarget,FThresholdValue,FStandardValue,FChallengeValue,FMultiTableID,FValues,FParentID,FState,FdeleteableByUndeliver,FSeqNumber) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql0);
            StringBuffer sql1 = new StringBuffer();
            sql1.append("Insert into t_pf_evalutarget");
            sql1.append("(fid,FCreateTime,FLastUpdateTime,FThresholdValue,FChallengeValue,FStandardValue,FReservedField2,FFirstTypeWeight,");
            sql1.append("FFirstTypeScore,FSecondTypeWeight,FSecondTypeScore,FReportFrequency,FSeqNumber,FDataPrecision,");
            sql1.append("FPrecisionType,FTargetType,FKind,FContent2,FStandard2,FDescription,FNumber,FValue,FContent,FStandard,FReservedField2text,");
            sql1.append("FReservedField3,FReservedField4,FReservedField5,FReservedField6,FScoringMethod,FEvaluationSide,FReservedField1,FUnit,FTypeID,");
            sql1.append("FControlUnitID,FLastUpdateUserID,FCreatorID,FSolutionPeriodID,FTargetID,FSecondTypeID,FFormulaID) ");
            sql1.append(" select ?,FCreateTime,FLastUpdateTime,FThresholdValue,FChallengeValue,FStandardValue,FReservedField2,FFirstTypeWeight,");
            sql1.append("FFirstTypeScore,FSecondTypeWeight,FSecondTypeScore,FReportFrequency,FSeqNumber,FDataPrecision,");
            sql1.append("FPrecisionType,FTargetType,FKind,FContent2,FStandard2,FDescription,FNumber,FValue,FContent,FStandard,FReservedField2text,");
            sql1.append("FReservedField3,FReservedField4,FReservedField5,FReservedField6,FScoringMethod,FEvaluationSide,FReservedField1,FUnit,FTypeID,");
            sql1.append("FControlUnitID,FLastUpdateUserID,FCreatorID,FSolutionPeriodID,FTargetID,FSecondTypeID,FFormulaID ");
            sql1.append(" from t_pf_evalutarget where fid= ? ");
            pstmt1 = conn.prepareStatement(sql1.toString());
            String ruleToolClassName = evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getEvaluRule().getEvaluRuleToolClassName();
            EvaluRuleTool evaluRuleTool = (EvaluRuleTool)Class.forName(ruleToolClassName).newInstance();
            evaluRuleTool.setCtx(ctx);
            int count = 0;
            String creatorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String controlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            String hrUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            boolean isAddEvalutarget = false;
            boolean isAddEvalutarget0 = false;
            String evaluObjectID = null;
            EvaluGroupTargetInfo groupTargetInfo = null;
            EvaluTargetInfo targetInfo = null;
            for (int i = 0; i < groupTargetColl.size(); ++i) {
                groupTargetInfo = groupTargetColl.get(i);
                targetInfo = groupTargetInfo.getEvaluTarget();
                if (targetInfo == null) continue;
                boolean isGroupTargetWhole = evaluRuleTool.isGroupTargetWhole(groupTargetInfo);
                Iterator iterator = evaluObjectIdSet.iterator();
                while (iterator.hasNext()) {
                    String tempEvaluTargetId;
                    ++count;
                    evaluObjectID = iterator.next().toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)new TargetEvaluStoreInfo().getBOSType()).toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)creatorID);
                    pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)controlUnitID);
                    pstmt.setBigDecimal(5, groupTargetInfo.getWeight() == null ? null : groupTargetInfo.getWeight());
                    pstmt.setInt(6, 0);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)evaluObjectID);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)evaluGroupInfo.getSolutionPeriod().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)hrUnit);
                    if (modifyFormSolutionContent) {
                        pstmt.setInt(11, 0);
                        tempEvaluTargetId = BOSUuid.create((BOSObjectType)targetInfo.getBOSType()).toString();
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)tempEvaluTargetId);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)1, (String)tempEvaluTargetId);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)2, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                        isAddEvalutarget = true;
                        isAddEvalutarget0 = true;
                    } else if (!isGroupTargetWhole && evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getAllocateTarget() != 1) {
                        pstmt.setInt(11, 0);
                        tempEvaluTargetId = BOSUuid.create((BOSObjectType)targetInfo.getBOSType()).toString();
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)tempEvaluTargetId);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)1, (String)tempEvaluTargetId);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt1, (int)2, (String)groupTargetInfo.getEvaluTarget().getId().toString());
                        isAddEvalutarget = true;
                        isAddEvalutarget0 = true;
                    } else {
                        pstmt.setInt(11, 1);
                    }
                    if (targetInfo.getThresholdValue() != null) {
                        pstmt.setBigDecimal(12, targetInfo.getThresholdValue());
                    } else {
                        pstmt.setNull(12, 3);
                    }
                    if (targetInfo.getStandardValue() != null) {
                        pstmt.setBigDecimal(13, targetInfo.getStandardValue());
                    } else {
                        pstmt.setNull(13, 3);
                    }
                    if (targetInfo.getChallengeValue() != null) {
                        pstmt.setBigDecimal(14, targetInfo.getChallengeValue());
                    } else {
                        pstmt.setNull(14, 3);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)groupTargetInfo.getMultiTable().getId().toString());
                    pstmt.setBigDecimal(16, groupTargetInfo.getValues());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)17, (String)storeParentMap.get(evaluObjectID).toString());
                    if (evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getAllocateTarget() != 0) {
                        pstmt.setInt(18, 2);
                    } else if (modifyFormSolutionContent) {
                        pstmt.setInt(18, 3);
                    } else if (!isGroupTargetWhole) {
                        pstmt.setInt(18, 3);
                    } else {
                        pstmt.setInt(18, 2);
                    }
                    pstmt.setInt(19, 1);
                    pstmt.setInt(20, targetInfo.getSeqNumber());
                    pstmt.addBatch();
                    if (isAddEvalutarget0) {
                        pstmt1.addBatch();
                        isAddEvalutarget0 = false;
                    }
                    if (count != 1000) continue;
                    pstmt.executeBatch();
                    if (isAddEvalutarget) {
                        pstmt1.executeBatch();
                        isAddEvalutarget = false;
                    }
                    count = 0;
                }
            }
            if (count > 0) {
                pstmt.executeBatch();
                if (isAddEvalutarget) {
                    pstmt1.executeBatch();
                    isAddEvalutarget = false;
                }
            }
            pstmtUpdateParent.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt1);
                SQLUtils.cleanup(pstmtUpdateParent, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt1);
        SQLUtils.cleanup((Statement)pstmtUpdateParent, (Connection)conn);
    }

    private TargetEvaluStoreParentCollection getStoreParentId(Context ctx, String solutionPeriodId, Set evaluObjectIdSet) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectIdSet, CompareType.INCLUDE));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(fi);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        return TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentCollection(ev);
    }

    @Override
    protected void _addnew(Context ctx, Set evaluGroupIdSet) throws BOSException, EASBizException {
        if (evaluGroupIdSet.isEmpty()) {
            return;
        }
        Iterator ir = evaluGroupIdSet.iterator();
        String groupId = null;
        while (ir.hasNext()) {
            groupId = ir.next().toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)groupId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filterInfo);
            EvaluGroupObjectCollection evaluGroupObjectCollection = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectCollection(view);
            HashSet<String> evaluObjectIDset = new HashSet<String>();
            for (int i = 0; i < evaluGroupObjectCollection.size(); ++i) {
                evaluObjectIDset.add(evaluGroupObjectCollection.get(i).getEvaluObject().getId().toString());
            }
            this._addnew(ctx, groupId, evaluObjectIDset);
        }
    }

    protected IObjectCollection getPrimarySubordinate(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPrimaryPerson(ctx, hierarchyId, personId, true);
    }

    private PersonCollection getPrimaryPerson(Context ctx, BOSUuid hierarchyId, BOSUuid personId, boolean isFindByParent) throws EASBizException, BOSException {
        PersonCollection personColl = null;
        IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection posiMemberColl = this.getPersonPosiMember(ctx, personId);
        PositionHierarchyCollection positionHierColl = null;
        PositionInfo positionInfo = null;
        PositionMemberInfo posiMemInfo = null;
        for (int i = 0; i < posiMemberColl.size(); ++i) {
            posiMemInfo = posiMemberColl.get(i);
            if (!posiMemInfo.isIsPrimary()) continue;
            positionInfo = posiMemInfo.getPosition();
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarInfo.getId(), positionInfo.getId(), isFindByParent));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarchyId, positionInfo.getId(), isFindByParent));
            }
            personColl = this.getPersonCOllByPM(ctx, positionHierColl, isFindByParent);
            break;
        }
        return personColl;
    }

    private PositionMemberCollection getPersonPosiMember(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        PositionMemberCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        posiMemberColl = iPosiMember.getPositionMemberCollection(this.getPMEntityViewInfo(ctx, personId));
        return posiMemberColl;
    }

    private PersonCollection getPersonCOllByPM(Context ctx, PositionHierarchyCollection positionHierColl, boolean isFindByParent) throws BOSException {
        PersonCollection personColl = new PersonCollection();
        PositionInfo positionInfo = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        for (int k = 0; k < positionHierColl.size(); ++k) {
            positionInfo = !isFindByParent ? positionHierColl.get(k).getParent() : positionHierColl.get(k).getChild();
            PositionMemberCollection superPMColl = iPosiMember.getPositionMemberCollection(this.getOtherPMEntityViewInfo(positionInfo));
            for (int j = 0; j < superPMColl.size(); ++j) {
                if (!superPMColl.get(j).isIsPrimary()) continue;
                personColl.add(superPMColl.get(j).getPerson());
            }
        }
        return personColl;
    }

    private EntityViewInfo getPHEntityViewInfo(BOSUuid hierarchyId, BOSUuid positionId, boolean isParent) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (!isParent) {
            filterItem = new FilterItemInfo("child.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("parent.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemHier = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemHier);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        return viewInfo;
    }

    private EntityViewInfo getPMEntityViewInfo(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemPosi = new FilterItemInfo("person.id", (Object)personId.toString().trim());
        filter.getFilterItems().add(filterItemPosi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPrimary"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        return viewInfo;
    }

    private EntityViewInfo getOtherPMEntityViewInfo(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionInfo.getId().toString().trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPrimary"));
        return viewInfo;
    }
}

