/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AchieveDataHelper;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreSQLException;
import com.kingdee.eas.hr.perf.TargetStateEnum;
import com.kingdee.eas.hr.perf.app.AbstractTargetEvaluStoreFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TargetEvaluStoreFacadeControllerBean
extends AbstractTargetEvaluStoreFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TargetEvaluStoreFacadeControllerBean");
    private static final String TABLE_NAME = " T_PF_TargetEvaluStore ";

    @Override
    protected void _setDelivered(Context ctx, String[] idList, boolean isDelivered, String spId) throws BOSException, EASBizException {
        if (idList == null || idList.length <= 0 || spId == null) {
            return;
        }
        String sql = "UPDATE T_PF_TargetEvaluStore SET FIsDelivered = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < idList.length; ++i) {
                pstmt.setBoolean(1, isDelivered);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)idList[i]);
                pstmt.addBatch();
                list.add(idList[i]);
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new TargetEvaluStoreSQLException(TargetEvaluStoreSQLException.SQLEXCEPTION);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        if (isDelivered) {
            AchieveDataHelper.createAchieveDataonDeliverTarget2(ctx, spId, list);
        } else {
            AchieveDataHelper.delAchieveDataOnUnDeliverTarget2(ctx, spId, list);
        }
    }

    @Override
    protected void _copyTaretEvaluStore(Context ctx, List evaluObjectIDList, BOSUuid solutionPeriodID, List targetStoreIDList, boolean isDelivered) throws BOSException, EASBizException {
        if (evaluObjectIDList == null || solutionPeriodID == null || targetStoreIDList == null) {
            return;
        }
        HashSet set = new HashSet();
        set.addAll(targetStoreIDList);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluTarget.*"));
        ITargetEvaluStore iTargetEvaluStore = TargetEvaluStoreFactory.getLocalInstance(ctx);
        TargetEvaluStoreCollection coll = iTargetEvaluStore.getTargetEvaluStoreCollection(viewInfo);
        TargetEvaluStoreInfo info = null;
        SolutionPeriodInfo solutionPeriod = new SolutionPeriodInfo();
        solutionPeriod.setId(solutionPeriodID);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(evaluObjectIDList), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        EvaluObjectCollection evaluObjects = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectCollection(viewInfo);
        EvaluTargetInfo evaluTargetInfo = null;
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        IObjectPK evaluTargetPK = null;
        IObjectPK pk = null;
        ArrayList<String> tes = new ArrayList<String>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            evaluTargetInfo = info.getEvaluTarget();
            evaluTargetInfo.setSolutionPeriod(solutionPeriod);
            info.setState(TargetStateEnum.unSubmit);
            info.setIsDelivered(isDelivered);
            info.setSolutionPeriod(solutionPeriod);
            info.setUniteTarget(false);
            int m = evaluObjects.size();
            for (int j = 0; j < m; ++j) {
                EvaluObjectInfo evaluObjectInfo = evaluObjects.get(j);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectInfo.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID.toString()));
                evi.setFilter(fi);
                try {
                    TargetEvaluStoreParentCollection parentCol = TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentCollection(evi);
                    info.setParent(parentCol.get(0));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                evaluTargetInfo.setId(null);
                evaluTargetInfo.setCreator(null);
                evaluTargetInfo.setCreateTime(null);
                evaluTargetPK = iEvaluTarget.addnew((CoreBaseInfo)evaluTargetInfo);
                evaluTargetInfo.setId(BOSUuid.read((String)evaluTargetPK.toString()));
                info.setId(null);
                info.setCreator(null);
                info.setCreateTime(null);
                info.setEvaluTarget(evaluTargetInfo);
                info.setEvaluObject(evaluObjects.get(j));
                pk = iTargetEvaluStore.addnew((CoreBaseInfo)info);
                tes.add(pk.toString());
            }
        }
        if (isDelivered) {
            AchieveDataHelper.createAchieveDataonDeliverTarget2(ctx, solutionPeriodID.toString(), tes);
        }
    }

    @Override
    protected void _confirmOrder(Context ctx, Map map) throws BOSException, EASBizException {
        if (map == null || map.size() <= 0) {
            return;
        }
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getLocalInstance(ctx);
        Set keySet = map.keySet();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("seqNumber"));
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            EvaluTargetInfo info = new EvaluTargetInfo();
            Object key = iter.next();
            info.setId(BOSUuid.read((String)key.toString()));
            info.setSeqNumber((Integer)map.get(key));
            iEvaluTarget.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected boolean _isUniteTargetDelivered(Context ctx, String solutionPeriodId) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("solutionPeriod", (Object)solutionPeriodId));
        fic.add(new FilterItemInfo("uniteTarget", (Object)Boolean.TRUE));
        fic.add(new FilterItemInfo("isDelivered", (Object)Boolean.TRUE));
        fic.add(new FilterItemInfo("uniteTarget", (Object)Boolean.FALSE));
        fi.setMaskString("#0 and ((#1 and #2) or #3)");
        return TargetEvaluStoreFactory.getLocalInstance(ctx).exists(fi);
    }
}

