/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AchieveDataHelper;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.ITargetEvaluStoreParent;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetAuditTypeEnum;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentInfo;
import com.kingdee.eas.hr.perf.TargetStateEnum;
import com.kingdee.eas.hr.perf.app.AbstractTargetEvaluStoreParentControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class TargetEvaluStoreParentControllerBean
extends AbstractTargetEvaluStoreParentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TargetEvaluStoreParentControllerBean");
    private Context ctx;

    @Override
    protected void _setStateAuditing(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setAuditState(ctx, billId, TargetStateEnum.auditing);
    }

    @Override
    protected void _setStateNopass(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setAuditState(ctx, billId, TargetStateEnum.unPassed);
    }

    @Override
    protected void _setStatePass(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.auditType"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        TargetEvaluStoreParentInfo parentInfo = TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        TargetAuditTypeEnum auditType = parentInfo.getSolutionPeriod().getEvaluSolution().getAuditType();
        if (auditType.getValue() == 10) {
            this.setAuditState(ctx, billId, TargetStateEnum.DELIEVERED);
            AchieveDataHelper.createAchieveDataAchieveDataForWorkbench(ctx, parentInfo.getSolutionPeriod().getId().toString(), parentInfo.getEvaluObject().getId().toString());
        } else {
            this.setAuditState(ctx, billId, TargetStateEnum.isAudited);
        }
    }

    @Override
    protected void _setStateUnsubmit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setAuditState(ctx, billId, TargetStateEnum.unSubmit);
    }

    @Override
    protected void _setStateIssubmited(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setAuditState(ctx, billId, TargetStateEnum.isSubmited);
    }

    @Override
    protected void _setStateDelivered(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setAuditState(ctx, billId, TargetStateEnum.DELIEVERED);
    }

    private void setAuditState(Context ctx, BOSUuid id, TargetStateEnum state) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_TargetEvaluStoreParent SET FState = ? , FAuditor = ?  WHERE FID = ?";
        Object[] args = new Object[]{new Integer(state.getValue()), ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString(), id.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])args);
        sql = "UPDATE T_PF_TargetEvaluStore SET FState = ? WHERE FParentID = ? AND FUniteTarget = 0;";
        args = new Object[]{new Integer(state.getValue()), id.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])args);
    }

    @Override
    protected String _getAuditorId(Context ctx, String targetEvaluStoreParentId) throws BOSException, EASBizException {
        String personId = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select assign.fpersonempid AS ID from T_WFR_Assign assign ");
        sb.append("inner join t_bd_person p on p.fid = assign.fpersonempid ");
        sb.append("where assign.FBIZOBJID =");
        sb.append("'" + targetEvaluStoreParentId + "'");
        sb.append(";");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rowSet.next()) {
                personId = rowSet.getString("ID").toString();
            }
        }
        catch (SQLException e) {
            logger.info((Object)sb.toString());
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personId;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        TargetEvaluStoreParentInfo info = (TargetEvaluStoreParentInfo)this._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    private void dealLogInfo(Context ctx, String id, String logItem) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        TargetEvaluStoreParentInfo info = TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentInfo((IObjectPK)new ObjectUuidPK(id), sic);
        StringBuffer retValue = new StringBuffer();
        if (info.getSolutionPeriod() != null) {
            retValue.append(info.getSolutionPeriod().getName());
        }
        retValue.append("   ");
        if (info.getEvaluObject() != null) {
            retValue.append(info.getEvaluObject().getName());
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TargetEvaluStoreParentFactory.getLocalInstance(ctx).getType(), null, (String)retValue.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _submitPersonNotWorkFlow(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateIssubmited(ctx, billId);
    }

    @Override
    protected void _submitOrg(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.submitTarget(ctx, billId);
    }

    @Override
    protected void _submitPerson(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.submitTarget(ctx, billId);
    }

    private void submitTarget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entry"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("entry.uniteTarget"));
        sic.add(new SelectorItemInfo("state"));
        TargetEvaluStoreParentInfo parentInfo = TargetEvaluStoreParentFactory.getLocalInstance(ctx).getTargetEvaluStoreParentInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        parentInfo.setState(TargetStateEnum.isSubmited);
        TargetEvaluStoreCollection targetEvaluStoreColl = parentInfo.getEntry();
        for (int i = 0; i < targetEvaluStoreColl.size(); ++i) {
            TargetEvaluStoreInfo targetEvaluStoreInfo = targetEvaluStoreColl.get(i);
            if (targetEvaluStoreInfo == null || targetEvaluStoreInfo.isUniteTarget()) continue;
            targetEvaluStoreInfo.setState(TargetStateEnum.isSubmited);
        }
        super.submit(ctx, (CoreBaseInfo)parentInfo);
    }

    @Override
    protected void _submitOrgNotWorkFlow(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateIssubmited(ctx, billId);
    }

    @Override
    protected void _returnBackOrg(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateUnsubmit(ctx, billId);
    }

    @Override
    protected void _returnBackPerson(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateUnsubmit(ctx, billId);
    }

    @Override
    protected void _unAuditOrg(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateUnsubmit(ctx, billId);
    }

    @Override
    protected void _unAuditPerson(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setStateUnsubmit(ctx, billId);
    }

    @Override
    protected void _setStateAntiDelivered(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStateUnsubmit(ctx, billId);
    }

    @Override
    protected void _addnew(Context ctx, String solutionPeriodId, Set evaluObjectIdSet, TargetStateEnum targetStateEnum) throws BOSException, EASBizException {
        if (evaluObjectIdSet.isEmpty()) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(fi);
        ev.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        ITargetEvaluStoreParent iTargetEvaluStoreParent = TargetEvaluStoreParentFactory.getLocalInstance(ctx);
        TargetEvaluStoreParentCollection coll = iTargetEvaluStoreParent.getTargetEvaluStoreParentCollection(ev);
        HashSet<String> existObjectIdSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            existObjectIdSet.add(coll.get(i).getEvaluObject().getId().toString());
        }
        HashSet<String> addNewEvaluObjectIdSet = new HashSet<String>();
        String objectIdTemp = null;
        Iterator ir = evaluObjectIdSet.iterator();
        while (ir.hasNext()) {
            objectIdTemp = ir.next().toString();
            if (existObjectIdSet.contains(objectIdTemp)) continue;
            addNewEvaluObjectIdSet.add(objectIdTemp);
        }
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setId(BOSUuid.read((String)solutionPeriodId));
        EvaluObjectInfo evaluObjectInfo = null;
        TargetEvaluStoreParentInfo storeParentInfo = null;
        TargetStateEnum targetStateEnump = targetStateEnum;
        if (targetStateEnum == null) {
            targetStateEnump = TargetStateEnum.unSubmit;
        }
        CoreBaseCollection addNewStoreParentColl = new CoreBaseCollection();
        Iterator iterator = addNewEvaluObjectIdSet.iterator();
        while (iterator.hasNext()) {
            evaluObjectInfo = new EvaluObjectInfo();
            evaluObjectInfo.setId(BOSUuid.read((String)iterator.next().toString()));
            storeParentInfo = new TargetEvaluStoreParentInfo();
            storeParentInfo.setEvaluObject(evaluObjectInfo);
            storeParentInfo.setSolutionPeriod(solutionPeriodInfo);
            storeParentInfo.setState(targetStateEnump);
            storeParentInfo.setSolutionDeliverd(false);
            addNewStoreParentColl.add((CoreBaseInfo)storeParentInfo);
        }
        if (!addNewStoreParentColl.isEmpty()) {
            iTargetEvaluStoreParent.save(addNewStoreParentColl);
        }
    }

    @Override
    protected void _addnew(Context ctx, String solutionPeriodId, Set evaluGroupIdSet) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        EvaluGroupObjectCollection evaluGroupObjectCollection = EvaluGroupObjectFactory.getLocalInstance(ctx).getEvaluGroupObjectCollection(view);
        HashSet<String> evaluObjectIDset = new HashSet<String>();
        for (int i = 0; i < evaluGroupObjectCollection.size(); ++i) {
            evaluObjectIDset.add(evaluGroupObjectCollection.get(i).getEvaluObject().getId().toString());
        }
        this._addnew(ctx, solutionPeriodId, evaluObjectIDset, null);
    }
}

