/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.TargetEvaluStoreSQLException;
import com.kingdee.eas.hr.perf.app.AbstractTargetEvaluStoreWeightFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class TargetEvaluStoreWeightFacadeControllerBean
extends AbstractTargetEvaluStoreWeightFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TargetEvaluStoreWeightFacadeControllerBean");
    private static final String pack = "com.kingdee.eas.hr.perf.app";
    private static final String query = "TargetEvaluStoreWeightQuery";
    private IQueryExecutor iqec = null;

    @Override
    protected BigDecimal _getTotalWeight(Context ctx, BOSUuid assessPeriodID, BOSUuid evaluSolutionID, String evaluObjectID) throws BOSException, EASBizException {
        BigDecimal ret = null;
        if (this.iqec == null) {
            this.iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(pack, query));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)evaluObjectID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(filter);
        this.iqec.setObjectView(viewInfo);
        IRowSet rowSet = this.iqec.executeQuery();
        try {
            if (rowSet.next()) {
                ret = rowSet.getBigDecimal("sumWeight");
            }
        }
        catch (SQLException ex) {
            throw new TargetEvaluStoreSQLException(TargetEvaluStoreSQLException.SQLEXCEPTION);
        }
        if (ret == null) {
            ret = new BigDecimal("0.00");
        }
        return ret;
    }

    @Override
    protected BigDecimal _getDeliveredWeight(Context ctx, BOSUuid assessPeriodID, BOSUuid evaluSolutionID, String evaluObjectID) throws BOSException, EASBizException {
        BigDecimal ret = null;
        if (this.iqec == null) {
            this.iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(pack, query));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)evaluObjectID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDelivered", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        viewInfo.setFilter(filter);
        this.iqec.setObjectView(viewInfo);
        IRowSet rowSet = this.iqec.executeQuery();
        try {
            if (rowSet.next()) {
                ret = rowSet.getBigDecimal("sumWeight");
            }
        }
        catch (SQLException ex) {
            throw new TargetEvaluStoreSQLException(TargetEvaluStoreSQLException.SQLEXCEPTION);
        }
        if (ret == null) {
            ret = new BigDecimal("0.00");
        }
        return ret;
    }

    @Override
    protected HashMap _getWeightInfo(Context ctx, BOSUuid assessPeriodID, BOSUuid evaluSolutionID, BOSUuid evaluObjectID) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> ret = new HashMap<String, BigDecimal>();
        BigDecimal totalWeight = this._getTotalWeight(ctx, assessPeriodID, evaluSolutionID, evaluObjectID.toString());
        BigDecimal deliveredWeight = this._getDeliveredWeight(ctx, assessPeriodID, evaluSolutionID, evaluObjectID.toString());
        ret.put("total", totalWeight);
        ret.put("delivered", deliveredWeight);
        return ret;
    }

    @Override
    protected HashMap _getTotalWeight(Context ctx, List evaluObjectIDList, BOSUuid solutionPeriodID) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (evaluObjectIDList == null || evaluObjectIDList.isEmpty()) {
            return map;
        }
        if (this.iqec == null) {
            this.iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(pack, query));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID.toString(), CompareType.EQUALS));
        HashSet set = new HashSet();
        set.addAll(evaluObjectIDList);
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", set, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        this.iqec.setObjectView(viewInfo);
        IRowSet rowSet = this.iqec.executeQuery();
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("evaluObject.id"), rowSet.getBigDecimal("sumWeight"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TargetEvaluStoreSQLException(TargetEvaluStoreSQLException.SQLEXCEPTION);
        }
        return map;
    }
}

