/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AchieveDataComputeException;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailFactory;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryTypeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultItemEnum;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryCollection;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryFactory;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryInfo;
import com.kingdee.eas.hr.perf.FormulaAchieveObjectEnum;
import com.kingdee.eas.hr.perf.FormulaInfo;
import com.kingdee.eas.hr.perf.FormulaPeriodEnum;
import com.kingdee.eas.hr.perf.FormulaSystemEntryCollection;
import com.kingdee.eas.hr.perf.FormulaSystemEntryFactory;
import com.kingdee.eas.hr.perf.FormulaSystemEntryInfo;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.PerfModeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumExpInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetGradeModeEnum;
import com.kingdee.eas.hr.perf.app.AbstractTargetScoreComputeFacadeControllerBean;
import com.kingdee.eas.hr.perf.app.FormulaComputeHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TargetScoreComputeFacadeControllerBean
extends AbstractTargetScoreComputeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TargetScoreComputeFacadeControllerBean");

    @Override
    protected void _computeTargetScore(Context ctx, String spId, String objId) throws BOSException, EASBizException {
        if (spId == null || objId == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objId));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("evaluTarget.formula.*"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.exp.sql"));
        sic.add(new SelectorItemInfo("multiTable.id"));
        TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        if (coll.size() <= 0) {
            return;
        }
        TargetEvaluStoreCollection newTargetStoreColl = new TargetEvaluStoreCollection();
        newTargetStoreColl = this.dealTargetstoreColl(ctx, coll);
        if (newTargetStoreColl.size() > 0) {
            coll.clear();
            coll = newTargetStoreColl;
        }
        if (coll.size() <= 0) {
            return;
        }
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup"));
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId), sic);
        EvaluObjectInfo objInfo = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objId));
        EvaluFormSolutionEntryCollection entryColl = this.getEvaluFormSolutionEntryInfoByMultiTableID(ctx, spInfo.getFormSolution().getId().toString());
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            TargetEvaluStoreInfo targetEvaluStoreInfo = coll.get(i);
            String mutiTaleID = targetEvaluStoreInfo.getMultiTable().getId().toString();
            if (!this.isShowCalFormulaFiled(entryColl, mutiTaleID)) continue;
            this.coumputeFormulaResult(ctx, coll.get(i), spInfo, objInfo);
        }
    }

    private boolean isShowCalFormulaFiled(EvaluFormSolutionEntryCollection entryColl, String mutiTaleID) {
        EvaluFormSolutionEntryInfo info = null;
        boolean visible = false;
        for (int k = 0; k < entryColl.size(); ++k) {
            info = entryColl.get(k);
            if (!mutiTaleID.equals(info.getMultiTable().getId().toString()) || !"calFormula".equals(info.getCode()) || !"calFormula".equals(info.getCode())) continue;
            visible = info.isVisible();
        }
        return visible;
    }

    private EvaluFormSolutionEntryCollection getEvaluFormSolutionEntryInfoByMultiTableID(Context ctx, String evaluFormSolutionID) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluFormSolution.id", (Object)evaluFormSolutionID));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)EvaluFormSolutionEntryTypeEnum.body));
        entityViewInfo.setFilter(filterInfo);
        EvaluFormSolutionEntryCollection coll = EvaluFormSolutionEntryFactory.getLocalInstance(ctx).getEvaluFormSolutionEntryCollection(entityViewInfo);
        return coll;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void coumputeFormulaResult(Context ctx, TargetEvaluStoreInfo targetEvaluStoreInfo, SolutionPeriodInfo spInfo, EvaluObjectInfo objInfo) throws BOSException, EASBizException {
        String tabName;
        TempTablePool pool;
        Connection conn;
        block42: {
            String name;
            IRowSet rs;
            StringBuffer sql;
            String rgId;
            block44: {
                block43: {
                    int i;
                    Map sysTxts;
                    Map achTxts;
                    HashMap valueMap;
                    ArrayList<Object> txtCols;
                    ArrayList<Object> numCols;
                    SumExpInfo exp;
                    FormulaInfo fInfo;
                    block40: {
                        Map sysMap;
                        if (targetEvaluStoreInfo.getEvaluTarget() == null) return;
                        if (targetEvaluStoreInfo.getEvaluTarget().getFormula() == null) {
                            return;
                        }
                        fInfo = targetEvaluStoreInfo.getEvaluTarget().getFormula();
                        exp = fInfo.getExp();
                        if (exp == null) return;
                        if (exp.getSql() == null) return;
                        if (exp.getSql().trim().length() <= 0) {
                            return;
                        }
                        conn = null;
                        pool = null;
                        tabName = null;
                        numCols = new ArrayList<Object>();
                        txtCols = new ArrayList<Object>();
                        valueMap = new HashMap();
                        Map achMap = this.getAchieveElementData(ctx, fInfo, spInfo, objInfo);
                        Map achNums = (Map)achMap.get("nums");
                        achTxts = (Map)achMap.get("txts");
                        if (achNums != null && achNums.size() > 0) {
                            numCols.addAll(achNums.keySet());
                            valueMap.putAll(achNums);
                        }
                        if (achTxts != null && achTxts.size() > 0) {
                            txtCols.addAll(achTxts.keySet());
                            valueMap.putAll(achTxts);
                        }
                        if ((sysMap = this.getSysElementData(ctx, fInfo, spInfo, objInfo)) == null) {
                            sysMap = Collections.EMPTY_MAP;
                        }
                        Map sysNums = (Map)sysMap.get("nums");
                        sysTxts = (Map)sysMap.get("txts");
                        if (sysNums != null && sysNums.size() > 0) {
                            numCols.addAll(sysNums.keySet());
                            valueMap.putAll(sysNums);
                        }
                        if (sysTxts != null && sysTxts.size() > 0) {
                            valueMap.putAll(sysTxts);
                            txtCols.addAll(sysTxts.keySet());
                        }
                        if (TargetGradeModeEnum.MANUAL_ENTER.equals((Object)spInfo.getEvaluSolution().getTargetGradeMode())) {
                            numCols.add("FRealValue");
                        } else {
                            txtCols.add("FRealValue");
                        }
                        if (numCols.size() > 0 || txtCols.size() > 0) break block40;
                        if (tabName == null) return;
                        try {
                            pool.releaseTable(tabName);
                            SQLUtils.cleanup((Connection)conn);
                            return;
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                            throw new BOSException(ex.getMessage(), ex.getCause());
                        }
                    }
                    conn = super.getConnection(ctx);
                    pool = TempTablePool.getInstance((Context)ctx);
                    tabName = FormulaComputeHelper.createTempTable(conn, pool, numCols, txtCols);
                    numCols.addAll(txtCols);
                    ArrayList backNumCols = new ArrayList();
                    int j = numCols.size();
                    for (int i2 = 0; i2 < j; ++i2) {
                        if ("FRealValue".equals(numCols.get(i2).toString())) continue;
                        backNumCols.add(numCols.get(i2));
                    }
                    StringBuffer ins_sql = new StringBuffer();
                    ins_sql.append("insert into ");
                    ins_sql.append(tabName);
                    ins_sql.append(" (FID");
                    int j2 = backNumCols.size();
                    for (i = 0; i < j2; ++i) {
                        ins_sql.append(", ");
                        ins_sql.append(backNumCols.get(i).toString());
                    }
                    ins_sql.append(") values ('");
                    ins_sql.append(targetEvaluStoreInfo.getId().toString());
                    ins_sql.append("'");
                    j2 = backNumCols.size();
                    for (i = 0; i < j2; ++i) {
                        ins_sql.append(", ?");
                    }
                    ins_sql.append(")");
                    PreparedStatement prst = conn.prepareStatement(ins_sql.toString());
                    String adNum = null;
                    int j32 = backNumCols.size();
                    for (int i3 = 0; i3 < j32; ++i3) {
                        adNum = backNumCols.get(i3).toString();
                        if (!valueMap.containsKey(adNum)) continue;
                        if (valueMap.get(adNum) == null) {
                            prst.setNull(i3 + 1, 3);
                            continue;
                        }
                        if (achTxts != null && achTxts.containsKey(adNum) || sysTxts != null && sysTxts.containsKey(adNum)) {
                            prst.setString(i3 + 1, valueMap.get(adNum).toString());
                            continue;
                        }
                        prst.setBigDecimal(i3 + 1, new BigDecimal(valueMap.get(adNum).toString()));
                    }
                    prst.execute();
                    prst.close();
                    String ksql = exp.getSql();
                    ksql = ksql.replaceAll("@", tabName);
                    StringTokenizer tokens = new StringTokenizer(ksql, ";");
                    Statement stmt = null;
                    try {
                        stmt = conn.createStatement();
                        while (tokens.hasMoreTokens()) {
                            stmt.execute(tokens.nextToken());
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        throw new AchieveDataComputeException(AchieveDataComputeException.FORMULA_EXECUTE_FAIL, new Object[]{fInfo.getName()});
                    }
                    finally {
                        SQLUtils.cleanup((Statement)stmt);
                    }
                    if (TargetGradeModeEnum.MANUAL_ENTER.equals((Object)spInfo.getEvaluSolution().getTargetGradeMode())) {
                        StringBuffer upd_sql = new StringBuffer();
                        upd_sql.append(" update T_PF_TargetEvaluStore set FFormulaScore = ");
                        upd_sql.append(" ( ");
                        upd_sql.append(" select FRealValue from ").append(tabName).append(" ");
                        upd_sql.append(" where T_PF_TargetEvaluStore.FId = ").append(tabName).append(".fid");
                        upd_sql.append(" ) ");
                        upd_sql.append(" where FID = '").append(targetEvaluStoreInfo.getId().toString()).append("'");
                        DbUtil.execute((Context)ctx, (String)upd_sql.toString());
                        break block42;
                    }
                    if (spInfo.getEvaluSolution().getRankGroup() != null) break block43;
                    if (tabName == null) return;
                    try {
                        pool.releaseTable(tabName);
                        SQLUtils.cleanup((Connection)conn);
                        return;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        throw new BOSException(ex.getMessage(), ex.getCause());
                    }
                }
                rgId = spInfo.getEvaluSolution().getTargetRankGroup().getId().toString();
                sql = new StringBuffer();
                sql.append(" select FRealValue rv from ").append(tabName).append(" ");
                sql.append(" where FID = '").append(targetEvaluStoreInfo.getId().toString()).append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rs.next()) break block42;
                name = rs.getString("rv");
                if (name != null && name.trim().length() > 0) break block44;
                if (tabName == null) return;
                try {
                    pool.releaseTable(tabName);
                    SQLUtils.cleanup((Connection)conn);
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
            }
            sql.delete(0, sql.length());
            sql.append(" select rk.fid id from T_PF_Rank rk ");
            sql.append(" left join T_PF_RankGroup rg on rg.FId = rk.FGroupID ");
            sql.append(" where rk.FGroupID = '").append(rgId).append("'");
            sql.append(" and rk.FName_l2 = '").append(name.trim()).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) break block42;
            String rkId = rs.getString("id");
            sql.delete(0, sql.length());
            sql.append(" update T_PF_TargetEvaluStore set FFormulaRank = ");
            sql.append("'").append(rkId).append("'");
            sql.append(" where FID = '").append(targetEvaluStoreInfo.getId().toString()).append("'");
            logger.info((Object)sql.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (tabName == null) return;
        try {
            pool.releaseTable(tabName);
            SQLUtils.cleanup((Connection)conn);
            return;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        catch (EASBizException e1) {
            try {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                throw e1;
                catch (Exception e2) {
                    logger.info((Object)e2.getMessage(), (Throwable)e2);
                    throw new BOSException(e2.getMessage(), e2.getCause());
                }
            }
            catch (Throwable throwable) {
                if (tabName == null) throw throwable;
                try {
                    pool.releaseTable(tabName);
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException(ex.getMessage(), ex.getCause());
                }
            }
        }
    }

    private Map getAchieveElementData(Context ctx, FormulaInfo fInfo, SolutionPeriodInfo spInfo, EvaluObjectInfo objInfo) throws Exception {
        String key;
        if (fInfo == null || spInfo == null || objInfo == null) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", (Object)fInfo.getId().toString()));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("achieveItem.dataType"));
        evi.setSelector(sic);
        FormulaAchieveEntryCollection aeColl = FormulaAchieveEntryFactory.getLocalInstance(ctx).getFormulaAchieveEntryCollection(evi);
        if (aeColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashSet<String> pdIds = new HashSet<String>();
        HashSet<String> acIds = new HashSet<String>();
        HashSet<String> pIds = new HashSet<String>();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> spIds = new HashSet<String>();
        int j = aeColl.size();
        for (int i = 0; i < j; ++i) {
            FormulaAchieveEntryInfo aeInfo = aeColl.get(i);
            acIds.add(aeInfo.getAchieveItem().getId().toString());
            if (FormulaPeriodEnum.current.equals((Object)aeInfo.getPeriodType())) {
                if (spInfo.getAchievePeriod() != null) {
                    pdIds.add(spInfo.getAchievePeriod().getId().toString());
                } else {
                    pdIds.add("error_id");
                }
            } else {
                pdIds.add(aeInfo.getPeriod());
            }
            if (FormulaAchieveObjectEnum.otherOrgUnit.equals((Object)aeInfo.getObjectType())) {
                orgIds.add(aeInfo.getObject());
            } else if (FormulaAchieveObjectEnum.otherPerson.equals((Object)aeInfo.getObjectType())) {
                pIds.add(aeInfo.getObject());
            } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)objInfo.getEvaluObjectType())) {
                orgIds.add(objInfo.getObjectID());
            } else if (EvaluObjectTypeEnum.PERSON.equals((Object)objInfo.getEvaluObjectType())) {
                pIds.add(objInfo.getObjectID());
            }
            if (aeInfo.isDefaultSp()) {
                spIds.add(spInfo.getId().toString());
                continue;
            }
            spIds.add(aeInfo.getSolutionPeriod());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ad.FPersonId pId,ad.FOrgUnitID orgId,ad.FPeriodID pdId, ");
        sql.append(" ad.FSolutionPeriodID spId,ad.FAchieveItemID achId,ad.FEvaluObjectType objType,");
        sql.append(" ad.FRealValue rv,ad.FThresholdValue tv,ad.FStandardValue sv,ad.FChallengeValue cv,ad.FReservedField2 rf");
        sql.append(" from t_pf_achieveData ad ");
        sql.append(" where FPeriodID in  ");
        sql.append(" (").append(FormulaComputeHelper.buildInSql(pdIds)).append(")");
        sql.append(" and ");
        sql.append(" (");
        if (pIds.size() > 0) {
            sql.append(" FPersonId in(").append(FormulaComputeHelper.buildInSql(pIds)).append(")");
        }
        if (pIds.size() > 0 && orgIds.size() > 0) {
            sql.append(" or ");
            sql.append(" FOrgUnitID in(").append(FormulaComputeHelper.buildInSql(orgIds)).append(")");
        } else if (orgIds.size() > 0) {
            sql.append(" FOrgUnitID in(").append(FormulaComputeHelper.buildInSql(orgIds)).append(")");
        }
        sql.append(")");
        if (spIds.size() > 0) {
            sql.append(" and FSolutionPeriodID in (").append(FormulaComputeHelper.buildInSql(spIds)).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        while (rs.next()) {
            int objType = rs.getInt("objType");
            key = rs.getString("achId") + rs.getString("pdId") + rs.getString("spId");
            if (objType == 101) {
                key = key + rs.getString("orgId");
            } else if (objType == 100) {
                key = key + rs.getString("pId");
            }
            Object[] values = new Object[]{rs.getString("rv"), rs.getBigDecimal("tv"), rs.getBigDecimal("sv"), rs.getBigDecimal("cv"), rs.getBigDecimal("rf")};
            map.put(key, values);
        }
        HashMap valueMap = new HashMap();
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        HashMap<String, Object> txtMap = new HashMap<String, Object>();
        int j2 = aeColl.size();
        for (int i = 0; i < j2; ++i) {
            FormulaAchieveEntryInfo aeInfo = aeColl.get(i);
            DataTypeEnum aiDt = aeInfo.getAchieveItem().getDataType();
            key = null;
            key = aeInfo.getAchieveItem().getId().toString();
            key = FormulaPeriodEnum.current.equals((Object)aeInfo.getPeriodType()) ? (spInfo.getAchievePeriod() == null ? key + "error_id" : key + spInfo.getAchievePeriod().getId().toString()) : key + aeInfo.getPeriod();
            key = aeInfo.isDefaultSp() ? key + spInfo.getId().toString() : key + aeInfo.getSolutionPeriod();
            key = FormulaAchieveObjectEnum.current.equals((Object)aeInfo.getObjectType()) ? key + objInfo.getObjectID() : key + aeInfo.getObject();
            if (map.containsKey(key)) {
                Object[] arr = (Object[])map.get(key);
                int dt = aeInfo.getDataType().getValue();
                Object val = null;
                if (dt == 1) {
                    val = arr[0];
                } else if (dt == 2) {
                    val = arr[1];
                } else if (dt == 3) {
                    val = arr[2];
                } else if (dt == 4) {
                    val = arr[3];
                } else if (dt == 5) {
                    val = arr[4];
                }
                if (DataTypeEnum.NUMERICAL.equals((Object)aiDt) || DataTypeEnum.PERCENT.equals((Object)aiDt)) {
                    numMap.put(aeInfo.getNumber(), val);
                    continue;
                }
                txtMap.put(aeInfo.getNumber(), val);
                continue;
            }
            if (DataTypeEnum.NUMERICAL.equals((Object)aiDt) || DataTypeEnum.PERCENT.equals((Object)aiDt)) {
                numMap.put(aeInfo.getNumber(), new Integer(0));
                continue;
            }
            txtMap.put(aeInfo.getNumber(), null);
        }
        valueMap.put("nums", numMap);
        valueMap.put("txts", txtMap);
        return valueMap;
    }

    private Map getSysElementData(Context ctx, FormulaInfo fInfo, SolutionPeriodInfo spInfo, EvaluObjectInfo objInfo) throws Exception {
        StringBuffer objIds;
        StringBuffer spIds;
        if (fInfo == null || spInfo == null || objInfo == null) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("formula.id", (Object)fInfo.getId().toString()));
        evi.setFilter(fi);
        FormulaSystemEntryCollection seColl = FormulaSystemEntryFactory.getLocalInstance(ctx).getFormulaSystemEntryCollection(evi);
        if (seColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        Map condition = new HashMap();
        int j = seColl.size();
        for (int i = 0; i < j; ++i) {
            FormulaSystemEntryInfo seInfo = seColl.get(i);
            PerfModeEnum pm = seInfo.getPerfMode();
            String seSpId = seInfo.getSolutionPeriod();
            String objId = seInfo.getObject();
            objId = objId != null && objId.trim().length() > 0 ? FormulaComputeHelper.getOrgOrPersonId(ctx, objId, pm) : (PerfModeEnum.orgTarget.equals((Object)pm) && EvaluObjectTypeEnum.PERSON.equals((Object)objInfo.getEvaluObjectType()) ? FormulaComputeHelper.getOwnerOrg(ctx, objInfo.getObjectID()) : objInfo.getObjectID());
            if (PerfModeEnum.personTarget.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "1", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "2", objId);
                continue;
            }
            if (PerfModeEnum.orgTarget.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "3", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "4", objId);
                continue;
            }
            if (PerfModeEnum.personMulti.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "5", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "6", objId);
                continue;
            }
            if (PerfModeEnum.orgMulti.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "7", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "8", objId);
                continue;
            }
            if (PerfModeEnum.complex.equals((Object)pm)) {
                condition = FormulaComputeHelper.buildConditionMap(condition, "9", seSpId);
                condition = FormulaComputeHelper.buildConditionMap(condition, "10", objId);
                continue;
            }
            if (!PerfModeEnum.sum.equals((Object)pm)) continue;
            condition = FormulaComputeHelper.buildConditionMap(condition, "11", seSpId);
            condition = FormulaComputeHelper.buildConditionMap(condition, "12", objId);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        if (condition.get("1") != null && condition.get("2") != null) {
            spIds = (StringBuffer)condition.get("1");
            objIds = (StringBuffer)condition.get("2");
            sql.append(" select er.FSolutionPeriodID spId,eo.FObjectID objId, ");
            sql.append(" er.FTargetEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_EvaluResult er ");
            sql.append(" left join T_PF_EvaluObject eo on er.FEvaluObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FPerfRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FObjectID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(100);
        }
        if (condition.get("3") != null && condition.get("4") != null) {
            spIds = (StringBuffer)condition.get("3");
            objIds = (StringBuffer)condition.get("4");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FObjectID objId, ");
            sql.append(" er.FTargetEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_EvaluResult er ");
            sql.append(" left join T_PF_EvaluObject eo on er.FEvaluObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FPerfRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FObjectID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(101);
        }
        if (condition.get("5") != null && condition.get("6") != null) {
            spIds = (StringBuffer)condition.get("5");
            objIds = (StringBuffer)condition.get("6");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FPersonID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_MDEVALURESULT er ");
            sql.append(" left join T_PF_MultiDimentionObject eo on er.FMdObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FPersonID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(100);
        }
        if (condition.get("7") != null && condition.get("8") != null) {
            spIds = (StringBuffer)condition.get("7");
            objIds = (StringBuffer)condition.get("8");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FEvaluOrgID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_MDEVALURESULT er ");
            sql.append(" left join T_PF_MultiDimentionObject eo on er.FMdObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FEvaluOrgID in(").append(objIds.toString()).append(")");
            sql.append(" and FEvaluObjectType = ").append(101);
        }
        if (condition.get("9") != null && condition.get("10") != null) {
            spIds = (StringBuffer)condition.get("9");
            objIds = (StringBuffer)condition.get("10");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select er.FSolutionPeriodID spId,eo.FPersonID objId, ");
            sql.append(" er.FEvaluScore score,er.FModifiedScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_SYNEVALURESULT er ");
            sql.append(" left join T_PF_SynEvaluObject eo on er.FSynObjectID = eo.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where er.FSolutionPeriodID in(").append(spIds.toString()).append(")");
            sql.append(" and eo.FPersonID in(").append(objIds.toString()).append(")");
        }
        if (condition.get("11") != null && condition.get("12") != null) {
            spIds = (StringBuffer)condition.get("9");
            objIds = (StringBuffer)condition.get("10");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" select sp.FSumSolutionID spId,sp.FPersonID objId, ");
            sql.append(" sr.FScore score,sr.FModifyScore mScore, ");
            sql.append(" rk.FName_l1 rk1,rk.FName_l2 rk2,rk.FName_l3 rk3 ");
            sql.append(" from T_PF_SumResult sr ");
            sql.append(" left join T_PF_SumPerson sp on sr.FSumPersonID = sp.fid ");
            sql.append(" left join T_PF_Rank rk on er.FRankID = rk.FID ");
            sql.append(" where sp.FSumSolutionID in(").append(spIds.toString()).append(")");
            sql.append(" and sp.FPersonID in(").append(objIds.toString()).append(")");
        }
        if (sql.length() <= 0) {
            return Collections.EMPTY_MAP;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String str = rs.getString("spId") + rs.getString("objId");
            resultMap.put(str + 10, rs.getBigDecimal("score"));
            resultMap.put(str + 20, rs.getBigDecimal("mScore"));
            if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                resultMap.put(str + 30, rs.getString("rk1"));
                continue;
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                resultMap.put(str + 30, rs.getString("rk2"));
                continue;
            }
            if (!LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) continue;
            resultMap.put(str + 30, rs.getString("rk3"));
        }
        HashMap valueMap = new HashMap();
        HashMap nums = new HashMap();
        HashMap txts = new HashMap();
        int j2 = seColl.size();
        for (int i = 0; i < j2; ++i) {
            FormulaSystemEntryInfo seInfo = seColl.get(i);
            EvaluResultItemEnum dt = seInfo.getDataType();
            String seSpId = seInfo.getSolutionPeriod();
            String objId = seInfo.getObject();
            objId = objId == null || objId.trim().length() <= 0 ? objInfo.getObjectID() : FormulaComputeHelper.getOrgOrPersonId(ctx, objId, seInfo.getPerfMode());
            String key = seSpId + objId + dt.getValue();
            if (EvaluResultItemEnum.PERF_RANK.equals((Object)seInfo.getDataType())) {
                txts.put(seInfo.getNumber(), resultMap.get(key));
                continue;
            }
            nums.put(seInfo.getNumber(), resultMap.get(key));
        }
        valueMap.put("nums", nums);
        valueMap.put("txts", txts);
        return valueMap;
    }

    @Override
    protected void _updateTargetRealValue(Context ctx, String spId, String objId) throws BOSException, EASBizException {
        if (spId == null || objId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_PF_TargetEvaluStore set FRealValue = ");
        sql.append(" ( ");
        sql.append(" select top 1 ad.FRealValue from T_PF_TargetEvaluStore tes ");
        sql.append(" inner join T_PF_SolutionPeriod sp on sp.FId = tes.FSolutionPeriodID ");
        sql.append(" inner join T_PF_EvaluObject eo on eo.FId = tes.FEvaluObjectID ");
        sql.append(" inner join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.FId ");
        sql.append(" inner join T_PF_Formula fa on et.FFormulaID = fa.FId ");
        sql.append(" inner join T_PF_AchieveData ad on fa.FAchieveItemID = ad.FAchieveItemID and ad.FSolutionPeriodID=sp.fid and eo.fid=ad.FEvaluObjectID and et.fid=ad.FTargetID and sp.FAchievePeriodID=ad.FPeriodID ");
        sql.append(" where tes.FId = T_PF_TargetEvaluStore.Fid ");
        sql.append(" and ad.FRootPeriod = 1 ");
        sql.append(" and ad.FPeriodID = sp.FAchievePeriodID ");
        sql.append(" and ad.FSolutionPeriodID = sp.FId ");
        sql.append(" and (ad.FPersonID = eo.FObjectID or ad.FOrgUnitID = eo.FObjectID) ");
        sql.append(" ) ");
        sql.append(" where FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and FEvaluObjectID = '").append(objId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected boolean _checkResultIsCommon(Context ctx, String spId, String objId) throws BOSException, EASBizException {
        if (spId == null || objId == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select es.FTargetGradeMode gm from T_PF_SolutionPeriod sp ");
        sql.append(" inner join T_PF_EvaluSolution es on es.FId = sp.FEvaluSolutionID ");
        sql.append(" where sp.FId = '").append(spId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int gm = 100;
        try {
            if (rs.next()) {
                gm = rs.getInt("gm");
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        sql.delete(0, sql.length());
        if (gm == 100) {
            sql.append(" select tes.FFormulaScore fm, ed.FTargetScore ed ");
        } else {
            sql.append(" select tes.FFormulaRank fm, ed.FRankID ed ");
        }
        sql.append(" from T_PF_EvaluDetail ed ");
        sql.append(" left join T_PF_TargetEvaluStore tes on ed.FTargetEvaluStoreID = tes.FId ");
        sql.append(" left join T_PF_EvaluTarget et on et.FId = tes.FEvaluTargetID ");
        sql.append(" where tes.FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and tes.FEvaluObjectID = '").append(objId).append("'");
        sql.append(" and et.FFormulaID is not null ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (!PerfUtils.isNotEq(rs.getObject("fm"), rs.getObject("ed"))) continue;
                return false;
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return true;
    }

    @Override
    protected void _updateAchieveDataState(Context ctx, String spId, String objId, boolean isFormSubmit) throws BOSException, EASBizException {
        if (spId == null || objId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_PF_AchieveData set FFormSubmit =  ").append(isFormSubmit ? 1 : 0);
        sql.append(" where FId in ");
        sql.append(" ( ");
        sql.append(" select ad.FId from T_PF_TargetEvaluStore tes ");
        sql.append(" inner join T_PF_SolutionPeriod sp on sp.FId = tes.FSolutionPeriodID ");
        sql.append(" inner join T_PF_EvaluObject eo on eo.FId = tes.FEvaluObjectID ");
        sql.append(" inner join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.FId ");
        sql.append(" inner join T_PF_Formula fa on et.FFormulaID = fa.FId ");
        sql.append(" inner join T_PF_AchieveData ad on fa.FAchieveItemID = ad.FAchieveItemID ");
        sql.append(" where ad.FRootPeriod = 1 ");
        sql.append(" and ad.FPeriodID = sp.FAchievePeriodID ");
        sql.append(" and ad.FSolutionPeriodID = sp.FId ");
        sql.append(" and (ad.FPersonID = eo.FObjectID or ad.FOrgUnitID = eo.FObjectID) ");
        sql.append(" and tes.FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and tes.FEvaluObjectID = '").append(objId).append("'");
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update T_PF_AchieveData set FFormSubmit =  ").append(isFormSubmit ? 1 : 0);
        sql.append(" where FParentID in ");
        sql.append(" ( ");
        sql.append(" select ad.FId from T_PF_TargetEvaluStore tes ");
        sql.append(" inner join T_PF_SolutionPeriod sp on sp.FId = tes.FSolutionPeriodID ");
        sql.append(" inner join T_PF_EvaluObject eo on eo.FId = tes.FEvaluObjectID ");
        sql.append(" inner join T_PF_EvaluTarget et on tes.FEvaluTargetID = et.FId ");
        sql.append(" inner join T_PF_Formula fa on et.FFormulaID = fa.FId ");
        sql.append(" inner join T_PF_AchieveData ad on fa.FAchieveItemID = ad.FAchieveItemID ");
        sql.append(" where ad.FRootPeriod = 1 ");
        sql.append(" and ad.FPeriodID = sp.FAchievePeriodID ");
        sql.append(" and ad.FSolutionPeriodID = sp.FId ");
        sql.append(" and (ad.FPersonID = eo.FObjectID or ad.FOrgUnitID = eo.FObjectID) ");
        sql.append(" and tes.FSolutionPeriodID = '").append(spId).append("'");
        sql.append(" and tes.FEvaluObjectID = '").append(objId).append("'");
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private boolean isAtFirstNode(Context ctx, String spId, String objId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod", (Object)spId));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)objId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluNode.*"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.wfLevels"));
        NodeProcesserCollection coll = NodeProcesserFactory.getLocalInstance(ctx).getNodeProcesserCollection(viewInfo);
        return false;
    }

    @Override
    protected void _computeQuantizedTargetScore(Context ctx, String solutionPeriodID, String objectID) throws BOSException, EASBizException {
        if (solutionPeriodID == null || objectID == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectID));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("evaluTarget.formula.*"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.exp.sql"));
        sic.add(new SelectorItemInfo("multiTable.id"));
        TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getLocalInstance(ctx).getTargetEvaluStoreCollection(evi);
        if (coll.size() <= 0) {
            return;
        }
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup"));
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getLocalInstance(ctx).getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        EvaluObjectInfo objInfo = EvaluObjectFactory.getLocalInstance(ctx).getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objectID));
        EvaluFormSolutionEntryCollection entryColl = this.getEvaluFormSolutionEntryInfoByMultiTableID(ctx, spInfo.getFormSolution().getId().toString());
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            TargetEvaluStoreInfo targetEvaluStoreInfo = coll.get(i);
            String mutiTaleID = targetEvaluStoreInfo.getMultiTable().getId().toString();
            if (!this.isShowCalFormulaFiled(entryColl, mutiTaleID)) continue;
            this.coumputeFormulaResult(ctx, coll.get(i), spInfo, objInfo);
        }
    }

    private TargetEvaluStoreCollection dealTargetstoreColl(Context ctx, TargetEvaluStoreCollection coll) throws BOSException, EASBizException {
        TargetEvaluStoreInfo evaluStoreInfo = null;
        HashSet<String> storeInfoIDSet = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                evaluStoreInfo = coll.get(i);
                storeInfoIDSet.add(evaluStoreInfo.getId().toString());
            }
        }
        EntityViewInfo evaluDetailViewInfo = new EntityViewInfo();
        FilterInfo evaluDetailFilterInfo = new FilterInfo();
        evaluDetailFilterInfo.getFilterItems().add(new FilterItemInfo("targetEvaluStore.id", storeInfoIDSet, CompareType.INCLUDE));
        evaluDetailViewInfo.setFilter(evaluDetailFilterInfo);
        SelectorItemCollection sic = evaluDetailViewInfo.getSelector();
        sic.add(new SelectorItemInfo("targetScore"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluTarget.id"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluTarget.formula.*"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluTarget.formula.exp.*"));
        sic.add(new SelectorItemInfo("targetEvaluStore.solutionPeriod.id"));
        sic.add(new SelectorItemInfo("targetEvaluStore.multiTable.id"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluObject.id"));
        sic.add(new SelectorItemInfo("targetEvaluStore.evaluObject.targetdeliverers"));
        EvaluDetailInfo evaluDetailInfo = null;
        TargetEvaluStoreCollection newTargetEvaluStoreColl = new TargetEvaluStoreCollection();
        TargetEvaluStoreInfo newTEvaluStoreInfo = null;
        EvaluDetailCollection evaluDetailColl = EvaluDetailFactory.getLocalInstance(ctx).getEvaluDetailCollection(evaluDetailViewInfo);
        if (evaluDetailColl != null && evaluDetailColl.size() > 0) {
            for (int j = 0; j < evaluDetailColl.size(); ++j) {
                evaluDetailInfo = evaluDetailColl.get(j);
                if (evaluDetailInfo.getTargetEvaluStore().getEvaluTarget().getFormula() == null || evaluDetailInfo.getTargetScore() != null) continue;
                newTEvaluStoreInfo = new TargetEvaluStoreInfo();
                newTEvaluStoreInfo.setId(evaluDetailInfo.getTargetEvaluStore().getId());
                newTEvaluStoreInfo.setSolutionPeriod(evaluDetailInfo.getTargetEvaluStore().getSolutionPeriod());
                newTEvaluStoreInfo.setEvaluObject(evaluDetailInfo.getTargetEvaluStore().getEvaluObject());
                newTEvaluStoreInfo.setMultiTable(evaluDetailInfo.getTargetEvaluStore().getMultiTable());
                newTEvaluStoreInfo.setEvaluTarget(evaluDetailInfo.getTargetEvaluStore().getEvaluTarget());
                newTEvaluStoreInfo.getEvaluTarget().getFormula().setExp(evaluDetailInfo.getTargetEvaluStore().getEvaluTarget().getFormula().getExp());
                newTargetEvaluStoreColl.add(newTEvaluStoreInfo);
            }
        }
        return newTargetEvaluStoreColl;
    }
}

