/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvalPersonCollection;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.app.AbstractTestPageFormFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TestPageFormFacadeControllerBean
extends AbstractTestPageFormFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TestPageFormFacadeControllerBean");

    @Override
    protected void _updateStatusAndCountScoreNoWorkFlow(Context ctx, String evalPersonID, String mdSolultionPeriodID, String mdEvluObjectID, String mdEvaluatorID, String mdEvalReDetailID) throws BOSException, EASBizException {
        boolean isFinish = this.needCountEvaluResult(ctx, mdEvaluatorID);
        if (isFinish) {
            MultiDimEvaluatorInfo dimEvaluatorInfo = this.getMDEvaluator(ctx, mdEvaluatorID);
            EvalRelationDetailInfo detailInfo = this.getDetailByEvalPersonID(dimEvaluatorInfo, evalPersonID);
            BigDecimal detailAvrScore = this.countEvalPersonAvrScore(detailInfo.getEvalPersons());
            detailInfo.setAvrScore(detailAvrScore);
            if (detailAvrScore != null) {
                this.updateEvalRelationDetailScore(ctx, detailInfo.getId().toString(), detailAvrScore);
            }
            BigDecimal avr = this.countEvaluResultScore(dimEvaluatorInfo);
            this.updateMDEvaluatorState(ctx, dimEvaluatorInfo.getId().toString(), 30);
            this.updateMDEvaluResult(ctx, mdSolultionPeriodID, mdEvluObjectID, avr);
        } else if (this.needCountEvalReDetailScore(ctx, mdEvalReDetailID)) {
            this.countEvalReDetailScore(ctx, mdEvalReDetailID);
        }
    }

    private void countEvalReDetailScore(Context ctx, String mdEvalReDetailID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_pf_evalredetail set favrscore = (");
        sql.append(" select avg(fscore) from t_pf_evalperson where fevalredetailid=t_pf_evalredetail.fid and FPaperState !=30 )");
        sql.append(" where fid='");
        sql.append(mdEvalReDetailID);
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private boolean needCountEvalReDetailScore(Context ctx, String mdEvalReDetailID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalReDetail.id", (Object)mdEvalReDetailID));
        filterInfo.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        return !EvalPersonFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    private boolean needCountEvaluResult(Context ctx, String mdEavaluatorID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.id", (Object)mdEavaluatorID));
        filterInfo.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        return !EvalPersonFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    @Override
    protected void _updateStatus(Context ctx, String evalPersonID, String mdSolultionPeriodID, String mdEvluObjectID, String mdEvaluatorID) throws BOSException, EASBizException {
        this.updateEvalPersonStatus(ctx, evalPersonID);
        MultiDimEvaluatorInfo dimEvaluatorInfo = this.getMDEvaluator(ctx, mdEvaluatorID);
        EvalRelationDetailInfo detailInfo = this.getDetailByEvalPersonID(dimEvaluatorInfo, evalPersonID);
        BigDecimal detailAvrScore = this.countEvalPersonAvrScore(detailInfo.getEvalPersons());
        detailInfo.setAvrScore(detailAvrScore);
        if (detailAvrScore != null) {
            this.updateEvalRelationDetailScore(ctx, detailInfo.getId().toString(), detailAvrScore);
        }
        if (this.checkAllTestPageSubmited(dimEvaluatorInfo)) {
            BigDecimal avr = this.countEvaluResultScore(dimEvaluatorInfo);
            this.updateMDEvaluatorState(ctx, dimEvaluatorInfo.getId().toString(), 30);
            this.updateMDEvaluResult(ctx, mdSolultionPeriodID, mdEvluObjectID, avr);
        }
    }

    private void updateMDEvaluatorState(Context ctx, String mdEvaluatorID, int value) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_MDEvaluator SET FWfStatus = ? WHERE FID = ?  ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, value);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdEvaluatorID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private BigDecimal countEvaluResultScore(MultiDimEvaluatorInfo dimEvaluatorInfo) {
        BigDecimal value = new BigDecimal("0.00000000");
        if (dimEvaluatorInfo == null) {
            return value;
        }
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            EvalRelationDetailInfo detailInfo = dimEvaluatorInfo.getEvalReDetails().get(i);
            if (dimEvaluatorInfo.getEvalReDetails().get(i).getAvrScore() == null) continue;
            value = value.add(detailInfo.getAvrScore().multiply(detailInfo.getEvalRelation().getWeight()));
        }
        value = value.multiply(new BigDecimal("0.01"));
        return value;
    }

    private boolean checkAllTestPageSubmited(MultiDimEvaluatorInfo dimEvaluatorInfo) {
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            int m = dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().size();
            for (int j = 0; j < m; ++j) {
                if (dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().get(j).getWfStatus().equals((Object)WFStatuEnum.CLOSED) || dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().get(j).getPaperState().equals((Object)MultiDimTestPaperStateEnum.CANCEL)) continue;
                return false;
            }
        }
        return true;
    }

    private void updateEvalRelationDetailScore(Context ctx, String mdEvaluDetailID, BigDecimal detailAvrScore) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_EvalReDetail SET FAvrScore = ? WHERE FID = ?  ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBigDecimal(1, detailAvrScore);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdEvaluDetailID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private EvalRelationDetailInfo getDetailByEvalPersonID(MultiDimEvaluatorInfo dimEvaluatorInfo, String evalPersonID) {
        int n = dimEvaluatorInfo.getEvalReDetails().size();
        for (int i = 0; i < n; ++i) {
            int m = dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().size();
            for (int j = 0; j < m; ++j) {
                if (!dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().get(j).getId().toString().equals(evalPersonID)) continue;
                dimEvaluatorInfo.getEvalReDetails().get(i).getEvalPersons().get(j).setPaperState(MultiDimTestPaperStateEnum.SUBMIT);
                return dimEvaluatorInfo.getEvalReDetails().get(i);
            }
        }
        return null;
    }

    private BigDecimal countEvalPersonAvrScore(EvalPersonCollection evalPersonCollection) {
        BigDecimal value = new BigDecimal("0.000000");
        int count = 0;
        int n = evalPersonCollection.size();
        for (int i = 0; i < n; ++i) {
            if (evalPersonCollection.get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.CANCEL)) continue;
            if (evalPersonCollection.get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.NOTSUBMIT)) {
                return null;
            }
            if (evalPersonCollection.get(i).getPaperState().equals((Object)MultiDimTestPaperStateEnum.SUBMIT) && evalPersonCollection.get(i).getScore() != null && evalPersonCollection.get(i).getWfStatus().equals((Object)WFStatuEnum.CLOSED)) {
                value = value.add(evalPersonCollection.get(i).getScore().setScale(2, 4));
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.000000");
        BigDecimal sizeValue = new BigDecimal("" + count);
        sizeValue = zero.add(sizeValue);
        BigDecimal avr = zero.add(value.divide(sizeValue, 4));
        return avr;
    }

    private MultiDimEvaluatorInfo getMDEvaluator(Context ctx, String mdEvaluatorID) throws BOSException, EASBizException {
        if (mdEvaluatorID == null) {
            return null;
        }
        SelectorItemCollection itemCollection = new SelectorItemCollection();
        itemCollection.add(new SelectorItemInfo("evalReDetails.id"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.avrScore"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalRelation.weight"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalPersons.id"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalPersons.score"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalPersons.paperState"));
        itemCollection.add(new SelectorItemInfo("evalReDetails.evalPersons.wfStatus"));
        return MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(mdEvaluatorID), itemCollection);
    }

    private void updateEvalPersonStatus(Context ctx, String evalPersonID) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_EvalPerson SET FWfStatus = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 30);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)evalPersonID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateMDEvaluResult(Context ctx, String mdSolutionPeriodID, String mdEvaluObjectID, BigDecimal value) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_MDEVALURESULT SET FEvaluScore = ? WHERE FSolutionPeriodID = ?  AND  FMdObjectID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBigDecimal(1, value);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)mdSolutionPeriodID);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)mdEvaluObjectID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

