/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.MultiDimentionCommentFactory;
import com.kingdee.eas.hr.perf.MultiDimentionEvalutionFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.TestPaperException;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.app.AbstractTestPaperControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TestPaperControllerBean
extends AbstractTestPaperControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TestPaperControllerBean");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
        this._checkNameDup(ctx, model);
        this._checkOther(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TestPaperInfo info = (TestPaperInfo)model;
        if (info.getType() == null) {
            throw new TestPaperException(TestPaperException.NULL_TYPE);
        }
        if (info.getOrgUnit() == null) {
            throw new TestPaperException(TestPaperException.NULL_ORGUNIT);
        }
        if (info.getGradeMode() == null) {
            throw new TestPaperException(TestPaperException.NULL_GRADEMODE);
        }
        if (info.getRankGroup() == null) {
            throw new TestPaperException(TestPaperException.NULL_RANKGROUP);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber((Context)ctx, (CoreBaseInfo)((TestPaperInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber((Context)ctx, (CoreBaseInfo)((TestPaperInfo)model));
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CodingRuleServerHelper.recycleNumber((Context)ctx, (IObjectPK)pk, (ICoreBase)TestPaperFactory.getLocalInstance(ctx), (String)TestPaperInfo.class.getName());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)pk.toString()));
        MultiDimentionCommentFactory.getLocalInstance(ctx).delete(filter);
        MultiDimentionEvalutionFactory.getLocalInstance(ctx).delete(filter);
        PaperQuestionsFactory.getLocalInstance(ctx).delete(filter);
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _isMeRefered(Context ctx, String id) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paper.id", (Object)id));
        return EvaluRelationFactory.getLocalInstance(ctx).exists(filter);
    }

    @Override
    protected void _setValid(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_TestPaper SET FState = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 20);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

