/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.app.AbstractTestPaperInputScoreUIHandler;
import com.kingdee.jdbc.rowset.IRowSet;

public class TestPaperInputScoreUIHandler
extends AbstractTestPaperInputScoreUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        String currentMDID = (String)request.get("currentMDID");
        IRowSet rowSet = request.getRowSet();
        if (rowSet != null) {
            String id;
            if (rowSet.next() && (id = rowSet.getString("id")) != null) {
                this.setEditor(context, id);
                this.fillSelectedTable(context, id, currentMDID, request);
            }
            rowSet.beforeFirst();
        }
    }

    private void setEditor(Context context, String id) throws Exception {
        if (id == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("paper.id"));
        sic.add(new SelectorItemInfo("paper.rankGroup.id"));
        EvaluRelationInfo erInfo = EvaluRelationFactory.getLocalInstance(context).getEvaluRelationInfo((IObjectPK)new ObjectUuidPK(id), sic);
        String groupId = erInfo.getPaper().getRankGroup().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupId));
        viewInfo.setFilter(filter);
        sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("serial");
        sorter.add(item);
        RankFactory.getLocalInstance(context).getRankCollection(viewInfo);
    }

    @Override
    protected void _handleActionSaveData(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IQueryExecutor getQueryExecutor(RequestContext request, ResponseContext response, Context context) throws Exception {
        IQueryExecutor exec = super.getQueryExecutor(request, response, context);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    private void fillSelectedTable(Context context, String relationID, String mdObjectID, RequestContext request) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)relationID));
        filter.getFilterItems().add(new FilterItemInfo("MDObject.id", (Object)mdObjectID));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalPersonInputScoreQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        boolean orderby = false;
        int maxRowCount = request.getMaxRowCount();
        EntityViewInfo entityView = request.getQuery();
        if (entityView != null && entityView.getSorter() != null && entityView.getSorter().size() > 0) {
            orderby = true;
        }
        exec.option().isIgnoreOrder = orderby;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = maxRowCount;
        exec.option().isIgnorePermissionCheck = request.isQueryOpeionPermission();
        exec.option().isAutoIgnoreZero = false;
        exec.executeQuery();
    }

    public ResponseContext tableRequestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVirtualModel(false);
        return super.tableRequestData(request, response, context);
    }

    protected FilterInfo getDefaultFilterForQuery(RequestContext request, Context context) throws Exception {
        FilterInfo filter = new FilterInfo();
        if (request.get("MDObject.id") != null) {
            filter.getFilterItems().add(new FilterItemInfo("MDObject.id", (Object)request.get("MDObject.id").toString()));
        }
        if (request.get("SolutionPeriod.id") != null) {
            filter.getFilterItems().add(new FilterItemInfo("SolutionPeriod.id", (Object)request.get("SolutionPeriod.id").toString()));
        }
        return filter;
    }
}

